/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderSimulation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderSimulationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.batch.DefaultSalesOrderSimulateServiceBatch;

/**
 * <p>
 * The API gives you information about pricing, material availability, and the customer&#39;s credit limit. The response
 * is provided synchronously. The simulated sales order is not saved.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b6/4937ce2692427594ee794ad033b8b3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_ORDER_SIMULATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_ORDER_SIMULATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Order Integration(SAP_COM_0109)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QI'>Opportunity-to-Order with Third-Party Sales Force Automation Apps
 * (Deprecated)(1QI)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2TY'>B2B Order Fulfillment with SAP Commerce
 * Cloud(2TY)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesOrderSimulateService" )
@Deprecated
public class DefaultSalesOrderSimulateService implements SalesOrderSimulateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesOrderSimulateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesOrderSimulateService()
    {
        servicePath = SalesOrderSimulateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesOrderSimulateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesOrderSimulateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesOrderSimulateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesOrderSimulateServiceBatch batch()
    {
        return new DefaultSalesOrderSimulateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesOrderSimulationCreateFluentHelper createSalesOrderSimulation(
        @Nonnull final SalesOrderSimulation salesOrderSimulation )
    {
        return new SalesOrderSimulationCreateFluentHelper(servicePath, salesOrderSimulation, "A_SalesOrderSimulation");
    }

}
