/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.batch.DefaultSalesOrderWithoutChargeServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire sales orders without charge or
 * only parts of the data, using the provided filters. - You can create sales orders without charge. Note that you must
 * use “deep insert” requests (a header plus the following entities: header partner, item and item partner). You cannot
 * create entities without including any related entities. - For existing sales orders without charge, you can create
 * new items. Note that you must use “deep insert” requests (with the entity: item partner). You cannot create entities
 * without including any related entities. - For existing sales orders without charge, you can update the header, header
 * partner, item and item partner. - For existing sales orders without charge, you can delete the header, header
 * partner, item and item partner..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1e/b3e97d4e314e769d614b8d5b16468d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_ORDER_WITHOUT_CHARGE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_ORDER_WITHOUT_CHARGE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Order Without Charge Integration(SAP_COM_0334)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order Without Charge</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesOrderWithoutChargeService" )
@Deprecated
public class DefaultSalesOrderWithoutChargeService implements SalesOrderWithoutChargeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesOrderWithoutChargeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesOrderWithoutChargeService()
    {
        servicePath = SalesOrderWithoutChargeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesOrderWithoutChargeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesOrderWithoutChargeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesOrderWithoutChargeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesOrderWithoutChargeServiceBatch batch()
    {
        return new DefaultSalesOrderWithoutChargeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeFluentHelper getAllSalesOrderWithoutCharge()
    {
        return new SalesOrderWithoutChargeFluentHelper(servicePath, "A_SalesOrderWithoutCharge");
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeByKeyFluentHelper getSalesOrderWithoutChargeByKey(
        final String salesOrderWithoutCharge )
    {
        return new SalesOrderWithoutChargeByKeyFluentHelper(
            servicePath,
            "A_SalesOrderWithoutCharge",
            salesOrderWithoutCharge);
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeCreateFluentHelper createSalesOrderWithoutCharge(
        @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge )
    {
        return new SalesOrderWithoutChargeCreateFluentHelper(
            servicePath,
            salesOrderWithoutCharge,
            "A_SalesOrderWithoutCharge");
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeUpdateFluentHelper updateSalesOrderWithoutCharge(
        @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge )
    {
        return new SalesOrderWithoutChargeUpdateFluentHelper(
            servicePath,
            salesOrderWithoutCharge,
            "A_SalesOrderWithoutCharge");
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeDeleteFluentHelper deleteSalesOrderWithoutCharge(
        @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge )
    {
        return new SalesOrderWithoutChargeDeleteFluentHelper(
            servicePath,
            salesOrderWithoutCharge,
            "A_SalesOrderWithoutCharge");
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeItemFluentHelper getAllSalesOrderWithoutChargeItem()
    {
        return new SalesOrderWithoutChargeItemFluentHelper(servicePath, "A_SalesOrderWithoutChargeItem");
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeItemByKeyFluentHelper getSalesOrderWithoutChargeItemByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem )
    {
        return new SalesOrderWithoutChargeItemByKeyFluentHelper(
            servicePath,
            "A_SalesOrderWithoutChargeItem",
            salesOrderWithoutCharge,
            salesOrderWithoutChargeItem);
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeItemCreateFluentHelper createSalesOrderWithoutChargeItem(
        @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem )
    {
        return new SalesOrderWithoutChargeItemCreateFluentHelper(
            servicePath,
            salesOrderWithoutChargeItem,
            "A_SalesOrderWithoutChargeItem");
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeItemUpdateFluentHelper updateSalesOrderWithoutChargeItem(
        @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem )
    {
        return new SalesOrderWithoutChargeItemUpdateFluentHelper(
            servicePath,
            salesOrderWithoutChargeItem,
            "A_SalesOrderWithoutChargeItem");
    }

    @Override
    @Nonnull
    public SalesOrderWithoutChargeItemDeleteFluentHelper deleteSalesOrderWithoutChargeItem(
        @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem )
    {
        return new SalesOrderWithoutChargeItemDeleteFluentHelper(
            servicePath,
            salesOrderWithoutChargeItem,
            "A_SalesOrderWithoutChargeItem");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmPartnerFluentHelper getAllSlsOrdWthoutChrgItmPartner()
    {
        return new SlsOrdWthoutChrgItmPartnerFluentHelper(servicePath, "A_SlsOrdWthoutChrgItmPartner");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmPartnerByKeyFluentHelper getSlsOrdWthoutChrgItmPartnerByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem,
        final String partnerFunction )
    {
        return new SlsOrdWthoutChrgItmPartnerByKeyFluentHelper(
            servicePath,
            "A_SlsOrdWthoutChrgItmPartner",
            salesOrderWithoutCharge,
            salesOrderWithoutChargeItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmPartnerUpdateFluentHelper updateSlsOrdWthoutChrgItmPartner(
        @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner )
    {
        return new SlsOrdWthoutChrgItmPartnerUpdateFluentHelper(
            servicePath,
            slsOrdWthoutChrgItmPartner,
            "A_SlsOrdWthoutChrgItmPartner");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmPartnerDeleteFluentHelper deleteSlsOrdWthoutChrgItmPartner(
        @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner )
    {
        return new SlsOrdWthoutChrgItmPartnerDeleteFluentHelper(
            servicePath,
            slsOrdWthoutChrgItmPartner,
            "A_SlsOrdWthoutChrgItmPartner");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmTextFluentHelper getAllSlsOrdWthoutChrgItmText()
    {
        return new SlsOrdWthoutChrgItmTextFluentHelper(servicePath, "A_SlsOrdWthoutChrgItmText");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmTextByKeyFluentHelper getSlsOrdWthoutChrgItmTextByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem,
        final String language,
        final String longTextID )
    {
        return new SlsOrdWthoutChrgItmTextByKeyFluentHelper(
            servicePath,
            "A_SlsOrdWthoutChrgItmText",
            salesOrderWithoutCharge,
            salesOrderWithoutChargeItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmTextUpdateFluentHelper updateSlsOrdWthoutChrgItmText(
        @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText )
    {
        return new SlsOrdWthoutChrgItmTextUpdateFluentHelper(
            servicePath,
            slsOrdWthoutChrgItmText,
            "A_SlsOrdWthoutChrgItmText");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgItmTextDeleteFluentHelper deleteSlsOrdWthoutChrgItmText(
        @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText )
    {
        return new SlsOrdWthoutChrgItmTextDeleteFluentHelper(
            servicePath,
            slsOrdWthoutChrgItmText,
            "A_SlsOrdWthoutChrgItmText");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgPartnerFluentHelper getAllSlsOrdWthoutChrgPartner()
    {
        return new SlsOrdWthoutChrgPartnerFluentHelper(servicePath, "A_SlsOrdWthoutChrgPartner");
    }

    @Override
    @Nonnull
    public
        SlsOrdWthoutChrgPartnerByKeyFluentHelper
        getSlsOrdWthoutChrgPartnerByKey( final String salesOrderWithoutCharge, final String partnerFunction )
    {
        return new SlsOrdWthoutChrgPartnerByKeyFluentHelper(
            servicePath,
            "A_SlsOrdWthoutChrgPartner",
            salesOrderWithoutCharge,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgPartnerUpdateFluentHelper updateSlsOrdWthoutChrgPartner(
        @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner )
    {
        return new SlsOrdWthoutChrgPartnerUpdateFluentHelper(
            servicePath,
            slsOrdWthoutChrgPartner,
            "A_SlsOrdWthoutChrgPartner");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgPartnerDeleteFluentHelper deleteSlsOrdWthoutChrgPartner(
        @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner )
    {
        return new SlsOrdWthoutChrgPartnerDeleteFluentHelper(
            servicePath,
            slsOrdWthoutChrgPartner,
            "A_SlsOrdWthoutChrgPartner");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgSchedLineFluentHelper getAllSlsOrdWthoutChrgSchedLine()
    {
        return new SlsOrdWthoutChrgSchedLineFluentHelper(servicePath, "A_SlsOrdWthoutChrgSchedLine");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgSchedLineByKeyFluentHelper getSlsOrdWthoutChrgSchedLineByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem,
        final String scheduleLine )
    {
        return new SlsOrdWthoutChrgSchedLineByKeyFluentHelper(
            servicePath,
            "A_SlsOrdWthoutChrgSchedLine",
            salesOrderWithoutCharge,
            salesOrderWithoutChargeItem,
            scheduleLine);
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgTextFluentHelper getAllSlsOrdWthoutChrgText()
    {
        return new SlsOrdWthoutChrgTextFluentHelper(servicePath, "A_SlsOrdWthoutChrgText");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgTextByKeyFluentHelper getSlsOrdWthoutChrgTextByKey(
        final String salesOrderWithoutCharge,
        final String language,
        final String longTextID )
    {
        return new SlsOrdWthoutChrgTextByKeyFluentHelper(
            servicePath,
            "A_SlsOrdWthoutChrgText",
            salesOrderWithoutCharge,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgTextUpdateFluentHelper updateSlsOrdWthoutChrgText(
        @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText )
    {
        return new SlsOrdWthoutChrgTextUpdateFluentHelper(servicePath, slsOrdWthoutChrgText, "A_SlsOrdWthoutChrgText");
    }

    @Override
    @Nonnull
    public SlsOrdWthoutChrgTextDeleteFluentHelper deleteSlsOrdWthoutChrgText(
        @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText )
    {
        return new SlsOrdWthoutChrgTextDeleteFluentHelper(servicePath, slsOrdWthoutChrgText, "A_SlsOrdWthoutChrgText");
    }

}
