/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.batch.DefaultSalesOrganizationServiceBatch;

/**
 * <p>
 * The service contains sales organization and sales organization text nodes.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/24/18326d6009458ab7acb72b2b747cca/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALESORGANIZATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALESORGANIZATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Organization</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesOrganizationService" )
@Deprecated
public class DefaultSalesOrganizationService implements SalesOrganizationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesOrganizationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesOrganizationService()
    {
        servicePath = SalesOrganizationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesOrganizationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesOrganizationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesOrganizationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesOrganizationServiceBatch batch()
    {
        return new DefaultSalesOrganizationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesOrganizationFluentHelper getAllSalesOrganization()
    {
        return new SalesOrganizationFluentHelper(servicePath, "A_SalesOrganization");
    }

    @Override
    @Nonnull
    public SalesOrganizationByKeyFluentHelper getSalesOrganizationByKey( final String salesOrganization )
    {
        return new SalesOrganizationByKeyFluentHelper(servicePath, "A_SalesOrganization", salesOrganization);
    }

    @Override
    @Nonnull
    public SalesOrganizationTextFluentHelper getAllSalesOrganizationText()
    {
        return new SalesOrganizationTextFluentHelper(servicePath, "A_SalesOrganizationText");
    }

    @Override
    @Nonnull
    public
        SalesOrganizationTextByKeyFluentHelper
        getSalesOrganizationTextByKey( final String salesOrganization, final String language )
    {
        return new SalesOrganizationTextByKeyFluentHelper(
            servicePath,
            "A_SalesOrganizationText",
            salesOrganization,
            language);
    }

}
