/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmntCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScaleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScaleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScaleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScaleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScaleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.batch.DefaultSalesPricingConditionRecordServiceBatch;

/**
 * <p>
 * Consumers of this inbound service can create, read, update, and delete condition records inside condition record,
 * validity of condition record, pricing scale, and condition supplement.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/79/16962329ee49b293156fffddfb7dd8/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SLSPRICINGCONDITIONRECORD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SLSPRICINGCONDITIONRECORD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Pricing Data Integration(SAP_COM_0294)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1A8'>Internal Project Management - Project-Based
 * Services(1A8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1B6'>Sales Rebate Processing(1B6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1EZ'>Credit Memo Processing(1EZ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1F1'>Debit Memo Processing(1F1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing(1JW)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1KC'>Advanced Resource Management - Project-Based Services(1KC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2EQ'>Sale of Services(2EQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2F4'>Intercompany Process for Customer Returns(2F4)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2ME'>Central Purchase Contracts(2ME)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2NV'>Guided Buying Capability with SAP Ariba Buying(2NV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R7'>Purchasing Rebate Processing(2R7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TT'>Sales Commissions - External Sales Representative(2TT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD3'>Sales Processing using Third-Party with Shipping
 * Notification(BD3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDQ'>Invoice Correction Process with Debit Memo(BDQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKJ'>Sales Order Processing with Customer Down Payment(BKJ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKL'>Invoice Correction Process with Credit Memo(BKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BMR'>Scheduling Agreements in Procurement(BMR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J11'>Customer Project Management - Project-Based Services(J11)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J14'>Sales Order Processing - Project-Based
 * Services(J14)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O8J'>Requisitioning(O8J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONV'>Guided Buying Capability with SAP Ariba Buying(ONV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/16T'>Intercompany Processes - Project-Based Services(16T)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/18J'>Requisitioning(18J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/19C'>Activity Management in Procurement(19C)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/19E'>Supplier Classification and Segmentation(19E)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1A0'>Sourcing with SAP Ariba Sourcing(1A0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1HO'>Intercompany Sales Order Processing - Domestic(1HO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1IQ'>Sales Inquiry(1IQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1LE'>Invoice Processing by OpenText(1LE)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MC'>Omnichannel Convergent Billing(1MC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MX'>Intercompany Sales Order Processing - International(1MX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1NB'>Ariba - Sales Order to Invoice integration for SD(1NB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1WO'>Extended Intercompany Processes for Sales(1WO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1XF'>Request for Price(1XF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1Z1'>Digital Payments - Sales(1Z1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1Z3'>Customer Returns with Direct Shipment from Customer to
 * Supplier(1Z3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1Z6'>External Billing(1Z6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/22Z'>Procurement of Services(22Z)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2EJ'>Integration of Procurement with External Suppliers(2EJ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2EL'>Integration of Sales with External Buyers(2EL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2ET'>Sales Order Processing for Non-Stock Material(2ET)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2LG'>Supplier Consignment(2LG)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2LH'>Automated Invoice Settlement(2LH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2LN'>Basic Available-to-Promise Processing(2LN)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2MV'>Basic Resource Management - Project-Based Services(2MV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2NX'>Scheduling Agreement for Subcontracting Procurement(2NX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2NY'>Scheduling Agreement for Consignment Procurement(2NY)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R3'>Cross-Company Purchasing Organization(2R3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TW'>Complementary Procurement Functions(2TW)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2XU'>Procurement of Materials with Variant Configuration(2XU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2XV'>Propose Material Group in Free-Text Purchase
 * Requisitions(2XV)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2XW'>Propose Creation of Catalog Items based on
 * Free-Text Purchase Orders(2XW)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/31Q'>Sales Order Processing for
 * Sales Kits(31Q)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDG'>Sales Quotation(BDG)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDH'>Sales Order Entry with One-Time Customer(BDH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDK'>Sales Processing Using Third-Party Without Shipping
 * Notification(BDK)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BDN'>Sales of Non-Stock Item with
 * Order-Specific Procurement(BDN)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BDW'>Returnables
 * Processing(BDW)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BKA'>Free Goods Processing(BKA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKK'>Sales Order Fulfillment Monitoring and Operations(BKK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKN'>Order-to-Cash Performance Monitoring (Deprecated)(BKN)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKX'>Sales Order Processing - SEPA Direct Debit Handling(BKX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKZ'>Sales Order Processing with Invoice List and Collective
 * Billing(BKZ)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BMD'>Purchase Contract(BMD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BMK'>Return to Supplier(BMK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BMY'>Subcontracting(BMY)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/I9I'>Sales Contract Management(I9I)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J12'>Time Recording - Project-Based Services(J12)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J82'>Automated Purchase-to-Pay with SAP Ariba Commerce
 * Automation(J82)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/O82'>Automated Purchase-to-Pay with SAP Ariba
 * Commerce Automation(O82)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/O9E'>Supplier Classification and
 * Segmentation(O9E)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/OA0'>Sourcing with SAP Ariba Sourcing(OA0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ODQ'>Invoice Correction Process with Debit Memo(ODQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OEQ'>Sale of Services(OEQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OF1'>Debit Memo Processing(OF1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OKL'>Invoice Correction Process with Credit Memo(OKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OL4'>Supplier Evaluation and Performance Monitoring(OL4)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OLE'>Invoice Processing by OpenText(OLE)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMD'>Purchase Contract(OMD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMK'>Return to Supplier(OMK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMR'>Scheduling Agreements in Procurement(OMR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXF'>Request for Price(OXF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OZ6'>External Billing(OZ6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PEZ'>Credit Memo Processing(PEZ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PMC'>Convergent Billing(PMC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/SL4'>Supplier Evaluation and Performance Monitoring(SL4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Condition Record for Pricing in Sales</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesPricingConditionRecordService" )
@Deprecated
public class DefaultSalesPricingConditionRecordService implements SalesPricingConditionRecordService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesPricingConditionRecordService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesPricingConditionRecordService()
    {
        servicePath = SalesPricingConditionRecordService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesPricingConditionRecordService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesPricingConditionRecordService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesPricingConditionRecordService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesPricingConditionRecordServiceBatch batch()
    {
        return new DefaultSalesPricingConditionRecordServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecdSuplmntFluentHelper getAllSlsPrcgCndnRecdSuplmnt()
    {
        return new SlsPrcgCndnRecdSuplmntFluentHelper(servicePath, "A_SlsPrcgCndnRecdSuplmnt");
    }

    @Override
    @Nonnull
    public
        SlsPrcgCndnRecdSuplmntByKeyFluentHelper
        getSlsPrcgCndnRecdSuplmntByKey( final String conditionRecord, final String conditionSequentialNumber )
    {
        return new SlsPrcgCndnRecdSuplmntByKeyFluentHelper(
            servicePath,
            "A_SlsPrcgCndnRecdSuplmnt",
            conditionRecord,
            conditionSequentialNumber);
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecdSuplmntCreateFluentHelper createSlsPrcgCndnRecdSuplmnt(
        @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt )
    {
        return new SlsPrcgCndnRecdSuplmntCreateFluentHelper(
            servicePath,
            slsPrcgCndnRecdSuplmnt,
            "A_SlsPrcgCndnRecdSuplmnt");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecdSuplmntUpdateFluentHelper updateSlsPrcgCndnRecdSuplmnt(
        @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt )
    {
        return new SlsPrcgCndnRecdSuplmntUpdateFluentHelper(
            servicePath,
            slsPrcgCndnRecdSuplmnt,
            "A_SlsPrcgCndnRecdSuplmnt");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecdSuplmntDeleteFluentHelper deleteSlsPrcgCndnRecdSuplmnt(
        @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt )
    {
        return new SlsPrcgCndnRecdSuplmntDeleteFluentHelper(
            servicePath,
            slsPrcgCndnRecdSuplmnt,
            "A_SlsPrcgCndnRecdSuplmnt");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecdValidityFluentHelper getAllSlsPrcgCndnRecdValidity()
    {
        return new SlsPrcgCndnRecdValidityFluentHelper(servicePath, "A_SlsPrcgCndnRecdValidity");
    }

    @Override
    @Nonnull
    public
        SlsPrcgCndnRecdValidityByKeyFluentHelper
        getSlsPrcgCndnRecdValidityByKey( final String conditionRecord, final LocalDateTime conditionValidityEndDate )
    {
        return new SlsPrcgCndnRecdValidityByKeyFluentHelper(
            servicePath,
            "A_SlsPrcgCndnRecdValidity",
            conditionRecord,
            conditionValidityEndDate);
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecdValidityCreateFluentHelper createSlsPrcgCndnRecdValidity(
        @Nonnull final SlsPrcgCndnRecdValidity slsPrcgCndnRecdValidity )
    {
        return new SlsPrcgCndnRecdValidityCreateFluentHelper(
            servicePath,
            slsPrcgCndnRecdValidity,
            "A_SlsPrcgCndnRecdValidity");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecdValidityUpdateFluentHelper updateSlsPrcgCndnRecdValidity(
        @Nonnull final SlsPrcgCndnRecdValidity slsPrcgCndnRecdValidity )
    {
        return new SlsPrcgCndnRecdValidityUpdateFluentHelper(
            servicePath,
            slsPrcgCndnRecdValidity,
            "A_SlsPrcgCndnRecdValidity");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecordScaleFluentHelper getAllSlsPrcgCndnRecordScale()
    {
        return new SlsPrcgCndnRecordScaleFluentHelper(servicePath, "A_SlsPrcgCndnRecordScale");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecordScaleByKeyFluentHelper getSlsPrcgCndnRecordScaleByKey(
        final String conditionRecord,
        final String conditionSequentialNumber,
        final String conditionScaleLine )
    {
        return new SlsPrcgCndnRecordScaleByKeyFluentHelper(
            servicePath,
            "A_SlsPrcgCndnRecordScale",
            conditionRecord,
            conditionSequentialNumber,
            conditionScaleLine);
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecordScaleCreateFluentHelper createSlsPrcgCndnRecordScale(
        @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale )
    {
        return new SlsPrcgCndnRecordScaleCreateFluentHelper(
            servicePath,
            slsPrcgCndnRecordScale,
            "A_SlsPrcgCndnRecordScale");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecordScaleUpdateFluentHelper updateSlsPrcgCndnRecordScale(
        @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale )
    {
        return new SlsPrcgCndnRecordScaleUpdateFluentHelper(
            servicePath,
            slsPrcgCndnRecordScale,
            "A_SlsPrcgCndnRecordScale");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnRecordScaleDeleteFluentHelper deleteSlsPrcgCndnRecordScale(
        @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale )
    {
        return new SlsPrcgCndnRecordScaleDeleteFluentHelper(
            servicePath,
            slsPrcgCndnRecordScale,
            "A_SlsPrcgCndnRecordScale");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnSupplementTextFluentHelper getAllSlsPrcgCndnSupplementText()
    {
        return new SlsPrcgCndnSupplementTextFluentHelper(servicePath, "A_SlsPrcgCndnSupplementText");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnSupplementTextByKeyFluentHelper getSlsPrcgCndnSupplementTextByKey(
        final String conditionRecord,
        final String conditionSequentialNumber,
        final String language )
    {
        return new SlsPrcgCndnSupplementTextByKeyFluentHelper(
            servicePath,
            "A_SlsPrcgCndnSupplementText",
            conditionRecord,
            conditionSequentialNumber,
            language);
    }

    @Override
    @Nonnull
    public SlsPrcgCndnSupplementTextCreateFluentHelper createSlsPrcgCndnSupplementText(
        @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText )
    {
        return new SlsPrcgCndnSupplementTextCreateFluentHelper(
            servicePath,
            slsPrcgCndnSupplementText,
            "A_SlsPrcgCndnSupplementText");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnSupplementTextUpdateFluentHelper updateSlsPrcgCndnSupplementText(
        @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText )
    {
        return new SlsPrcgCndnSupplementTextUpdateFluentHelper(
            servicePath,
            slsPrcgCndnSupplementText,
            "A_SlsPrcgCndnSupplementText");
    }

    @Override
    @Nonnull
    public SlsPrcgCndnSupplementTextDeleteFluentHelper deleteSlsPrcgCndnSupplementText(
        @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText )
    {
        return new SlsPrcgCndnSupplementTextDeleteFluentHelper(
            servicePath,
            slsPrcgCndnSupplementText,
            "A_SlsPrcgCndnSupplementText");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordFluentHelper getAllSlsPrcgConditionRecord()
    {
        return new SlsPrcgConditionRecordFluentHelper(servicePath, "A_SlsPrcgConditionRecord");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordByKeyFluentHelper getSlsPrcgConditionRecordByKey( final String conditionRecord )
    {
        return new SlsPrcgConditionRecordByKeyFluentHelper(servicePath, "A_SlsPrcgConditionRecord", conditionRecord);
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordCreateFluentHelper createSlsPrcgConditionRecord(
        @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord )
    {
        return new SlsPrcgConditionRecordCreateFluentHelper(
            servicePath,
            slsPrcgConditionRecord,
            "A_SlsPrcgConditionRecord");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordUpdateFluentHelper updateSlsPrcgConditionRecord(
        @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord )
    {
        return new SlsPrcgConditionRecordUpdateFluentHelper(
            servicePath,
            slsPrcgConditionRecord,
            "A_SlsPrcgConditionRecord");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordDeleteFluentHelper deleteSlsPrcgConditionRecord(
        @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord )
    {
        return new SlsPrcgConditionRecordDeleteFluentHelper(
            servicePath,
            slsPrcgConditionRecord,
            "A_SlsPrcgConditionRecord");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordTextFluentHelper getAllSlsPrcgConditionRecordText()
    {
        return new SlsPrcgConditionRecordTextFluentHelper(servicePath, "A_SlsPrcgConditionRecordText");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordTextByKeyFluentHelper getSlsPrcgConditionRecordTextByKey(
        final String conditionRecord,
        final String conditionSequentialNumber,
        final String language )
    {
        return new SlsPrcgConditionRecordTextByKeyFluentHelper(
            servicePath,
            "A_SlsPrcgConditionRecordText",
            conditionRecord,
            conditionSequentialNumber,
            language);
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordTextCreateFluentHelper createSlsPrcgConditionRecordText(
        @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText )
    {
        return new SlsPrcgConditionRecordTextCreateFluentHelper(
            servicePath,
            slsPrcgConditionRecordText,
            "A_SlsPrcgConditionRecordText");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordTextUpdateFluentHelper updateSlsPrcgConditionRecordText(
        @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText )
    {
        return new SlsPrcgConditionRecordTextUpdateFluentHelper(
            servicePath,
            slsPrcgConditionRecordText,
            "A_SlsPrcgConditionRecordText");
    }

    @Override
    @Nonnull
    public SlsPrcgConditionRecordTextDeleteFluentHelper deleteSlsPrcgConditionRecordText(
        @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText )
    {
        return new SlsPrcgConditionRecordTextDeleteFluentHelper(
            servicePath,
            slsPrcgConditionRecordText,
            "A_SlsPrcgConditionRecordText");
    }

}
