/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanPrecdgProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanPrecdgProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.batch.DefaultSalesQuotationServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire sales quotations or only parts
 * of the data, using the provided filters. - You can create sales quotations. Note that you must use “deep insert”
 * requests (a header plus the following entities: header partner, header pricing element, header text, header related
 * object, item, item partner, item pricing element, item text, and item related object). You cannot create entities
 * without including any related entities. - For existing sales quotations, you can create new items. Note that you must
 * use “deep insert” requests (with the following entities: item partner, item pricing element, item text, and item
 * related object). You cannot create entities without including any related entities. - For existing sales quotations,
 * you can update the header, header partner, header pricing element, header text, item, item partner, item pricing
 * element, and item text. - For existing sales quotations, you can delete the header, header partner, header pricing
 * element, header text, header related object, item, item partner, item pricing element, item text, and item related
 * object. - You can accept or deny approval requests for sales quotations that cannot be processed without the consent
 * of an approver..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/bc/fea10daf7241aea335dab3bc70ea8e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_QUOTATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_QUOTATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Quotation Integration(SAP_COM_0118)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BDG'>Sales Quotation(BDG)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Quotation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesQuotationService" )
@Deprecated
public class DefaultSalesQuotationService implements SalesQuotationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesQuotationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesQuotationService()
    {
        servicePath = SalesQuotationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesQuotationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesQuotationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesQuotationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesQuotationServiceBatch batch()
    {
        return new DefaultSalesQuotationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesQuotationFluentHelper getAllSalesQuotation()
    {
        return new SalesQuotationFluentHelper(servicePath, "A_SalesQuotation");
    }

    @Override
    @Nonnull
    public SalesQuotationByKeyFluentHelper getSalesQuotationByKey( final String salesQuotation )
    {
        return new SalesQuotationByKeyFluentHelper(servicePath, "A_SalesQuotation", salesQuotation);
    }

    @Override
    @Nonnull
    public SalesQuotationCreateFluentHelper createSalesQuotation( @Nonnull final SalesQuotation salesQuotation )
    {
        return new SalesQuotationCreateFluentHelper(servicePath, salesQuotation, "A_SalesQuotation");
    }

    @Override
    @Nonnull
    public SalesQuotationUpdateFluentHelper updateSalesQuotation( @Nonnull final SalesQuotation salesQuotation )
    {
        return new SalesQuotationUpdateFluentHelper(servicePath, salesQuotation, "A_SalesQuotation");
    }

    @Override
    @Nonnull
    public SalesQuotationDeleteFluentHelper deleteSalesQuotation( @Nonnull final SalesQuotation salesQuotation )
    {
        return new SalesQuotationDeleteFluentHelper(servicePath, salesQuotation, "A_SalesQuotation");
    }

    @Override
    @Nonnull
    public SalesQuotationItemFluentHelper getAllSalesQuotationItem()
    {
        return new SalesQuotationItemFluentHelper(servicePath, "A_SalesQuotationItem");
    }

    @Override
    @Nonnull
    public
        SalesQuotationItemByKeyFluentHelper
        getSalesQuotationItemByKey( final String salesQuotation, final String salesQuotationItem )
    {
        return new SalesQuotationItemByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationItem",
            salesQuotation,
            salesQuotationItem);
    }

    @Override
    @Nonnull
    public SalesQuotationItemCreateFluentHelper createSalesQuotationItem(
        @Nonnull final SalesQuotationItem salesQuotationItem )
    {
        return new SalesQuotationItemCreateFluentHelper(servicePath, salesQuotationItem, "A_SalesQuotationItem");
    }

    @Override
    @Nonnull
    public SalesQuotationItemUpdateFluentHelper updateSalesQuotationItem(
        @Nonnull final SalesQuotationItem salesQuotationItem )
    {
        return new SalesQuotationItemUpdateFluentHelper(servicePath, salesQuotationItem, "A_SalesQuotationItem");
    }

    @Override
    @Nonnull
    public SalesQuotationItemDeleteFluentHelper deleteSalesQuotationItem(
        @Nonnull final SalesQuotationItem salesQuotationItem )
    {
        return new SalesQuotationItemDeleteFluentHelper(servicePath, salesQuotationItem, "A_SalesQuotationItem");
    }

    @Override
    @Nonnull
    public SalesQuotationItemPartnerFluentHelper getAllSalesQuotationItemPartner()
    {
        return new SalesQuotationItemPartnerFluentHelper(servicePath, "A_SalesQuotationItemPartner");
    }

    @Override
    @Nonnull
    public SalesQuotationItemPartnerByKeyFluentHelper getSalesQuotationItemPartnerByKey(
        final String salesQuotation,
        final String salesQuotationItem,
        final String partnerFunction )
    {
        return new SalesQuotationItemPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationItemPartner",
            salesQuotation,
            salesQuotationItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesQuotationItemPartnerUpdateFluentHelper updateSalesQuotationItemPartner(
        @Nonnull final SalesQuotationItemPartner salesQuotationItemPartner )
    {
        return new SalesQuotationItemPartnerUpdateFluentHelper(
            servicePath,
            salesQuotationItemPartner,
            "A_SalesQuotationItemPartner");
    }

    @Override
    @Nonnull
    public SalesQuotationItemPartnerDeleteFluentHelper deleteSalesQuotationItemPartner(
        @Nonnull final SalesQuotationItemPartner salesQuotationItemPartner )
    {
        return new SalesQuotationItemPartnerDeleteFluentHelper(
            servicePath,
            salesQuotationItemPartner,
            "A_SalesQuotationItemPartner");
    }

    @Override
    @Nonnull
    public SalesQuotationItemPrcgElmntFluentHelper getAllSalesQuotationItemPrcgElmnt()
    {
        return new SalesQuotationItemPrcgElmntFluentHelper(servicePath, "A_SalesQuotationItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesQuotationItemPrcgElmntByKeyFluentHelper getSalesQuotationItemPrcgElmntByKey(
        final String salesQuotation,
        final String salesQuotationItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesQuotationItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationItemPrcgElmnt",
            salesQuotation,
            salesQuotationItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesQuotationItemPrcgElmntUpdateFluentHelper updateSalesQuotationItemPrcgElmnt(
        @Nonnull final SalesQuotationItemPrcgElmnt salesQuotationItemPrcgElmnt )
    {
        return new SalesQuotationItemPrcgElmntUpdateFluentHelper(
            servicePath,
            salesQuotationItemPrcgElmnt,
            "A_SalesQuotationItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesQuotationItemPrcgElmntDeleteFluentHelper deleteSalesQuotationItemPrcgElmnt(
        @Nonnull final SalesQuotationItemPrcgElmnt salesQuotationItemPrcgElmnt )
    {
        return new SalesQuotationItemPrcgElmntDeleteFluentHelper(
            servicePath,
            salesQuotationItemPrcgElmnt,
            "A_SalesQuotationItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesQuotationItemTextFluentHelper getAllSalesQuotationItemText()
    {
        return new SalesQuotationItemTextFluentHelper(servicePath, "A_SalesQuotationItemText");
    }

    @Override
    @Nonnull
    public SalesQuotationItemTextByKeyFluentHelper getSalesQuotationItemTextByKey(
        final String salesQuotation,
        final String salesQuotationItem,
        final String language,
        final String longTextID )
    {
        return new SalesQuotationItemTextByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationItemText",
            salesQuotation,
            salesQuotationItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SalesQuotationItemTextUpdateFluentHelper updateSalesQuotationItemText(
        @Nonnull final SalesQuotationItemText salesQuotationItemText )
    {
        return new SalesQuotationItemTextUpdateFluentHelper(
            servicePath,
            salesQuotationItemText,
            "A_SalesQuotationItemText");
    }

    @Override
    @Nonnull
    public SalesQuotationItemTextDeleteFluentHelper deleteSalesQuotationItemText(
        @Nonnull final SalesQuotationItemText salesQuotationItemText )
    {
        return new SalesQuotationItemTextDeleteFluentHelper(
            servicePath,
            salesQuotationItemText,
            "A_SalesQuotationItemText");
    }

    @Override
    @Nonnull
    public SalesQuotationPartnerFluentHelper getAllSalesQuotationPartner()
    {
        return new SalesQuotationPartnerFluentHelper(servicePath, "A_SalesQuotationPartner");
    }

    @Override
    @Nonnull
    public
        SalesQuotationPartnerByKeyFluentHelper
        getSalesQuotationPartnerByKey( final String salesQuotation, final String partnerFunction )
    {
        return new SalesQuotationPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationPartner",
            salesQuotation,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesQuotationPartnerUpdateFluentHelper updateSalesQuotationPartner(
        @Nonnull final SalesQuotationPartner salesQuotationPartner )
    {
        return new SalesQuotationPartnerUpdateFluentHelper(
            servicePath,
            salesQuotationPartner,
            "A_SalesQuotationPartner");
    }

    @Override
    @Nonnull
    public SalesQuotationPartnerDeleteFluentHelper deleteSalesQuotationPartner(
        @Nonnull final SalesQuotationPartner salesQuotationPartner )
    {
        return new SalesQuotationPartnerDeleteFluentHelper(
            servicePath,
            salesQuotationPartner,
            "A_SalesQuotationPartner");
    }

    @Override
    @Nonnull
    public SalesQuotationPrcgElmntFluentHelper getAllSalesQuotationPrcgElmnt()
    {
        return new SalesQuotationPrcgElmntFluentHelper(servicePath, "A_SalesQuotationPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesQuotationPrcgElmntByKeyFluentHelper getSalesQuotationPrcgElmntByKey(
        final String salesQuotation,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesQuotationPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationPrcgElmnt",
            salesQuotation,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesQuotationPrcgElmntUpdateFluentHelper updateSalesQuotationPrcgElmnt(
        @Nonnull final SalesQuotationPrcgElmnt salesQuotationPrcgElmnt )
    {
        return new SalesQuotationPrcgElmntUpdateFluentHelper(
            servicePath,
            salesQuotationPrcgElmnt,
            "A_SalesQuotationPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesQuotationPrcgElmntDeleteFluentHelper deleteSalesQuotationPrcgElmnt(
        @Nonnull final SalesQuotationPrcgElmnt salesQuotationPrcgElmnt )
    {
        return new SalesQuotationPrcgElmntDeleteFluentHelper(
            servicePath,
            salesQuotationPrcgElmnt,
            "A_SalesQuotationPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesQuotationRelatedObjectFluentHelper getAllSalesQuotationRelatedObject()
    {
        return new SalesQuotationRelatedObjectFluentHelper(servicePath, "A_SalesQuotationRelatedObject");
    }

    @Override
    @Nonnull
    public
        SalesQuotationRelatedObjectByKeyFluentHelper
        getSalesQuotationRelatedObjectByKey( final String salesQuotation, final String sDDocRelatedObjectSequenceNmbr )
    {
        return new SalesQuotationRelatedObjectByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationRelatedObject",
            salesQuotation,
            sDDocRelatedObjectSequenceNmbr);
    }

    @Override
    @Nonnull
    public SalesQuotationRelatedObjectCreateFluentHelper createSalesQuotationRelatedObject(
        @Nonnull final SalesQuotationRelatedObject salesQuotationRelatedObject )
    {
        return new SalesQuotationRelatedObjectCreateFluentHelper(
            servicePath,
            salesQuotationRelatedObject,
            "A_SalesQuotationRelatedObject");
    }

    @Override
    @Nonnull
    public SalesQuotationRelatedObjectDeleteFluentHelper deleteSalesQuotationRelatedObject(
        @Nonnull final SalesQuotationRelatedObject salesQuotationRelatedObject )
    {
        return new SalesQuotationRelatedObjectDeleteFluentHelper(
            servicePath,
            salesQuotationRelatedObject,
            "A_SalesQuotationRelatedObject");
    }

    @Override
    @Nonnull
    public SalesQuotationTextFluentHelper getAllSalesQuotationText()
    {
        return new SalesQuotationTextFluentHelper(servicePath, "A_SalesQuotationText");
    }

    @Override
    @Nonnull
    public
        SalesQuotationTextByKeyFluentHelper
        getSalesQuotationTextByKey( final String salesQuotation, final String language, final String longTextID )
    {
        return new SalesQuotationTextByKeyFluentHelper(
            servicePath,
            "A_SalesQuotationText",
            salesQuotation,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SalesQuotationTextUpdateFluentHelper updateSalesQuotationText(
        @Nonnull final SalesQuotationText salesQuotationText )
    {
        return new SalesQuotationTextUpdateFluentHelper(servicePath, salesQuotationText, "A_SalesQuotationText");
    }

    @Override
    @Nonnull
    public SalesQuotationTextDeleteFluentHelper deleteSalesQuotationText(
        @Nonnull final SalesQuotationText salesQuotationText )
    {
        return new SalesQuotationTextDeleteFluentHelper(servicePath, salesQuotationText, "A_SalesQuotationText");
    }

    @Override
    @Nonnull
    public SlsQtanItemRelatedObjectFluentHelper getAllSlsQtanItemRelatedObject()
    {
        return new SlsQtanItemRelatedObjectFluentHelper(servicePath, "A_SlsQtanItemRelatedObject");
    }

    @Override
    @Nonnull
    public SlsQtanItemRelatedObjectByKeyFluentHelper getSlsQtanItemRelatedObjectByKey(
        final String salesQuotation,
        final String salesQuotationItem,
        final String sDDocRelatedObjectSequenceNmbr )
    {
        return new SlsQtanItemRelatedObjectByKeyFluentHelper(
            servicePath,
            "A_SlsQtanItemRelatedObject",
            salesQuotation,
            salesQuotationItem,
            sDDocRelatedObjectSequenceNmbr);
    }

    @Override
    @Nonnull
    public SlsQtanItemRelatedObjectCreateFluentHelper createSlsQtanItemRelatedObject(
        @Nonnull final SlsQtanItemRelatedObject slsQtanItemRelatedObject )
    {
        return new SlsQtanItemRelatedObjectCreateFluentHelper(
            servicePath,
            slsQtanItemRelatedObject,
            "A_SlsQtanItemRelatedObject");
    }

    @Override
    @Nonnull
    public SlsQtanItemRelatedObjectDeleteFluentHelper deleteSlsQtanItemRelatedObject(
        @Nonnull final SlsQtanItemRelatedObject slsQtanItemRelatedObject )
    {
        return new SlsQtanItemRelatedObjectDeleteFluentHelper(
            servicePath,
            slsQtanItemRelatedObject,
            "A_SlsQtanItemRelatedObject");
    }

    @Override
    @Nonnull
    public SlsQtanItmPrecdgProcFlowFluentHelper getAllSlsQtanItmPrecdgProcFlow()
    {
        return new SlsQtanItmPrecdgProcFlowFluentHelper(servicePath, "A_SlsQtanItmPrecdgProcFlow");
    }

    @Override
    @Nonnull
    public SlsQtanItmPrecdgProcFlowByKeyFluentHelper getSlsQtanItmPrecdgProcFlowByKey(
        final String salesQuotation,
        final String salesQuotationItem,
        final UUID docRelationshipUUID )
    {
        return new SlsQtanItmPrecdgProcFlowByKeyFluentHelper(
            servicePath,
            "A_SlsQtanItmPrecdgProcFlow",
            salesQuotation,
            salesQuotationItem,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public SlsQtanItmSubsqntProcFlowFluentHelper getAllSlsQtanItmSubsqntProcFlow()
    {
        return new SlsQtanItmSubsqntProcFlowFluentHelper(servicePath, "A_SlsQtanItmSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public SlsQtanItmSubsqntProcFlowByKeyFluentHelper getSlsQtanItmSubsqntProcFlowByKey(
        final String salesQuotation,
        final String salesQuotationItem,
        final UUID docRelationshipUUID )
    {
        return new SlsQtanItmSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_SlsQtanItmSubsqntProcFlow",
            salesQuotation,
            salesQuotationItem,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public SlsQtanPrecdgProcFlowFluentHelper getAllSlsQtanPrecdgProcFlow()
    {
        return new SlsQtanPrecdgProcFlowFluentHelper(servicePath, "A_SlsQtanPrecdgProcFlow");
    }

    @Override
    @Nonnull
    public
        SlsQtanPrecdgProcFlowByKeyFluentHelper
        getSlsQtanPrecdgProcFlowByKey( final String salesQuotation, final UUID docRelationshipUUID )
    {
        return new SlsQtanPrecdgProcFlowByKeyFluentHelper(
            servicePath,
            "A_SlsQtanPrecdgProcFlow",
            salesQuotation,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public SlsQtanSubsqntProcFlowFluentHelper getAllSlsQtanSubsqntProcFlow()
    {
        return new SlsQtanSubsqntProcFlowFluentHelper(servicePath, "A_SlsQtanSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public
        SlsQtanSubsqntProcFlowByKeyFluentHelper
        getSlsQtanSubsqntProcFlowByKey( final String salesQuotation, final UUID docRelationshipUUID )
    {
        return new SlsQtanSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_SlsQtanSubsqntProcFlow",
            salesQuotation,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String salesQuotation )
    {
        return new ReleaseApprovalRequestFluentHelper(servicePath, salesQuotation);
    }

    @Override
    @Nonnull
    public RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String salesQuotation )
    {
        return new RejectApprovalRequestFluentHelper(servicePath, salesQuotation);
    }

}
