/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.CreateCorrectionDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSchedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.batch.DefaultSalesSchedulingAgreementServiceBatch;

/**
 * <p>
 *
 * The service contains header, item, delivery schedule, and schedule line entities, as well as header and item
 * sub-entities for partners and pricing elements. Once the sales scheduling agreement has been created, the sales
 * scheduling agreement number is sent in the response with the data included in the sales scheduling agreement. If
 * there are any issues when creating, retrieving, updating, or deleting the sales scheduling agreement, the system
 * displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/90/4b06b7cbb84ce48e7f71c58db856e0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_SCHEDULING_AGREEMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_SCHEDULING_AGREEMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Scheduling Agreements Integration(SAP_COM_0360)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3NR'>Sales Scheduling Agreements(3NR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LZ'>Sales Scheduling Agreement with Consignment(4LZ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Scheduling Agreement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesSchedulingAgreementService" )
@Deprecated
public class DefaultSalesSchedulingAgreementService implements SalesSchedulingAgreementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesSchedulingAgreementService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesSchedulingAgreementService()
    {
        servicePath = SalesSchedulingAgreementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesSchedulingAgreementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesSchedulingAgreementService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesSchedulingAgreementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesSchedulingAgreementServiceBatch batch()
    {
        return new DefaultSalesSchedulingAgreementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtFluentHelper getAllSalesSchedgAgrmt()
    {
        return new SalesSchedgAgrmtFluentHelper(servicePath, "A_SalesSchedgAgrmt");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtByKeyFluentHelper getSalesSchedgAgrmtByKey( final String salesSchedulingAgreement )
    {
        return new SalesSchedgAgrmtByKeyFluentHelper(servicePath, "A_SalesSchedgAgrmt", salesSchedulingAgreement);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtCreateFluentHelper createSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt )
    {
        return new SalesSchedgAgrmtCreateFluentHelper(servicePath, salesSchedgAgrmt, "A_SalesSchedgAgrmt");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtUpdateFluentHelper updateSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt )
    {
        return new SalesSchedgAgrmtUpdateFluentHelper(servicePath, salesSchedgAgrmt, "A_SalesSchedgAgrmt");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtDeleteFluentHelper deleteSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt )
    {
        return new SalesSchedgAgrmtDeleteFluentHelper(servicePath, salesSchedgAgrmt, "A_SalesSchedgAgrmt");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtDelivSchedFluentHelper getAllSalesSchedgAgrmtDelivSched()
    {
        return new SalesSchedgAgrmtDelivSchedFluentHelper(servicePath, "A_SalesSchedgAgrmtDelivSched");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtDelivSchedByKeyFluentHelper getSalesSchedgAgrmtDelivSchedByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String intDeliveryScheduleNumber,
        final String schedulingAgreementReleaseType )
    {
        return new SalesSchedgAgrmtDelivSchedByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtDelivSched",
            salesSchedulingAgreement,
            salesSchedulingAgreementItem,
            intDeliveryScheduleNumber,
            schedulingAgreementReleaseType);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemFluentHelper getAllSalesSchedgAgrmtItem()
    {
        return new SalesSchedgAgrmtItemFluentHelper(servicePath, "A_SalesSchedgAgrmtItem");
    }

    @Override
    @Nonnull
    public
        SalesSchedgAgrmtItemByKeyFluentHelper
        getSalesSchedgAgrmtItemByKey( final String salesSchedulingAgreement, final String salesSchedulingAgreementItem )
    {
        return new SalesSchedgAgrmtItemByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtItem",
            salesSchedulingAgreement,
            salesSchedulingAgreementItem);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemCreateFluentHelper createSalesSchedgAgrmtItem(
        @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem )
    {
        return new SalesSchedgAgrmtItemCreateFluentHelper(servicePath, salesSchedgAgrmtItem, "A_SalesSchedgAgrmtItem");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemUpdateFluentHelper updateSalesSchedgAgrmtItem(
        @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem )
    {
        return new SalesSchedgAgrmtItemUpdateFluentHelper(servicePath, salesSchedgAgrmtItem, "A_SalesSchedgAgrmtItem");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemDeleteFluentHelper deleteSalesSchedgAgrmtItem(
        @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem )
    {
        return new SalesSchedgAgrmtItemDeleteFluentHelper(servicePath, salesSchedgAgrmtItem, "A_SalesSchedgAgrmtItem");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemPartnerFluentHelper getAllSalesSchedgAgrmtItemPartner()
    {
        return new SalesSchedgAgrmtItemPartnerFluentHelper(servicePath, "A_SalesSchedgAgrmtItemPartner");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemPartnerByKeyFluentHelper getSalesSchedgAgrmtItemPartnerByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String partnerFunction )
    {
        return new SalesSchedgAgrmtItemPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtItemPartner",
            salesSchedulingAgreement,
            salesSchedulingAgreementItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemPartnerUpdateFluentHelper updateSalesSchedgAgrmtItemPartner(
        @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner )
    {
        return new SalesSchedgAgrmtItemPartnerUpdateFluentHelper(
            servicePath,
            salesSchedgAgrmtItemPartner,
            "A_SalesSchedgAgrmtItemPartner");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemPartnerDeleteFluentHelper deleteSalesSchedgAgrmtItemPartner(
        @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner )
    {
        return new SalesSchedgAgrmtItemPartnerDeleteFluentHelper(
            servicePath,
            salesSchedgAgrmtItemPartner,
            "A_SalesSchedgAgrmtItemPartner");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemTextFluentHelper getAllSalesSchedgAgrmtItemText()
    {
        return new SalesSchedgAgrmtItemTextFluentHelper(servicePath, "A_SalesSchedgAgrmtItemText");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemTextByKeyFluentHelper getSalesSchedgAgrmtItemTextByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String language,
        final String longTextID )
    {
        return new SalesSchedgAgrmtItemTextByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtItemText",
            salesSchedulingAgreement,
            salesSchedulingAgreementItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemTextUpdateFluentHelper updateSalesSchedgAgrmtItemText(
        @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText )
    {
        return new SalesSchedgAgrmtItemTextUpdateFluentHelper(
            servicePath,
            salesSchedgAgrmtItemText,
            "A_SalesSchedgAgrmtItemText");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItemTextDeleteFluentHelper deleteSalesSchedgAgrmtItemText(
        @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText )
    {
        return new SalesSchedgAgrmtItemTextDeleteFluentHelper(
            servicePath,
            salesSchedgAgrmtItemText,
            "A_SalesSchedgAgrmtItemText");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItmPrcgElmntFluentHelper getAllSalesSchedgAgrmtItmPrcgElmnt()
    {
        return new SalesSchedgAgrmtItmPrcgElmntFluentHelper(servicePath, "A_SalesSchedgAgrmtItmPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItmPrcgElmntByKeyFluentHelper getSalesSchedgAgrmtItmPrcgElmntByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesSchedgAgrmtItmPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtItmPrcgElmnt",
            salesSchedulingAgreement,
            salesSchedulingAgreementItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItmPrcgElmntUpdateFluentHelper updateSalesSchedgAgrmtItmPrcgElmnt(
        @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt )
    {
        return new SalesSchedgAgrmtItmPrcgElmntUpdateFluentHelper(
            servicePath,
            salesSchedgAgrmtItmPrcgElmnt,
            "A_SalesSchedgAgrmtItmPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtItmPrcgElmntDeleteFluentHelper deleteSalesSchedgAgrmtItmPrcgElmnt(
        @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt )
    {
        return new SalesSchedgAgrmtItmPrcgElmntDeleteFluentHelper(
            servicePath,
            salesSchedgAgrmtItmPrcgElmnt,
            "A_SalesSchedgAgrmtItmPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtPartnerFluentHelper getAllSalesSchedgAgrmtPartner()
    {
        return new SalesSchedgAgrmtPartnerFluentHelper(servicePath, "A_SalesSchedgAgrmtPartner");
    }

    @Override
    @Nonnull
    public
        SalesSchedgAgrmtPartnerByKeyFluentHelper
        getSalesSchedgAgrmtPartnerByKey( final String salesSchedulingAgreement, final String partnerFunction )
    {
        return new SalesSchedgAgrmtPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtPartner",
            salesSchedulingAgreement,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtPartnerUpdateFluentHelper updateSalesSchedgAgrmtPartner(
        @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner )
    {
        return new SalesSchedgAgrmtPartnerUpdateFluentHelper(
            servicePath,
            salesSchedgAgrmtPartner,
            "A_SalesSchedgAgrmtPartner");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtPartnerDeleteFluentHelper deleteSalesSchedgAgrmtPartner(
        @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner )
    {
        return new SalesSchedgAgrmtPartnerDeleteFluentHelper(
            servicePath,
            salesSchedgAgrmtPartner,
            "A_SalesSchedgAgrmtPartner");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtPrcgElementFluentHelper getAllSalesSchedgAgrmtPrcgElement()
    {
        return new SalesSchedgAgrmtPrcgElementFluentHelper(servicePath, "A_SalesSchedgAgrmtPrcgElement");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtPrcgElementByKeyFluentHelper getSalesSchedgAgrmtPrcgElementByKey(
        final String salesSchedulingAgreement,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesSchedgAgrmtPrcgElementByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtPrcgElement",
            salesSchedulingAgreement,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtPrcgElementUpdateFluentHelper updateSalesSchedgAgrmtPrcgElement(
        @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement )
    {
        return new SalesSchedgAgrmtPrcgElementUpdateFluentHelper(
            servicePath,
            salesSchedgAgrmtPrcgElement,
            "A_SalesSchedgAgrmtPrcgElement");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtPrcgElementDeleteFluentHelper deleteSalesSchedgAgrmtPrcgElement(
        @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement )
    {
        return new SalesSchedgAgrmtPrcgElementDeleteFluentHelper(
            servicePath,
            salesSchedgAgrmtPrcgElement,
            "A_SalesSchedgAgrmtPrcgElement");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtSchedLineFluentHelper getAllSalesSchedgAgrmtSchedLine()
    {
        return new SalesSchedgAgrmtSchedLineFluentHelper(servicePath, "A_SalesSchedgAgrmtSchedLine");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtSchedLineByKeyFluentHelper getSalesSchedgAgrmtSchedLineByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String scheduleLine )
    {
        return new SalesSchedgAgrmtSchedLineByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtSchedLine",
            salesSchedulingAgreement,
            salesSchedulingAgreementItem,
            scheduleLine);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtTextFluentHelper getAllSalesSchedgAgrmtText()
    {
        return new SalesSchedgAgrmtTextFluentHelper(servicePath, "A_SalesSchedgAgrmtText");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtTextByKeyFluentHelper getSalesSchedgAgrmtTextByKey(
        final String salesSchedulingAgreement,
        final String language,
        final String longTextID )
    {
        return new SalesSchedgAgrmtTextByKeyFluentHelper(
            servicePath,
            "A_SalesSchedgAgrmtText",
            salesSchedulingAgreement,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtTextUpdateFluentHelper updateSalesSchedgAgrmtText(
        @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText )
    {
        return new SalesSchedgAgrmtTextUpdateFluentHelper(servicePath, salesSchedgAgrmtText, "A_SalesSchedgAgrmtText");
    }

    @Override
    @Nonnull
    public SalesSchedgAgrmtTextDeleteFluentHelper deleteSalesSchedgAgrmtText(
        @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText )
    {
        return new SalesSchedgAgrmtTextDeleteFluentHelper(servicePath, salesSchedgAgrmtText, "A_SalesSchedgAgrmtText");
    }

    @Override
    @Nonnull
    public CreateCorrectionDeliveryFluentHelper createCorrectionDelivery(
        @Nonnull final String salesSchedulingAgreementItem,
        @Nonnull final String salesSchedulingAgreement,
        @Nonnull final BigDecimal correctionDeliveryQuantity,
        @Nonnull final LocalDateTime correctionDeliveryDate )
    {
        return new CreateCorrectionDeliveryFluentHelper(
            servicePath,
            salesSchedulingAgreementItem,
            salesSchedulingAgreement,
            correctionDeliveryQuantity,
            correctionDeliveryDate);
    }

}
