/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.HeaderReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.ItemReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.batch.DefaultSchedulingAgreementServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete purchase scheduling agreements from any external system
 * through an API call. Once the purchase scheduling agreement has been created or updated, the scheduling agreement
 * number is sent in the response. If there are any issues while managing (create, read or update) purchase scheduling
 * agreements, the system displays error messages in the response.
 *
 * # .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c7/584658aac4a007e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SCHED_AGRMT_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SCHED_AGRMT_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchase Scheduling Agreement Integration(SAP_COM_0103)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMR'>Scheduling Agreements in Procurement(BMR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Scheduling Agreement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSchedulingAgreementService" )
@Deprecated
public class DefaultSchedulingAgreementService implements SchedulingAgreementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SchedulingAgreementService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSchedulingAgreementService()
    {
        servicePath = SchedulingAgreementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSchedulingAgreementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSchedulingAgreementService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSchedulingAgreementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSchedulingAgreementServiceBatch batch()
    {
        return new DefaultSchedulingAgreementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SchAgrmtAcCntFluentHelper getAllSchAgrmtAcCnt()
    {
        return new SchAgrmtAcCntFluentHelper(servicePath, "A_SchAgrmtAcCnt");
    }

    @Override
    @Nonnull
    public SchAgrmtAcCntByKeyFluentHelper getSchAgrmtAcCntByKey(
        final String accountAssignmentNumber,
        final String schedulingAgreementItem,
        final String schedulingAgreement )
    {
        return new SchAgrmtAcCntByKeyFluentHelper(
            servicePath,
            "A_SchAgrmtAcCnt",
            accountAssignmentNumber,
            schedulingAgreementItem,
            schedulingAgreement);
    }

    @Override
    @Nonnull
    public SchAgrmtAcCntCreateFluentHelper createSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt )
    {
        return new SchAgrmtAcCntCreateFluentHelper(servicePath, schAgrmtAcCnt, "A_SchAgrmtAcCnt");
    }

    @Override
    @Nonnull
    public SchAgrmtAcCntUpdateFluentHelper updateSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt )
    {
        return new SchAgrmtAcCntUpdateFluentHelper(servicePath, schAgrmtAcCnt, "A_SchAgrmtAcCnt");
    }

    @Override
    @Nonnull
    public SchAgrmtHeaderFluentHelper getAllSchAgrmtHeader()
    {
        return new SchAgrmtHeaderFluentHelper(servicePath, "A_SchAgrmtHeader");
    }

    @Override
    @Nonnull
    public SchAgrmtHeaderByKeyFluentHelper getSchAgrmtHeaderByKey( final String schedulingAgreement )
    {
        return new SchAgrmtHeaderByKeyFluentHelper(servicePath, "A_SchAgrmtHeader", schedulingAgreement);
    }

    @Override
    @Nonnull
    public SchAgrmtHeaderCreateFluentHelper createSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader )
    {
        return new SchAgrmtHeaderCreateFluentHelper(servicePath, schAgrmtHeader, "A_SchAgrmtHeader");
    }

    @Override
    @Nonnull
    public SchAgrmtHeaderUpdateFluentHelper updateSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader )
    {
        return new SchAgrmtHeaderUpdateFluentHelper(servicePath, schAgrmtHeader, "A_SchAgrmtHeader");
    }

    @Override
    @Nonnull
    public SchAgrmtItemFluentHelper getAllSchAgrmtItem()
    {
        return new SchAgrmtItemFluentHelper(servicePath, "A_SchAgrmtItem");
    }

    @Override
    @Nonnull
    public
        SchAgrmtItemByKeyFluentHelper
        getSchAgrmtItemByKey( final String schedulingAgreement, final String schedulingAgreementItem )
    {
        return new SchAgrmtItemByKeyFluentHelper(
            servicePath,
            "A_SchAgrmtItem",
            schedulingAgreement,
            schedulingAgreementItem);
    }

    @Override
    @Nonnull
    public SchAgrmtItemCreateFluentHelper createSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem )
    {
        return new SchAgrmtItemCreateFluentHelper(servicePath, schAgrmtItem, "A_SchAgrmtItem");
    }

    @Override
    @Nonnull
    public SchAgrmtItemUpdateFluentHelper updateSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem )
    {
        return new SchAgrmtItemUpdateFluentHelper(servicePath, schAgrmtItem, "A_SchAgrmtItem");
    }

    @Override
    @Nonnull
    public SchAgrmtPartnerFluentHelper getAllSchAgrmtPartner()
    {
        return new SchAgrmtPartnerFluentHelper(servicePath, "A_SchAgrmtPartner");
    }

    @Override
    @Nonnull
    public SchAgrmtPartnerByKeyFluentHelper getSchAgrmtPartnerByKey(
        final String schedulingAgreement,
        final String schedulingAgreementItem,
        final String purchasingOrganization,
        final String supplierSubrange,
        final String plant,
        final String partnerFunction,
        final String partnerCounter )
    {
        return new SchAgrmtPartnerByKeyFluentHelper(
            servicePath,
            "A_SchAgrmtPartner",
            schedulingAgreement,
            schedulingAgreementItem,
            purchasingOrganization,
            supplierSubrange,
            plant,
            partnerFunction,
            partnerCounter);
    }

    @Override
    @Nonnull
    public SchAgrmtSchLineFluentHelper getAllSchAgrmtSchLine()
    {
        return new SchAgrmtSchLineFluentHelper(servicePath, "A_SchAgrmtSchLine");
    }

    @Override
    @Nonnull
    public SchAgrmtSchLineByKeyFluentHelper getSchAgrmtSchLineByKey(
        final String schedulingAgreement,
        final String schedulingAgreementItem,
        final String scheduleLine )
    {
        return new SchAgrmtSchLineByKeyFluentHelper(
            servicePath,
            "A_SchAgrmtSchLine",
            schedulingAgreement,
            schedulingAgreementItem,
            scheduleLine);
    }

    @Override
    @Nonnull
    public SchAgrmtSchLineCreateFluentHelper createSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine )
    {
        return new SchAgrmtSchLineCreateFluentHelper(servicePath, schAgrmtSchLine, "A_SchAgrmtSchLine");
    }

    @Override
    @Nonnull
    public SchAgrmtSchLineUpdateFluentHelper updateSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine )
    {
        return new SchAgrmtSchLineUpdateFluentHelper(servicePath, schAgrmtSchLine, "A_SchAgrmtSchLine");
    }

    @Override
    @Nonnull
    public SchAgrmtSchLineDeleteFluentHelper deleteSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine )
    {
        return new SchAgrmtSchLineDeleteFluentHelper(servicePath, schAgrmtSchLine, "A_SchAgrmtSchLine");
    }

    @Override
    @Nonnull
    public SchedgAgrmtDeliveryAddressFluentHelper getAllSchedgAgrmtDeliveryAddress()
    {
        return new SchedgAgrmtDeliveryAddressFluentHelper(servicePath, "A_SchedgAgrmtDeliveryAddress");
    }

    @Override
    @Nonnull
    public
        SchedgAgrmtDeliveryAddressByKeyFluentHelper
        getSchedgAgrmtDeliveryAddressByKey( final String schedulingAgreement, final String schedulingAgreementItem )
    {
        return new SchedgAgrmtDeliveryAddressByKeyFluentHelper(
            servicePath,
            "A_SchedgAgrmtDeliveryAddress",
            schedulingAgreement,
            schedulingAgreementItem);
    }

    @Override
    @Nonnull
    public SchedgAgrmtDeliveryAddressCreateFluentHelper createSchedgAgrmtDeliveryAddress(
        @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress )
    {
        return new SchedgAgrmtDeliveryAddressCreateFluentHelper(
            servicePath,
            schedgAgrmtDeliveryAddress,
            "A_SchedgAgrmtDeliveryAddress");
    }

    @Override
    @Nonnull
    public SchedgAgrmtDeliveryAddressUpdateFluentHelper updateSchedgAgrmtDeliveryAddress(
        @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress )
    {
        return new SchedgAgrmtDeliveryAddressUpdateFluentHelper(
            servicePath,
            schedgAgrmtDeliveryAddress,
            "A_SchedgAgrmtDeliveryAddress");
    }

    @Override
    @Nonnull
    public SchedgAgrmtHdrNotesFluentHelper getAllSchedgAgrmtHdrNotes()
    {
        return new SchedgAgrmtHdrNotesFluentHelper(servicePath, "A_SchedgAgrmtHdrNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtHdrNotesByKeyFluentHelper getSchedgAgrmtHdrNotesByKey(
        final String language,
        final String documentText,
        final String technicalObjectType,
        final String archObjectNumber,
        final String schedulingAgreement )
    {
        return new SchedgAgrmtHdrNotesByKeyFluentHelper(
            servicePath,
            "A_SchedgAgrmtHdrNotes",
            language,
            documentText,
            technicalObjectType,
            archObjectNumber,
            schedulingAgreement);
    }

    @Override
    @Nonnull
    public SchedgAgrmtHdrNotesCreateFluentHelper createSchedgAgrmtHdrNotes(
        @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes )
    {
        return new SchedgAgrmtHdrNotesCreateFluentHelper(servicePath, schedgAgrmtHdrNotes, "A_SchedgAgrmtHdrNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtHdrNotesUpdateFluentHelper updateSchedgAgrmtHdrNotes(
        @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes )
    {
        return new SchedgAgrmtHdrNotesUpdateFluentHelper(servicePath, schedgAgrmtHdrNotes, "A_SchedgAgrmtHdrNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtHdrNotesDeleteFluentHelper deleteSchedgAgrmtHdrNotes(
        @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes )
    {
        return new SchedgAgrmtHdrNotesDeleteFluentHelper(servicePath, schedgAgrmtHdrNotes, "A_SchedgAgrmtHdrNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtItmNotesFluentHelper getAllSchedgAgrmtItmNotes()
    {
        return new SchedgAgrmtItmNotesFluentHelper(servicePath, "A_SchedgAgrmtItmNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtItmNotesByKeyFluentHelper getSchedgAgrmtItmNotesByKey(
        final String language,
        final String documentText,
        final String technicalObjectType,
        final String archObjectNumber )
    {
        return new SchedgAgrmtItmNotesByKeyFluentHelper(
            servicePath,
            "A_SchedgAgrmtItmNotes",
            language,
            documentText,
            technicalObjectType,
            archObjectNumber);
    }

    @Override
    @Nonnull
    public SchedgAgrmtItmNotesCreateFluentHelper createSchedgAgrmtItmNotes(
        @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes )
    {
        return new SchedgAgrmtItmNotesCreateFluentHelper(servicePath, schedgAgrmtItmNotes, "A_SchedgAgrmtItmNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtItmNotesUpdateFluentHelper updateSchedgAgrmtItmNotes(
        @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes )
    {
        return new SchedgAgrmtItmNotesUpdateFluentHelper(servicePath, schedgAgrmtItmNotes, "A_SchedgAgrmtItmNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtItmNotesDeleteFluentHelper deleteSchedgAgrmtItmNotes(
        @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes )
    {
        return new SchedgAgrmtItmNotesDeleteFluentHelper(servicePath, schedgAgrmtItmNotes, "A_SchedgAgrmtItmNotes");
    }

    @Override
    @Nonnull
    public SchedgAgrmtSubcontrgCompFluentHelper getAllSchedgAgrmtSubcontrgComp()
    {
        return new SchedgAgrmtSubcontrgCompFluentHelper(servicePath, "A_SchedgAgrmtSubcontrgComp");
    }

    @Override
    @Nonnull
    public SchedgAgrmtSubcontrgCompByKeyFluentHelper getSchedgAgrmtSubcontrgCompByKey(
        final String schedulingAgreement,
        final String schedulingAgreementItem,
        final String scheduleLine,
        final String reservationItem,
        final String recordType )
    {
        return new SchedgAgrmtSubcontrgCompByKeyFluentHelper(
            servicePath,
            "A_SchedgAgrmtSubcontrgComp",
            schedulingAgreement,
            schedulingAgreementItem,
            scheduleLine,
            reservationItem,
            recordType);
    }

    @Override
    @Nonnull
    public SchedgAgrmtSubcontrgCompUpdateFluentHelper updateSchedgAgrmtSubcontrgComp(
        @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp )
    {
        return new SchedgAgrmtSubcontrgCompUpdateFluentHelper(
            servicePath,
            schedgAgrmtSubcontrgComp,
            "A_SchedgAgrmtSubcontrgComp");
    }

    @Override
    @Nonnull
    public SchedgAgrmtSubcontrgCompDeleteFluentHelper deleteSchedgAgrmtSubcontrgComp(
        @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp )
    {
        return new SchedgAgrmtSubcontrgCompDeleteFluentHelper(
            servicePath,
            schedgAgrmtSubcontrgComp,
            "A_SchedgAgrmtSubcontrgComp");
    }

    @Override
    @Nonnull
    public WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String schedulingAgreement )
    {
        return new WithdrawFromApprovalFluentHelper(servicePath, schedulingAgreement);
    }

    @Override
    @Nonnull
    public HeaderReleaseFluentHelper headerRelease(
        @Nonnull final String schedulingAgreement,
        @Nonnull final Boolean schedgAgreementWithJitProfile,
        @Nonnull final Boolean schedgAgreementWithFrcProfile,
        @Nonnull final Boolean schedgAgreementCreateFrcAndJit,
        @Nonnull final Boolean schedgAgreementCreateFrcOnly,
        @Nonnull final Boolean schedgAgreementCreateJitOnly,
        @Nonnull final Boolean schedgAgreementCreateWoutSline,
        @Nonnull final Boolean schedgAgreementDeactFrcTolChck,
        @Nonnull final Boolean schedgAgreementdeactJitTolChck,
        @Nonnull final String schedgAgreementMoveCreateDate,
        @Nonnull final Boolean schedgAgreementOffFrcDynStop,
        @Nonnull final Boolean schedgAgreementOffJitDynStop,
        @Nonnull final String schedgAgreementSelectionScope,
        @Nonnull final String schedgAgreementStandardRelDate )
    {
        return new HeaderReleaseFluentHelper(
            servicePath,
            schedulingAgreement,
            schedgAgreementWithJitProfile,
            schedgAgreementWithFrcProfile,
            schedgAgreementCreateFrcAndJit,
            schedgAgreementCreateFrcOnly,
            schedgAgreementCreateJitOnly,
            schedgAgreementCreateWoutSline,
            schedgAgreementDeactFrcTolChck,
            schedgAgreementdeactJitTolChck,
            schedgAgreementMoveCreateDate,
            schedgAgreementOffFrcDynStop,
            schedgAgreementOffJitDynStop,
            schedgAgreementSelectionScope,
            schedgAgreementStandardRelDate);
    }

    @Override
    @Nonnull
    public ItemReleaseFluentHelper itemRelease(
        @Nonnull final String schedulingAgreement,
        @Nonnull final String schedulingAgreementItem,
        @Nonnull final String schedulingAgreementReleaseType )
    {
        return new ItemReleaseFluentHelper(
            servicePath,
            schedulingAgreement,
            schedulingAgreementItem,
            schedulingAgreementReleaseType);
    }

}
