/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.SegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.SegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.SegmentTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.SegmentTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.batch.DefaultSegmentServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve segments and their names in the respective language..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f2/c665d7d7cf423d910c111f8fb558cd/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SEGMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SEGMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Segment</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSegmentService" )
@Deprecated
public class DefaultSegmentService implements SegmentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SegmentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSegmentService()
    {
        servicePath = SegmentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSegmentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSegmentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSegmentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSegmentServiceBatch batch()
    {
        return new DefaultSegmentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SegmentFluentHelper getAllSegment()
    {
        return new SegmentFluentHelper(servicePath, "A_Segment");
    }

    @Override
    @Nonnull
    public SegmentByKeyFluentHelper getSegmentByKey( final String segment )
    {
        return new SegmentByKeyFluentHelper(servicePath, "A_Segment", segment);
    }

    @Override
    @Nonnull
    public SegmentTextFluentHelper getAllSegmentText()
    {
        return new SegmentTextFluentHelper(servicePath, "A_SegmentText");
    }

    @Override
    @Nonnull
    public SegmentTextByKeyFluentHelper getSegmentTextByKey( final String language, final String segment )
    {
        return new SegmentTextByKeyFluentHelper(servicePath, "A_SegmentText", language, segment);
    }

}
