/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.batch.DefaultSepaMandateManageInAccountsReceivableServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, and update SEPA Mandates for Accounts Receivable (FI-AR). You can also
 * create and read about the usage of SEPA mandates. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ed/139844691f43c6baf38f0f2ddef5eb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_APAR_SEPA_MANDATE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_APAR_SEPA_MANDATE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Accounts Receivable SEPA Mandate Integration(SAP_COM_0719)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/19M'>Direct Debit(19M)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SEPA Mandate</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSepaMandateManageInAccountsReceivableService" )
@Deprecated
public class DefaultSepaMandateManageInAccountsReceivableService implements SepaMandateManageInAccountsReceivableService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SepaMandateManageInAccountsReceivableService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultSepaMandateManageInAccountsReceivableService()
    {
        servicePath = SepaMandateManageInAccountsReceivableService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSepaMandateManageInAccountsReceivableService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSepaMandateManageInAccountsReceivableService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSepaMandateManageInAccountsReceivableService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSepaMandateManageInAccountsReceivableServiceBatch batch()
    {
        return new DefaultSepaMandateManageInAccountsReceivableServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SEPAMandateFluentHelper getAllSEPAMandate()
    {
        return new SEPAMandateFluentHelper(servicePath, "SEPAMandateSet");
    }

    @Override
    @Nonnull
    public SEPAMandateByKeyFluentHelper getSEPAMandateByKey( final String creditor, final String sEPAMandate )
    {
        return new SEPAMandateByKeyFluentHelper(servicePath, "SEPAMandateSet", creditor, sEPAMandate);
    }

    @Override
    @Nonnull
    public SEPAMandateCreateFluentHelper createSEPAMandate( @Nonnull final SEPAMandate sEPAMandate )
    {
        return new SEPAMandateCreateFluentHelper(servicePath, sEPAMandate, "SEPAMandateSet");
    }

    @Override
    @Nonnull
    public SEPAMandateUpdateFluentHelper updateSEPAMandate( @Nonnull final SEPAMandate sEPAMandate )
    {
        return new SEPAMandateUpdateFluentHelper(servicePath, sEPAMandate, "SEPAMandateSet");
    }

    @Override
    @Nonnull
    public SEPAMandateUsageFluentHelper getAllSEPAMandateUsage()
    {
        return new SEPAMandateUsageFluentHelper(servicePath, "SEPAMandateUsageSet");
    }

    @Override
    @Nonnull
    public SEPAMandateUsageByKeyFluentHelper getSEPAMandateUsageByKey(
        final String creditor,
        final String sEPAMandate,
        final LocalDateTime sEPAMandateUseDate,
        final String sEPAMandateUseObjectType,
        final String sEPAMandateUsePaymentDoc )
    {
        return new SEPAMandateUsageByKeyFluentHelper(
            servicePath,
            "SEPAMandateUsageSet",
            creditor,
            sEPAMandate,
            sEPAMandateUseDate,
            sEPAMandateUseObjectType,
            sEPAMandateUsePaymentDoc);
    }

    @Override
    @Nonnull
    public SEPAMandateUsageCreateFluentHelper createSEPAMandateUsage( @Nonnull final SEPAMandateUsage sEPAMandateUsage )
    {
        return new SEPAMandateUsageCreateFluentHelper(servicePath, sEPAMandateUsage, "SEPAMandateUsageSet");
    }

}
