/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.batch.DefaultServiceConfirmationServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service confirmation processing in SAP S/4HANA
 * Cloud. In each API call, you can use the following operations: - Retrieve service confirmations. - Create service
 * confirmations. Note: You must use “deep insert” requests (a header plus the following entities: header person
 * responsible, header reference object, header pricing element, header text, and item). - Create new items for existing
 * service confirmations. - Create an item reference object, item pricing element, and an item text for existing service
 * confirmation items. - Update the header, header person responsible, header reference object, header pricing element,
 * header text, item, item reference object, item pricing element, and item text for existing service confirmations. -
 * Delete the header person responsible, header reference object, header text, item, item reference object, and item
 * text for existing service confirmations.
 *
 * This service enables you to add attachments to service confirmation items by making an API call to the service
 * Attachments (API_CV_ATTACHMENT_SRV). You can also use the service Attachments to download and delete attachments from
 * service confirmation items..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a4/6bcadb5c914c06ae8b84c9a6dc368f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_CONFIRMATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_CONFIRMATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Confirmation OData Integration(SAP_COM_0352), Service - Repair Confirmation
 * Integration(SAP_COM_0933)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Confirmation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultServiceConfirmationService" )
@Deprecated
public class DefaultServiceConfirmationService implements ServiceConfirmationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ServiceConfirmationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultServiceConfirmationService()
    {
        servicePath = ServiceConfirmationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultServiceConfirmationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultServiceConfirmationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultServiceConfirmationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultServiceConfirmationServiceBatch batch()
    {
        return new DefaultServiceConfirmationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ServiceConfirmationFluentHelper getAllServiceConfirmation()
    {
        return new ServiceConfirmationFluentHelper(servicePath, "A_ServiceConfirmation");
    }

    @Override
    @Nonnull
    public ServiceConfirmationByKeyFluentHelper getServiceConfirmationByKey( final String serviceConfirmation )
    {
        return new ServiceConfirmationByKeyFluentHelper(servicePath, "A_ServiceConfirmation", serviceConfirmation);
    }

    @Override
    @Nonnull
    public ServiceConfirmationCreateFluentHelper createServiceConfirmation(
        @Nonnull final ServiceConfirmation serviceConfirmation )
    {
        return new ServiceConfirmationCreateFluentHelper(servicePath, serviceConfirmation, "A_ServiceConfirmation");
    }

    @Override
    @Nonnull
    public ServiceConfirmationUpdateFluentHelper updateServiceConfirmation(
        @Nonnull final ServiceConfirmation serviceConfirmation )
    {
        return new ServiceConfirmationUpdateFluentHelper(servicePath, serviceConfirmation, "A_ServiceConfirmation");
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemFluentHelper getAllServiceConfirmationItem()
    {
        return new ServiceConfirmationItemFluentHelper(servicePath, "A_ServiceConfirmationItem");
    }

    @Override
    @Nonnull
    public
        ServiceConfirmationItemByKeyFluentHelper
        getServiceConfirmationItemByKey( final String serviceConfirmation, final String serviceConfirmationItem )
    {
        return new ServiceConfirmationItemByKeyFluentHelper(
            servicePath,
            "A_ServiceConfirmationItem",
            serviceConfirmation,
            serviceConfirmationItem);
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemCreateFluentHelper createServiceConfirmationItem(
        @Nonnull final ServiceConfirmationItem serviceConfirmationItem )
    {
        return new ServiceConfirmationItemCreateFluentHelper(
            servicePath,
            serviceConfirmationItem,
            "A_ServiceConfirmationItem");
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemUpdateFluentHelper updateServiceConfirmationItem(
        @Nonnull final ServiceConfirmationItem serviceConfirmationItem )
    {
        return new ServiceConfirmationItemUpdateFluentHelper(
            servicePath,
            serviceConfirmationItem,
            "A_ServiceConfirmationItem");
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemDeleteFluentHelper deleteServiceConfirmationItem(
        @Nonnull final ServiceConfirmationItem serviceConfirmationItem )
    {
        return new ServiceConfirmationItemDeleteFluentHelper(
            servicePath,
            serviceConfirmationItem,
            "A_ServiceConfirmationItem");
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemTextFluentHelper getAllServiceConfirmationItemText()
    {
        return new ServiceConfirmationItemTextFluentHelper(servicePath, "A_ServiceConfirmationItemText");
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemTextByKeyFluentHelper getServiceConfirmationItemTextByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String language,
        final String longTextID )
    {
        return new ServiceConfirmationItemTextByKeyFluentHelper(
            servicePath,
            "A_ServiceConfirmationItemText",
            serviceConfirmation,
            serviceConfirmationItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemTextCreateFluentHelper createServiceConfirmationItemText(
        @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText )
    {
        return new ServiceConfirmationItemTextCreateFluentHelper(
            servicePath,
            serviceConfirmationItemText,
            "A_ServiceConfirmationItemText");
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemTextUpdateFluentHelper updateServiceConfirmationItemText(
        @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText )
    {
        return new ServiceConfirmationItemTextUpdateFluentHelper(
            servicePath,
            serviceConfirmationItemText,
            "A_ServiceConfirmationItemText");
    }

    @Override
    @Nonnull
    public ServiceConfirmationItemTextDeleteFluentHelper deleteServiceConfirmationItemText(
        @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText )
    {
        return new ServiceConfirmationItemTextDeleteFluentHelper(
            servicePath,
            serviceConfirmationItemText,
            "A_ServiceConfirmationItemText");
    }

    @Override
    @Nonnull
    public ServiceConfirmationTextFluentHelper getAllServiceConfirmationText()
    {
        return new ServiceConfirmationTextFluentHelper(servicePath, "A_ServiceConfirmationText");
    }

    @Override
    @Nonnull
    public ServiceConfirmationTextByKeyFluentHelper getServiceConfirmationTextByKey(
        final String serviceConfirmation,
        final String language,
        final String longTextID )
    {
        return new ServiceConfirmationTextByKeyFluentHelper(
            servicePath,
            "A_ServiceConfirmationText",
            serviceConfirmation,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceConfirmationTextCreateFluentHelper createServiceConfirmationText(
        @Nonnull final ServiceConfirmationText serviceConfirmationText )
    {
        return new ServiceConfirmationTextCreateFluentHelper(
            servicePath,
            serviceConfirmationText,
            "A_ServiceConfirmationText");
    }

    @Override
    @Nonnull
    public ServiceConfirmationTextUpdateFluentHelper updateServiceConfirmationText(
        @Nonnull final ServiceConfirmationText serviceConfirmationText )
    {
        return new ServiceConfirmationTextUpdateFluentHelper(
            servicePath,
            serviceConfirmationText,
            "A_ServiceConfirmationText");
    }

    @Override
    @Nonnull
    public ServiceConfirmationTextDeleteFluentHelper deleteServiceConfirmationText(
        @Nonnull final ServiceConfirmationText serviceConfirmationText )
    {
        return new ServiceConfirmationTextDeleteFluentHelper(
            servicePath,
            serviceConfirmationText,
            "A_ServiceConfirmationText");
    }

    @Override
    @Nonnull
    public ServiceConfItemPriceElementFluentHelper getAllServiceConfItemPriceElement()
    {
        return new ServiceConfItemPriceElementFluentHelper(servicePath, "A_ServiceConfItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceConfItemPriceElementByKeyFluentHelper getServiceConfItemPriceElementByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new ServiceConfItemPriceElementByKeyFluentHelper(
            servicePath,
            "A_ServiceConfItemPriceElement",
            serviceConfirmation,
            serviceConfirmationItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public ServiceConfItemPriceElementCreateFluentHelper createServiceConfItemPriceElement(
        @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement )
    {
        return new ServiceConfItemPriceElementCreateFluentHelper(
            servicePath,
            serviceConfItemPriceElement,
            "A_ServiceConfItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceConfItemPriceElementUpdateFluentHelper updateServiceConfItemPriceElement(
        @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement )
    {
        return new ServiceConfItemPriceElementUpdateFluentHelper(
            servicePath,
            serviceConfItemPriceElement,
            "A_ServiceConfItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceConfItemUserStatusFluentHelper getAllServiceConfItemUserStatus()
    {
        return new ServiceConfItemUserStatusFluentHelper(servicePath, "A_ServiceConfItemUserStatus");
    }

    @Override
    @Nonnull
    public ServiceConfItemUserStatusByKeyFluentHelper getServiceConfItemUserStatusByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcConfItemUserStatus )
    {
        return new ServiceConfItemUserStatusByKeyFluentHelper(
            servicePath,
            "A_ServiceConfItemUserStatus",
            serviceConfirmation,
            serviceConfirmationItem,
            srvcConfItemUserStatus);
    }

    @Override
    @Nonnull
    public ServiceConfItemUserStatusCreateFluentHelper createServiceConfItemUserStatus(
        @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus )
    {
        return new ServiceConfItemUserStatusCreateFluentHelper(
            servicePath,
            serviceConfItemUserStatus,
            "A_ServiceConfItemUserStatus");
    }

    @Override
    @Nonnull
    public ServiceConfItemUserStatusDeleteFluentHelper deleteServiceConfItemUserStatus(
        @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus )
    {
        return new ServiceConfItemUserStatusDeleteFluentHelper(
            servicePath,
            serviceConfItemUserStatus,
            "A_ServiceConfItemUserStatus");
    }

    @Override
    @Nonnull
    public ServiceConfItmRefObjectFluentHelper getAllServiceConfItmRefObject()
    {
        return new ServiceConfItmRefObjectFluentHelper(servicePath, "A_ServiceConfItmRefObject");
    }

    @Override
    @Nonnull
    public ServiceConfItmRefObjectByKeyFluentHelper getServiceConfItmRefObjectByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceConfItmRefObjectByKeyFluentHelper(
            servicePath,
            "A_ServiceConfItmRefObject",
            serviceConfirmation,
            serviceConfirmationItem,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceConfItmRefObjectCreateFluentHelper createServiceConfItmRefObject(
        @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject )
    {
        return new ServiceConfItmRefObjectCreateFluentHelper(
            servicePath,
            serviceConfItmRefObject,
            "A_ServiceConfItmRefObject");
    }

    @Override
    @Nonnull
    public ServiceConfItmRefObjectDeleteFluentHelper deleteServiceConfItmRefObject(
        @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject )
    {
        return new ServiceConfItmRefObjectDeleteFluentHelper(
            servicePath,
            serviceConfItmRefObject,
            "A_ServiceConfItmRefObject");
    }

    @Override
    @Nonnull
    public ServiceConfPersonRespFluentHelper getAllServiceConfPersonResp()
    {
        return new ServiceConfPersonRespFluentHelper(servicePath, "A_ServiceConfPersonResp");
    }

    @Override
    @Nonnull
    public
        ServiceConfPersonRespByKeyFluentHelper
        getServiceConfPersonRespByKey( final String serviceConfirmation, final String personResponsible )
    {
        return new ServiceConfPersonRespByKeyFluentHelper(
            servicePath,
            "A_ServiceConfPersonResp",
            serviceConfirmation,
            personResponsible);
    }

    @Override
    @Nonnull
    public ServiceConfPersonRespCreateFluentHelper createServiceConfPersonResp(
        @Nonnull final ServiceConfPersonResp serviceConfPersonResp )
    {
        return new ServiceConfPersonRespCreateFluentHelper(
            servicePath,
            serviceConfPersonResp,
            "A_ServiceConfPersonResp");
    }

    @Override
    @Nonnull
    public ServiceConfPersonRespUpdateFluentHelper updateServiceConfPersonResp(
        @Nonnull final ServiceConfPersonResp serviceConfPersonResp )
    {
        return new ServiceConfPersonRespUpdateFluentHelper(
            servicePath,
            serviceConfPersonResp,
            "A_ServiceConfPersonResp");
    }

    @Override
    @Nonnull
    public ServiceConfPersonRespDeleteFluentHelper deleteServiceConfPersonResp(
        @Nonnull final ServiceConfPersonResp serviceConfPersonResp )
    {
        return new ServiceConfPersonRespDeleteFluentHelper(
            servicePath,
            serviceConfPersonResp,
            "A_ServiceConfPersonResp");
    }

    @Override
    @Nonnull
    public ServiceConfPriceElementFluentHelper getAllServiceConfPriceElement()
    {
        return new ServiceConfPriceElementFluentHelper(servicePath, "A_ServiceConfPriceElement");
    }

    @Override
    @Nonnull
    public ServiceConfPriceElementByKeyFluentHelper getServiceConfPriceElementByKey(
        final String serviceConfirmation,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new ServiceConfPriceElementByKeyFluentHelper(
            servicePath,
            "A_ServiceConfPriceElement",
            serviceConfirmation,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public ServiceConfPriceElementCreateFluentHelper createServiceConfPriceElement(
        @Nonnull final ServiceConfPriceElement serviceConfPriceElement )
    {
        return new ServiceConfPriceElementCreateFluentHelper(
            servicePath,
            serviceConfPriceElement,
            "A_ServiceConfPriceElement");
    }

    @Override
    @Nonnull
    public ServiceConfPriceElementUpdateFluentHelper updateServiceConfPriceElement(
        @Nonnull final ServiceConfPriceElement serviceConfPriceElement )
    {
        return new ServiceConfPriceElementUpdateFluentHelper(
            servicePath,
            serviceConfPriceElement,
            "A_ServiceConfPriceElement");
    }

    @Override
    @Nonnull
    public ServiceConfRefObjectFluentHelper getAllServiceConfRefObject()
    {
        return new ServiceConfRefObjectFluentHelper(servicePath, "A_ServiceConfRefObject");
    }

    @Override
    @Nonnull
    public ServiceConfRefObjectByKeyFluentHelper getServiceConfRefObjectByKey(
        final String serviceConfirmation,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceConfRefObjectByKeyFluentHelper(
            servicePath,
            "A_ServiceConfRefObject",
            serviceConfirmation,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceConfRefObjectCreateFluentHelper createServiceConfRefObject(
        @Nonnull final ServiceConfRefObject serviceConfRefObject )
    {
        return new ServiceConfRefObjectCreateFluentHelper(servicePath, serviceConfRefObject, "A_ServiceConfRefObject");
    }

    @Override
    @Nonnull
    public ServiceConfRefObjectDeleteFluentHelper deleteServiceConfRefObject(
        @Nonnull final ServiceConfRefObject serviceConfRefObject )
    {
        return new ServiceConfRefObjectDeleteFluentHelper(servicePath, serviceConfRefObject, "A_ServiceConfRefObject");
    }

    @Override
    @Nonnull
    public ServiceConfUserStatusFluentHelper getAllServiceConfUserStatus()
    {
        return new ServiceConfUserStatusFluentHelper(servicePath, "A_ServiceConfUserStatus");
    }

    @Override
    @Nonnull
    public
        ServiceConfUserStatusByKeyFluentHelper
        getServiceConfUserStatusByKey( final String serviceConfirmation, final String srvcConfUserStatus )
    {
        return new ServiceConfUserStatusByKeyFluentHelper(
            servicePath,
            "A_ServiceConfUserStatus",
            serviceConfirmation,
            srvcConfUserStatus);
    }

    @Override
    @Nonnull
    public ServiceConfUserStatusCreateFluentHelper createServiceConfUserStatus(
        @Nonnull final ServiceConfUserStatus serviceConfUserStatus )
    {
        return new ServiceConfUserStatusCreateFluentHelper(
            servicePath,
            serviceConfUserStatus,
            "A_ServiceConfUserStatus");
    }

    @Override
    @Nonnull
    public ServiceConfUserStatusDeleteFluentHelper deleteServiceConfUserStatus(
        @Nonnull final ServiceConfUserStatus serviceConfUserStatus )
    {
        return new ServiceConfUserStatusDeleteFluentHelper(
            servicePath,
            serviceConfUserStatus,
            "A_ServiceConfUserStatus");
    }

    @Override
    @Nonnull
    public SrvcConfAppointmentFluentHelper getAllSrvcConfAppointment()
    {
        return new SrvcConfAppointmentFluentHelper(servicePath, "A_SrvcConfAppointment");
    }

    @Override
    @Nonnull
    public
        SrvcConfAppointmentByKeyFluentHelper
        getSrvcConfAppointmentByKey( final String serviceConfirmation, final String srvcDocAppointmentType )
    {
        return new SrvcConfAppointmentByKeyFluentHelper(
            servicePath,
            "A_SrvcConfAppointment",
            serviceConfirmation,
            srvcDocAppointmentType);
    }

    @Override
    @Nonnull
    public SrvcConfAppointmentCreateFluentHelper createSrvcConfAppointment(
        @Nonnull final SrvcConfAppointment srvcConfAppointment )
    {
        return new SrvcConfAppointmentCreateFluentHelper(servicePath, srvcConfAppointment, "A_SrvcConfAppointment");
    }

    @Override
    @Nonnull
    public SrvcConfAppointmentUpdateFluentHelper updateSrvcConfAppointment(
        @Nonnull final SrvcConfAppointment srvcConfAppointment )
    {
        return new SrvcConfAppointmentUpdateFluentHelper(servicePath, srvcConfAppointment, "A_SrvcConfAppointment");
    }

    @Override
    @Nonnull
    public SrvcConfDurationFluentHelper getAllSrvcConfDuration()
    {
        return new SrvcConfDurationFluentHelper(servicePath, "A_SrvcConfDuration");
    }

    @Override
    @Nonnull
    public
        SrvcConfDurationByKeyFluentHelper
        getSrvcConfDurationByKey( final String serviceConfirmation, final String srvcDocDurationType )
    {
        return new SrvcConfDurationByKeyFluentHelper(
            servicePath,
            "A_SrvcConfDuration",
            serviceConfirmation,
            srvcDocDurationType);
    }

    @Override
    @Nonnull
    public SrvcConfDurationCreateFluentHelper createSrvcConfDuration( @Nonnull final SrvcConfDuration srvcConfDuration )
    {
        return new SrvcConfDurationCreateFluentHelper(servicePath, srvcConfDuration, "A_SrvcConfDuration");
    }

    @Override
    @Nonnull
    public SrvcConfDurationUpdateFluentHelper updateSrvcConfDuration( @Nonnull final SrvcConfDuration srvcConfDuration )
    {
        return new SrvcConfDurationUpdateFluentHelper(servicePath, srvcConfDuration, "A_SrvcConfDuration");
    }

    @Override
    @Nonnull
    public SrvcConfItemAppointmentFluentHelper getAllSrvcConfItemAppointment()
    {
        return new SrvcConfItemAppointmentFluentHelper(servicePath, "A_SrvcConfItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcConfItemAppointmentByKeyFluentHelper getSrvcConfItemAppointmentByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcDocAppointmentType )
    {
        return new SrvcConfItemAppointmentByKeyFluentHelper(
            servicePath,
            "A_SrvcConfItemAppointment",
            serviceConfirmation,
            serviceConfirmationItem,
            srvcDocAppointmentType);
    }

    @Override
    @Nonnull
    public SrvcConfItemAppointmentCreateFluentHelper createSrvcConfItemAppointment(
        @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment )
    {
        return new SrvcConfItemAppointmentCreateFluentHelper(
            servicePath,
            srvcConfItemAppointment,
            "A_SrvcConfItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcConfItemAppointmentUpdateFluentHelper updateSrvcConfItemAppointment(
        @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment )
    {
        return new SrvcConfItemAppointmentUpdateFluentHelper(
            servicePath,
            srvcConfItemAppointment,
            "A_SrvcConfItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcConfItemDurationFluentHelper getAllSrvcConfItemDuration()
    {
        return new SrvcConfItemDurationFluentHelper(servicePath, "A_SrvcConfItemDuration");
    }

    @Override
    @Nonnull
    public SrvcConfItemDurationByKeyFluentHelper getSrvcConfItemDurationByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcDocDurationType )
    {
        return new SrvcConfItemDurationByKeyFluentHelper(
            servicePath,
            "A_SrvcConfItemDuration",
            serviceConfirmation,
            serviceConfirmationItem,
            srvcDocDurationType);
    }

    @Override
    @Nonnull
    public SrvcConfItemDurationCreateFluentHelper createSrvcConfItemDuration(
        @Nonnull final SrvcConfItemDuration srvcConfItemDuration )
    {
        return new SrvcConfItemDurationCreateFluentHelper(servicePath, srvcConfItemDuration, "A_SrvcConfItemDuration");
    }

    @Override
    @Nonnull
    public SrvcConfItemDurationUpdateFluentHelper updateSrvcConfItemDuration(
        @Nonnull final SrvcConfItemDuration srvcConfItemDuration )
    {
        return new SrvcConfItemDurationUpdateFluentHelper(servicePath, srvcConfItemDuration, "A_SrvcConfItemDuration");
    }

    @Override
    @Nonnull
    public SrvcConfItemPartnerFluentHelper getAllSrvcConfItemPartner()
    {
        return new SrvcConfItemPartnerFluentHelper(servicePath, "A_SrvcConfItemPartner");
    }

    @Override
    @Nonnull
    public SrvcConfItemPartnerByKeyFluentHelper getSrvcConfItemPartnerByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcConfItemPartnerByKeyFluentHelper(
            servicePath,
            "A_SrvcConfItemPartner",
            serviceConfirmation,
            serviceConfirmationItem,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcConfItemPartnerCreateFluentHelper createSrvcConfItemPartner(
        @Nonnull final SrvcConfItemPartner srvcConfItemPartner )
    {
        return new SrvcConfItemPartnerCreateFluentHelper(servicePath, srvcConfItemPartner, "A_SrvcConfItemPartner");
    }

    @Override
    @Nonnull
    public SrvcConfItemPartnerUpdateFluentHelper updateSrvcConfItemPartner(
        @Nonnull final SrvcConfItemPartner srvcConfItemPartner )
    {
        return new SrvcConfItemPartnerUpdateFluentHelper(servicePath, srvcConfItemPartner, "A_SrvcConfItemPartner");
    }

    @Override
    @Nonnull
    public SrvcConfItemPartnerDeleteFluentHelper deleteSrvcConfItemPartner(
        @Nonnull final SrvcConfItemPartner srvcConfItemPartner )
    {
        return new SrvcConfItemPartnerDeleteFluentHelper(servicePath, srvcConfItemPartner, "A_SrvcConfItemPartner");
    }

    @Override
    @Nonnull
    public SrvcConfItmPartnerAddressFluentHelper getAllSrvcConfItmPartnerAddress()
    {
        return new SrvcConfItmPartnerAddressFluentHelper(servicePath, "A_SrvcConfItmPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcConfItmPartnerAddressByKeyFluentHelper getSrvcConfItmPartnerAddressByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcConfItmPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SrvcConfItmPartnerAddress",
            serviceConfirmation,
            serviceConfirmationItem,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcConfItmPartnerAddressUpdateFluentHelper updateSrvcConfItmPartnerAddress(
        @Nonnull final SrvcConfItmPartnerAddress srvcConfItmPartnerAddress )
    {
        return new SrvcConfItmPartnerAddressUpdateFluentHelper(
            servicePath,
            srvcConfItmPartnerAddress,
            "A_SrvcConfItmPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcConfPartnerFluentHelper getAllSrvcConfPartner()
    {
        return new SrvcConfPartnerFluentHelper(servicePath, "A_SrvcConfPartner");
    }

    @Override
    @Nonnull
    public SrvcConfPartnerByKeyFluentHelper getSrvcConfPartnerByKey(
        final String serviceConfirmation,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcConfPartnerByKeyFluentHelper(
            servicePath,
            "A_SrvcConfPartner",
            serviceConfirmation,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcConfPartnerCreateFluentHelper createSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner )
    {
        return new SrvcConfPartnerCreateFluentHelper(servicePath, srvcConfPartner, "A_SrvcConfPartner");
    }

    @Override
    @Nonnull
    public SrvcConfPartnerUpdateFluentHelper updateSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner )
    {
        return new SrvcConfPartnerUpdateFluentHelper(servicePath, srvcConfPartner, "A_SrvcConfPartner");
    }

    @Override
    @Nonnull
    public SrvcConfPartnerDeleteFluentHelper deleteSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner )
    {
        return new SrvcConfPartnerDeleteFluentHelper(servicePath, srvcConfPartner, "A_SrvcConfPartner");
    }

    @Override
    @Nonnull
    public SrvcConfPartnerAddressFluentHelper getAllSrvcConfPartnerAddress()
    {
        return new SrvcConfPartnerAddressFluentHelper(servicePath, "A_SrvcConfPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcConfPartnerAddressByKeyFluentHelper getSrvcConfPartnerAddressByKey(
        final String serviceConfirmation,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcConfPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SrvcConfPartnerAddress",
            serviceConfirmation,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcConfPartnerAddressUpdateFluentHelper updateSrvcConfPartnerAddress(
        @Nonnull final SrvcConfPartnerAddress srvcConfPartnerAddress )
    {
        return new SrvcConfPartnerAddressUpdateFluentHelper(
            servicePath,
            srvcConfPartnerAddress,
            "A_SrvcConfPartnerAddress");
    }

}
