/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.batch.DefaultServiceContractServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service contract processing in SAP S/4HANA Cloud.
 * The service contains entities of service contract header, header text, item text, item, item object list, item
 * product list, item price element, item released order, and billing request line. In each API call, you can use the
 * operation to retrieve service contracts. You can apply any of the filters provided or retrieve all existing data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/40/e8f572cd8a4a41bfe34b3094ef638e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_CONTRACT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_CONTRACT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Contract OData Integration(SAP_COM_0558)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultServiceContractService" )
@Deprecated
public class DefaultServiceContractService implements ServiceContractService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ServiceContractService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultServiceContractService()
    {
        servicePath = ServiceContractService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultServiceContractService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultServiceContractService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultServiceContractService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultServiceContractServiceBatch batch()
    {
        return new DefaultServiceContractServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ServiceContractFluentHelper getAllServiceContract()
    {
        return new ServiceContractFluentHelper(servicePath, "A_ServiceContract");
    }

    @Override
    @Nonnull
    public ServiceContractByKeyFluentHelper getServiceContractByKey( final String serviceContract )
    {
        return new ServiceContractByKeyFluentHelper(servicePath, "A_ServiceContract", serviceContract);
    }

    @Override
    @Nonnull
    public ServiceContractItemFluentHelper getAllServiceContractItem()
    {
        return new ServiceContractItemFluentHelper(servicePath, "A_ServiceContractItem");
    }

    @Override
    @Nonnull
    public
        ServiceContractItemByKeyFluentHelper
        getServiceContractItemByKey( final String serviceContract, final String serviceContractItem )
    {
        return new ServiceContractItemByKeyFluentHelper(
            servicePath,
            "A_ServiceContractItem",
            serviceContract,
            serviceContractItem);
    }

    @Override
    @Nonnull
    public ServiceContractItemTextFluentHelper getAllServiceContractItemText()
    {
        return new ServiceContractItemTextFluentHelper(servicePath, "A_ServiceContractItemText");
    }

    @Override
    @Nonnull
    public ServiceContractItemTextByKeyFluentHelper getServiceContractItemTextByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String language,
        final String longTextID )
    {
        return new ServiceContractItemTextByKeyFluentHelper(
            servicePath,
            "A_ServiceContractItemText",
            serviceContract,
            serviceContractItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceContractTextFluentHelper getAllServiceContractText()
    {
        return new ServiceContractTextFluentHelper(servicePath, "A_ServiceContractText");
    }

    @Override
    @Nonnull
    public
        ServiceContractTextByKeyFluentHelper
        getServiceContractTextByKey( final String serviceContract, final String language, final String longTextID )
    {
        return new ServiceContractTextByKeyFluentHelper(
            servicePath,
            "A_ServiceContractText",
            serviceContract,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceContrItemObjectListFluentHelper getAllServiceContrItemObjectList()
    {
        return new ServiceContrItemObjectListFluentHelper(servicePath, "A_ServiceContrItemObjectList");
    }

    @Override
    @Nonnull
    public ServiceContrItemObjectListByKeyFluentHelper getServiceContrItemObjectListByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String serviceRefObjectSequenceNumber )
    {
        return new ServiceContrItemObjectListByKeyFluentHelper(
            servicePath,
            "A_ServiceContrItemObjectList",
            serviceContract,
            serviceContractItem,
            serviceRefObjectSequenceNumber);
    }

    @Override
    @Nonnull
    public ServiceContrItemPriceElementFluentHelper getAllServiceContrItemPriceElement()
    {
        return new ServiceContrItemPriceElementFluentHelper(servicePath, "A_ServiceContrItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceContrItemPriceElementByKeyFluentHelper getServiceContrItemPriceElementByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new ServiceContrItemPriceElementByKeyFluentHelper(
            servicePath,
            "A_ServiceContrItemPriceElement",
            serviceContract,
            serviceContractItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public ServiceContrItmReleasedOrderFluentHelper getAllServiceContrItmReleasedOrder()
    {
        return new ServiceContrItmReleasedOrderFluentHelper(servicePath, "A_ServiceContrItmReleasedOrder");
    }

    @Override
    @Nonnull
    public ServiceContrItmReleasedOrderByKeyFluentHelper getServiceContrItmReleasedOrderByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber )
    {
        return new ServiceContrItmReleasedOrderByKeyFluentHelper(
            servicePath,
            "A_ServiceContrItmReleasedOrder",
            serviceDocumentItmRelationUUID,
            serviceDocItmRltnSqncNumber);
    }

    @Override
    @Nonnull
    public SrvcContrBillgReqItmPrcElmntFluentHelper getAllSrvcContrBillgReqItmPrcElmnt()
    {
        return new SrvcContrBillgReqItmPrcElmntFluentHelper(servicePath, "A_SrvcContrBillgReqItmPrcElmnt");
    }

    @Override
    @Nonnull
    public SrvcContrBillgReqItmPrcElmntByKeyFluentHelper getSrvcContrBillgReqItmPrcElmntByKey(
        final String serviceContract,
        final String billingRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SrvcContrBillgReqItmPrcElmntByKeyFluentHelper(
            servicePath,
            "A_SrvcContrBillgReqItmPrcElmnt",
            serviceContract,
            billingRequestItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SrvcContrItemProductFluentHelper getAllSrvcContrItemProduct()
    {
        return new SrvcContrItemProductFluentHelper(servicePath, "A_SrvcContrItemProduct");
    }

    @Override
    @Nonnull
    public SrvcContrItemProductByKeyFluentHelper getSrvcContrItemProductByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String serviceProductListItem )
    {
        return new SrvcContrItemProductByKeyFluentHelper(
            servicePath,
            "A_SrvcContrItemProduct",
            serviceContract,
            serviceContractItem,
            serviceProductListItem);
    }

    @Override
    @Nonnull
    public SrvcContrItmBillgReqItemFluentHelper getAllSrvcContrItmBillgReqItem()
    {
        return new SrvcContrItmBillgReqItemFluentHelper(servicePath, "A_SrvcContrItmBillgReqItem");
    }

    @Override
    @Nonnull
    public SrvcContrItmBillgReqItemByKeyFluentHelper getSrvcContrItmBillgReqItemByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String billingRequestItem )
    {
        return new SrvcContrItmBillgReqItemByKeyFluentHelper(
            servicePath,
            "A_SrvcContrItmBillgReqItem",
            serviceContract,
            serviceContractItem,
            billingRequestItem);
    }

}
