/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.RevokeApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SubmitForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.batch.DefaultServiceEntrySheetServiceBatch;

/**
 * <p>
 *
 * This service enables a remote system to read, create and update service entry sheets from or in the SAP S/4HANA Cloud
 * system. It also provides service nodes to submit a service entry sheet for approval, withdraw a service entry sheet
 * from approval or revoke approval of an already approved service entry sheet..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/0f/17c815dc784fa39b4fc7c0fe9f72b5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_ENTRY_SHEET_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_ENTRY_SHEET_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Entry Sheet Integration(SAP_COM_0146)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/22Z'>Procurement of Services(22Z)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Entry Sheet</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultServiceEntrySheetService" )
@Deprecated
public class DefaultServiceEntrySheetService implements ServiceEntrySheetService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ServiceEntrySheetService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultServiceEntrySheetService()
    {
        servicePath = ServiceEntrySheetService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultServiceEntrySheetService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultServiceEntrySheetService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultServiceEntrySheetService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultServiceEntrySheetServiceBatch batch()
    {
        return new DefaultServiceEntrySheetServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ServiceEntrySheetFluentHelper getAllServiceEntrySheet()
    {
        return new ServiceEntrySheetFluentHelper(servicePath, "A_ServiceEntrySheet");
    }

    @Override
    @Nonnull
    public ServiceEntrySheetByKeyFluentHelper getServiceEntrySheetByKey( final String serviceEntrySheet )
    {
        return new ServiceEntrySheetByKeyFluentHelper(servicePath, "A_ServiceEntrySheet", serviceEntrySheet);
    }

    @Override
    @Nonnull
    public ServiceEntrySheetCreateFluentHelper createServiceEntrySheet(
        @Nonnull final ServiceEntrySheet serviceEntrySheet )
    {
        return new ServiceEntrySheetCreateFluentHelper(servicePath, serviceEntrySheet, "A_ServiceEntrySheet");
    }

    @Override
    @Nonnull
    public ServiceEntrySheetUpdateFluentHelper updateServiceEntrySheet(
        @Nonnull final ServiceEntrySheet serviceEntrySheet )
    {
        return new ServiceEntrySheetUpdateFluentHelper(servicePath, serviceEntrySheet, "A_ServiceEntrySheet");
    }

    @Override
    @Nonnull
    public ServiceEntrySheetItemFluentHelper getAllServiceEntrySheetItem()
    {
        return new ServiceEntrySheetItemFluentHelper(servicePath, "A_ServiceEntrySheetItem");
    }

    @Override
    @Nonnull
    public
        ServiceEntrySheetItemByKeyFluentHelper
        getServiceEntrySheetItemByKey( final String serviceEntrySheet, final String serviceEntrySheetItem )
    {
        return new ServiceEntrySheetItemByKeyFluentHelper(
            servicePath,
            "A_ServiceEntrySheetItem",
            serviceEntrySheet,
            serviceEntrySheetItem);
    }

    @Override
    @Nonnull
    public ServiceEntrySheetItemUpdateFluentHelper updateServiceEntrySheetItem(
        @Nonnull final ServiceEntrySheetItem serviceEntrySheetItem )
    {
        return new ServiceEntrySheetItemUpdateFluentHelper(
            servicePath,
            serviceEntrySheetItem,
            "A_ServiceEntrySheetItem");
    }

    @Override
    @Nonnull
    public SrvcEntrShtAcctAssignmentFluentHelper getAllSrvcEntrShtAcctAssignment()
    {
        return new SrvcEntrShtAcctAssignmentFluentHelper(servicePath, "A_SrvcEntrShtAcctAssignment");
    }

    @Override
    @Nonnull
    public SrvcEntrShtAcctAssignmentByKeyFluentHelper getSrvcEntrShtAcctAssignmentByKey(
        final String serviceEntrySheet,
        final String serviceEntrySheetItem,
        final String accountAssignment )
    {
        return new SrvcEntrShtAcctAssignmentByKeyFluentHelper(
            servicePath,
            "A_SrvcEntrShtAcctAssignment",
            serviceEntrySheet,
            serviceEntrySheetItem,
            accountAssignment);
    }

    @Override
    @Nonnull
    public SrvcEntrShtAcctAssignmentUpdateFluentHelper updateSrvcEntrShtAcctAssignment(
        @Nonnull final SrvcEntrShtAcctAssignment srvcEntrShtAcctAssignment )
    {
        return new SrvcEntrShtAcctAssignmentUpdateFluentHelper(
            servicePath,
            srvcEntrShtAcctAssignment,
            "A_SrvcEntrShtAcctAssignment");
    }

    @Override
    @Nonnull
    public SubmitForApprovalFluentHelper submitForApproval( @Nonnull final String serviceEntrySheet )
    {
        return new SubmitForApprovalFluentHelper(servicePath, serviceEntrySheet);
    }

    @Override
    @Nonnull
    public
        RevokeApprovalFluentHelper
        revokeApproval( @Nonnull final String postingDate, @Nonnull final String serviceEntrySheet )
    {
        return new RevokeApprovalFluentHelper(servicePath, postingDate, serviceEntrySheet);
    }

    @Override
    @Nonnull
    public WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String serviceEntrySheet )
    {
        return new WithdrawFromApprovalFluentHelper(servicePath, serviceEntrySheet);
    }

}
