/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.batch.DefaultServiceOrderServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service order processing in SAP S/4HANA Cloud. In
 * each API call, you can use the following operations: - Retrieve service orders. - Create service orders. Note: You
 * must use “deep insert” requests (a header plus the following entities: header person responsible, header pricing
 * element, header reference object, header defect, header text, and item). - Create new items for existing service
 * orders. - Create an item reference object, item pricing element, and an item text for existing service orders items.
 * - Update the header, header person responsible, header pricing element, header defect, header text, item, item
 * pricing element, and item text for existing service orders. - Delete the header person responsible, header reference
 * object, header defect, header text, item, item reference object, and item text for existing service orders.
 *
 * This service enables you to add attachments to a service order header and service order items by making an API call
 * to the service Attachments (API_CV_ATTACHMENT_SRV). You can also use the service Attachments to download and delete
 * attachments from a service order header and service order items..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/dd/fe570e96c84075b2ff3e5b1be9714b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_ORDER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_ORDER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Order OData Integration(SAP_COM_0350), Service - Repair Order Integration(SAP_COM_0742)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultServiceOrderService" )
@Deprecated
public class DefaultServiceOrderService implements ServiceOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ServiceOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultServiceOrderService()
    {
        servicePath = ServiceOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultServiceOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultServiceOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultServiceOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultServiceOrderServiceBatch batch()
    {
        return new DefaultServiceOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ServiceOrderFluentHelper getAllServiceOrder()
    {
        return new ServiceOrderFluentHelper(servicePath, "A_ServiceOrder");
    }

    @Override
    @Nonnull
    public ServiceOrderByKeyFluentHelper getServiceOrderByKey( final String serviceOrder )
    {
        return new ServiceOrderByKeyFluentHelper(servicePath, "A_ServiceOrder", serviceOrder);
    }

    @Override
    @Nonnull
    public ServiceOrderCreateFluentHelper createServiceOrder( @Nonnull final ServiceOrder serviceOrder )
    {
        return new ServiceOrderCreateFluentHelper(servicePath, serviceOrder, "A_ServiceOrder");
    }

    @Override
    @Nonnull
    public ServiceOrderUpdateFluentHelper updateServiceOrder( @Nonnull final ServiceOrder serviceOrder )
    {
        return new ServiceOrderUpdateFluentHelper(servicePath, serviceOrder, "A_ServiceOrder");
    }

    @Override
    @Nonnull
    public ServiceOrderConfirmationFluentHelper getAllServiceOrderConfirmation()
    {
        return new ServiceOrderConfirmationFluentHelper(servicePath, "A_ServiceOrderConfirmation");
    }

    @Override
    @Nonnull
    public
        ServiceOrderConfirmationByKeyFluentHelper
        getServiceOrderConfirmationByKey( final String serviceOrder, final String serviceConfirmation )
    {
        return new ServiceOrderConfirmationByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderConfirmation",
            serviceOrder,
            serviceConfirmation);
    }

    @Override
    @Nonnull
    public ServiceOrderDefectFluentHelper getAllServiceOrderDefect()
    {
        return new ServiceOrderDefectFluentHelper(servicePath, "A_ServiceOrderDefect");
    }

    @Override
    @Nonnull
    public ServiceOrderDefectByKeyFluentHelper getServiceOrderDefectByKey(
        final String serviceOrder,
        final String srvcDocTypeDefectCodeProfType,
        final Short serviceDefectSequence )
    {
        return new ServiceOrderDefectByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderDefect",
            serviceOrder,
            srvcDocTypeDefectCodeProfType,
            serviceDefectSequence);
    }

    @Override
    @Nonnull
    public ServiceOrderDefectCreateFluentHelper createServiceOrderDefect(
        @Nonnull final ServiceOrderDefect serviceOrderDefect )
    {
        return new ServiceOrderDefectCreateFluentHelper(servicePath, serviceOrderDefect, "A_ServiceOrderDefect");
    }

    @Override
    @Nonnull
    public ServiceOrderDefectUpdateFluentHelper updateServiceOrderDefect(
        @Nonnull final ServiceOrderDefect serviceOrderDefect )
    {
        return new ServiceOrderDefectUpdateFluentHelper(servicePath, serviceOrderDefect, "A_ServiceOrderDefect");
    }

    @Override
    @Nonnull
    public ServiceOrderDefectDeleteFluentHelper deleteServiceOrderDefect(
        @Nonnull final ServiceOrderDefect serviceOrderDefect )
    {
        return new ServiceOrderDefectDeleteFluentHelper(servicePath, serviceOrderDefect, "A_ServiceOrderDefect");
    }

    @Override
    @Nonnull
    public ServiceOrderItemFluentHelper getAllServiceOrderItem()
    {
        return new ServiceOrderItemFluentHelper(servicePath, "A_ServiceOrderItem");
    }

    @Override
    @Nonnull
    public
        ServiceOrderItemByKeyFluentHelper
        getServiceOrderItemByKey( final String serviceOrder, final String serviceOrderItem )
    {
        return new ServiceOrderItemByKeyFluentHelper(servicePath, "A_ServiceOrderItem", serviceOrder, serviceOrderItem);
    }

    @Override
    @Nonnull
    public ServiceOrderItemCreateFluentHelper createServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem )
    {
        return new ServiceOrderItemCreateFluentHelper(servicePath, serviceOrderItem, "A_ServiceOrderItem");
    }

    @Override
    @Nonnull
    public ServiceOrderItemUpdateFluentHelper updateServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem )
    {
        return new ServiceOrderItemUpdateFluentHelper(servicePath, serviceOrderItem, "A_ServiceOrderItem");
    }

    @Override
    @Nonnull
    public ServiceOrderItemDeleteFluentHelper deleteServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem )
    {
        return new ServiceOrderItemDeleteFluentHelper(servicePath, serviceOrderItem, "A_ServiceOrderItem");
    }

    @Override
    @Nonnull
    public ServiceOrderItemConfirmationFluentHelper getAllServiceOrderItemConfirmation()
    {
        return new ServiceOrderItemConfirmationFluentHelper(servicePath, "A_ServiceOrderItemConfirmation");
    }

    @Override
    @Nonnull
    public ServiceOrderItemConfirmationByKeyFluentHelper getServiceOrderItemConfirmationByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String serviceConfirmation,
        final String serviceConfirmationItem )
    {
        return new ServiceOrderItemConfirmationByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderItemConfirmation",
            serviceOrder,
            serviceOrderItem,
            serviceConfirmation,
            serviceConfirmationItem);
    }

    @Override
    @Nonnull
    public ServiceOrderItemPriceElementFluentHelper getAllServiceOrderItemPriceElement()
    {
        return new ServiceOrderItemPriceElementFluentHelper(servicePath, "A_ServiceOrderItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceOrderItemPriceElementByKeyFluentHelper getServiceOrderItemPriceElementByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new ServiceOrderItemPriceElementByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderItemPriceElement",
            serviceOrder,
            serviceOrderItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public ServiceOrderItemPriceElementCreateFluentHelper createServiceOrderItemPriceElement(
        @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement )
    {
        return new ServiceOrderItemPriceElementCreateFluentHelper(
            servicePath,
            serviceOrderItemPriceElement,
            "A_ServiceOrderItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceOrderItemPriceElementUpdateFluentHelper updateServiceOrderItemPriceElement(
        @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement )
    {
        return new ServiceOrderItemPriceElementUpdateFluentHelper(
            servicePath,
            serviceOrderItemPriceElement,
            "A_ServiceOrderItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceOrderItemRefObjectFluentHelper getAllServiceOrderItemRefObject()
    {
        return new ServiceOrderItemRefObjectFluentHelper(servicePath, "A_ServiceOrderItemRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderItemRefObjectByKeyFluentHelper getServiceOrderItemRefObjectByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceOrderItemRefObjectByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderItemRefObject",
            serviceOrder,
            serviceOrderItem,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceOrderItemRefObjectCreateFluentHelper createServiceOrderItemRefObject(
        @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject )
    {
        return new ServiceOrderItemRefObjectCreateFluentHelper(
            servicePath,
            serviceOrderItemRefObject,
            "A_ServiceOrderItemRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderItemRefObjectDeleteFluentHelper deleteServiceOrderItemRefObject(
        @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject )
    {
        return new ServiceOrderItemRefObjectDeleteFluentHelper(
            servicePath,
            serviceOrderItemRefObject,
            "A_ServiceOrderItemRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderItemTextFluentHelper getAllServiceOrderItemText()
    {
        return new ServiceOrderItemTextFluentHelper(servicePath, "A_ServiceOrderItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderItemTextByKeyFluentHelper getServiceOrderItemTextByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String language,
        final String longTextID )
    {
        return new ServiceOrderItemTextByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderItemText",
            serviceOrder,
            serviceOrderItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceOrderItemTextCreateFluentHelper createServiceOrderItemText(
        @Nonnull final ServiceOrderItemText serviceOrderItemText )
    {
        return new ServiceOrderItemTextCreateFluentHelper(servicePath, serviceOrderItemText, "A_ServiceOrderItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderItemTextUpdateFluentHelper updateServiceOrderItemText(
        @Nonnull final ServiceOrderItemText serviceOrderItemText )
    {
        return new ServiceOrderItemTextUpdateFluentHelper(servicePath, serviceOrderItemText, "A_ServiceOrderItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderItemTextDeleteFluentHelper deleteServiceOrderItemText(
        @Nonnull final ServiceOrderItemText serviceOrderItemText )
    {
        return new ServiceOrderItemTextDeleteFluentHelper(servicePath, serviceOrderItemText, "A_ServiceOrderItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderPersonRespFluentHelper getAllServiceOrderPersonResp()
    {
        return new ServiceOrderPersonRespFluentHelper(servicePath, "A_ServiceOrderPersonResp");
    }

    @Override
    @Nonnull
    public
        ServiceOrderPersonRespByKeyFluentHelper
        getServiceOrderPersonRespByKey( final String serviceOrder, final String personResponsible )
    {
        return new ServiceOrderPersonRespByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderPersonResp",
            serviceOrder,
            personResponsible);
    }

    @Override
    @Nonnull
    public ServiceOrderPersonRespCreateFluentHelper createServiceOrderPersonResp(
        @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp )
    {
        return new ServiceOrderPersonRespCreateFluentHelper(
            servicePath,
            serviceOrderPersonResp,
            "A_ServiceOrderPersonResp");
    }

    @Override
    @Nonnull
    public ServiceOrderPersonRespUpdateFluentHelper updateServiceOrderPersonResp(
        @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp )
    {
        return new ServiceOrderPersonRespUpdateFluentHelper(
            servicePath,
            serviceOrderPersonResp,
            "A_ServiceOrderPersonResp");
    }

    @Override
    @Nonnull
    public ServiceOrderPersonRespDeleteFluentHelper deleteServiceOrderPersonResp(
        @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp )
    {
        return new ServiceOrderPersonRespDeleteFluentHelper(
            servicePath,
            serviceOrderPersonResp,
            "A_ServiceOrderPersonResp");
    }

    @Override
    @Nonnull
    public ServiceOrderPriceElementFluentHelper getAllServiceOrderPriceElement()
    {
        return new ServiceOrderPriceElementFluentHelper(servicePath, "A_ServiceOrderPriceElement");
    }

    @Override
    @Nonnull
    public ServiceOrderPriceElementByKeyFluentHelper getServiceOrderPriceElementByKey(
        final String serviceOrder,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new ServiceOrderPriceElementByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderPriceElement",
            serviceOrder,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public ServiceOrderPriceElementCreateFluentHelper createServiceOrderPriceElement(
        @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement )
    {
        return new ServiceOrderPriceElementCreateFluentHelper(
            servicePath,
            serviceOrderPriceElement,
            "A_ServiceOrderPriceElement");
    }

    @Override
    @Nonnull
    public ServiceOrderPriceElementUpdateFluentHelper updateServiceOrderPriceElement(
        @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement )
    {
        return new ServiceOrderPriceElementUpdateFluentHelper(
            servicePath,
            serviceOrderPriceElement,
            "A_ServiceOrderPriceElement");
    }

    @Override
    @Nonnull
    public ServiceOrderRefObjectFluentHelper getAllServiceOrderRefObject()
    {
        return new ServiceOrderRefObjectFluentHelper(servicePath, "A_ServiceOrderRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderRefObjectByKeyFluentHelper getServiceOrderRefObjectByKey(
        final String serviceOrder,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceOrderRefObjectByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderRefObject",
            serviceOrder,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceOrderRefObjectCreateFluentHelper createServiceOrderRefObject(
        @Nonnull final ServiceOrderRefObject serviceOrderRefObject )
    {
        return new ServiceOrderRefObjectCreateFluentHelper(
            servicePath,
            serviceOrderRefObject,
            "A_ServiceOrderRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderRefObjectDeleteFluentHelper deleteServiceOrderRefObject(
        @Nonnull final ServiceOrderRefObject serviceOrderRefObject )
    {
        return new ServiceOrderRefObjectDeleteFluentHelper(
            servicePath,
            serviceOrderRefObject,
            "A_ServiceOrderRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderTextFluentHelper getAllServiceOrderText()
    {
        return new ServiceOrderTextFluentHelper(servicePath, "A_ServiceOrderText");
    }

    @Override
    @Nonnull
    public
        ServiceOrderTextByKeyFluentHelper
        getServiceOrderTextByKey( final String serviceOrder, final String language, final String longTextID )
    {
        return new ServiceOrderTextByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderText",
            serviceOrder,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceOrderTextCreateFluentHelper createServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText )
    {
        return new ServiceOrderTextCreateFluentHelper(servicePath, serviceOrderText, "A_ServiceOrderText");
    }

    @Override
    @Nonnull
    public ServiceOrderTextUpdateFluentHelper updateServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText )
    {
        return new ServiceOrderTextUpdateFluentHelper(servicePath, serviceOrderText, "A_ServiceOrderText");
    }

    @Override
    @Nonnull
    public ServiceOrderTextDeleteFluentHelper deleteServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText )
    {
        return new ServiceOrderTextDeleteFluentHelper(servicePath, serviceOrderText, "A_ServiceOrderText");
    }

    @Override
    @Nonnull
    public ServiceOrdItemUserStatusFluentHelper getAllServiceOrdItemUserStatus()
    {
        return new ServiceOrdItemUserStatusFluentHelper(servicePath, "A_ServiceOrdItemUserStatus");
    }

    @Override
    @Nonnull
    public ServiceOrdItemUserStatusByKeyFluentHelper getServiceOrdItemUserStatusByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String srvcOrdItemUserStatus )
    {
        return new ServiceOrdItemUserStatusByKeyFluentHelper(
            servicePath,
            "A_ServiceOrdItemUserStatus",
            serviceOrder,
            serviceOrderItem,
            srvcOrdItemUserStatus);
    }

    @Override
    @Nonnull
    public ServiceOrdItemUserStatusCreateFluentHelper createServiceOrdItemUserStatus(
        @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus )
    {
        return new ServiceOrdItemUserStatusCreateFluentHelper(
            servicePath,
            serviceOrdItemUserStatus,
            "A_ServiceOrdItemUserStatus");
    }

    @Override
    @Nonnull
    public ServiceOrdItemUserStatusDeleteFluentHelper deleteServiceOrdItemUserStatus(
        @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus )
    {
        return new ServiceOrdItemUserStatusDeleteFluentHelper(
            servicePath,
            serviceOrdItemUserStatus,
            "A_ServiceOrdItemUserStatus");
    }

    @Override
    @Nonnull
    public ServiceOrdUserStatusFluentHelper getAllServiceOrdUserStatus()
    {
        return new ServiceOrdUserStatusFluentHelper(servicePath, "A_ServiceOrdUserStatus");
    }

    @Override
    @Nonnull
    public
        ServiceOrdUserStatusByKeyFluentHelper
        getServiceOrdUserStatusByKey( final String serviceOrder, final String srvcOrdUserStatus )
    {
        return new ServiceOrdUserStatusByKeyFluentHelper(
            servicePath,
            "A_ServiceOrdUserStatus",
            serviceOrder,
            srvcOrdUserStatus);
    }

    @Override
    @Nonnull
    public ServiceOrdUserStatusCreateFluentHelper createServiceOrdUserStatus(
        @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus )
    {
        return new ServiceOrdUserStatusCreateFluentHelper(servicePath, serviceOrdUserStatus, "A_ServiceOrdUserStatus");
    }

    @Override
    @Nonnull
    public ServiceOrdUserStatusDeleteFluentHelper deleteServiceOrdUserStatus(
        @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus )
    {
        return new ServiceOrdUserStatusDeleteFluentHelper(servicePath, serviceOrdUserStatus, "A_ServiceOrdUserStatus");
    }

    @Override
    @Nonnull
    public SrvcOrdAppointmentFluentHelper getAllSrvcOrdAppointment()
    {
        return new SrvcOrdAppointmentFluentHelper(servicePath, "A_SrvcOrdAppointment");
    }

    @Override
    @Nonnull
    public
        SrvcOrdAppointmentByKeyFluentHelper
        getSrvcOrdAppointmentByKey( final String serviceOrder, final String srvcDocAppointmentType )
    {
        return new SrvcOrdAppointmentByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdAppointment",
            serviceOrder,
            srvcDocAppointmentType);
    }

    @Override
    @Nonnull
    public SrvcOrdAppointmentCreateFluentHelper createSrvcOrdAppointment(
        @Nonnull final SrvcOrdAppointment srvcOrdAppointment )
    {
        return new SrvcOrdAppointmentCreateFluentHelper(servicePath, srvcOrdAppointment, "A_SrvcOrdAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdAppointmentUpdateFluentHelper updateSrvcOrdAppointment(
        @Nonnull final SrvcOrdAppointment srvcOrdAppointment )
    {
        return new SrvcOrdAppointmentUpdateFluentHelper(servicePath, srvcOrdAppointment, "A_SrvcOrdAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdDurationFluentHelper getAllSrvcOrdDuration()
    {
        return new SrvcOrdDurationFluentHelper(servicePath, "A_SrvcOrdDuration");
    }

    @Override
    @Nonnull
    public
        SrvcOrdDurationByKeyFluentHelper
        getSrvcOrdDurationByKey( final String serviceOrder, final String srvcDocDurationType )
    {
        return new SrvcOrdDurationByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdDuration",
            serviceOrder,
            srvcDocDurationType);
    }

    @Override
    @Nonnull
    public SrvcOrdDurationCreateFluentHelper createSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration )
    {
        return new SrvcOrdDurationCreateFluentHelper(servicePath, srvcOrdDuration, "A_SrvcOrdDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdDurationUpdateFluentHelper updateSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration )
    {
        return new SrvcOrdDurationUpdateFluentHelper(servicePath, srvcOrdDuration, "A_SrvcOrdDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdItemAppointmentFluentHelper getAllSrvcOrdItemAppointment()
    {
        return new SrvcOrdItemAppointmentFluentHelper(servicePath, "A_SrvcOrdItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdItemAppointmentByKeyFluentHelper getSrvcOrdItemAppointmentByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String srvcDocAppointmentType )
    {
        return new SrvcOrdItemAppointmentByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdItemAppointment",
            serviceOrder,
            serviceOrderItem,
            srvcDocAppointmentType);
    }

    @Override
    @Nonnull
    public SrvcOrdItemAppointmentCreateFluentHelper createSrvcOrdItemAppointment(
        @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment )
    {
        return new SrvcOrdItemAppointmentCreateFluentHelper(
            servicePath,
            srvcOrdItemAppointment,
            "A_SrvcOrdItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdItemAppointmentUpdateFluentHelper updateSrvcOrdItemAppointment(
        @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment )
    {
        return new SrvcOrdItemAppointmentUpdateFluentHelper(
            servicePath,
            srvcOrdItemAppointment,
            "A_SrvcOrdItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdItemDurationFluentHelper getAllSrvcOrdItemDuration()
    {
        return new SrvcOrdItemDurationFluentHelper(servicePath, "A_SrvcOrdItemDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdItemDurationByKeyFluentHelper getSrvcOrdItemDurationByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String srvcDocDurationType )
    {
        return new SrvcOrdItemDurationByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdItemDuration",
            serviceOrder,
            serviceOrderItem,
            srvcDocDurationType);
    }

    @Override
    @Nonnull
    public SrvcOrdItemDurationCreateFluentHelper createSrvcOrdItemDuration(
        @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration )
    {
        return new SrvcOrdItemDurationCreateFluentHelper(servicePath, srvcOrdItemDuration, "A_SrvcOrdItemDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdItemDurationUpdateFluentHelper updateSrvcOrdItemDuration(
        @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration )
    {
        return new SrvcOrdItemDurationUpdateFluentHelper(servicePath, srvcOrdItemDuration, "A_SrvcOrdItemDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerFluentHelper getAllSrvcOrdItmPartner()
    {
        return new SrvcOrdItmPartnerFluentHelper(servicePath, "A_SrvcOrdItmPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerByKeyFluentHelper getSrvcOrdItmPartnerByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdItmPartnerByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdItmPartner",
            serviceOrder,
            serviceOrderItem,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerCreateFluentHelper createSrvcOrdItmPartner(
        @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner )
    {
        return new SrvcOrdItmPartnerCreateFluentHelper(servicePath, srvcOrdItmPartner, "A_SrvcOrdItmPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerUpdateFluentHelper updateSrvcOrdItmPartner(
        @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner )
    {
        return new SrvcOrdItmPartnerUpdateFluentHelper(servicePath, srvcOrdItmPartner, "A_SrvcOrdItmPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerDeleteFluentHelper deleteSrvcOrdItmPartner(
        @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner )
    {
        return new SrvcOrdItmPartnerDeleteFluentHelper(servicePath, srvcOrdItmPartner, "A_SrvcOrdItmPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerAddressFluentHelper getAllSrvcOrdItmPartnerAddress()
    {
        return new SrvcOrdItmPartnerAddressFluentHelper(servicePath, "A_SrvcOrdItmPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerAddressByKeyFluentHelper getSrvcOrdItmPartnerAddressByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdItmPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdItmPartnerAddress",
            serviceOrder,
            serviceOrderItem,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdItmPartnerAddressUpdateFluentHelper updateSrvcOrdItmPartnerAddress(
        @Nonnull final SrvcOrdItmPartnerAddress srvcOrdItmPartnerAddress )
    {
        return new SrvcOrdItmPartnerAddressUpdateFluentHelper(
            servicePath,
            srvcOrdItmPartnerAddress,
            "A_SrvcOrdItmPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdItmProdRefObjectFluentHelper getAllSrvcOrdItmProdRefObject()
    {
        return new SrvcOrdItmProdRefObjectFluentHelper(servicePath, "A_SrvcOrdItmProdRefObject");
    }

    @Override
    @Nonnull
    public SrvcOrdItmProdRefObjectByKeyFluentHelper getSrvcOrdItmProdRefObjectByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String serviceReferenceProduct )
    {
        return new SrvcOrdItmProdRefObjectByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdItmProdRefObject",
            serviceOrder,
            serviceOrderItem,
            serviceReferenceProduct);
    }

    @Override
    @Nonnull
    public SrvcOrdItmProdRefObjectCreateFluentHelper createSrvcOrdItmProdRefObject(
        @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject )
    {
        return new SrvcOrdItmProdRefObjectCreateFluentHelper(
            servicePath,
            srvcOrdItmProdRefObject,
            "A_SrvcOrdItmProdRefObject");
    }

    @Override
    @Nonnull
    public SrvcOrdItmProdRefObjectDeleteFluentHelper deleteSrvcOrdItmProdRefObject(
        @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject )
    {
        return new SrvcOrdItmProdRefObjectDeleteFluentHelper(
            servicePath,
            srvcOrdItmProdRefObject,
            "A_SrvcOrdItmProdRefObject");
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerFluentHelper getAllSrvcOrdPartner()
    {
        return new SrvcOrdPartnerFluentHelper(servicePath, "A_SrvcOrdPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerByKeyFluentHelper getSrvcOrdPartnerByKey(
        final String serviceOrder,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdPartnerByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdPartner",
            serviceOrder,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerCreateFluentHelper createSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner )
    {
        return new SrvcOrdPartnerCreateFluentHelper(servicePath, srvcOrdPartner, "A_SrvcOrdPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerUpdateFluentHelper updateSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner )
    {
        return new SrvcOrdPartnerUpdateFluentHelper(servicePath, srvcOrdPartner, "A_SrvcOrdPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerDeleteFluentHelper deleteSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner )
    {
        return new SrvcOrdPartnerDeleteFluentHelper(servicePath, srvcOrdPartner, "A_SrvcOrdPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerAddressFluentHelper getAllSrvcOrdPartnerAddress()
    {
        return new SrvcOrdPartnerAddressFluentHelper(servicePath, "A_SrvcOrdPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerAddressByKeyFluentHelper getSrvcOrdPartnerAddressByKey(
        final String serviceOrder,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdPartnerAddress",
            serviceOrder,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdPartnerAddressUpdateFluentHelper updateSrvcOrdPartnerAddress(
        @Nonnull final SrvcOrdPartnerAddress srvcOrdPartnerAddress )
    {
        return new SrvcOrdPartnerAddressUpdateFluentHelper(
            servicePath,
            srvcOrdPartnerAddress,
            "A_SrvcOrdPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdProdRefObjectFluentHelper getAllSrvcOrdProdRefObject()
    {
        return new SrvcOrdProdRefObjectFluentHelper(servicePath, "A_SrvcOrdProdRefObject");
    }

    @Override
    @Nonnull
    public
        SrvcOrdProdRefObjectByKeyFluentHelper
        getSrvcOrdProdRefObjectByKey( final String serviceOrder, final String serviceReferenceProduct )
    {
        return new SrvcOrdProdRefObjectByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdProdRefObject",
            serviceOrder,
            serviceReferenceProduct);
    }

    @Override
    @Nonnull
    public SrvcOrdProdRefObjectCreateFluentHelper createSrvcOrdProdRefObject(
        @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject )
    {
        return new SrvcOrdProdRefObjectCreateFluentHelper(servicePath, srvcOrdProdRefObject, "A_SrvcOrdProdRefObject");
    }

    @Override
    @Nonnull
    public SrvcOrdProdRefObjectDeleteFluentHelper deleteSrvcOrdProdRefObject(
        @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject )
    {
        return new SrvcOrdProdRefObjectDeleteFluentHelper(servicePath, srvcOrdProdRefObject, "A_SrvcOrdProdRefObject");
    }

    @Override
    @Nonnull
    public SrvcOrdRefServiceContractFluentHelper getAllSrvcOrdRefServiceContract()
    {
        return new SrvcOrdRefServiceContractFluentHelper(servicePath, "A_SrvcOrdRefServiceContract");
    }

    @Override
    @Nonnull
    public
        SrvcOrdRefServiceContractByKeyFluentHelper
        getSrvcOrdRefServiceContractByKey( final String serviceOrder, final String referenceServiceContract )
    {
        return new SrvcOrdRefServiceContractByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdRefServiceContract",
            serviceOrder,
            referenceServiceContract);
    }

}
