/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObjByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObjCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObjDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObjFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonRespCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonRespDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.batch.DefaultServiceOrderTemplateServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with Service Order Template processing in Service in SAP
 * S/4HANA Cloud. In each API call, you can use the following operations: - Retrieve Service Order Template. - Create
 * Service Order Template. Note: You must use “deep insert” requests (a header plus the following entities: Header
 * details, Header text, Service Items and Person responsible). - Create an item reference object, item object list and
 * an item text for existing Service Order Template items. - Update the header, header text, item and item text of
 * existing Service Order Template. - Delete the item, item reference object, item object list and item text of existing
 * Service Order Template..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c9/0a2ce42b9b49f7b9bcc5abb9dc248b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_ORDER_TEMPLATE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_ORDER_TEMPLATE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Order Template Integration(SAP_COM_0715)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Order Template</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultServiceOrderTemplateService" )
@Deprecated
public class DefaultServiceOrderTemplateService implements ServiceOrderTemplateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ServiceOrderTemplateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultServiceOrderTemplateService()
    {
        servicePath = ServiceOrderTemplateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultServiceOrderTemplateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultServiceOrderTemplateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultServiceOrderTemplateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultServiceOrderTemplateServiceBatch batch()
    {
        return new DefaultServiceOrderTemplateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateFluentHelper getAllServiceOrderTemplate()
    {
        return new ServiceOrderTemplateFluentHelper(servicePath, "A_ServiceOrderTemplate");
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateByKeyFluentHelper getServiceOrderTemplateByKey( final String serviceOrderTemplate )
    {
        return new ServiceOrderTemplateByKeyFluentHelper(servicePath, "A_ServiceOrderTemplate", serviceOrderTemplate);
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateCreateFluentHelper createServiceOrderTemplate(
        @Nonnull final ServiceOrderTemplate serviceOrderTemplate )
    {
        return new ServiceOrderTemplateCreateFluentHelper(servicePath, serviceOrderTemplate, "A_ServiceOrderTemplate");
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateUpdateFluentHelper updateServiceOrderTemplate(
        @Nonnull final ServiceOrderTemplate serviceOrderTemplate )
    {
        return new ServiceOrderTemplateUpdateFluentHelper(servicePath, serviceOrderTemplate, "A_ServiceOrderTemplate");
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateItemFluentHelper getAllServiceOrderTemplateItem()
    {
        return new ServiceOrderTemplateItemFluentHelper(servicePath, "A_ServiceOrderTemplateItem");
    }

    @Override
    @Nonnull
    public
        ServiceOrderTemplateItemByKeyFluentHelper
        getServiceOrderTemplateItemByKey( final String serviceOrderTemplate, final String serviceOrderTemplateItem )
    {
        return new ServiceOrderTemplateItemByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderTemplateItem",
            serviceOrderTemplate,
            serviceOrderTemplateItem);
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateItemCreateFluentHelper createServiceOrderTemplateItem(
        @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem )
    {
        return new ServiceOrderTemplateItemCreateFluentHelper(
            servicePath,
            serviceOrderTemplateItem,
            "A_ServiceOrderTemplateItem");
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateItemUpdateFluentHelper updateServiceOrderTemplateItem(
        @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem )
    {
        return new ServiceOrderTemplateItemUpdateFluentHelper(
            servicePath,
            serviceOrderTemplateItem,
            "A_ServiceOrderTemplateItem");
    }

    @Override
    @Nonnull
    public ServiceOrderTemplateItemDeleteFluentHelper deleteServiceOrderTemplateItem(
        @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem )
    {
        return new ServiceOrderTemplateItemDeleteFluentHelper(
            servicePath,
            serviceOrderTemplateItem,
            "A_ServiceOrderTemplateItem");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemRefObjFluentHelper getAllServiceOrderTmplItemRefObj()
    {
        return new ServiceOrderTmplItemRefObjFluentHelper(servicePath, "A_ServiceOrderTmplItemRefObj");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemRefObjByKeyFluentHelper getServiceOrderTmplItemRefObjByKey(
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceOrderTmplItemRefObjByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderTmplItemRefObj",
            serviceOrderTemplate,
            serviceOrderTemplateItem,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemRefObjCreateFluentHelper createServiceOrderTmplItemRefObj(
        @Nonnull final ServiceOrderTmplItemRefObj serviceOrderTmplItemRefObj )
    {
        return new ServiceOrderTmplItemRefObjCreateFluentHelper(
            servicePath,
            serviceOrderTmplItemRefObj,
            "A_ServiceOrderTmplItemRefObj");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemRefObjDeleteFluentHelper deleteServiceOrderTmplItemRefObj(
        @Nonnull final ServiceOrderTmplItemRefObj serviceOrderTmplItemRefObj )
    {
        return new ServiceOrderTmplItemRefObjDeleteFluentHelper(
            servicePath,
            serviceOrderTmplItemRefObj,
            "A_ServiceOrderTmplItemRefObj");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemTextFluentHelper getAllServiceOrderTmplItemText()
    {
        return new ServiceOrderTmplItemTextFluentHelper(servicePath, "A_ServiceOrderTmplItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemTextByKeyFluentHelper getServiceOrderTmplItemTextByKey(
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String language,
        final String longTextID )
    {
        return new ServiceOrderTmplItemTextByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderTmplItemText",
            serviceOrderTemplate,
            serviceOrderTemplateItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemTextCreateFluentHelper createServiceOrderTmplItemText(
        @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText )
    {
        return new ServiceOrderTmplItemTextCreateFluentHelper(
            servicePath,
            serviceOrderTmplItemText,
            "A_ServiceOrderTmplItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemTextUpdateFluentHelper updateServiceOrderTmplItemText(
        @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText )
    {
        return new ServiceOrderTmplItemTextUpdateFluentHelper(
            servicePath,
            serviceOrderTmplItemText,
            "A_ServiceOrderTmplItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplItemTextDeleteFluentHelper deleteServiceOrderTmplItemText(
        @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText )
    {
        return new ServiceOrderTmplItemTextDeleteFluentHelper(
            servicePath,
            serviceOrderTmplItemText,
            "A_ServiceOrderTmplItemText");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplPersonRespFluentHelper getAllServiceOrderTmplPersonResp()
    {
        return new ServiceOrderTmplPersonRespFluentHelper(servicePath, "A_ServiceOrderTmplPersonResp");
    }

    @Override
    @Nonnull
    public
        ServiceOrderTmplPersonRespByKeyFluentHelper
        getServiceOrderTmplPersonRespByKey( final String serviceOrderTemplate, final String personResponsible )
    {
        return new ServiceOrderTmplPersonRespByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderTmplPersonResp",
            serviceOrderTemplate,
            personResponsible);
    }

    @Override
    @Nonnull
    public ServiceOrderTmplPersonRespCreateFluentHelper createServiceOrderTmplPersonResp(
        @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp )
    {
        return new ServiceOrderTmplPersonRespCreateFluentHelper(
            servicePath,
            serviceOrderTmplPersonResp,
            "A_ServiceOrderTmplPersonResp");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplPersonRespUpdateFluentHelper updateServiceOrderTmplPersonResp(
        @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp )
    {
        return new ServiceOrderTmplPersonRespUpdateFluentHelper(
            servicePath,
            serviceOrderTmplPersonResp,
            "A_ServiceOrderTmplPersonResp");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplPersonRespDeleteFluentHelper deleteServiceOrderTmplPersonResp(
        @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp )
    {
        return new ServiceOrderTmplPersonRespDeleteFluentHelper(
            servicePath,
            serviceOrderTmplPersonResp,
            "A_ServiceOrderTmplPersonResp");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplRefObjectFluentHelper getAllServiceOrderTmplRefObject()
    {
        return new ServiceOrderTmplRefObjectFluentHelper(servicePath, "A_ServiceOrderTmplRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplRefObjectByKeyFluentHelper getServiceOrderTmplRefObjectByKey(
        final String serviceOrderTemplate,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceOrderTmplRefObjectByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderTmplRefObject",
            serviceOrderTemplate,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceOrderTmplRefObjectCreateFluentHelper createServiceOrderTmplRefObject(
        @Nonnull final ServiceOrderTmplRefObject serviceOrderTmplRefObject )
    {
        return new ServiceOrderTmplRefObjectCreateFluentHelper(
            servicePath,
            serviceOrderTmplRefObject,
            "A_ServiceOrderTmplRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplRefObjectDeleteFluentHelper deleteServiceOrderTmplRefObject(
        @Nonnull final ServiceOrderTmplRefObject serviceOrderTmplRefObject )
    {
        return new ServiceOrderTmplRefObjectDeleteFluentHelper(
            servicePath,
            serviceOrderTmplRefObject,
            "A_ServiceOrderTmplRefObject");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplTextFluentHelper getAllServiceOrderTmplText()
    {
        return new ServiceOrderTmplTextFluentHelper(servicePath, "A_ServiceOrderTmplText");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplTextByKeyFluentHelper getServiceOrderTmplTextByKey(
        final String serviceOrderTemplate,
        final String language,
        final String longTextID )
    {
        return new ServiceOrderTmplTextByKeyFluentHelper(
            servicePath,
            "A_ServiceOrderTmplText",
            serviceOrderTemplate,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceOrderTmplTextCreateFluentHelper createServiceOrderTmplText(
        @Nonnull final ServiceOrderTmplText serviceOrderTmplText )
    {
        return new ServiceOrderTmplTextCreateFluentHelper(servicePath, serviceOrderTmplText, "A_ServiceOrderTmplText");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplTextUpdateFluentHelper updateServiceOrderTmplText(
        @Nonnull final ServiceOrderTmplText serviceOrderTmplText )
    {
        return new ServiceOrderTmplTextUpdateFluentHelper(servicePath, serviceOrderTmplText, "A_ServiceOrderTmplText");
    }

    @Override
    @Nonnull
    public ServiceOrderTmplTextDeleteFluentHelper deleteServiceOrderTmplText(
        @Nonnull final ServiceOrderTmplText serviceOrderTmplText )
    {
        return new ServiceOrderTmplTextDeleteFluentHelper(servicePath, serviceOrderTmplText, "A_ServiceOrderTmplText");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplAppointmentFluentHelper getAllSrvcOrdTmplAppointment()
    {
        return new SrvcOrdTmplAppointmentFluentHelper(servicePath, "A_SrvcOrdTmplAppointment");
    }

    @Override
    @Nonnull
    public
        SrvcOrdTmplAppointmentByKeyFluentHelper
        getSrvcOrdTmplAppointmentByKey( final String serviceOrderTemplate, final String srvcDocAppointmentType )
    {
        return new SrvcOrdTmplAppointmentByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplAppointment",
            serviceOrderTemplate,
            srvcDocAppointmentType);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplAppointmentCreateFluentHelper createSrvcOrdTmplAppointment(
        @Nonnull final SrvcOrdTmplAppointment srvcOrdTmplAppointment )
    {
        return new SrvcOrdTmplAppointmentCreateFluentHelper(
            servicePath,
            srvcOrdTmplAppointment,
            "A_SrvcOrdTmplAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplAppointmentUpdateFluentHelper updateSrvcOrdTmplAppointment(
        @Nonnull final SrvcOrdTmplAppointment srvcOrdTmplAppointment )
    {
        return new SrvcOrdTmplAppointmentUpdateFluentHelper(
            servicePath,
            srvcOrdTmplAppointment,
            "A_SrvcOrdTmplAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplDurationFluentHelper getAllSrvcOrdTmplDuration()
    {
        return new SrvcOrdTmplDurationFluentHelper(servicePath, "A_SrvcOrdTmplDuration");
    }

    @Override
    @Nonnull
    public
        SrvcOrdTmplDurationByKeyFluentHelper
        getSrvcOrdTmplDurationByKey( final String serviceOrderTemplate, final String srvcDocDurationType )
    {
        return new SrvcOrdTmplDurationByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplDuration",
            serviceOrderTemplate,
            srvcDocDurationType);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplDurationCreateFluentHelper createSrvcOrdTmplDuration(
        @Nonnull final SrvcOrdTmplDuration srvcOrdTmplDuration )
    {
        return new SrvcOrdTmplDurationCreateFluentHelper(servicePath, srvcOrdTmplDuration, "A_SrvcOrdTmplDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplDurationUpdateFluentHelper updateSrvcOrdTmplDuration(
        @Nonnull final SrvcOrdTmplDuration srvcOrdTmplDuration )
    {
        return new SrvcOrdTmplDurationUpdateFluentHelper(servicePath, srvcOrdTmplDuration, "A_SrvcOrdTmplDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemAppointmentFluentHelper getAllSrvcOrdTmplItemAppointment()
    {
        return new SrvcOrdTmplItemAppointmentFluentHelper(servicePath, "A_SrvcOrdTmplItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemAppointmentByKeyFluentHelper getSrvcOrdTmplItemAppointmentByKey(
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String srvcDocAppointmentType )
    {
        return new SrvcOrdTmplItemAppointmentByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplItemAppointment",
            serviceOrderTemplate,
            serviceOrderTemplateItem,
            srvcDocAppointmentType);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemAppointmentCreateFluentHelper createSrvcOrdTmplItemAppointment(
        @Nonnull final SrvcOrdTmplItemAppointment srvcOrdTmplItemAppointment )
    {
        return new SrvcOrdTmplItemAppointmentCreateFluentHelper(
            servicePath,
            srvcOrdTmplItemAppointment,
            "A_SrvcOrdTmplItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemAppointmentUpdateFluentHelper updateSrvcOrdTmplItemAppointment(
        @Nonnull final SrvcOrdTmplItemAppointment srvcOrdTmplItemAppointment )
    {
        return new SrvcOrdTmplItemAppointmentUpdateFluentHelper(
            servicePath,
            srvcOrdTmplItemAppointment,
            "A_SrvcOrdTmplItemAppointment");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemDurationFluentHelper getAllSrvcOrdTmplItemDuration()
    {
        return new SrvcOrdTmplItemDurationFluentHelper(servicePath, "A_SrvcOrdTmplItemDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemDurationByKeyFluentHelper getSrvcOrdTmplItemDurationByKey(
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String srvcDocDurationType )
    {
        return new SrvcOrdTmplItemDurationByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplItemDuration",
            serviceOrderTemplate,
            serviceOrderTemplateItem,
            srvcDocDurationType);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemDurationCreateFluentHelper createSrvcOrdTmplItemDuration(
        @Nonnull final SrvcOrdTmplItemDuration srvcOrdTmplItemDuration )
    {
        return new SrvcOrdTmplItemDurationCreateFluentHelper(
            servicePath,
            srvcOrdTmplItemDuration,
            "A_SrvcOrdTmplItemDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemDurationUpdateFluentHelper updateSrvcOrdTmplItemDuration(
        @Nonnull final SrvcOrdTmplItemDuration srvcOrdTmplItemDuration )
    {
        return new SrvcOrdTmplItemDurationUpdateFluentHelper(
            servicePath,
            srvcOrdTmplItemDuration,
            "A_SrvcOrdTmplItemDuration");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemPartnerFluentHelper getAllSrvcOrdTmplItemPartner()
    {
        return new SrvcOrdTmplItemPartnerFluentHelper(servicePath, "A_SrvcOrdTmplItemPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemPartnerByKeyFluentHelper getSrvcOrdTmplItemPartnerByKey(
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdTmplItemPartnerByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplItemPartner",
            serviceOrderTemplate,
            serviceOrderTemplateItem,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemPartnerCreateFluentHelper createSrvcOrdTmplItemPartner(
        @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner )
    {
        return new SrvcOrdTmplItemPartnerCreateFluentHelper(
            servicePath,
            srvcOrdTmplItemPartner,
            "A_SrvcOrdTmplItemPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemPartnerUpdateFluentHelper updateSrvcOrdTmplItemPartner(
        @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner )
    {
        return new SrvcOrdTmplItemPartnerUpdateFluentHelper(
            servicePath,
            srvcOrdTmplItemPartner,
            "A_SrvcOrdTmplItemPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemPartnerDeleteFluentHelper deleteSrvcOrdTmplItemPartner(
        @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner )
    {
        return new SrvcOrdTmplItemPartnerDeleteFluentHelper(
            servicePath,
            srvcOrdTmplItemPartner,
            "A_SrvcOrdTmplItemPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemUserStatusFluentHelper getAllSrvcOrdTmplItemUserStatus()
    {
        return new SrvcOrdTmplItemUserStatusFluentHelper(servicePath, "A_SrvcOrdTmplItemUserStatus");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemUserStatusByKeyFluentHelper getSrvcOrdTmplItemUserStatusByKey(
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String srvcOrdTmplItmUserStatus )
    {
        return new SrvcOrdTmplItemUserStatusByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplItemUserStatus",
            serviceOrderTemplate,
            serviceOrderTemplateItem,
            srvcOrdTmplItmUserStatus);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemUserStatusCreateFluentHelper createSrvcOrdTmplItemUserStatus(
        @Nonnull final SrvcOrdTmplItemUserStatus srvcOrdTmplItemUserStatus )
    {
        return new SrvcOrdTmplItemUserStatusCreateFluentHelper(
            servicePath,
            srvcOrdTmplItemUserStatus,
            "A_SrvcOrdTmplItemUserStatus");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItemUserStatusDeleteFluentHelper deleteSrvcOrdTmplItemUserStatus(
        @Nonnull final SrvcOrdTmplItemUserStatus srvcOrdTmplItemUserStatus )
    {
        return new SrvcOrdTmplItemUserStatusDeleteFluentHelper(
            servicePath,
            srvcOrdTmplItemUserStatus,
            "A_SrvcOrdTmplItemUserStatus");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItmPartnerAddressFluentHelper getAllSrvcOrdTmplItmPartnerAddress()
    {
        return new SrvcOrdTmplItmPartnerAddressFluentHelper(servicePath, "A_SrvcOrdTmplItmPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItmPartnerAddressByKeyFluentHelper getSrvcOrdTmplItmPartnerAddressByKey(
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdTmplItmPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplItmPartnerAddress",
            serviceOrderTemplate,
            serviceOrderTemplateItem,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplItmPartnerAddressUpdateFluentHelper updateSrvcOrdTmplItmPartnerAddress(
        @Nonnull final SrvcOrdTmplItmPartnerAddress srvcOrdTmplItmPartnerAddress )
    {
        return new SrvcOrdTmplItmPartnerAddressUpdateFluentHelper(
            servicePath,
            srvcOrdTmplItmPartnerAddress,
            "A_SrvcOrdTmplItmPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerFluentHelper getAllSrvcOrdTmplPartner()
    {
        return new SrvcOrdTmplPartnerFluentHelper(servicePath, "A_SrvcOrdTmplPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerByKeyFluentHelper getSrvcOrdTmplPartnerByKey(
        final String serviceOrderTemplate,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdTmplPartnerByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplPartner",
            serviceOrderTemplate,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerCreateFluentHelper createSrvcOrdTmplPartner(
        @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner )
    {
        return new SrvcOrdTmplPartnerCreateFluentHelper(servicePath, srvcOrdTmplPartner, "A_SrvcOrdTmplPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerUpdateFluentHelper updateSrvcOrdTmplPartner(
        @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner )
    {
        return new SrvcOrdTmplPartnerUpdateFluentHelper(servicePath, srvcOrdTmplPartner, "A_SrvcOrdTmplPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerDeleteFluentHelper deleteSrvcOrdTmplPartner(
        @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner )
    {
        return new SrvcOrdTmplPartnerDeleteFluentHelper(servicePath, srvcOrdTmplPartner, "A_SrvcOrdTmplPartner");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerAddressFluentHelper getAllSrvcOrdTmplPartnerAddress()
    {
        return new SrvcOrdTmplPartnerAddressFluentHelper(servicePath, "A_SrvcOrdTmplPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerAddressByKeyFluentHelper getSrvcOrdTmplPartnerAddressByKey(
        final String serviceOrderTemplate,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        return new SrvcOrdTmplPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplPartnerAddress",
            serviceOrderTemplate,
            custMgmtPartnerFunction,
            custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplPartnerAddressUpdateFluentHelper updateSrvcOrdTmplPartnerAddress(
        @Nonnull final SrvcOrdTmplPartnerAddress srvcOrdTmplPartnerAddress )
    {
        return new SrvcOrdTmplPartnerAddressUpdateFluentHelper(
            servicePath,
            srvcOrdTmplPartnerAddress,
            "A_SrvcOrdTmplPartnerAddress");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplUserStatusFluentHelper getAllSrvcOrdTmplUserStatus()
    {
        return new SrvcOrdTmplUserStatusFluentHelper(servicePath, "A_SrvcOrdTmplUserStatus");
    }

    @Override
    @Nonnull
    public
        SrvcOrdTmplUserStatusByKeyFluentHelper
        getSrvcOrdTmplUserStatusByKey( final String serviceOrderTemplate, final String srvcOrdTmplUserStatus )
    {
        return new SrvcOrdTmplUserStatusByKeyFluentHelper(
            servicePath,
            "A_SrvcOrdTmplUserStatus",
            serviceOrderTemplate,
            srvcOrdTmplUserStatus);
    }

    @Override
    @Nonnull
    public SrvcOrdTmplUserStatusCreateFluentHelper createSrvcOrdTmplUserStatus(
        @Nonnull final SrvcOrdTmplUserStatus srvcOrdTmplUserStatus )
    {
        return new SrvcOrdTmplUserStatusCreateFluentHelper(
            servicePath,
            srvcOrdTmplUserStatus,
            "A_SrvcOrdTmplUserStatus");
    }

    @Override
    @Nonnull
    public SrvcOrdTmplUserStatusDeleteFluentHelper deleteSrvcOrdTmplUserStatus(
        @Nonnull final SrvcOrdTmplUserStatus srvcOrdTmplUserStatus )
    {
        return new SrvcOrdTmplUserStatusDeleteFluentHelper(
            servicePath,
            srvcOrdTmplUserStatus,
            "A_SrvcOrdTmplUserStatus");
    }

}
