/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.batch.DefaultServiceQuotationServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service quotation processing in Service in SAP
 * S/4HANA Cloud. In each API call, you can use the following operations: - Retrieve service quotations. - Create
 * service quotations. Note: You must use “deep insert” requests (a header plus the following entities: header person
 * responsible, header pricing element, header reference object, header text, and item). - Create new items for existing
 * service quotations. - Create an item reference object, item pricing element, and an item text for existing service
 * quotations items. - Update the header, header person responsible, header pricing element, header text, item, item
 * pricing element, and item text of existing service quotations. - Delete the header person responsible, header
 * reference object, header pricing element, header text, item, item reference object, item pricing element, and item
 * text of existing service quotations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/44/0e29eeccde42d9ab7296cfa17fbd62/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_QUOTATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_QUOTATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Quotation Integration(SAP_COM_0355), Service - Repair Quotation Integration(SAP_COM_0744)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Quotation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2202 (Feb 2022). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultServiceQuotationService" )
@Deprecated
public class DefaultServiceQuotationService implements ServiceQuotationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ServiceQuotationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultServiceQuotationService()
    {
        servicePath = ServiceQuotationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultServiceQuotationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultServiceQuotationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultServiceQuotationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultServiceQuotationServiceBatch batch()
    {
        return new DefaultServiceQuotationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ServiceQtanItemPriceElementFluentHelper getAllServiceQtanItemPriceElement()
    {
        return new ServiceQtanItemPriceElementFluentHelper(servicePath, "A_ServiceQtanItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanItemPriceElementByKeyFluentHelper getServiceQtanItemPriceElementByKey(
        final String serviceQuotation,
        final String serviceQuotationItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new ServiceQtanItemPriceElementByKeyFluentHelper(
            servicePath,
            "A_ServiceQtanItemPriceElement",
            serviceQuotation,
            serviceQuotationItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public ServiceQtanItemPriceElementCreateFluentHelper createServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return new ServiceQtanItemPriceElementCreateFluentHelper(
            servicePath,
            serviceQtanItemPriceElement,
            "A_ServiceQtanItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanItemPriceElementUpdateFluentHelper updateServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return new ServiceQtanItemPriceElementUpdateFluentHelper(
            servicePath,
            serviceQtanItemPriceElement,
            "A_ServiceQtanItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanItemPriceElementDeleteFluentHelper deleteServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return new ServiceQtanItemPriceElementDeleteFluentHelper(
            servicePath,
            serviceQtanItemPriceElement,
            "A_ServiceQtanItemPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanItemRefObjectFluentHelper getAllServiceQtanItemRefObject()
    {
        return new ServiceQtanItemRefObjectFluentHelper(servicePath, "A_ServiceQtanItemRefObject");
    }

    @Override
    @Nonnull
    public ServiceQtanItemRefObjectByKeyFluentHelper getServiceQtanItemRefObjectByKey(
        final String serviceQuotation,
        final String serviceQuotationItem,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceQtanItemRefObjectByKeyFluentHelper(
            servicePath,
            "A_ServiceQtanItemRefObject",
            serviceQuotation,
            serviceQuotationItem,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceQtanItemRefObjectCreateFluentHelper createServiceQtanItemRefObject(
        @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject )
    {
        return new ServiceQtanItemRefObjectCreateFluentHelper(
            servicePath,
            serviceQtanItemRefObject,
            "A_ServiceQtanItemRefObject");
    }

    @Override
    @Nonnull
    public ServiceQtanItemRefObjectDeleteFluentHelper deleteServiceQtanItemRefObject(
        @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject )
    {
        return new ServiceQtanItemRefObjectDeleteFluentHelper(
            servicePath,
            serviceQtanItemRefObject,
            "A_ServiceQtanItemRefObject");
    }

    @Override
    @Nonnull
    public ServiceQtanPersonRespFluentHelper getAllServiceQtanPersonResp()
    {
        return new ServiceQtanPersonRespFluentHelper(servicePath, "A_ServiceQtanPersonResp");
    }

    @Override
    @Nonnull
    public
        ServiceQtanPersonRespByKeyFluentHelper
        getServiceQtanPersonRespByKey( final String serviceQuotation, final String personResponsible )
    {
        return new ServiceQtanPersonRespByKeyFluentHelper(
            servicePath,
            "A_ServiceQtanPersonResp",
            serviceQuotation,
            personResponsible);
    }

    @Override
    @Nonnull
    public ServiceQtanPersonRespCreateFluentHelper createServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return new ServiceQtanPersonRespCreateFluentHelper(
            servicePath,
            serviceQtanPersonResp,
            "A_ServiceQtanPersonResp");
    }

    @Override
    @Nonnull
    public ServiceQtanPersonRespUpdateFluentHelper updateServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return new ServiceQtanPersonRespUpdateFluentHelper(
            servicePath,
            serviceQtanPersonResp,
            "A_ServiceQtanPersonResp");
    }

    @Override
    @Nonnull
    public ServiceQtanPersonRespDeleteFluentHelper deleteServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return new ServiceQtanPersonRespDeleteFluentHelper(
            servicePath,
            serviceQtanPersonResp,
            "A_ServiceQtanPersonResp");
    }

    @Override
    @Nonnull
    public ServiceQtanPriceElementFluentHelper getAllServiceQtanPriceElement()
    {
        return new ServiceQtanPriceElementFluentHelper(servicePath, "A_ServiceQtanPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanPriceElementByKeyFluentHelper getServiceQtanPriceElementByKey(
        final String serviceQuotation,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new ServiceQtanPriceElementByKeyFluentHelper(
            servicePath,
            "A_ServiceQtanPriceElement",
            serviceQuotation,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public ServiceQtanPriceElementCreateFluentHelper createServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return new ServiceQtanPriceElementCreateFluentHelper(
            servicePath,
            serviceQtanPriceElement,
            "A_ServiceQtanPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanPriceElementUpdateFluentHelper updateServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return new ServiceQtanPriceElementUpdateFluentHelper(
            servicePath,
            serviceQtanPriceElement,
            "A_ServiceQtanPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanPriceElementDeleteFluentHelper deleteServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return new ServiceQtanPriceElementDeleteFluentHelper(
            servicePath,
            serviceQtanPriceElement,
            "A_ServiceQtanPriceElement");
    }

    @Override
    @Nonnull
    public ServiceQtanRefObjectFluentHelper getAllServiceQtanRefObject()
    {
        return new ServiceQtanRefObjectFluentHelper(servicePath, "A_ServiceQtanRefObject");
    }

    @Override
    @Nonnull
    public ServiceQtanRefObjectByKeyFluentHelper getServiceQtanRefObjectByKey(
        final String serviceQuotation,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        return new ServiceQtanRefObjectByKeyFluentHelper(
            servicePath,
            "A_ServiceQtanRefObject",
            serviceQuotation,
            serviceReferenceEquipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public ServiceQtanRefObjectCreateFluentHelper createServiceQtanRefObject(
        @Nonnull final ServiceQtanRefObject serviceQtanRefObject )
    {
        return new ServiceQtanRefObjectCreateFluentHelper(servicePath, serviceQtanRefObject, "A_ServiceQtanRefObject");
    }

    @Override
    @Nonnull
    public ServiceQtanRefObjectDeleteFluentHelper deleteServiceQtanRefObject(
        @Nonnull final ServiceQtanRefObject serviceQtanRefObject )
    {
        return new ServiceQtanRefObjectDeleteFluentHelper(servicePath, serviceQtanRefObject, "A_ServiceQtanRefObject");
    }

    @Override
    @Nonnull
    public ServiceQuotationFluentHelper getAllServiceQuotation()
    {
        return new ServiceQuotationFluentHelper(servicePath, "A_ServiceQuotation");
    }

    @Override
    @Nonnull
    public ServiceQuotationByKeyFluentHelper getServiceQuotationByKey( final String serviceQuotation )
    {
        return new ServiceQuotationByKeyFluentHelper(servicePath, "A_ServiceQuotation", serviceQuotation);
    }

    @Override
    @Nonnull
    public ServiceQuotationCreateFluentHelper createServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation )
    {
        return new ServiceQuotationCreateFluentHelper(servicePath, serviceQuotation, "A_ServiceQuotation");
    }

    @Override
    @Nonnull
    public ServiceQuotationUpdateFluentHelper updateServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation )
    {
        return new ServiceQuotationUpdateFluentHelper(servicePath, serviceQuotation, "A_ServiceQuotation");
    }

    @Override
    @Nonnull
    public ServiceQuotationItemFluentHelper getAllServiceQuotationItem()
    {
        return new ServiceQuotationItemFluentHelper(servicePath, "A_ServiceQuotationItem");
    }

    @Override
    @Nonnull
    public
        ServiceQuotationItemByKeyFluentHelper
        getServiceQuotationItemByKey( final String serviceQuotation, final String serviceQuotationItem )
    {
        return new ServiceQuotationItemByKeyFluentHelper(
            servicePath,
            "A_ServiceQuotationItem",
            serviceQuotation,
            serviceQuotationItem);
    }

    @Override
    @Nonnull
    public ServiceQuotationItemCreateFluentHelper createServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return new ServiceQuotationItemCreateFluentHelper(servicePath, serviceQuotationItem, "A_ServiceQuotationItem");
    }

    @Override
    @Nonnull
    public ServiceQuotationItemUpdateFluentHelper updateServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return new ServiceQuotationItemUpdateFluentHelper(servicePath, serviceQuotationItem, "A_ServiceQuotationItem");
    }

    @Override
    @Nonnull
    public ServiceQuotationItemDeleteFluentHelper deleteServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return new ServiceQuotationItemDeleteFluentHelper(servicePath, serviceQuotationItem, "A_ServiceQuotationItem");
    }

    @Override
    @Nonnull
    public ServiceQuotationItemTextFluentHelper getAllServiceQuotationItemText()
    {
        return new ServiceQuotationItemTextFluentHelper(servicePath, "A_ServiceQuotationItemText");
    }

    @Override
    @Nonnull
    public ServiceQuotationItemTextByKeyFluentHelper getServiceQuotationItemTextByKey(
        final String serviceQuotation,
        final String serviceQuotationItem,
        final String language,
        final String longTextID )
    {
        return new ServiceQuotationItemTextByKeyFluentHelper(
            servicePath,
            "A_ServiceQuotationItemText",
            serviceQuotation,
            serviceQuotationItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceQuotationItemTextCreateFluentHelper createServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return new ServiceQuotationItemTextCreateFluentHelper(
            servicePath,
            serviceQuotationItemText,
            "A_ServiceQuotationItemText");
    }

    @Override
    @Nonnull
    public ServiceQuotationItemTextUpdateFluentHelper updateServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return new ServiceQuotationItemTextUpdateFluentHelper(
            servicePath,
            serviceQuotationItemText,
            "A_ServiceQuotationItemText");
    }

    @Override
    @Nonnull
    public ServiceQuotationItemTextDeleteFluentHelper deleteServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return new ServiceQuotationItemTextDeleteFluentHelper(
            servicePath,
            serviceQuotationItemText,
            "A_ServiceQuotationItemText");
    }

    @Override
    @Nonnull
    public ServiceQuotationTextFluentHelper getAllServiceQuotationText()
    {
        return new ServiceQuotationTextFluentHelper(servicePath, "A_ServiceQuotationText");
    }

    @Override
    @Nonnull
    public
        ServiceQuotationTextByKeyFluentHelper
        getServiceQuotationTextByKey( final String serviceQuotation, final String language, final String longTextID )
    {
        return new ServiceQuotationTextByKeyFluentHelper(
            servicePath,
            "A_ServiceQuotationText",
            serviceQuotation,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ServiceQuotationTextCreateFluentHelper createServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return new ServiceQuotationTextCreateFluentHelper(servicePath, serviceQuotationText, "A_ServiceQuotationText");
    }

    @Override
    @Nonnull
    public ServiceQuotationTextUpdateFluentHelper updateServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return new ServiceQuotationTextUpdateFluentHelper(servicePath, serviceQuotationText, "A_ServiceQuotationText");
    }

    @Override
    @Nonnull
    public ServiceQuotationTextDeleteFluentHelper deleteServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return new ServiceQuotationTextDeleteFluentHelper(servicePath, serviceQuotationText, "A_ServiceQuotationText");
    }

}
