/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.batch.DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch;

/**
 * <p>
 * This service contains one entity only. Once the sold-to party assignment has been retrieved, it is sent in the
 * response. If there are any issues when retrieving the sold-to party assignment, the system displays error messages in
 * the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/19/e224a14b034a4798e08bddafd2fe78/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SD_SA_SOLDTOPARTYDETN?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SD_SA_SOLDTOPARTYDETN</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sold-to Party Assignment of Sales Scheduling Agreement Integration(SAP_COM_0367)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3NR'>Sales Scheduling Agreements(3NR)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Scheduling Agreement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementService" )
@Deprecated
public class DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementService
    implements
    SoldToPartyAssignmentOfSalesSchedulingAgreementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SoldToPartyAssignmentOfSalesSchedulingAgreementService#DEFAULT_SERVICE_PATH} to
     * send the requests.
     *
     */
    public DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementService()
    {
        servicePath = SoldToPartyAssignmentOfSalesSchedulingAgreementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementService withServicePath(
        @Nonnull final String servicePath )
    {
        return new DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch batch()
    {
        return new DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DelivSchedSoldToPartyDetnFluentHelper getAllDelivSchedSoldToPartyDetn()
    {
        return new DelivSchedSoldToPartyDetnFluentHelper(servicePath, "A_DelivSchedSoldToPartyDetn");
    }

    @Override
    @Nonnull
    public DelivSchedSoldToPartyDetnByKeyFluentHelper getDelivSchedSoldToPartyDetnByKey(
        final String supplier,
        final String partnerDescription,
        final String unloadingPointName )
    {
        return new DelivSchedSoldToPartyDetnByKeyFluentHelper(
            servicePath,
            "A_DelivSchedSoldToPartyDetn",
            supplier,
            partnerDescription,
            unloadingPointName);
    }

}
