/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.batch.DefaultStandardWorkFormulaParameterGroupServiceBatch;

/**
 * <p>
 *
 * This service is based on OData V2 protocol and can be consumed in Fiori apps and on other user interfaces. It enables
 * you to read standard work formula parameter group, standard work formula parameter group text and standard work
 * formula parameter text in an API call..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4b/ee70f8a5844765a4a30b4113935306/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_STDWRKFMLAPARAM_GROUP_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_STDWRKFMLAPARAM_GROUP_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Work Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultStandardWorkFormulaParameterGroupService" )
@Deprecated
public class DefaultStandardWorkFormulaParameterGroupService implements StandardWorkFormulaParameterGroupService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link StandardWorkFormulaParameterGroupService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultStandardWorkFormulaParameterGroupService()
    {
        servicePath = StandardWorkFormulaParameterGroupService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultStandardWorkFormulaParameterGroupService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultStandardWorkFormulaParameterGroupService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultStandardWorkFormulaParameterGroupService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultStandardWorkFormulaParameterGroupServiceBatch batch()
    {
        return new DefaultStandardWorkFormulaParameterGroupServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public StandardWorkFmlaParamGroupFluentHelper getAllStandardWorkFmlaParamGroup()
    {
        return new StandardWorkFmlaParamGroupFluentHelper(servicePath, "StandardWorkFmlaParamGroup");
    }

    @Override
    @Nonnull
    public StandardWorkFmlaParamGroupByKeyFluentHelper getStandardWorkFmlaParamGroupByKey(
        final String standardWorkFormulaParamGroup )
    {
        return new StandardWorkFmlaParamGroupByKeyFluentHelper(
            servicePath,
            "StandardWorkFmlaParamGroup",
            standardWorkFormulaParamGroup);
    }

    @Override
    @Nonnull
    public StandardWorkFmlaParamGrpTextFluentHelper getAllStandardWorkFmlaParamGrpText()
    {
        return new StandardWorkFmlaParamGrpTextFluentHelper(servicePath, "StandardWorkFmlaParamGrpText");
    }

    @Override
    @Nonnull
    public
        StandardWorkFmlaParamGrpTextByKeyFluentHelper
        getStandardWorkFmlaParamGrpTextByKey( final String standardWorkFormulaParamGroup, final String language )
    {
        return new StandardWorkFmlaParamGrpTextByKeyFluentHelper(
            servicePath,
            "StandardWorkFmlaParamGrpText",
            standardWorkFormulaParamGroup,
            language);
    }

    @Override
    @Nonnull
    public StandardWorkFormulaParamTextFluentHelper getAllStandardWorkFormulaParamText()
    {
        return new StandardWorkFormulaParamTextFluentHelper(servicePath, "StandardWorkFormulaParamText");
    }

    @Override
    @Nonnull
    public
        StandardWorkFormulaParamTextByKeyFluentHelper
        getStandardWorkFormulaParamTextByKey( final String standardWorkFormulaParameter, final String language )
    {
        return new StandardWorkFormulaParamTextByKeyFluentHelper(
            servicePath,
            "StandardWorkFormulaParamText",
            standardWorkFormulaParameter,
            language);
    }

}
