/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.batch.DefaultStatisticalKeyFigureServiceBatch;

/**
 * <p>
 *
 * This service is based on the OData protocol and can be consumed in Fiori apps and on other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/78/c9f90d79654fdc85e2f34f404a278c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_STATISTICALKEYFIGURE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_STATISTICALKEYFIGURE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Statistical Key Figure Integration(SAP_COM_0130)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Statistical Key Figure</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultStatisticalKeyFigureService" )
@Deprecated
public class DefaultStatisticalKeyFigureService implements StatisticalKeyFigureService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link StatisticalKeyFigureService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultStatisticalKeyFigureService()
    {
        servicePath = StatisticalKeyFigureService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultStatisticalKeyFigureService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultStatisticalKeyFigureService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultStatisticalKeyFigureService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultStatisticalKeyFigureServiceBatch batch()
    {
        return new DefaultStatisticalKeyFigureServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureFluentHelper getAllStatisticalKeyFigure()
    {
        return new StatisticalKeyFigureFluentHelper(servicePath, "A_StatisticalKeyFigure");
    }

    @Override
    @Nonnull
    public
        StatisticalKeyFigureByKeyFluentHelper
        getStatisticalKeyFigureByKey( final String statisticalKeyFigure, final String controllingArea )
    {
        return new StatisticalKeyFigureByKeyFluentHelper(
            servicePath,
            "A_StatisticalKeyFigure",
            statisticalKeyFigure,
            controllingArea);
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureCreateFluentHelper createStatisticalKeyFigure(
        @Nonnull final StatisticalKeyFigure statisticalKeyFigure )
    {
        return new StatisticalKeyFigureCreateFluentHelper(servicePath, statisticalKeyFigure, "A_StatisticalKeyFigure");
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureUpdateFluentHelper updateStatisticalKeyFigure(
        @Nonnull final StatisticalKeyFigure statisticalKeyFigure )
    {
        return new StatisticalKeyFigureUpdateFluentHelper(servicePath, statisticalKeyFigure, "A_StatisticalKeyFigure");
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureDeleteFluentHelper deleteStatisticalKeyFigure(
        @Nonnull final StatisticalKeyFigure statisticalKeyFigure )
    {
        return new StatisticalKeyFigureDeleteFluentHelper(servicePath, statisticalKeyFigure, "A_StatisticalKeyFigure");
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureTextFluentHelper getAllStatisticalKeyFigureText()
    {
        return new StatisticalKeyFigureTextFluentHelper(servicePath, "A_StatisticalKeyFigureText");
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureTextByKeyFluentHelper getStatisticalKeyFigureTextByKey(
        final String language,
        final String controllingArea,
        final String statisticalKeyFigure )
    {
        return new StatisticalKeyFigureTextByKeyFluentHelper(
            servicePath,
            "A_StatisticalKeyFigureText",
            language,
            controllingArea,
            statisticalKeyFigure);
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureTextCreateFluentHelper createStatisticalKeyFigureText(
        @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText )
    {
        return new StatisticalKeyFigureTextCreateFluentHelper(
            servicePath,
            statisticalKeyFigureText,
            "A_StatisticalKeyFigureText");
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureTextUpdateFluentHelper updateStatisticalKeyFigureText(
        @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText )
    {
        return new StatisticalKeyFigureTextUpdateFluentHelper(
            servicePath,
            statisticalKeyFigureText,
            "A_StatisticalKeyFigureText");
    }

    @Override
    @Nonnull
    public StatisticalKeyFigureTextDeleteFluentHelper deleteStatisticalKeyFigureText(
        @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText )
    {
        return new StatisticalKeyFigureTextDeleteFluentHelper(
            servicePath,
            statisticalKeyFigureText,
            "A_StatisticalKeyFigureText");
    }

}
