/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillgByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.batch.DefaultSubsequentBillingDocumentServiceBatch;

/**
 * <p>
 *
 * SAP Self-Billing Cockpit uses this service to retrieve details about billing documents in your system that were
 * created with reference to existing billing documents in your system. For example, if a credit memo was created with
 * reference to an invoice, the invoice is the preceding billing document and the credit memo is the subsequent billing
 * document. The service makes the subsequent billing document&#39;s data available through a single service entity.
 *
 * This service is intended solely for the integration between SAP S/4HANA Cloud and SAP Self-Billing Cockpit and should
 * not be used for any other purposes. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b9/f5d563bc2745df9c21f1c1c6a43cdd/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUBSQNT_BILLG_DOC_SBI_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUBSQNT_BILLG_DOC_SBI_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Self-Billing Cockpit Integration(SAP_COM_0564)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4H2'>Self-Billing(4H2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Billing Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSubsequentBillingDocumentService" )
@Deprecated
public class DefaultSubsequentBillingDocumentService implements SubsequentBillingDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SubsequentBillingDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSubsequentBillingDocumentService()
    {
        servicePath = SubsequentBillingDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSubsequentBillingDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSubsequentBillingDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSubsequentBillingDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSubsequentBillingDocumentServiceBatch batch()
    {
        return new DefaultSubsequentBillingDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SubsqntBillgDocForSelfBillgFluentHelper getAllSubsqntBillgDocForSelfBillg()
    {
        return new SubsqntBillgDocForSelfBillgFluentHelper(servicePath, "A_SubsqntBillgDocForSelfBillg");
    }

    @Override
    @Nonnull
    public SubsqntBillgDocForSelfBillgByKeyFluentHelper getSubsqntBillgDocForSelfBillgByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String subsequentDocument,
        final String subsequentDocumentItem )
    {
        return new SubsqntBillgDocForSelfBillgByKeyFluentHelper(
            servicePath,
            "A_SubsqntBillgDocForSelfBillg",
            billingDocument,
            billingDocumentItem,
            subsequentDocument,
            subsequentDocumentItem);
    }

}
