/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.batch.DefaultSupplierActivityServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete procurement-related activities through an API call.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f0/decab112af49d3825253d442dbc253/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPPLIER_ACTIVITY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPPLIER_ACTIVITY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Activity Integration(SAP_COM_0137)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/19C'>Activity Management in Procurement(19C)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Activity</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSupplierActivityService" )
@Deprecated
public class DefaultSupplierActivityService implements SupplierActivityService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SupplierActivityService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSupplierActivityService()
    {
        servicePath = SupplierActivityService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSupplierActivityService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierActivityService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSupplierActivityService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSupplierActivityServiceBatch batch()
    {
        return new DefaultSupplierActivityServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SuplrActyDescriptionFluentHelper getAllSuplrActyDescription()
    {
        return new SuplrActyDescriptionFluentHelper(servicePath, "A_SuplrActyDescription");
    }

    @Override
    @Nonnull
    public
        SuplrActyDescriptionByKeyFluentHelper
        getSuplrActyDescriptionByKey( final UUID suplrActyUUID, final String language )
    {
        return new SuplrActyDescriptionByKeyFluentHelper(
            servicePath,
            "A_SuplrActyDescription",
            suplrActyUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrActyDescriptionCreateFluentHelper createSuplrActyDescription(
        @Nonnull final SuplrActyDescription suplrActyDescription )
    {
        return new SuplrActyDescriptionCreateFluentHelper(servicePath, suplrActyDescription, "A_SuplrActyDescription");
    }

    @Override
    @Nonnull
    public SuplrActyDescriptionUpdateFluentHelper updateSuplrActyDescription(
        @Nonnull final SuplrActyDescription suplrActyDescription )
    {
        return new SuplrActyDescriptionUpdateFluentHelper(servicePath, suplrActyDescription, "A_SuplrActyDescription");
    }

    @Override
    @Nonnull
    public SuplrActyDescriptionDeleteFluentHelper deleteSuplrActyDescription(
        @Nonnull final SuplrActyDescription suplrActyDescription )
    {
        return new SuplrActyDescriptionDeleteFluentHelper(servicePath, suplrActyDescription, "A_SuplrActyDescription");
    }

    @Override
    @Nonnull
    public SuplrActyParticipantFluentHelper getAllSuplrActyParticipant()
    {
        return new SuplrActyParticipantFluentHelper(servicePath, "A_SuplrActyParticipant");
    }

    @Override
    @Nonnull
    public SuplrActyParticipantByKeyFluentHelper getSuplrActyParticipantByKey( final UUID suplrActyPartyUUID )
    {
        return new SuplrActyParticipantByKeyFluentHelper(servicePath, "A_SuplrActyParticipant", suplrActyPartyUUID);
    }

    @Override
    @Nonnull
    public SuplrActyParticipantCreateFluentHelper createSuplrActyParticipant(
        @Nonnull final SuplrActyParticipant suplrActyParticipant )
    {
        return new SuplrActyParticipantCreateFluentHelper(servicePath, suplrActyParticipant, "A_SuplrActyParticipant");
    }

    @Override
    @Nonnull
    public SuplrActyParticipantUpdateFluentHelper updateSuplrActyParticipant(
        @Nonnull final SuplrActyParticipant suplrActyParticipant )
    {
        return new SuplrActyParticipantUpdateFluentHelper(servicePath, suplrActyParticipant, "A_SuplrActyParticipant");
    }

    @Override
    @Nonnull
    public SuplrActyParticipantDeleteFluentHelper deleteSuplrActyParticipant(
        @Nonnull final SuplrActyParticipant suplrActyParticipant )
    {
        return new SuplrActyParticipantDeleteFluentHelper(servicePath, suplrActyParticipant, "A_SuplrActyParticipant");
    }

    @Override
    @Nonnull
    public SuplrActyPurchaserRespFluentHelper getAllSuplrActyPurchaserResp()
    {
        return new SuplrActyPurchaserRespFluentHelper(servicePath, "A_SuplrActyPurchaserResp");
    }

    @Override
    @Nonnull
    public SuplrActyPurchaserRespByKeyFluentHelper getSuplrActyPurchaserRespByKey( final UUID suplrActyPartyUUID )
    {
        return new SuplrActyPurchaserRespByKeyFluentHelper(servicePath, "A_SuplrActyPurchaserResp", suplrActyPartyUUID);
    }

    @Override
    @Nonnull
    public SuplrActyPurchaserRespUpdateFluentHelper updateSuplrActyPurchaserResp(
        @Nonnull final SuplrActyPurchaserResp suplrActyPurchaserResp )
    {
        return new SuplrActyPurchaserRespUpdateFluentHelper(
            servicePath,
            suplrActyPurchaserResp,
            "A_SuplrActyPurchaserResp");
    }

    @Override
    @Nonnull
    public SuplrActySupplierFluentHelper getAllSuplrActySupplier()
    {
        return new SuplrActySupplierFluentHelper(servicePath, "A_SuplrActySupplier");
    }

    @Override
    @Nonnull
    public SuplrActySupplierByKeyFluentHelper getSuplrActySupplierByKey( final UUID suplrActyPartyUUID )
    {
        return new SuplrActySupplierByKeyFluentHelper(servicePath, "A_SuplrActySupplier", suplrActyPartyUUID);
    }

    @Override
    @Nonnull
    public SuplrActySupplierCreateFluentHelper createSuplrActySupplier(
        @Nonnull final SuplrActySupplier suplrActySupplier )
    {
        return new SuplrActySupplierCreateFluentHelper(servicePath, suplrActySupplier, "A_SuplrActySupplier");
    }

    @Override
    @Nonnull
    public SuplrActySupplierUpdateFluentHelper updateSuplrActySupplier(
        @Nonnull final SuplrActySupplier suplrActySupplier )
    {
        return new SuplrActySupplierUpdateFluentHelper(servicePath, suplrActySupplier, "A_SuplrActySupplier");
    }

    @Override
    @Nonnull
    public SuplrActySupplierDeleteFluentHelper deleteSuplrActySupplier(
        @Nonnull final SuplrActySupplier suplrActySupplier )
    {
        return new SuplrActySupplierDeleteFluentHelper(servicePath, suplrActySupplier, "A_SuplrActySupplier");
    }

    @Override
    @Nonnull
    public SupplierActivityFluentHelper getAllSupplierActivity()
    {
        return new SupplierActivityFluentHelper(servicePath, "A_SupplierActivity");
    }

    @Override
    @Nonnull
    public SupplierActivityByKeyFluentHelper getSupplierActivityByKey( final UUID suplrActyUUID )
    {
        return new SupplierActivityByKeyFluentHelper(servicePath, "A_SupplierActivity", suplrActyUUID);
    }

    @Override
    @Nonnull
    public SupplierActivityCreateFluentHelper createSupplierActivity( @Nonnull final SupplierActivity supplierActivity )
    {
        return new SupplierActivityCreateFluentHelper(servicePath, supplierActivity, "A_SupplierActivity");
    }

    @Override
    @Nonnull
    public SupplierActivityUpdateFluentHelper updateSupplierActivity( @Nonnull final SupplierActivity supplierActivity )
    {
        return new SupplierActivityUpdateFluentHelper(servicePath, supplierActivity, "A_SupplierActivity");
    }

    @Override
    @Nonnull
    public SupplierActivityDeleteFluentHelper deleteSupplierActivity( @Nonnull final SupplierActivity supplierActivity )
    {
        return new SupplierActivityDeleteFluentHelper(servicePath, supplierActivity, "A_SupplierActivity");
    }

}
