/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.CompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.RequestClarificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SendFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SubmitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReferenceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReferenceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTaskByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTaskFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.batch.DefaultSupplierActivityTaskServiceBatch;

/**
 * <p>
 * This service enables you to create, update and delete procurement-related tasks through an API call.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/95/e05385472d444e8ae8a830459d6986/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPPLIER_ACTIVITY_TASK_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPPLIER_ACTIVITY_TASK_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Activity Task Integration(SAP_COM_0138)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/19C'>Activity Management in Procurement(19C)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Activity</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSupplierActivityTaskService" )
@Deprecated
public class DefaultSupplierActivityTaskService implements SupplierActivityTaskService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SupplierActivityTaskService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSupplierActivityTaskService()
    {
        servicePath = SupplierActivityTaskService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSupplierActivityTaskService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierActivityTaskService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSupplierActivityTaskService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSupplierActivityTaskServiceBatch batch()
    {
        return new DefaultSupplierActivityTaskServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SuplrActyTskActyReferenceFluentHelper getAllSuplrActyTskActyReference()
    {
        return new SuplrActyTskActyReferenceFluentHelper(servicePath, "A_SuplrActyTskActyReference");
    }

    @Override
    @Nonnull
    public SuplrActyTskActyReferenceByKeyFluentHelper getSuplrActyTskActyReferenceByKey(
        final UUID suplrActyTaskReferenceUUID )
    {
        return new SuplrActyTskActyReferenceByKeyFluentHelper(
            servicePath,
            "A_SuplrActyTskActyReference",
            suplrActyTaskReferenceUUID);
    }

    @Override
    @Nonnull
    public SuplrActyTskCommTextFluentHelper getAllSuplrActyTskCommText()
    {
        return new SuplrActyTskCommTextFluentHelper(servicePath, "A_SuplrActyTskCommText");
    }

    @Override
    @Nonnull
    public
        SuplrActyTskCommTextByKeyFluentHelper
        getSuplrActyTskCommTextByKey( final UUID suplrActyTaskUUID, final String language )
    {
        return new SuplrActyTskCommTextByKeyFluentHelper(
            servicePath,
            "A_SuplrActyTskCommText",
            suplrActyTaskUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrActyTskDescriptionFluentHelper getAllSuplrActyTskDescription()
    {
        return new SuplrActyTskDescriptionFluentHelper(servicePath, "A_SuplrActyTskDescription");
    }

    @Override
    @Nonnull
    public
        SuplrActyTskDescriptionByKeyFluentHelper
        getSuplrActyTskDescriptionByKey( final UUID suplrActyTaskUUID, final String language )
    {
        return new SuplrActyTskDescriptionByKeyFluentHelper(
            servicePath,
            "A_SuplrActyTskDescription",
            suplrActyTaskUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrActyTskMessageTextFluentHelper getAllSuplrActyTskMessageText()
    {
        return new SuplrActyTskMessageTextFluentHelper(servicePath, "A_SuplrActyTskMessageText");
    }

    @Override
    @Nonnull
    public
        SuplrActyTskMessageTextByKeyFluentHelper
        getSuplrActyTskMessageTextByKey( final UUID suplrActyTaskUUID, final String language )
    {
        return new SuplrActyTskMessageTextByKeyFluentHelper(
            servicePath,
            "A_SuplrActyTskMessageText",
            suplrActyTaskUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrActyTskProcessorFluentHelper getAllSuplrActyTskProcessor()
    {
        return new SuplrActyTskProcessorFluentHelper(servicePath, "A_SuplrActyTskProcessor");
    }

    @Override
    @Nonnull
    public SuplrActyTskProcessorByKeyFluentHelper getSuplrActyTskProcessorByKey( final UUID suplrActyTaskPartyUUID )
    {
        return new SuplrActyTskProcessorByKeyFluentHelper(
            servicePath,
            "A_SuplrActyTskProcessor",
            suplrActyTaskPartyUUID);
    }

    @Override
    @Nonnull
    public SuplrActyTskPurchaserRespFluentHelper getAllSuplrActyTskPurchaserResp()
    {
        return new SuplrActyTskPurchaserRespFluentHelper(servicePath, "A_SuplrActyTskPurchaserResp");
    }

    @Override
    @Nonnull
    public SuplrActyTskPurchaserRespByKeyFluentHelper getSuplrActyTskPurchaserRespByKey(
        final UUID suplrActyTaskPartyUUID )
    {
        return new SuplrActyTskPurchaserRespByKeyFluentHelper(
            servicePath,
            "A_SuplrActyTskPurchaserResp",
            suplrActyTaskPartyUUID);
    }

    @Override
    @Nonnull
    public SuplrActyTskSupplierFluentHelper getAllSuplrActyTskSupplier()
    {
        return new SuplrActyTskSupplierFluentHelper(servicePath, "A_SuplrActyTskSupplier");
    }

    @Override
    @Nonnull
    public SuplrActyTskSupplierByKeyFluentHelper getSuplrActyTskSupplierByKey( final UUID suplrActyTaskPartyUUID )
    {
        return new SuplrActyTskSupplierByKeyFluentHelper(servicePath, "A_SuplrActyTskSupplier", suplrActyTaskPartyUUID);
    }

    @Override
    @Nonnull
    public SupplierActivityTaskFluentHelper getAllSupplierActivityTask()
    {
        return new SupplierActivityTaskFluentHelper(servicePath, "A_SupplierActivityTask");
    }

    @Override
    @Nonnull
    public SupplierActivityTaskByKeyFluentHelper getSupplierActivityTaskByKey( final UUID suplrActyTaskUUID )
    {
        return new SupplierActivityTaskByKeyFluentHelper(servicePath, "A_SupplierActivityTask", suplrActyTaskUUID);
    }

    @Override
    @Nonnull
    public SendFluentHelper send( @Nonnull final UUID suplrActyTaskUUID )
    {
        return new SendFluentHelper(servicePath, suplrActyTaskUUID);
    }

    @Override
    @Nonnull
    public SubmitFluentHelper submit( @Nonnull final UUID suplrActyTaskUUID )
    {
        return new SubmitFluentHelper(servicePath, suplrActyTaskUUID);
    }

    @Override
    @Nonnull
    public CompleteFluentHelper complete( @Nonnull final UUID suplrActyTaskUUID )
    {
        return new CompleteFluentHelper(servicePath, suplrActyTaskUUID);
    }

    @Override
    @Nonnull
    public RequestClarificationFluentHelper requestClarification( @Nonnull final UUID suplrActyTaskUUID )
    {
        return new RequestClarificationFluentHelper(servicePath, suplrActyTaskUUID);
    }

}
