/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiserByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiserFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalNameByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalNameFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroductionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroductionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.batch.DefaultSupplierEvaluationResponseServiceBatch;

/**
 * <p>
 * This service enables you to read supplier evaluation responses through an API call.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c3/ae159f9d0d4ce89c03e433212be4bf/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPLR_EVAL_RESPONSE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPLR_EVAL_RESPONSE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Evaluation Response Integration(SAP_COM_0139)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/SL4'>Supplier Evaluation and Performance Monitoring(SL4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Evaluation Response</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSupplierEvaluationResponseService" )
@Deprecated
public class DefaultSupplierEvaluationResponseService implements SupplierEvaluationResponseService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SupplierEvaluationResponseService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSupplierEvaluationResponseService()
    {
        servicePath = SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSupplierEvaluationResponseService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierEvaluationResponseService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSupplierEvaluationResponseService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSupplierEvaluationResponseServiceBatch batch()
    {
        return new DefaultSupplierEvaluationResponseServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SuplrEvalRspAppraiserFluentHelper getAllSuplrEvalRspAppraiser()
    {
        return new SuplrEvalRspAppraiserFluentHelper(servicePath, "A_SuplrEvalRspAppraiser");
    }

    @Override
    @Nonnull
    public SuplrEvalRspAppraiserByKeyFluentHelper getSuplrEvalRspAppraiserByKey( final UUID suplrEvalRspPartyUUID )
    {
        return new SuplrEvalRspAppraiserByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspAppraiser",
            suplrEvalRspPartyUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalRspExplTextFluentHelper getAllSuplrEvalRspExplText()
    {
        return new SuplrEvalRspExplTextFluentHelper(servicePath, "A_SuplrEvalRspExplText");
    }

    @Override
    @Nonnull
    public
        SuplrEvalRspExplTextByKeyFluentHelper
        getSuplrEvalRspExplTextByKey( final UUID suplrEvalReqUUID, final String language )
    {
        return new SuplrEvalRspExplTextByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspExplText",
            suplrEvalReqUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrEvalRspExternalNameFluentHelper getAllSuplrEvalRspExternalName()
    {
        return new SuplrEvalRspExternalNameFluentHelper(servicePath, "A_SuplrEvalRspExternalName");
    }

    @Override
    @Nonnull
    public
        SuplrEvalRspExternalNameByKeyFluentHelper
        getSuplrEvalRspExternalNameByKey( final UUID suplrEvalRspUUID, final String language )
    {
        return new SuplrEvalRspExternalNameByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspExternalName",
            suplrEvalRspUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrEvalRspIntroductionFluentHelper getAllSuplrEvalRspIntroduction()
    {
        return new SuplrEvalRspIntroductionFluentHelper(servicePath, "A_SuplrEvalRspIntroduction");
    }

    @Override
    @Nonnull
    public
        SuplrEvalRspIntroductionByKeyFluentHelper
        getSuplrEvalRspIntroductionByKey( final UUID suplrEvalReqUUID, final String language )
    {
        return new SuplrEvalRspIntroductionByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspIntroduction",
            suplrEvalReqUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrEvalRspLanguageFluentHelper getAllSuplrEvalRspLanguage()
    {
        return new SuplrEvalRspLanguageFluentHelper(servicePath, "A_SuplrEvalRspLanguage");
    }

    @Override
    @Nonnull
    public SuplrEvalRspLanguageByKeyFluentHelper getSuplrEvalRspLanguageByKey( final UUID suplrEvalRspLanguageUUID )
    {
        return new SuplrEvalRspLanguageByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspLanguage",
            suplrEvalRspLanguageUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalRspPurchaserRespFluentHelper getAllSuplrEvalRspPurchaserResp()
    {
        return new SuplrEvalRspPurchaserRespFluentHelper(servicePath, "A_SuplrEvalRspPurchaserResp");
    }

    @Override
    @Nonnull
    public SuplrEvalRspPurchaserRespByKeyFluentHelper getSuplrEvalRspPurchaserRespByKey(
        final UUID suplrEvalRspPartyUUID )
    {
        return new SuplrEvalRspPurchaserRespByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspPurchaserResp",
            suplrEvalRspPartyUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalRspQuestionFluentHelper getAllSuplrEvalRspQuestion()
    {
        return new SuplrEvalRspQuestionFluentHelper(servicePath, "A_SuplrEvalRspQuestion");
    }

    @Override
    @Nonnull
    public SuplrEvalRspQuestionByKeyFluentHelper getSuplrEvalRspQuestionByKey( final UUID suplrEvalRspQuestionUUID )
    {
        return new SuplrEvalRspQuestionByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspQuestion",
            suplrEvalRspQuestionUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalRspQuestionTextFluentHelper getAllSuplrEvalRspQuestionText()
    {
        return new SuplrEvalRspQuestionTextFluentHelper(servicePath, "A_SuplrEvalRspQuestionText");
    }

    @Override
    @Nonnull
    public
        SuplrEvalRspQuestionTextByKeyFluentHelper
        getSuplrEvalRspQuestionTextByKey( final UUID suplrEvalReqUUID, final String language )
    {
        return new SuplrEvalRspQuestionTextByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspQuestionText",
            suplrEvalReqUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrEvalRspRootQnaireFluentHelper getAllSuplrEvalRspRootQnaire()
    {
        return new SuplrEvalRspRootQnaireFluentHelper(servicePath, "A_SuplrEvalRspRootQnaire");
    }

    @Override
    @Nonnull
    public SuplrEvalRspRootQnaireByKeyFluentHelper getSuplrEvalRspRootQnaireByKey(
        final UUID suplrEvalRspQuestionnaireUUID )
    {
        return new SuplrEvalRspRootQnaireByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspRootQnaire",
            suplrEvalRspQuestionnaireUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalRspSectionFluentHelper getAllSuplrEvalRspSection()
    {
        return new SuplrEvalRspSectionFluentHelper(servicePath, "A_SuplrEvalRspSection");
    }

    @Override
    @Nonnull
    public SuplrEvalRspSectionByKeyFluentHelper getSuplrEvalRspSectionByKey( final UUID suplrEvalRspSectionUUID )
    {
        return new SuplrEvalRspSectionByKeyFluentHelper(servicePath, "A_SuplrEvalRspSection", suplrEvalRspSectionUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalRspSectionTextFluentHelper getAllSuplrEvalRspSectionText()
    {
        return new SuplrEvalRspSectionTextFluentHelper(servicePath, "A_SuplrEvalRspSectionText");
    }

    @Override
    @Nonnull
    public
        SuplrEvalRspSectionTextByKeyFluentHelper
        getSuplrEvalRspSectionTextByKey( final UUID suplrEvalReqUUID, final String language )
    {
        return new SuplrEvalRspSectionTextByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspSectionText",
            suplrEvalReqUUID,
            language);
    }

    @Override
    @Nonnull
    public SuplrEvalRspStrucQnaireFluentHelper getAllSuplrEvalRspStrucQnaire()
    {
        return new SuplrEvalRspStrucQnaireFluentHelper(servicePath, "A_SuplrEvalRspStrucQnaire");
    }

    @Override
    @Nonnull
    public SuplrEvalRspStrucQnaireByKeyFluentHelper getSuplrEvalRspStrucQnaireByKey(
        final UUID suplrEvalRspQuestionnaireUUID )
    {
        return new SuplrEvalRspStrucQnaireByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalRspStrucQnaire",
            suplrEvalRspQuestionnaireUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalRspSupplierFluentHelper getAllSuplrEvalRspSupplier()
    {
        return new SuplrEvalRspSupplierFluentHelper(servicePath, "A_SuplrEvalRspSupplier");
    }

    @Override
    @Nonnull
    public SuplrEvalRspSupplierByKeyFluentHelper getSuplrEvalRspSupplierByKey( final UUID suplrEvalRspPartyUUID )
    {
        return new SuplrEvalRspSupplierByKeyFluentHelper(servicePath, "A_SuplrEvalRspSupplier", suplrEvalRspPartyUUID);
    }

    @Override
    @Nonnull
    public SupplierEvaluationResponseFluentHelper getAllSupplierEvaluationResponse()
    {
        return new SupplierEvaluationResponseFluentHelper(servicePath, "A_SupplierEvaluationResponse");
    }

    @Override
    @Nonnull
    public SupplierEvaluationResponseByKeyFluentHelper getSupplierEvaluationResponseByKey( final UUID suplrEvalRspUUID )
    {
        return new SupplierEvaluationResponseByKeyFluentHelper(
            servicePath,
            "A_SupplierEvaluationResponse",
            suplrEvalRspUUID);
    }

}
