/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.batch.DefaultSupplierEvaluationScoreServiceBatch;

/**
 * <p>
 *
 * This service enables consumers to read operational supplier evaluation scores from the SAP S/4HANA Cloud system.
 * These scores are calculated in the SAP S/4HANA Cloud system by time, by quantity, by price, and by quality. This
 * service is based on the OData protocol, and can be consumed by apps and other interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a8/7d292f30b04d47bc5e29cabbff1a57/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/A_SUPPLIEROPLSCORESAV_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>A_SUPPLIEROPLSCORESAV_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Procurement - Operational Supplier Evaluation Score Integration(SAP_COM_0324)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/SL4'>Supplier Evaluation and Performance Monitoring(SL4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Evaluation Score</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSupplierEvaluationScoreService" )
@Deprecated
public class DefaultSupplierEvaluationScoreService implements SupplierEvaluationScoreService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SupplierEvaluationScoreService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSupplierEvaluationScoreService()
    {
        servicePath = SupplierEvaluationScoreService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSupplierEvaluationScoreService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierEvaluationScoreService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSupplierEvaluationScoreService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSupplierEvaluationScoreServiceBatch batch()
    {
        return new DefaultSupplierEvaluationScoreServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SAP__CurrencyFluentHelper getAllSAP__Currency()
    {
        return new SAP__CurrencyFluentHelper(servicePath, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyByKeyFluentHelper getSAP__CurrencyByKey( final String currencyCode )
    {
        return new SAP__CurrencyByKeyFluentHelper(servicePath, "SAP__Currencies", currencyCode);
    }

    @Override
    @Nonnull
    public SAP__CurrencyCreateFluentHelper createSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyCreateFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyUpdateFluentHelper updateSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyUpdateFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyDeleteFluentHelper deleteSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyDeleteFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureFluentHelper getAllSAP__UnitOfMeasure()
    {
        return new SAP__UnitOfMeasureFluentHelper(servicePath, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureByKeyFluentHelper getSAP__UnitOfMeasureByKey( final String unitCode )
    {
        return new SAP__UnitOfMeasureByKeyFluentHelper(servicePath, "SAP__UnitsOfMeasure", unitCode);
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureCreateFluentHelper createSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureCreateFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureUpdateFluentHelper updateSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureUpdateFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureDeleteFluentHelper deleteSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureDeleteFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionFluentHelper getAllSAP__DocumentDescription()
    {
        return new SAP__DocumentDescriptionFluentHelper(servicePath, "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionByKeyFluentHelper getSAP__DocumentDescriptionByKey( final UUID id )
    {
        return new SAP__DocumentDescriptionByKeyFluentHelper(servicePath, "SAP__MyDocumentDescriptions", id);
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionCreateFluentHelper createSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionCreateFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionUpdateFluentHelper updateSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionUpdateFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionDeleteFluentHelper deleteSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionDeleteFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpFluentHelper getAllSAP__ValueHelp()
    {
        return new SAP__ValueHelpFluentHelper(servicePath, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpByKeyFluentHelper getSAP__ValueHelpByKey( final String vALUEHELP )
    {
        return new SAP__ValueHelpByKeyFluentHelper(servicePath, "SAP__ValueHelpSet", vALUEHELP);
    }

    @Override
    @Nonnull
    public SAP__ValueHelpCreateFluentHelper createSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpCreateFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpUpdateFluentHelper updateSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpUpdateFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpDeleteFluentHelper deleteSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpDeleteFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public
        SupplierOplScoresAVParametersByKeyFluentHelper
        getSupplierOplScoresAVParametersByKey( final String p_DisplayCurrency, final String p_DateFunction )
    {
        return new SupplierOplScoresAVParametersByKeyFluentHelper(
            servicePath,
            "A_SupplierOplScoresAV",
            p_DisplayCurrency,
            p_DateFunction);
    }

}
