/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSectionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSectionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.batch.DefaultSupplierEvaluationScorecardServiceBatch;

/**
 * <p>
 * This service enables you to read supplier evaluation scorecards that contain the results of the supplier evaluations
 * per supplier.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/91/16dbdb342f4d5d8ff36e9ca410e018/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPLR_EVAL_SCORECARD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPLR_EVAL_SCORECARD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Evaluation Scorecard Integration(SAP_COM_0122)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/SL4'>Supplier Evaluation and Performance Monitoring(SL4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Evaluation Scorecard</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSupplierEvaluationScorecardService" )
@Deprecated
public class DefaultSupplierEvaluationScorecardService implements SupplierEvaluationScorecardService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SupplierEvaluationScorecardService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSupplierEvaluationScorecardService()
    {
        servicePath = SupplierEvaluationScorecardService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSupplierEvaluationScorecardService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierEvaluationScorecardService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSupplierEvaluationScorecardService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSupplierEvaluationScorecardServiceBatch batch()
    {
        return new DefaultSupplierEvaluationScorecardServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdPurchaserRespFluentHelper getAllSuplrEvalSccrdPurchaserResp()
    {
        return new SuplrEvalSccrdPurchaserRespFluentHelper(servicePath, "A_SuplrEvalSccrdPurchaserResp");
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdPurchaserRespByKeyFluentHelper getSuplrEvalSccrdPurchaserRespByKey(
        final UUID suplrEvalScorecardPtyUUID )
    {
        return new SuplrEvalSccrdPurchaserRespByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalSccrdPurchaserResp",
            suplrEvalScorecardPtyUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdQuestionFluentHelper getAllSuplrEvalSccrdQuestion()
    {
        return new SuplrEvalSccrdQuestionFluentHelper(servicePath, "A_SuplrEvalSccrdQuestion");
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdQuestionByKeyFluentHelper getSuplrEvalSccrdQuestionByKey(
        final UUID suplrEvalSccrdQuestionUUID )
    {
        return new SuplrEvalSccrdQuestionByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalSccrdQuestion",
            suplrEvalSccrdQuestionUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdSectionFluentHelper getAllSuplrEvalSccrdSection()
    {
        return new SuplrEvalSccrdSectionFluentHelper(servicePath, "A_SuplrEvalSccrdSection");
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdSectionByKeyFluentHelper getSuplrEvalSccrdSectionByKey( final UUID suplrEvalSccrdSectionUUID )
    {
        return new SuplrEvalSccrdSectionByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalSccrdSection",
            suplrEvalSccrdSectionUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdStrucQnaireFluentHelper getAllSuplrEvalSccrdStrucQnaire()
    {
        return new SuplrEvalSccrdStrucQnaireFluentHelper(servicePath, "A_SuplrEvalSccrdStrucQnaire");
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdStrucQnaireByKeyFluentHelper getSuplrEvalSccrdStrucQnaireByKey(
        final UUID suplrEvalScorecardQnaireUUID )
    {
        return new SuplrEvalSccrdStrucQnaireByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalSccrdStrucQnaire",
            suplrEvalScorecardQnaireUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdSupplierFluentHelper getAllSuplrEvalSccrdSupplier()
    {
        return new SuplrEvalSccrdSupplierFluentHelper(servicePath, "A_SuplrEvalSccrdSupplier");
    }

    @Override
    @Nonnull
    public SuplrEvalSccrdSupplierByKeyFluentHelper getSuplrEvalSccrdSupplierByKey(
        final UUID suplrEvalScorecardPtyUUID )
    {
        return new SuplrEvalSccrdSupplierByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalSccrdSupplier",
            suplrEvalScorecardPtyUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalScorecardFluentHelper getAllSuplrEvalScorecard()
    {
        return new SuplrEvalScorecardFluentHelper(servicePath, "A_SuplrEvalScorecard");
    }

    @Override
    @Nonnull
    public SuplrEvalScorecardByKeyFluentHelper getSuplrEvalScorecardByKey( final UUID suplrEvalScorecardUUID )
    {
        return new SuplrEvalScorecardByKeyFluentHelper(servicePath, "A_SuplrEvalScorecard", suplrEvalScorecardUUID);
    }

    @Override
    @Nonnull
    public SuplrEvalScorecardRootQnaireFluentHelper getAllSuplrEvalScorecardRootQnaire()
    {
        return new SuplrEvalScorecardRootQnaireFluentHelper(servicePath, "A_SuplrEvalScorecardRootQnaire");
    }

    @Override
    @Nonnull
    public SuplrEvalScorecardRootQnaireByKeyFluentHelper getSuplrEvalScorecardRootQnaireByKey(
        final UUID suplrEvalScorecardQnaireUUID )
    {
        return new SuplrEvalScorecardRootQnaireByKeyFluentHelper(
            servicePath,
            "A_SuplrEvalScorecardRootQnaire",
            suplrEvalScorecardQnaireUUID);
    }

}
