/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.PostFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.ReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRefByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRefFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLeanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcctByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcctFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.batch.DefaultSupplierInvoiceIntegrationServiceBatch;

/**
 * <p>
 * This service enables you to create supplier invoices through an API call from a source system outside SAP S/4HANA
 * Cloud. Furthermore the service enables you to read, release, reverse and post existing supplier invoices from the SAP
 * S/4HANA Cloud system. The service is based on the OData protocol.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/7b/c52558ef790a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPPLIERINVOICE_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPPLIERINVOICE_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Invoice Integration(SAP_COM_0057)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Invoice</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSupplierInvoiceIntegrationService" )
@Deprecated
public class DefaultSupplierInvoiceIntegrationService implements SupplierInvoiceIntegrationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SupplierInvoiceIntegrationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSupplierInvoiceIntegrationService()
    {
        servicePath = SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSupplierInvoiceIntegrationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierInvoiceIntegrationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSupplierInvoiceIntegrationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSupplierInvoiceIntegrationServiceBatch batch()
    {
        return new DefaultSupplierInvoiceIntegrationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SuplrInvcHeaderWhldgTaxFluentHelper getAllSuplrInvcHeaderWhldgTax()
    {
        return new SuplrInvcHeaderWhldgTaxFluentHelper(servicePath, "A_SuplrInvcHeaderWhldgTax");
    }

    @Override
    @Nonnull
    public SuplrInvcHeaderWhldgTaxByKeyFluentHelper getSuplrInvcHeaderWhldgTaxByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String withholdingTaxType )
    {
        return new SuplrInvcHeaderWhldgTaxByKeyFluentHelper(
            servicePath,
            "A_SuplrInvcHeaderWhldgTax",
            supplierInvoice,
            fiscalYear,
            withholdingTaxType);
    }

    @Override
    @Nonnull
    public SuplrInvcItemAcctAssgmtFluentHelper getAllSuplrInvcItemAcctAssgmt()
    {
        return new SuplrInvcItemAcctAssgmtFluentHelper(servicePath, "A_SuplrInvcItemAcctAssgmt");
    }

    @Override
    @Nonnull
    public SuplrInvcItemAcctAssgmtByKeyFluentHelper getSuplrInvcItemAcctAssgmtByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String supplierInvoiceItem,
        final String ordinalNumber )
    {
        return new SuplrInvcItemAcctAssgmtByKeyFluentHelper(
            servicePath,
            "A_SuplrInvcItemAcctAssgmt",
            supplierInvoice,
            fiscalYear,
            supplierInvoiceItem,
            ordinalNumber);
    }

    @Override
    @Nonnull
    public SuplrInvcItemPurOrdRefFluentHelper getAllSuplrInvcItemPurOrdRef()
    {
        return new SuplrInvcItemPurOrdRefFluentHelper(servicePath, "A_SuplrInvcItemPurOrdRef");
    }

    @Override
    @Nonnull
    public SuplrInvcItemPurOrdRefByKeyFluentHelper getSuplrInvcItemPurOrdRefByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String supplierInvoiceItem )
    {
        return new SuplrInvcItemPurOrdRefByKeyFluentHelper(
            servicePath,
            "A_SuplrInvcItemPurOrdRef",
            supplierInvoice,
            fiscalYear,
            supplierInvoiceItem);
    }

    @Override
    @Nonnull
    public SuplrInvcSeldInbDeliveryNoteFluentHelper getAllSuplrInvcSeldInbDeliveryNote()
    {
        return new SuplrInvcSeldInbDeliveryNoteFluentHelper(servicePath, "A_SuplrInvcSeldInbDeliveryNote");
    }

    @Override
    @Nonnull
    public SuplrInvcSeldInbDeliveryNoteByKeyFluentHelper getSuplrInvcSeldInbDeliveryNoteByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String inboundDeliveryNote )
    {
        return new SuplrInvcSeldInbDeliveryNoteByKeyFluentHelper(
            servicePath,
            "A_SuplrInvcSeldInbDeliveryNote",
            supplierInvoice,
            fiscalYear,
            inboundDeliveryNote);
    }

    @Override
    @Nonnull
    public SuplrInvcSeldPurgDocumentFluentHelper getAllSuplrInvcSeldPurgDocument()
    {
        return new SuplrInvcSeldPurgDocumentFluentHelper(servicePath, "A_SuplrInvcSeldPurgDocument");
    }

    @Override
    @Nonnull
    public SuplrInvcSeldPurgDocumentByKeyFluentHelper getSuplrInvcSeldPurgDocumentByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String purchaseOrder,
        final String purchaseOrderItem )
    {
        return new SuplrInvcSeldPurgDocumentByKeyFluentHelper(
            servicePath,
            "A_SuplrInvcSeldPurgDocument",
            supplierInvoice,
            fiscalYear,
            purchaseOrder,
            purchaseOrderItem);
    }

    @Override
    @Nonnull
    public SuplrInvcSeldSrvcEntrShtLeanFluentHelper getAllSuplrInvcSeldSrvcEntrShtLean()
    {
        return new SuplrInvcSeldSrvcEntrShtLeanFluentHelper(servicePath, "A_SuplrInvcSeldSrvcEntrShtLean");
    }

    @Override
    @Nonnull
    public SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper getSuplrInvcSeldSrvcEntrShtLeanByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String serviceEntrySheet,
        final String serviceEntrySheetItem )
    {
        return new SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper(
            servicePath,
            "A_SuplrInvcSeldSrvcEntrShtLean",
            supplierInvoice,
            fiscalYear,
            serviceEntrySheet,
            serviceEntrySheetItem);
    }

    @Override
    @Nonnull
    public SuplrInvoiceAdditionalDataFluentHelper getAllSuplrInvoiceAdditionalData()
    {
        return new SuplrInvoiceAdditionalDataFluentHelper(servicePath, "A_SuplrInvoiceAdditionalData");
    }

    @Override
    @Nonnull
    public
        SuplrInvoiceAdditionalDataByKeyFluentHelper
        getSuplrInvoiceAdditionalDataByKey( final String supplierInvoice, final String fiscalYear )
    {
        return new SuplrInvoiceAdditionalDataByKeyFluentHelper(
            servicePath,
            "A_SuplrInvoiceAdditionalData",
            supplierInvoice,
            fiscalYear);
    }

    @Override
    @Nonnull
    public SupplierInvoiceFluentHelper getAllSupplierInvoice()
    {
        return new SupplierInvoiceFluentHelper(servicePath, "A_SupplierInvoice");
    }

    @Override
    @Nonnull
    public
        SupplierInvoiceByKeyFluentHelper
        getSupplierInvoiceByKey( final String supplierInvoice, final String fiscalYear )
    {
        return new SupplierInvoiceByKeyFluentHelper(servicePath, "A_SupplierInvoice", supplierInvoice, fiscalYear);
    }

    @Override
    @Nonnull
    public SupplierInvoiceCreateFluentHelper createSupplierInvoice( @Nonnull final SupplierInvoice supplierInvoice )
    {
        return new SupplierInvoiceCreateFluentHelper(servicePath, supplierInvoice, "A_SupplierInvoice");
    }

    @Override
    @Nonnull
    public SupplierInvoiceDeleteFluentHelper deleteSupplierInvoice( @Nonnull final SupplierInvoice supplierInvoice )
    {
        return new SupplierInvoiceDeleteFluentHelper(servicePath, supplierInvoice, "A_SupplierInvoice");
    }

    @Override
    @Nonnull
    public SupplierInvoiceItemGLAcctFluentHelper getAllSupplierInvoiceItemGLAcct()
    {
        return new SupplierInvoiceItemGLAcctFluentHelper(servicePath, "A_SupplierInvoiceItemGLAcct");
    }

    @Override
    @Nonnull
    public SupplierInvoiceItemGLAcctByKeyFluentHelper getSupplierInvoiceItemGLAcctByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String supplierInvoiceItem )
    {
        return new SupplierInvoiceItemGLAcctByKeyFluentHelper(
            servicePath,
            "A_SupplierInvoiceItemGLAcct",
            supplierInvoice,
            fiscalYear,
            supplierInvoiceItem);
    }

    @Override
    @Nonnull
    public SupplierInvoiceTaxFluentHelper getAllSupplierInvoiceTax()
    {
        return new SupplierInvoiceTaxFluentHelper(servicePath, "A_SupplierInvoiceTax");
    }

    @Override
    @Nonnull
    public SupplierInvoiceTaxByKeyFluentHelper getSupplierInvoiceTaxByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String taxCode,
        final String supplierInvoiceTaxCounter )
    {
        return new SupplierInvoiceTaxByKeyFluentHelper(
            servicePath,
            "A_SupplierInvoiceTax",
            supplierInvoice,
            fiscalYear,
            taxCode,
            supplierInvoiceTaxCounter);
    }

    @Override
    @Nonnull
    public PostFluentHelper post( @Nonnull final String supplierInvoice, @Nonnull final String fiscalYear )
    {
        return new PostFluentHelper(servicePath, supplierInvoice, fiscalYear);
    }

    @Override
    @Nonnull
    public ReleaseFluentHelper release(
        @Nonnull final Boolean discountDaysHaveToBeShifted,
        @Nonnull final String fiscalYear,
        @Nonnull final String supplierInvoice )
    {
        return new ReleaseFluentHelper(servicePath, discountDaysHaveToBeShifted, fiscalYear, supplierInvoice);
    }

    @Override
    @Nonnull
    public CancelFluentHelper cancel(
        @Nonnull final String supplierInvoice,
        @Nonnull final String fiscalYear,
        @Nonnull final String reversalReason,
        @Nonnull final LocalDateTime postingDate )
    {
        return new CancelFluentHelper(servicePath, supplierInvoice, fiscalYear, reversalReason, postingDate);
    }

}
