/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CreateFromRFQFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SubmitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SubmitForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.batch.DefaultSupplierQuotationServiceBatch;

/**
 * <p>
 *
 * This service enables you to read, update and create supplier quotations with reference to an RFQ from or in the SAP
 * S/4HANA Cloud system. The service contains header, item, and bidder nodes. The information is sent in the request as
 * a payload. Once the supplier quotation has been successfully created, the supplier quotation number is sent in the
 * response with the data included in the supplier quotation. If any issues arise when the supplier quotation is
 * created, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/87/a40bc9b4db43d89fcbb6e10dd152fe/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_QTN_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_QTN_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Distributed Manufacturing Integration(SAP_COM_0077), Purchase Request for Quotation
 * Integration(SAP_COM_0113)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1A0'>Sourcing with SAP Ariba Sourcing(1A0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1L2'>Supplier Quote Automation with SAP Ariba Commerce
 * Automation(1L2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1XF'>Request for Price(1XF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OA0'>Sourcing with SAP Ariba Sourcing(OA0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXF'>Request for Price(OXF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Quotation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSupplierQuotationService" )
@Deprecated
public class DefaultSupplierQuotationService implements SupplierQuotationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SupplierQuotationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSupplierQuotationService()
    {
        servicePath = SupplierQuotationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSupplierQuotationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierQuotationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSupplierQuotationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSupplierQuotationServiceBatch batch()
    {
        return new DefaultSupplierQuotationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SupplierQuotationFluentHelper getAllSupplierQuotation()
    {
        return new SupplierQuotationFluentHelper(servicePath, "A_SupplierQuotation");
    }

    @Override
    @Nonnull
    public SupplierQuotationByKeyFluentHelper getSupplierQuotationByKey( final String supplierQuotation )
    {
        return new SupplierQuotationByKeyFluentHelper(servicePath, "A_SupplierQuotation", supplierQuotation);
    }

    @Override
    @Nonnull
    public SupplierQuotationCreateFluentHelper createSupplierQuotation(
        @Nonnull final SupplierQuotation supplierQuotation )
    {
        return new SupplierQuotationCreateFluentHelper(servicePath, supplierQuotation, "A_SupplierQuotation");
    }

    @Override
    @Nonnull
    public SupplierQuotationUpdateFluentHelper updateSupplierQuotation(
        @Nonnull final SupplierQuotation supplierQuotation )
    {
        return new SupplierQuotationUpdateFluentHelper(servicePath, supplierQuotation, "A_SupplierQuotation");
    }

    @Override
    @Nonnull
    public SupplierQuotationDeleteFluentHelper deleteSupplierQuotation(
        @Nonnull final SupplierQuotation supplierQuotation )
    {
        return new SupplierQuotationDeleteFluentHelper(servicePath, supplierQuotation, "A_SupplierQuotation");
    }

    @Override
    @Nonnull
    public SupplierQuotationItemFluentHelper getAllSupplierQuotationItem()
    {
        return new SupplierQuotationItemFluentHelper(servicePath, "A_SupplierQuotationItem");
    }

    @Override
    @Nonnull
    public
        SupplierQuotationItemByKeyFluentHelper
        getSupplierQuotationItemByKey( final String supplierQuotation, final String supplierQuotationItem )
    {
        return new SupplierQuotationItemByKeyFluentHelper(
            servicePath,
            "A_SupplierQuotationItem",
            supplierQuotation,
            supplierQuotationItem);
    }

    @Override
    @Nonnull
    public SupplierQuotationItemUpdateFluentHelper updateSupplierQuotationItem(
        @Nonnull final SupplierQuotationItem supplierQuotationItem )
    {
        return new SupplierQuotationItemUpdateFluentHelper(
            servicePath,
            supplierQuotationItem,
            "A_SupplierQuotationItem");
    }

    @Override
    @Nonnull
    public SubmitFluentHelper submit( @Nonnull final String supplierQuotation )
    {
        return new SubmitFluentHelper(servicePath, supplierQuotation);
    }

    @Override
    @Nonnull
    public CompleteFluentHelper complete( @Nonnull final String supplierQuotation )
    {
        return new CompleteFluentHelper(servicePath, supplierQuotation);
    }

    @Override
    @Nonnull
    public CancelFluentHelper cancel( @Nonnull final String supplierQuotation )
    {
        return new CancelFluentHelper(servicePath, supplierQuotation);
    }

    @Override
    @Nonnull
    public SubmitForApprovalFluentHelper submitForApproval( @Nonnull final String supplierQuotation )
    {
        return new SubmitForApprovalFluentHelper(servicePath, supplierQuotation);
    }

    @Override
    @Nonnull
    public CreateFromRFQFluentHelper createFromRFQ(
        @Nonnull final LocalDateTime quotationSubmissionDate,
        @Nonnull final String supplier,
        @Nonnull final String requestForQuotation )
    {
        return new CreateFromRFQFluentHelper(servicePath, quotationSubmissionDate, supplier, requestForQuotation);
    }

}
