/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.PartnerCompanyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.PartnerCompanyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.batch.DefaultTradingPartnerServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve trading partners and their texts..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c2/2cde3a85c94d8d985a4d9886d2913b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PARTNERCOMPANY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PARTNERCOMPANY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Company Code</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultTradingPartnerService" )
@Deprecated
public class DefaultTradingPartnerService implements TradingPartnerService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link TradingPartnerService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultTradingPartnerService()
    {
        servicePath = TradingPartnerService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultTradingPartnerService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultTradingPartnerService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultTradingPartnerService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultTradingPartnerServiceBatch batch()
    {
        return new DefaultTradingPartnerServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PartnerCompanyFluentHelper getAllPartnerCompany()
    {
        return new PartnerCompanyFluentHelper(servicePath, "A_PartnerCompany");
    }

    @Override
    @Nonnull
    public PartnerCompanyByKeyFluentHelper getPartnerCompanyByKey( final String partnerCompany )
    {
        return new PartnerCompanyByKeyFluentHelper(servicePath, "A_PartnerCompany", partnerCompany);
    }

}
