/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.batch.DefaultTransactionDataForGroupReportingServiceBatch;

/**
 * <p>
 *
 * This service selects transaction data that is included in SAP S/4HANA Cloud for group reporting, such as reported
 * financial data or consolidated financial data. With this service you can retrieve consolidated data including
 * intercompany elimination and consolidation entries..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/87/fde46ffd0742639ef0a9d7c5631a5a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GRTRANSACTIONDATA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GRTRANSACTIONDATA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Cloud Consolidation Data Collection Integration(SAP_COM_0241), Finance - Cloud Consolidation
 * Transaction Data for Group Reporting Integration(SAP_COM_0348), Finance - Group Reporting Planning
 * Integration(SAP_COM_0370)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2U6'>Group Reporting - Data from External
 * Systems(2U6)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Consolidation Group Journal Entry</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultTransactionDataForGroupReportingService" )
@Deprecated
public class DefaultTransactionDataForGroupReportingService implements TransactionDataForGroupReportingService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link TransactionDataForGroupReportingService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultTransactionDataForGroupReportingService()
    {
        servicePath = TransactionDataForGroupReportingService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultTransactionDataForGroupReportingService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultTransactionDataForGroupReportingService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultTransactionDataForGroupReportingService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultTransactionDataForGroupReportingServiceBatch batch()
    {
        return new DefaultTransactionDataForGroupReportingServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public GRTransactionDataParametersByKeyFluentHelper getGRTransactionDataParametersByKey(
        final String p_ConsolidationUnitHierId,
        final String p_ConsolidationPrftCtrHierId,
        final String p_ConsolidationSegmentHierId,
        final LocalDateTime p_KeyDate )
    {
        return new GRTransactionDataParametersByKeyFluentHelper(
            servicePath,
            "GRTransactionData",
            p_ConsolidationUnitHierId,
            p_ConsolidationPrftCtrHierId,
            p_ConsolidationSegmentHierId,
            p_KeyDate);
    }

}
