/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.batch.DefaultTreasuryPositionFlowServiceBatch;

/**
 * <p>
 * You can use this inbound service to read treasury position flows. The treasury position is the most detailed level in
 * which you can break down the balance sheet accounts in the Treasury and Risk Management ledger. The treasury position
 * flows are generated by the operative or derived business transactions to update the position components of the
 * treasury positions. The service provides you with detailed information about each selected treasury position flow,
 * such as amount, currency, dates, differentiation criteria of the affected treasury position, business transaction,
 * and update type.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fd/bdf48471784561a68d2a23d474650d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_TRSYPOSFLOW_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_TRSYPOSFLOW_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Treasury Position Flow Integration(SAP_COM_0332)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XN'>Market Rates Management - Manually via Upload(1XN)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXN'>Market Data for Treasury and Risk Management(OXN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>TreasuryLedgerPositionFlowList</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultTreasuryPositionFlowService" )
@Deprecated
public class DefaultTreasuryPositionFlowService implements TreasuryPositionFlowService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link TreasuryPositionFlowService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultTreasuryPositionFlowService()
    {
        servicePath = TreasuryPositionFlowService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultTreasuryPositionFlowService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultTreasuryPositionFlowService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultTreasuryPositionFlowService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultTreasuryPositionFlowServiceBatch batch()
    {
        return new DefaultTreasuryPositionFlowServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public TrsyPosFlowFluentHelper getAllTrsyPosFlow()
    {
        return new TrsyPosFlowFluentHelper(servicePath, "A_TrsyPosFlow");
    }

    @Override
    @Nonnull
    public
        TrsyPosFlowByKeyFluentHelper
        getTrsyPosFlowByKey( final Integer treasuryTransactionFlow, final UUID businessTransactionDocUUID )
    {
        return new TrsyPosFlowByKeyFluentHelper(
            servicePath,
            "A_TrsyPosFlow",
            treasuryTransactionFlow,
            businessTransactionDocUUID);
    }

}
