/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonthByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonthFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonthByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonthFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYearByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYearFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannelByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FundByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FundFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManagedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManagedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversalByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettledByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettledFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LedgerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LedgerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompletedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompletedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcernByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcernFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFundByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFundFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKeyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetworkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetworkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncompleteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganizationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganizationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.batch.DefaultTrialBalanceServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve starting, credit and debit balances for G/L accounts per fiscal year period.
 *
 * You can read data for period-based balances. You cannot read data for day-based balances.
 *
 * You need to provide the time frame for the selection in a date format and you need to provide the level of
 * aggregation in a $select clause..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/61/ab22d2f6da49a394004e459947e994/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/C_TRIALBALANCE_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>C_TRIALBALANCE_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Accounting Analytics Integration(SAP_COM_0303)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J58'>Accounting and Financial Close(J58)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O58'>Accounting and Financial Close(O58)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>General Ledger Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultTrialBalanceService" )
@Deprecated
public class DefaultTrialBalanceService implements TrialBalanceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link TrialBalanceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultTrialBalanceService()
    {
        servicePath = TrialBalanceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultTrialBalanceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultTrialBalanceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultTrialBalanceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultTrialBalanceServiceBatch batch()
    {
        return new DefaultTrialBalanceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LedgerFluentHelper getAllLedger()
    {
        return new LedgerFluentHelper(servicePath, "Ledger");
    }

    @Override
    @Nonnull
    public LedgerByKeyFluentHelper getLedgerByKey( final String ledger )
    {
        return new LedgerByKeyFluentHelper(servicePath, "Ledger", ledger);
    }

    @Override
    @Nonnull
    public CompanyCodeFluentHelper getAllCompanyCode()
    {
        return new CompanyCodeFluentHelper(servicePath, "CompanyCode");
    }

    @Override
    @Nonnull
    public CompanyCodeByKeyFluentHelper getCompanyCodeByKey( final String companyCode )
    {
        return new CompanyCodeByKeyFluentHelper(servicePath, "CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    public GLAccountFluentHelper getAllGLAccount()
    {
        return new GLAccountFluentHelper(servicePath, "GLAccount");
    }

    @Override
    @Nonnull
    public GLAccountByKeyFluentHelper getGLAccountByKey( final String gLAccount )
    {
        return new GLAccountByKeyFluentHelper(servicePath, "GLAccount", gLAccount);
    }

    @Override
    @Nonnull
    public OrderIDFluentHelper getAllOrderID()
    {
        return new OrderIDFluentHelper(servicePath, "OrderID");
    }

    @Override
    @Nonnull
    public OrderIDByKeyFluentHelper getOrderIDByKey( final String orderID )
    {
        return new OrderIDByKeyFluentHelper(servicePath, "OrderID", orderID);
    }

    @Override
    @Nonnull
    public ProjectNetworkFluentHelper getAllProjectNetwork()
    {
        return new ProjectNetworkFluentHelper(servicePath, "ProjectNetwork");
    }

    @Override
    @Nonnull
    public ProjectNetworkByKeyFluentHelper getProjectNetworkByKey( final String projectNetwork )
    {
        return new ProjectNetworkByKeyFluentHelper(servicePath, "ProjectNetwork", projectNetwork);
    }

    @Override
    @Nonnull
    public ProjectFluentHelper getAllProject()
    {
        return new ProjectFluentHelper(servicePath, "Project");
    }

    @Override
    @Nonnull
    public ProjectByKeyFluentHelper getProjectByKey( final String project )
    {
        return new ProjectByKeyFluentHelper(servicePath, "Project", project);
    }

    @Override
    @Nonnull
    public BusinessProcessFluentHelper getAllBusinessProcess()
    {
        return new BusinessProcessFluentHelper(servicePath, "BusinessProcess");
    }

    @Override
    @Nonnull
    public BusinessProcessByKeyFluentHelper getBusinessProcessByKey( final String businessProcess )
    {
        return new BusinessProcessByKeyFluentHelper(servicePath, "BusinessProcess", businessProcess);
    }

    @Override
    @Nonnull
    public BillingDocumentFluentHelper getAllBillingDocument()
    {
        return new BillingDocumentFluentHelper(servicePath, "BillingDocumentType");
    }

    @Override
    @Nonnull
    public BillingDocumentByKeyFluentHelper getBillingDocumentByKey( final String billingDocumentType )
    {
        return new BillingDocumentByKeyFluentHelper(servicePath, "BillingDocumentType", billingDocumentType);
    }

    @Override
    @Nonnull
    public SalesOrganizationFluentHelper getAllSalesOrganization()
    {
        return new SalesOrganizationFluentHelper(servicePath, "SalesOrganization");
    }

    @Override
    @Nonnull
    public SalesOrganizationByKeyFluentHelper getSalesOrganizationByKey( final String salesOrganization )
    {
        return new SalesOrganizationByKeyFluentHelper(servicePath, "SalesOrganization", salesOrganization);
    }

    @Override
    @Nonnull
    public DistributionChannelFluentHelper getAllDistributionChannel()
    {
        return new DistributionChannelFluentHelper(servicePath, "DistributionChannel");
    }

    @Override
    @Nonnull
    public DistributionChannelByKeyFluentHelper getDistributionChannelByKey( final String distributionChannel )
    {
        return new DistributionChannelByKeyFluentHelper(servicePath, "DistributionChannel", distributionChannel);
    }

    @Override
    @Nonnull
    public SoldProductFluentHelper getAllSoldProduct()
    {
        return new SoldProductFluentHelper(servicePath, "SoldProduct");
    }

    @Override
    @Nonnull
    public SoldProductByKeyFluentHelper getSoldProductByKey( final String soldProduct )
    {
        return new SoldProductByKeyFluentHelper(servicePath, "SoldProduct", soldProduct);
    }

    @Override
    @Nonnull
    public PartnerCompanyFluentHelper getAllPartnerCompany()
    {
        return new PartnerCompanyFluentHelper(servicePath, "PartnerCompany");
    }

    @Override
    @Nonnull
    public PartnerCompanyByKeyFluentHelper getPartnerCompanyByKey( final String partnerCompany )
    {
        return new PartnerCompanyByKeyFluentHelper(servicePath, "PartnerCompany", partnerCompany);
    }

    @Override
    @Nonnull
    public PartnerOrderFluentHelper getAllPartnerOrder()
    {
        return new PartnerOrderFluentHelper(servicePath, "PartnerOrder");
    }

    @Override
    @Nonnull
    public PartnerOrderByKeyFluentHelper getPartnerOrderByKey( final String partnerOrder )
    {
        return new PartnerOrderByKeyFluentHelper(servicePath, "PartnerOrder", partnerOrder);
    }

    @Override
    @Nonnull
    public PartnerWBSElementFluentHelper getAllPartnerWBSElement()
    {
        return new PartnerWBSElementFluentHelper(servicePath, "PartnerWBSElement");
    }

    @Override
    @Nonnull
    public PartnerWBSElementByKeyFluentHelper getPartnerWBSElementByKey( final String partnerWBSElement )
    {
        return new PartnerWBSElementByKeyFluentHelper(servicePath, "PartnerWBSElement", partnerWBSElement);
    }

    @Override
    @Nonnull
    public PartnerProjectFluentHelper getAllPartnerProject()
    {
        return new PartnerProjectFluentHelper(servicePath, "PartnerProject");
    }

    @Override
    @Nonnull
    public PartnerProjectByKeyFluentHelper getPartnerProjectByKey( final String partnerProject )
    {
        return new PartnerProjectByKeyFluentHelper(servicePath, "PartnerProject", partnerProject);
    }

    @Override
    @Nonnull
    public PartnerSalesDocumentFluentHelper getAllPartnerSalesDocument()
    {
        return new PartnerSalesDocumentFluentHelper(servicePath, "PartnerSalesDocument");
    }

    @Override
    @Nonnull
    public PartnerSalesDocumentByKeyFluentHelper getPartnerSalesDocumentByKey( final String partnerSalesDocument )
    {
        return new PartnerSalesDocumentByKeyFluentHelper(servicePath, "PartnerSalesDocument", partnerSalesDocument);
    }

    @Override
    @Nonnull
    public PartnerBusinessProcessFluentHelper getAllPartnerBusinessProcess()
    {
        return new PartnerBusinessProcessFluentHelper(servicePath, "PartnerBusinessProcess");
    }

    @Override
    @Nonnull
    public PartnerBusinessProcessByKeyFluentHelper getPartnerBusinessProcessByKey( final String partnerBusinessProcess )
    {
        return new PartnerBusinessProcessByKeyFluentHelper(
            servicePath,
            "PartnerBusinessProcess",
            partnerBusinessProcess);
    }

    @Override
    @Nonnull
    public FinancialManagementAreaFluentHelper getAllFinancialManagementArea()
    {
        return new FinancialManagementAreaFluentHelper(servicePath, "FinancialManagementArea");
    }

    @Override
    @Nonnull
    public FinancialManagementAreaByKeyFluentHelper getFinancialManagementAreaByKey(
        final String financialManagementArea )
    {
        return new FinancialManagementAreaByKeyFluentHelper(
            servicePath,
            "FinancialManagementArea",
            financialManagementArea);
    }

    @Override
    @Nonnull
    public FundFluentHelper getAllFund()
    {
        return new FundFluentHelper(servicePath, "Fund");
    }

    @Override
    @Nonnull
    public FundByKeyFluentHelper getFundByKey( final String fund )
    {
        return new FundByKeyFluentHelper(servicePath, "Fund", fund);
    }

    @Override
    @Nonnull
    public GrantIDFluentHelper getAllGrantID()
    {
        return new GrantIDFluentHelper(servicePath, "GrantID");
    }

    @Override
    @Nonnull
    public GrantIDByKeyFluentHelper getGrantIDByKey( final String grantID )
    {
        return new GrantIDByKeyFluentHelper(servicePath, "GrantID", grantID);
    }

    @Override
    @Nonnull
    public BudgetPeriodFluentHelper getAllBudgetPeriod()
    {
        return new BudgetPeriodFluentHelper(servicePath, "BudgetPeriod");
    }

    @Override
    @Nonnull
    public BudgetPeriodByKeyFluentHelper getBudgetPeriodByKey( final String budgetPeriod )
    {
        return new BudgetPeriodByKeyFluentHelper(servicePath, "BudgetPeriod", budgetPeriod);
    }

    @Override
    @Nonnull
    public PartnerFundFluentHelper getAllPartnerFund()
    {
        return new PartnerFundFluentHelper(servicePath, "PartnerFund");
    }

    @Override
    @Nonnull
    public PartnerFundByKeyFluentHelper getPartnerFundByKey( final String partnerFund )
    {
        return new PartnerFundByKeyFluentHelper(servicePath, "PartnerFund", partnerFund);
    }

    @Override
    @Nonnull
    public PartnerGrantFluentHelper getAllPartnerGrant()
    {
        return new PartnerGrantFluentHelper(servicePath, "PartnerGrant");
    }

    @Override
    @Nonnull
    public PartnerGrantByKeyFluentHelper getPartnerGrantByKey( final String partnerGrant )
    {
        return new PartnerGrantByKeyFluentHelper(servicePath, "PartnerGrant", partnerGrant);
    }

    @Override
    @Nonnull
    public PartnerBudgetPeriodFluentHelper getAllPartnerBudgetPeriod()
    {
        return new PartnerBudgetPeriodFluentHelper(servicePath, "PartnerBudgetPeriod");
    }

    @Override
    @Nonnull
    public PartnerBudgetPeriodByKeyFluentHelper getPartnerBudgetPeriodByKey( final String partnerBudgetPeriod )
    {
        return new PartnerBudgetPeriodByKeyFluentHelper(servicePath, "PartnerBudgetPeriod", partnerBudgetPeriod);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency8FluentHelper getAllFreeDefinedCurrency8()
    {
        return new FreeDefinedCurrency8FluentHelper(servicePath, "FreeDefinedCurrency8");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency8ByKeyFluentHelper getFreeDefinedCurrency8ByKey( final String freeDefinedCurrency8_ID )
    {
        return new FreeDefinedCurrency8ByKeyFluentHelper(servicePath, "FreeDefinedCurrency8", freeDefinedCurrency8_ID);
    }

    @Override
    @Nonnull
    public QuantityIsIncompleteFluentHelper getAllQuantityIsIncomplete()
    {
        return new QuantityIsIncompleteFluentHelper(servicePath, "QuantityIsIncomplete");
    }

    @Override
    @Nonnull
    public QuantityIsIncompleteByKeyFluentHelper getQuantityIsIncompleteByKey( final String quantityIsIncomplete_ID )
    {
        return new QuantityIsIncompleteByKeyFluentHelper(servicePath, "QuantityIsIncomplete", quantityIsIncomplete_ID);
    }

    @Override
    @Nonnull
    public IsOpenItemManagedFluentHelper getAllIsOpenItemManaged()
    {
        return new IsOpenItemManagedFluentHelper(servicePath, "IsOpenItemManaged");
    }

    @Override
    @Nonnull
    public IsOpenItemManagedByKeyFluentHelper getIsOpenItemManagedByKey( final String isOpenItemManaged_ID )
    {
        return new IsOpenItemManagedByKeyFluentHelper(servicePath, "IsOpenItemManaged", isOpenItemManaged_ID);
    }

    @Override
    @Nonnull
    public CorporateGroupAccountFluentHelper getAllCorporateGroupAccount()
    {
        return new CorporateGroupAccountFluentHelper(servicePath, "CorporateGroupAccount");
    }

    @Override
    @Nonnull
    public CorporateGroupAccountByKeyFluentHelper getCorporateGroupAccountByKey(
        final String corporateGroupAccount_ID,
        final String corporateGroupChartOfAccounts )
    {
        return new CorporateGroupAccountByKeyFluentHelper(
            servicePath,
            "CorporateGroupAccount",
            corporateGroupAccount_ID,
            corporateGroupChartOfAccounts);
    }

    @Override
    @Nonnull
    public CorporateGroupChartOfAccountsFluentHelper getAllCorporateGroupChartOfAccounts()
    {
        return new CorporateGroupChartOfAccountsFluentHelper(servicePath, "CorporateGroupChartOfAccounts");
    }

    @Override
    @Nonnull
    public CorporateGroupChartOfAccountsByKeyFluentHelper getCorporateGroupChartOfAccountsByKey(
        final String corporateGroupChartOfAccounts_ID )
    {
        return new CorporateGroupChartOfAccountsByKeyFluentHelper(
            servicePath,
            "CorporateGroupChartOfAccounts",
            corporateGroupChartOfAccounts_ID);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency2FluentHelper getAllFreeDefinedCurrency2()
    {
        return new FreeDefinedCurrency2FluentHelper(servicePath, "FreeDefinedCurrency2");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency2ByKeyFluentHelper getFreeDefinedCurrency2ByKey( final String freeDefinedCurrency2_ID )
    {
        return new FreeDefinedCurrency2ByKeyFluentHelper(servicePath, "FreeDefinedCurrency2", freeDefinedCurrency2_ID);
    }

    @Override
    @Nonnull
    public PartnerProfitCenterFluentHelper getAllPartnerProfitCenter()
    {
        return new PartnerProfitCenterFluentHelper(servicePath, "PartnerProfitCenter");
    }

    @Override
    @Nonnull
    public
        PartnerProfitCenterByKeyFluentHelper
        getPartnerProfitCenterByKey( final String partnerProfitCenter_ID, final String controllingArea )
    {
        return new PartnerProfitCenterByKeyFluentHelper(
            servicePath,
            "PartnerProfitCenter",
            partnerProfitCenter_ID,
            controllingArea);
    }

    @Override
    @Nonnull
    public PartnerControllingObjectClassFluentHelper getAllPartnerControllingObjectClass()
    {
        return new PartnerControllingObjectClassFluentHelper(servicePath, "PartnerControllingObjectClass");
    }

    @Override
    @Nonnull
    public PartnerControllingObjectClassByKeyFluentHelper getPartnerControllingObjectClassByKey(
        final String partnerControllingObjectClass_ID )
    {
        return new PartnerControllingObjectClassByKeyFluentHelper(
            servicePath,
            "PartnerControllingObjectClass",
            partnerControllingObjectClass_ID);
    }

    @Override
    @Nonnull
    public GLAccount_2FluentHelper getAllGLAccount_2()
    {
        return new GLAccount_2FluentHelper(servicePath, "GLAccountType");
    }

    @Override
    @Nonnull
    public GLAccount_2ByKeyFluentHelper getGLAccount_2ByKey( final String gLAccountType_ID )
    {
        return new GLAccount_2ByKeyFluentHelper(servicePath, "GLAccountType", gLAccountType_ID);
    }

    @Override
    @Nonnull
    public AccountingDocumentCategoryFluentHelper getAllAccountingDocumentCategory()
    {
        return new AccountingDocumentCategoryFluentHelper(servicePath, "AccountingDocumentCategory");
    }

    @Override
    @Nonnull
    public AccountingDocumentCategoryByKeyFluentHelper getAccountingDocumentCategoryByKey(
        final String accountingDocumentCategory_ID )
    {
        return new AccountingDocumentCategoryByKeyFluentHelper(
            servicePath,
            "AccountingDocumentCategory",
            accountingDocumentCategory_ID);
    }

    @Override
    @Nonnull
    public BusinessTransactionFluentHelper getAllBusinessTransaction()
    {
        return new BusinessTransactionFluentHelper(servicePath, "BusinessTransactionType");
    }

    @Override
    @Nonnull
    public BusinessTransactionByKeyFluentHelper getBusinessTransactionByKey( final String businessTransactionType_ID )
    {
        return new BusinessTransactionByKeyFluentHelper(
            servicePath,
            "BusinessTransactionType",
            businessTransactionType_ID);
    }

    @Override
    @Nonnull
    public CalendarMonthFluentHelper getAllCalendarMonth()
    {
        return new CalendarMonthFluentHelper(servicePath, "CalendarMonth");
    }

    @Override
    @Nonnull
    public CalendarMonthByKeyFluentHelper getCalendarMonthByKey( final String calendarMonth_ID )
    {
        return new CalendarMonthByKeyFluentHelper(servicePath, "CalendarMonth", calendarMonth_ID);
    }

    @Override
    @Nonnull
    public CalendarQuarterFluentHelper getAllCalendarQuarter()
    {
        return new CalendarQuarterFluentHelper(servicePath, "CalendarQuarter");
    }

    @Override
    @Nonnull
    public CalendarQuarterByKeyFluentHelper getCalendarQuarterByKey( final String calendarQuarter_ID )
    {
        return new CalendarQuarterByKeyFluentHelper(servicePath, "CalendarQuarter", calendarQuarter_ID);
    }

    @Override
    @Nonnull
    public ClearingAccountingDocumentFluentHelper getAllClearingAccountingDocument()
    {
        return new ClearingAccountingDocumentFluentHelper(servicePath, "ClearingAccountingDocument");
    }

    @Override
    @Nonnull
    public ClearingAccountingDocumentByKeyFluentHelper getClearingAccountingDocumentByKey(
        final String clearingAccountingDocument_ID,
        final String companyCode,
        final String fiscalYear )
    {
        return new ClearingAccountingDocumentByKeyFluentHelper(
            servicePath,
            "ClearingAccountingDocument",
            clearingAccountingDocument_ID,
            companyCode,
            fiscalYear);
    }

    @Override
    @Nonnull
    public AccountingDocumentFluentHelper getAllAccountingDocument()
    {
        return new AccountingDocumentFluentHelper(servicePath, "AccountingDocumentType");
    }

    @Override
    @Nonnull
    public AccountingDocumentByKeyFluentHelper getAccountingDocumentByKey( final String accountingDocumentType_ID )
    {
        return new AccountingDocumentByKeyFluentHelper(
            servicePath,
            "AccountingDocumentType",
            accountingDocumentType_ID);
    }

    @Override
    @Nonnull
    public FinancialAccountFluentHelper getAllFinancialAccount()
    {
        return new FinancialAccountFluentHelper(servicePath, "FinancialAccountType");
    }

    @Override
    @Nonnull
    public FinancialAccountByKeyFluentHelper getFinancialAccountByKey( final String financialAccountType_ID )
    {
        return new FinancialAccountByKeyFluentHelper(servicePath, "FinancialAccountType", financialAccountType_ID);
    }

    @Override
    @Nonnull
    public BusinessAreaFluentHelper getAllBusinessArea()
    {
        return new BusinessAreaFluentHelper(servicePath, "BusinessArea");
    }

    @Override
    @Nonnull
    public BusinessAreaByKeyFluentHelper getBusinessAreaByKey( final String businessArea_ID )
    {
        return new BusinessAreaByKeyFluentHelper(servicePath, "BusinessArea", businessArea_ID);
    }

    @Override
    @Nonnull
    public OriginCostCtrActivityFluentHelper getAllOriginCostCtrActivity()
    {
        return new OriginCostCtrActivityFluentHelper(servicePath, "OriginCostCtrActivityType");
    }

    @Override
    @Nonnull
    public
        OriginCostCtrActivityByKeyFluentHelper
        getOriginCostCtrActivityByKey( final String originCostCtrActivityType_ID, final String controllingArea )
    {
        return new OriginCostCtrActivityByKeyFluentHelper(
            servicePath,
            "OriginCostCtrActivityType",
            originCostCtrActivityType_ID,
            controllingArea);
    }

    @Override
    @Nonnull
    public ChartOfAccountsFluentHelper getAllChartOfAccounts()
    {
        return new ChartOfAccountsFluentHelper(servicePath, "ChartOfAccounts");
    }

    @Override
    @Nonnull
    public ChartOfAccountsByKeyFluentHelper getChartOfAccountsByKey( final String chartOfAccounts_ID )
    {
        return new ChartOfAccountsByKeyFluentHelper(servicePath, "ChartOfAccounts", chartOfAccounts_ID);
    }

    @Override
    @Nonnull
    public ControllingAreaFluentHelper getAllControllingArea()
    {
        return new ControllingAreaFluentHelper(servicePath, "ControllingArea");
    }

    @Override
    @Nonnull
    public ControllingAreaByKeyFluentHelper getControllingAreaByKey( final String controllingArea_ID )
    {
        return new ControllingAreaByKeyFluentHelper(servicePath, "ControllingArea", controllingArea_ID);
    }

    @Override
    @Nonnull
    public ControllingObjectClassFluentHelper getAllControllingObjectClass()
    {
        return new ControllingObjectClassFluentHelper(servicePath, "ControllingObjectClass");
    }

    @Override
    @Nonnull
    public ControllingObjectClassByKeyFluentHelper getControllingObjectClassByKey(
        final String controllingObjectClass_ID )
    {
        return new ControllingObjectClassByKeyFluentHelper(
            servicePath,
            "ControllingObjectClass",
            controllingObjectClass_ID);
    }

    @Override
    @Nonnull
    public PartnerCostCenterFluentHelper getAllPartnerCostCenter()
    {
        return new PartnerCostCenterFluentHelper(servicePath, "PartnerCostCenter");
    }

    @Override
    @Nonnull
    public
        PartnerCostCenterByKeyFluentHelper
        getPartnerCostCenterByKey( final String partnerCostCenter_ID, final String controllingArea )
    {
        return new PartnerCostCenterByKeyFluentHelper(
            servicePath,
            "PartnerCostCenter",
            partnerCostCenter_ID,
            controllingArea);
    }

    @Override
    @Nonnull
    public DebitCreditCodeFluentHelper getAllDebitCreditCode()
    {
        return new DebitCreditCodeFluentHelper(servicePath, "DebitCreditCode");
    }

    @Override
    @Nonnull
    public DebitCreditCodeByKeyFluentHelper getDebitCreditCodeByKey( final String debitCreditCode_ID )
    {
        return new DebitCreditCodeByKeyFluentHelper(servicePath, "DebitCreditCode", debitCreditCode_ID);
    }

    @Override
    @Nonnull
    public FiscalYearVariantFluentHelper getAllFiscalYearVariant()
    {
        return new FiscalYearVariantFluentHelper(servicePath, "FiscalYearVariant");
    }

    @Override
    @Nonnull
    public FiscalYearVariantByKeyFluentHelper getFiscalYearVariantByKey( final String fiscalYearVariant_ID )
    {
        return new FiscalYearVariantByKeyFluentHelper(servicePath, "FiscalYearVariant", fiscalYearVariant_ID);
    }

    @Override
    @Nonnull
    public FunctionalAreaFluentHelper getAllFunctionalArea()
    {
        return new FunctionalAreaFluentHelper(servicePath, "FunctionalArea");
    }

    @Override
    @Nonnull
    public FunctionalAreaByKeyFluentHelper getFunctionalAreaByKey( final String functionalArea_ID )
    {
        return new FunctionalAreaByKeyFluentHelper(servicePath, "FunctionalArea", functionalArea_ID);
    }

    @Override
    @Nonnull
    public FiscalYearFluentHelper getAllFiscalYear()
    {
        return new FiscalYearFluentHelper(servicePath, "FiscalYear");
    }

    @Override
    @Nonnull
    public FiscalYearByKeyFluentHelper getFiscalYearByKey( final String fiscalYear_ID, final String companyCode )
    {
        return new FiscalYearByKeyFluentHelper(servicePath, "FiscalYear", fiscalYear_ID, companyCode);
    }

    @Override
    @Nonnull
    public CostCenterFluentHelper getAllCostCenter()
    {
        return new CostCenterFluentHelper(servicePath, "CostCenter");
    }

    @Override
    @Nonnull
    public CostCenterByKeyFluentHelper getCostCenterByKey( final String costCenter_ID, final String controllingArea )
    {
        return new CostCenterByKeyFluentHelper(servicePath, "CostCenter", costCenter_ID, controllingArea);
    }

    @Override
    @Nonnull
    public IsReversalFluentHelper getAllIsReversal()
    {
        return new IsReversalFluentHelper(servicePath, "IsReversal");
    }

    @Override
    @Nonnull
    public IsReversalByKeyFluentHelper getIsReversalByKey( final String isReversal_ID )
    {
        return new IsReversalByKeyFluentHelper(servicePath, "IsReversal", isReversal_ID);
    }

    @Override
    @Nonnull
    public IsReversedFluentHelper getAllIsReversed()
    {
        return new IsReversedFluentHelper(servicePath, "IsReversed");
    }

    @Override
    @Nonnull
    public IsReversedByKeyFluentHelper getIsReversedByKey( final String isReversed_ID )
    {
        return new IsReversedByKeyFluentHelper(servicePath, "IsReversed", isReversed_ID);
    }

    @Override
    @Nonnull
    public IsSettledFluentHelper getAllIsSettled()
    {
        return new IsSettledFluentHelper(servicePath, "IsSettled");
    }

    @Override
    @Nonnull
    public IsSettledByKeyFluentHelper getIsSettledByKey( final String isSettled_ID )
    {
        return new IsSettledByKeyFluentHelper(servicePath, "IsSettled", isSettled_ID);
    }

    @Override
    @Nonnull
    public IsSettlementFluentHelper getAllIsSettlement()
    {
        return new IsSettlementFluentHelper(servicePath, "IsSettlement");
    }

    @Override
    @Nonnull
    public IsSettlementByKeyFluentHelper getIsSettlementByKey( final String isSettlement_ID )
    {
        return new IsSettlementByKeyFluentHelper(servicePath, "IsSettlement", isSettlement_ID);
    }

    @Override
    @Nonnull
    public SalesOrderFluentHelper getAllSalesOrder()
    {
        return new SalesOrderFluentHelper(servicePath, "SalesOrder");
    }

    @Override
    @Nonnull
    public SalesOrderByKeyFluentHelper getSalesOrderByKey( final String salesOrder_ID )
    {
        return new SalesOrderByKeyFluentHelper(servicePath, "SalesOrder", salesOrder_ID);
    }

    @Override
    @Nonnull
    public WBSElementFluentHelper getAllWBSElement()
    {
        return new WBSElementFluentHelper(servicePath, "WBSElement");
    }

    @Override
    @Nonnull
    public WBSElementByKeyFluentHelper getWBSElementByKey( final String wBSElement_ID )
    {
        return new WBSElementByKeyFluentHelper(servicePath, "WBSElement", wBSElement_ID);
    }

    @Override
    @Nonnull
    public HouseBankFluentHelper getAllHouseBank()
    {
        return new HouseBankFluentHelper(servicePath, "HouseBank");
    }

    @Override
    @Nonnull
    public HouseBankByKeyFluentHelper getHouseBankByKey( final String houseBank_ID, final String companyCode )
    {
        return new HouseBankByKeyFluentHelper(servicePath, "HouseBank", houseBank_ID, companyCode);
    }

    @Override
    @Nonnull
    public InventorySpecialStockValnFluentHelper getAllInventorySpecialStockValn()
    {
        return new InventorySpecialStockValnFluentHelper(servicePath, "InventorySpecialStockValnType");
    }

    @Override
    @Nonnull
    public InventorySpecialStockValnByKeyFluentHelper getInventorySpecialStockValnByKey(
        final String inventorySpecialStockValnType_ID )
    {
        return new InventorySpecialStockValnByKeyFluentHelper(
            servicePath,
            "InventorySpecialStockValnType",
            inventorySpecialStockValnType_ID);
    }

    @Override
    @Nonnull
    public MasterFixedAssetFluentHelper getAllMasterFixedAsset()
    {
        return new MasterFixedAssetFluentHelper(servicePath, "MasterFixedAsset");
    }

    @Override
    @Nonnull
    public
        MasterFixedAssetByKeyFluentHelper
        getMasterFixedAssetByKey( final String masterFixedAsset_ID, final String companyCode )
    {
        return new MasterFixedAssetByKeyFluentHelper(servicePath, "MasterFixedAsset", masterFixedAsset_ID, companyCode);
    }

    @Override
    @Nonnull
    public PostingKeyFluentHelper getAllPostingKey()
    {
        return new PostingKeyFluentHelper(servicePath, "PostingKey");
    }

    @Override
    @Nonnull
    public PostingKeyByKeyFluentHelper getPostingKeyByKey( final String postingKey_ID )
    {
        return new PostingKeyByKeyFluentHelper(servicePath, "PostingKey", postingKey_ID);
    }

    @Override
    @Nonnull
    public ProfitCenterFluentHelper getAllProfitCenter()
    {
        return new ProfitCenterFluentHelper(servicePath, "ProfitCenter");
    }

    @Override
    @Nonnull
    public
        ProfitCenterByKeyFluentHelper
        getProfitCenterByKey( final String profitCenter_ID, final String controllingArea )
    {
        return new ProfitCenterByKeyFluentHelper(servicePath, "ProfitCenter", profitCenter_ID, controllingArea);
    }

    @Override
    @Nonnull
    public SegmentFluentHelper getAllSegment()
    {
        return new SegmentFluentHelper(servicePath, "Segment");
    }

    @Override
    @Nonnull
    public SegmentByKeyFluentHelper getSegmentByKey( final String segment_ID )
    {
        return new SegmentByKeyFluentHelper(servicePath, "Segment", segment_ID);
    }

    @Override
    @Nonnull
    public SpecialGLCodeFluentHelper getAllSpecialGLCode()
    {
        return new SpecialGLCodeFluentHelper(servicePath, "SpecialGLCode");
    }

    @Override
    @Nonnull
    public
        SpecialGLCodeByKeyFluentHelper
        getSpecialGLCodeByKey( final String specialGLCode_ID, final String financialAccountType )
    {
        return new SpecialGLCodeByKeyFluentHelper(servicePath, "SpecialGLCode", specialGLCode_ID, financialAccountType);
    }

    @Override
    @Nonnull
    public FinancialTransactionFluentHelper getAllFinancialTransaction()
    {
        return new FinancialTransactionFluentHelper(servicePath, "FinancialTransactionType");
    }

    @Override
    @Nonnull
    public FinancialTransactionByKeyFluentHelper getFinancialTransactionByKey(
        final String financialTransactionType_ID )
    {
        return new FinancialTransactionByKeyFluentHelper(
            servicePath,
            "FinancialTransactionType",
            financialTransactionType_ID);
    }

    @Override
    @Nonnull
    public FixedAssetFluentHelper getAllFixedAsset()
    {
        return new FixedAssetFluentHelper(servicePath, "FixedAsset");
    }

    @Override
    @Nonnull
    public
        FixedAssetByKeyFluentHelper
        getFixedAssetByKey( final String fixedAsset_ID, final String companyCode, final String masterFixedAsset )
    {
        return new FixedAssetByKeyFluentHelper(servicePath, "FixedAsset", fixedAsset_ID, companyCode, masterFixedAsset);
    }

    @Override
    @Nonnull
    public HouseBankAccountFluentHelper getAllHouseBankAccount()
    {
        return new HouseBankAccountFluentHelper(servicePath, "HouseBankAccount");
    }

    @Override
    @Nonnull
    public
        HouseBankAccountByKeyFluentHelper
        getHouseBankAccountByKey( final String houseBankAccount_ID, final String companyCode, final String houseBank )
    {
        return new HouseBankAccountByKeyFluentHelper(
            servicePath,
            "HouseBankAccount",
            houseBankAccount_ID,
            companyCode,
            houseBank);
    }

    @Override
    @Nonnull
    public InventorySpecialStockFluentHelper getAllInventorySpecialStock()
    {
        return new InventorySpecialStockFluentHelper(servicePath, "InventorySpecialStockType");
    }

    @Override
    @Nonnull
    public InventorySpecialStockByKeyFluentHelper getInventorySpecialStockByKey(
        final String inventorySpecialStockType_ID )
    {
        return new InventorySpecialStockByKeyFluentHelper(
            servicePath,
            "InventorySpecialStockType",
            inventorySpecialStockType_ID);
    }

    @Override
    @Nonnull
    public AlternativeGLAccountFluentHelper getAllAlternativeGLAccount()
    {
        return new AlternativeGLAccountFluentHelper(servicePath, "AlternativeGLAccount");
    }

    @Override
    @Nonnull
    public
        AlternativeGLAccountByKeyFluentHelper
        getAlternativeGLAccountByKey( final String alternativeGLAccount_ID, final String countryChartOfAccounts )
    {
        return new AlternativeGLAccountByKeyFluentHelper(
            servicePath,
            "AlternativeGLAccount",
            alternativeGLAccount_ID,
            countryChartOfAccounts);
    }

    @Override
    @Nonnull
    public MaterialFluentHelper getAllMaterial()
    {
        return new MaterialFluentHelper(servicePath, "Material");
    }

    @Override
    @Nonnull
    public MaterialByKeyFluentHelper getMaterialByKey( final String material_ID )
    {
        return new MaterialByKeyFluentHelper(servicePath, "Material", material_ID);
    }

    @Override
    @Nonnull
    public MaterialGroupFluentHelper getAllMaterialGroup()
    {
        return new MaterialGroupFluentHelper(servicePath, "MaterialGroup");
    }

    @Override
    @Nonnull
    public MaterialGroupByKeyFluentHelper getMaterialGroupByKey( final String materialGroup_ID )
    {
        return new MaterialGroupByKeyFluentHelper(servicePath, "MaterialGroup", materialGroup_ID);
    }

    @Override
    @Nonnull
    public PlantFluentHelper getAllPlant()
    {
        return new PlantFluentHelper(servicePath, "Plant");
    }

    @Override
    @Nonnull
    public PlantByKeyFluentHelper getPlantByKey( final String plant_ID )
    {
        return new PlantByKeyFluentHelper(servicePath, "Plant", plant_ID);
    }

    @Override
    @Nonnull
    public OrderCategoryFluentHelper getAllOrderCategory()
    {
        return new OrderCategoryFluentHelper(servicePath, "OrderCategory");
    }

    @Override
    @Nonnull
    public OrderCategoryByKeyFluentHelper getOrderCategoryByKey( final String orderCategory_ID )
    {
        return new OrderCategoryByKeyFluentHelper(servicePath, "OrderCategory", orderCategory_ID);
    }

    @Override
    @Nonnull
    public ProductFluentHelper getAllProduct()
    {
        return new ProductFluentHelper(servicePath, "Product");
    }

    @Override
    @Nonnull
    public ProductByKeyFluentHelper getProductByKey( final String product_ID )
    {
        return new ProductByKeyFluentHelper(servicePath, "Product", product_ID);
    }

    @Override
    @Nonnull
    public ProductGroupFluentHelper getAllProductGroup()
    {
        return new ProductGroupFluentHelper(servicePath, "ProductGroup");
    }

    @Override
    @Nonnull
    public ProductGroupByKeyFluentHelper getProductGroupByKey( final String productGroup_ID )
    {
        return new ProductGroupByKeyFluentHelper(servicePath, "ProductGroup", productGroup_ID);
    }

    @Override
    @Nonnull
    public ValuationAreaFluentHelper getAllValuationArea()
    {
        return new ValuationAreaFluentHelper(servicePath, "ValuationArea");
    }

    @Override
    @Nonnull
    public ValuationAreaByKeyFluentHelper getValuationAreaByKey( final String valuationArea_ID )
    {
        return new ValuationAreaByKeyFluentHelper(servicePath, "ValuationArea", valuationArea_ID);
    }

    @Override
    @Nonnull
    public CustomerGroupFluentHelper getAllCustomerGroup()
    {
        return new CustomerGroupFluentHelper(servicePath, "CustomerGroup");
    }

    @Override
    @Nonnull
    public CustomerGroupByKeyFluentHelper getCustomerGroupByKey( final String customerGroup_ID )
    {
        return new CustomerGroupByKeyFluentHelper(servicePath, "CustomerGroup", customerGroup_ID);
    }

    @Override
    @Nonnull
    public InventorySpclStkSalesDocumentFluentHelper getAllInventorySpclStkSalesDocument()
    {
        return new InventorySpclStkSalesDocumentFluentHelper(servicePath, "InventorySpclStkSalesDocument");
    }

    @Override
    @Nonnull
    public InventorySpclStkSalesDocumentByKeyFluentHelper getInventorySpclStkSalesDocumentByKey(
        final String inventorySpclStkSalesDocument_ID )
    {
        return new InventorySpclStkSalesDocumentByKeyFluentHelper(
            servicePath,
            "InventorySpclStkSalesDocument",
            inventorySpclStkSalesDocument_ID);
    }

    @Override
    @Nonnull
    public InventorySpclStkSalesDocItmFluentHelper getAllInventorySpclStkSalesDocItm()
    {
        return new InventorySpclStkSalesDocItmFluentHelper(servicePath, "InventorySpclStkSalesDocItm");
    }

    @Override
    @Nonnull
    public InventorySpclStkSalesDocItmByKeyFluentHelper getInventorySpclStkSalesDocItmByKey(
        final String inventorySpclStkSalesDocItm_ID,
        final String inventorySpclStkSalesDocument )
    {
        return new InventorySpclStkSalesDocItmByKeyFluentHelper(
            servicePath,
            "InventorySpclStkSalesDocItm",
            inventorySpclStkSalesDocItm_ID,
            inventorySpclStkSalesDocument);
    }

    @Override
    @Nonnull
    public InvtrySpclStockWBSElmntIntIDFluentHelper getAllInvtrySpclStockWBSElmntIntID()
    {
        return new InvtrySpclStockWBSElmntIntIDFluentHelper(servicePath, "InvtrySpclStockWBSElmntIntID");
    }

    @Override
    @Nonnull
    public InvtrySpclStockWBSElmntIntIDByKeyFluentHelper getInvtrySpclStockWBSElmntIntIDByKey(
        final String invtrySpclStockWBSElmntIntID_ID )
    {
        return new InvtrySpclStockWBSElmntIntIDByKeyFluentHelper(
            servicePath,
            "InvtrySpclStockWBSElmntIntID",
            invtrySpclStockWBSElmntIntID_ID);
    }

    @Override
    @Nonnull
    public InventorySpclStockWBSElementFluentHelper getAllInventorySpclStockWBSElement()
    {
        return new InventorySpclStockWBSElementFluentHelper(servicePath, "InventorySpclStockWBSElement");
    }

    @Override
    @Nonnull
    public InventorySpclStockWBSElementByKeyFluentHelper getInventorySpclStockWBSElementByKey(
        final String inventorySpclStockWBSElement_ID )
    {
        return new InventorySpclStockWBSElementByKeyFluentHelper(
            servicePath,
            "InventorySpclStockWBSElement",
            inventorySpclStockWBSElement_ID);
    }

    @Override
    @Nonnull
    public CalendarYearMonthFluentHelper getAllCalendarYearMonth()
    {
        return new CalendarYearMonthFluentHelper(servicePath, "CalendarYearMonth");
    }

    @Override
    @Nonnull
    public CalendarYearMonthByKeyFluentHelper getCalendarYearMonthByKey( final String calendarYearMonth_ID )
    {
        return new CalendarYearMonthByKeyFluentHelper(servicePath, "CalendarYearMonth", calendarYearMonth_ID);
    }

    @Override
    @Nonnull
    public CustomerFluentHelper getAllCustomer()
    {
        return new CustomerFluentHelper(servicePath, "Customer");
    }

    @Override
    @Nonnull
    public CustomerByKeyFluentHelper getCustomerByKey( final String customer_ID )
    {
        return new CustomerByKeyFluentHelper(servicePath, "Customer", customer_ID);
    }

    @Override
    @Nonnull
    public SupplierFluentHelper getAllSupplier()
    {
        return new SupplierFluentHelper(servicePath, "Supplier");
    }

    @Override
    @Nonnull
    public SupplierByKeyFluentHelper getSupplierByKey( final String supplier_ID )
    {
        return new SupplierByKeyFluentHelper(servicePath, "Supplier", supplier_ID);
    }

    @Override
    @Nonnull
    public BalanceTransactionCurrencyFluentHelper getAllBalanceTransactionCurrency()
    {
        return new BalanceTransactionCurrencyFluentHelper(servicePath, "BalanceTransactionCurrency");
    }

    @Override
    @Nonnull
    public BalanceTransactionCurrencyByKeyFluentHelper getBalanceTransactionCurrencyByKey(
        final String balanceTransactionCurrency_ID )
    {
        return new BalanceTransactionCurrencyByKeyFluentHelper(
            servicePath,
            "BalanceTransactionCurrency",
            balanceTransactionCurrency_ID);
    }

    @Override
    @Nonnull
    public WBSElementExternalIDFluentHelper getAllWBSElementExternalID()
    {
        return new WBSElementExternalIDFluentHelper(servicePath, "WBSElementExternalID");
    }

    @Override
    @Nonnull
    public WBSElementExternalIDByKeyFluentHelper getWBSElementExternalIDByKey( final String wBSElementExternalID_ID )
    {
        return new WBSElementExternalIDByKeyFluentHelper(servicePath, "WBSElementExternalID", wBSElementExternalID_ID);
    }

    @Override
    @Nonnull
    public IsBalanceSheetAccountFluentHelper getAllIsBalanceSheetAccount()
    {
        return new IsBalanceSheetAccountFluentHelper(servicePath, "IsBalanceSheetAccount");
    }

    @Override
    @Nonnull
    public IsBalanceSheetAccountByKeyFluentHelper getIsBalanceSheetAccountByKey( final String isBalanceSheetAccount_ID )
    {
        return new IsBalanceSheetAccountByKeyFluentHelper(
            servicePath,
            "IsBalanceSheetAccount",
            isBalanceSheetAccount_ID);
    }

    @Override
    @Nonnull
    public ReferenceDocumentFluentHelper getAllReferenceDocument()
    {
        return new ReferenceDocumentFluentHelper(servicePath, "ReferenceDocumentType");
    }

    @Override
    @Nonnull
    public ReferenceDocumentByKeyFluentHelper getReferenceDocumentByKey( final String referenceDocumentType_ID )
    {
        return new ReferenceDocumentByKeyFluentHelper(servicePath, "ReferenceDocumentType", referenceDocumentType_ID);
    }

    @Override
    @Nonnull
    public GroupFixedAssetFluentHelper getAllGroupFixedAsset()
    {
        return new GroupFixedAssetFluentHelper(servicePath, "GroupFixedAsset");
    }

    @Override
    @Nonnull
    public GroupFixedAssetByKeyFluentHelper getGroupFixedAssetByKey(
        final String groupFixedAsset_ID,
        final String companyCode,
        final String groupMasterFixedAsset )
    {
        return new GroupFixedAssetByKeyFluentHelper(
            servicePath,
            "GroupFixedAsset",
            groupFixedAsset_ID,
            companyCode,
            groupMasterFixedAsset);
    }

    @Override
    @Nonnull
    public PartnerSegmentFluentHelper getAllPartnerSegment()
    {
        return new PartnerSegmentFluentHelper(servicePath, "PartnerSegment");
    }

    @Override
    @Nonnull
    public PartnerSegmentByKeyFluentHelper getPartnerSegmentByKey( final String partnerSegment_ID )
    {
        return new PartnerSegmentByKeyFluentHelper(servicePath, "PartnerSegment", partnerSegment_ID);
    }

    @Override
    @Nonnull
    public ClearingJournalEntryFluentHelper getAllClearingJournalEntry()
    {
        return new ClearingJournalEntryFluentHelper(servicePath, "ClearingJournalEntry");
    }

    @Override
    @Nonnull
    public ClearingJournalEntryByKeyFluentHelper getClearingJournalEntryByKey(
        final String clearingJournalEntry_ID,
        final String companyCode,
        final String clearingJournalEntryFiscalYear )
    {
        return new ClearingJournalEntryByKeyFluentHelper(
            servicePath,
            "ClearingJournalEntry",
            clearingJournalEntry_ID,
            companyCode,
            clearingJournalEntryFiscalYear);
    }

    @Override
    @Nonnull
    public OperatingConcernFluentHelper getAllOperatingConcern()
    {
        return new OperatingConcernFluentHelper(servicePath, "OperatingConcern");
    }

    @Override
    @Nonnull
    public OperatingConcernByKeyFluentHelper getOperatingConcernByKey( final String operatingConcern_ID )
    {
        return new OperatingConcernByKeyFluentHelper(servicePath, "OperatingConcern", operatingConcern_ID);
    }

    @Override
    @Nonnull
    public InvtrySpclStockWBSElmntExtIDFluentHelper getAllInvtrySpclStockWBSElmntExtID()
    {
        return new InvtrySpclStockWBSElmntExtIDFluentHelper(servicePath, "InvtrySpclStockWBSElmntExtID");
    }

    @Override
    @Nonnull
    public InvtrySpclStockWBSElmntExtIDByKeyFluentHelper getInvtrySpclStockWBSElmntExtIDByKey(
        final String invtrySpclStockWBSElmntExtID_ID )
    {
        return new InvtrySpclStockWBSElmntExtIDByKeyFluentHelper(
            servicePath,
            "InvtrySpclStockWBSElmntExtID",
            invtrySpclStockWBSElmntExtID_ID);
    }

    @Override
    @Nonnull
    public CountryChartOfAccountsFluentHelper getAllCountryChartOfAccounts()
    {
        return new CountryChartOfAccountsFluentHelper(servicePath, "CountryChartOfAccounts");
    }

    @Override
    @Nonnull
    public CountryChartOfAccountsByKeyFluentHelper getCountryChartOfAccountsByKey(
        final String countryChartOfAccounts_ID )
    {
        return new CountryChartOfAccountsByKeyFluentHelper(
            servicePath,
            "CountryChartOfAccounts",
            countryChartOfAccounts_ID);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency6FluentHelper getAllFreeDefinedCurrency6()
    {
        return new FreeDefinedCurrency6FluentHelper(servicePath, "FreeDefinedCurrency6");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency6ByKeyFluentHelper getFreeDefinedCurrency6ByKey( final String freeDefinedCurrency6_ID )
    {
        return new FreeDefinedCurrency6ByKeyFluentHelper(servicePath, "FreeDefinedCurrency6", freeDefinedCurrency6_ID);
    }

    @Override
    @Nonnull
    public TransactionCurrencyFluentHelper getAllTransactionCurrency()
    {
        return new TransactionCurrencyFluentHelper(servicePath, "TransactionCurrency");
    }

    @Override
    @Nonnull
    public TransactionCurrencyByKeyFluentHelper getTransactionCurrencyByKey( final String transactionCurrency_ID )
    {
        return new TransactionCurrencyByKeyFluentHelper(servicePath, "TransactionCurrency", transactionCurrency_ID);
    }

    @Override
    @Nonnull
    public SalesDocumentFluentHelper getAllSalesDocument()
    {
        return new SalesDocumentFluentHelper(servicePath, "SalesDocument");
    }

    @Override
    @Nonnull
    public SalesDocumentByKeyFluentHelper getSalesDocumentByKey( final String salesDocument_ID )
    {
        return new SalesDocumentByKeyFluentHelper(servicePath, "SalesDocument", salesDocument_ID);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency1FluentHelper getAllFreeDefinedCurrency1()
    {
        return new FreeDefinedCurrency1FluentHelper(servicePath, "FreeDefinedCurrency1");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency1ByKeyFluentHelper getFreeDefinedCurrency1ByKey( final String freeDefinedCurrency1_ID )
    {
        return new FreeDefinedCurrency1ByKeyFluentHelper(servicePath, "FreeDefinedCurrency1", freeDefinedCurrency1_ID);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency3FluentHelper getAllFreeDefinedCurrency3()
    {
        return new FreeDefinedCurrency3FluentHelper(servicePath, "FreeDefinedCurrency3");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency3ByKeyFluentHelper getFreeDefinedCurrency3ByKey( final String freeDefinedCurrency3_ID )
    {
        return new FreeDefinedCurrency3ByKeyFluentHelper(servicePath, "FreeDefinedCurrency3", freeDefinedCurrency3_ID);
    }

    @Override
    @Nonnull
    public AssetTransactionFluentHelper getAllAssetTransaction()
    {
        return new AssetTransactionFluentHelper(servicePath, "AssetTransactionType");
    }

    @Override
    @Nonnull
    public AssetTransactionByKeyFluentHelper getAssetTransactionByKey( final String assetTransactionType_ID )
    {
        return new AssetTransactionByKeyFluentHelper(servicePath, "AssetTransactionType", assetTransactionType_ID);
    }

    @Override
    @Nonnull
    public PurchasingDocumentFluentHelper getAllPurchasingDocument()
    {
        return new PurchasingDocumentFluentHelper(servicePath, "PurchasingDocument");
    }

    @Override
    @Nonnull
    public PurchasingDocumentByKeyFluentHelper getPurchasingDocumentByKey( final String purchasingDocument_ID )
    {
        return new PurchasingDocumentByKeyFluentHelper(servicePath, "PurchasingDocument", purchasingDocument_ID);
    }

    @Override
    @Nonnull
    public InvtrySpecialStockValnType_2FluentHelper getAllInvtrySpecialStockValnType_2()
    {
        return new InvtrySpecialStockValnType_2FluentHelper(servicePath, "InvtrySpecialStockValnType_2");
    }

    @Override
    @Nonnull
    public InvtrySpecialStockValnType_2ByKeyFluentHelper getInvtrySpecialStockValnType_2ByKey(
        final String invtrySpecialStockValnType_2_ID )
    {
        return new InvtrySpecialStockValnType_2ByKeyFluentHelper(
            servicePath,
            "InvtrySpecialStockValnType_2",
            invtrySpecialStockValnType_2_ID);
    }

    @Override
    @Nonnull
    public EliminationProfitCenterFluentHelper getAllEliminationProfitCenter()
    {
        return new EliminationProfitCenterFluentHelper(servicePath, "EliminationProfitCenter");
    }

    @Override
    @Nonnull
    public
        EliminationProfitCenterByKeyFluentHelper
        getEliminationProfitCenterByKey( final String eliminationProfitCenter_ID, final String controllingArea )
    {
        return new EliminationProfitCenterByKeyFluentHelper(
            servicePath,
            "EliminationProfitCenter",
            eliminationProfitCenter_ID,
            controllingArea);
    }

    @Override
    @Nonnull
    public GlobalCurrencyFluentHelper getAllGlobalCurrency()
    {
        return new GlobalCurrencyFluentHelper(servicePath, "GlobalCurrency");
    }

    @Override
    @Nonnull
    public GlobalCurrencyByKeyFluentHelper getGlobalCurrencyByKey( final String globalCurrency_ID )
    {
        return new GlobalCurrencyByKeyFluentHelper(servicePath, "GlobalCurrency", globalCurrency_ID);
    }

    @Override
    @Nonnull
    public PredecessorReferenceDocFluentHelper getAllPredecessorReferenceDoc()
    {
        return new PredecessorReferenceDocFluentHelper(servicePath, "PredecessorReferenceDocType");
    }

    @Override
    @Nonnull
    public PredecessorReferenceDocByKeyFluentHelper getPredecessorReferenceDocByKey(
        final String predecessorReferenceDocType_ID )
    {
        return new PredecessorReferenceDocByKeyFluentHelper(
            servicePath,
            "PredecessorReferenceDocType",
            predecessorReferenceDocType_ID);
    }

    @Override
    @Nonnull
    public OffsettingAccountFluentHelper getAllOffsettingAccount()
    {
        return new OffsettingAccountFluentHelper(servicePath, "OffsettingAccount");
    }

    @Override
    @Nonnull
    public
        OffsettingAccountByKeyFluentHelper
        getOffsettingAccountByKey( final String offsettingAccount_ID, final String offsettingAccountType )
    {
        return new OffsettingAccountByKeyFluentHelper(
            servicePath,
            "OffsettingAccount",
            offsettingAccount_ID,
            offsettingAccountType);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency4FluentHelper getAllFreeDefinedCurrency4()
    {
        return new FreeDefinedCurrency4FluentHelper(servicePath, "FreeDefinedCurrency4");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency4ByKeyFluentHelper getFreeDefinedCurrency4ByKey( final String freeDefinedCurrency4_ID )
    {
        return new FreeDefinedCurrency4ByKeyFluentHelper(servicePath, "FreeDefinedCurrency4", freeDefinedCurrency4_ID);
    }

    @Override
    @Nonnull
    public LineItemIsCompletedFluentHelper getAllLineItemIsCompleted()
    {
        return new LineItemIsCompletedFluentHelper(servicePath, "LineItemIsCompleted");
    }

    @Override
    @Nonnull
    public LineItemIsCompletedByKeyFluentHelper getLineItemIsCompletedByKey( final String lineItemIsCompleted_ID )
    {
        return new LineItemIsCompletedByKeyFluentHelper(servicePath, "LineItemIsCompleted", lineItemIsCompleted_ID);
    }

    @Override
    @Nonnull
    public PartnerProjectInternalIDFluentHelper getAllPartnerProjectInternalID()
    {
        return new PartnerProjectInternalIDFluentHelper(servicePath, "PartnerProjectInternalID");
    }

    @Override
    @Nonnull
    public PartnerProjectInternalIDByKeyFluentHelper getPartnerProjectInternalIDByKey(
        final String partnerProjectInternalID_ID )
    {
        return new PartnerProjectInternalIDByKeyFluentHelper(
            servicePath,
            "PartnerProjectInternalID",
            partnerProjectInternalID_ID);
    }

    @Override
    @Nonnull
    public InventorySpecialStockSupplierFluentHelper getAllInventorySpecialStockSupplier()
    {
        return new InventorySpecialStockSupplierFluentHelper(servicePath, "InventorySpecialStockSupplier");
    }

    @Override
    @Nonnull
    public InventorySpecialStockSupplierByKeyFluentHelper getInventorySpecialStockSupplierByKey(
        final String inventorySpecialStockSupplier_ID )
    {
        return new InventorySpecialStockSupplierByKeyFluentHelper(
            servicePath,
            "InventorySpecialStockSupplier",
            inventorySpecialStockSupplier_ID);
    }

    @Override
    @Nonnull
    public SoldProductGroupFluentHelper getAllSoldProductGroup()
    {
        return new SoldProductGroupFluentHelper(servicePath, "SoldProductGroup");
    }

    @Override
    @Nonnull
    public SoldProductGroupByKeyFluentHelper getSoldProductGroupByKey( final String soldProductGroup_ID )
    {
        return new SoldProductGroupByKeyFluentHelper(servicePath, "SoldProductGroup", soldProductGroup_ID);
    }

    @Override
    @Nonnull
    public ClearingJournalEntryFiscalYearFluentHelper getAllClearingJournalEntryFiscalYear()
    {
        return new ClearingJournalEntryFiscalYearFluentHelper(servicePath, "ClearingJournalEntryFiscalYear");
    }

    @Override
    @Nonnull
    public ClearingJournalEntryFiscalYearByKeyFluentHelper getClearingJournalEntryFiscalYearByKey(
        final String clearingJournalEntryFiscalYear_ID,
        final String companyCode )
    {
        return new ClearingJournalEntryFiscalYearByKeyFluentHelper(
            servicePath,
            "ClearingJournalEntryFiscalYear",
            clearingJournalEntryFiscalYear_ID,
            companyCode);
    }

    @Override
    @Nonnull
    public LogicalSystemFluentHelper getAllLogicalSystem()
    {
        return new LogicalSystemFluentHelper(servicePath, "LogicalSystem");
    }

    @Override
    @Nonnull
    public LogicalSystemByKeyFluentHelper getLogicalSystemByKey( final String logicalSystem_ID )
    {
        return new LogicalSystemByKeyFluentHelper(servicePath, "LogicalSystem", logicalSystem_ID);
    }

    @Override
    @Nonnull
    public GroupMasterFixedAssetFluentHelper getAllGroupMasterFixedAsset()
    {
        return new GroupMasterFixedAssetFluentHelper(servicePath, "GroupMasterFixedAsset");
    }

    @Override
    @Nonnull
    public
        GroupMasterFixedAssetByKeyFluentHelper
        getGroupMasterFixedAssetByKey( final String groupMasterFixedAsset_ID, final String companyCode )
    {
        return new GroupMasterFixedAssetByKeyFluentHelper(
            servicePath,
            "GroupMasterFixedAsset",
            groupMasterFixedAsset_ID,
            companyCode);
    }

    @Override
    @Nonnull
    public SalesDocumentItemFluentHelper getAllSalesDocumentItem()
    {
        return new SalesDocumentItemFluentHelper(servicePath, "SalesDocumentItem");
    }

    @Override
    @Nonnull
    public
        SalesDocumentItemByKeyFluentHelper
        getSalesDocumentItemByKey( final String salesDocumentItem_ID, final String salesDocument )
    {
        return new SalesDocumentItemByKeyFluentHelper(
            servicePath,
            "SalesDocumentItem",
            salesDocumentItem_ID,
            salesDocument);
    }

    @Override
    @Nonnull
    public PartnerOrderCategoryFluentHelper getAllPartnerOrderCategory()
    {
        return new PartnerOrderCategoryFluentHelper(servicePath, "PartnerOrderCategory");
    }

    @Override
    @Nonnull
    public PartnerOrderCategoryByKeyFluentHelper getPartnerOrderCategoryByKey( final String partnerOrderCategory_ID )
    {
        return new PartnerOrderCategoryByKeyFluentHelper(servicePath, "PartnerOrderCategory", partnerOrderCategory_ID);
    }

    @Override
    @Nonnull
    public PartnerBusinessAreaFluentHelper getAllPartnerBusinessArea()
    {
        return new PartnerBusinessAreaFluentHelper(servicePath, "PartnerBusinessArea");
    }

    @Override
    @Nonnull
    public PartnerBusinessAreaByKeyFluentHelper getPartnerBusinessAreaByKey( final String partnerBusinessArea_ID )
    {
        return new PartnerBusinessAreaByKeyFluentHelper(servicePath, "PartnerBusinessArea", partnerBusinessArea_ID);
    }

    @Override
    @Nonnull
    public PartnerFunctionalAreaFluentHelper getAllPartnerFunctionalArea()
    {
        return new PartnerFunctionalAreaFluentHelper(servicePath, "PartnerFunctionalArea");
    }

    @Override
    @Nonnull
    public PartnerFunctionalAreaByKeyFluentHelper getPartnerFunctionalAreaByKey( final String partnerFunctionalArea_ID )
    {
        return new PartnerFunctionalAreaByKeyFluentHelper(
            servicePath,
            "PartnerFunctionalArea",
            partnerFunctionalArea_ID);
    }

    @Override
    @Nonnull
    public ProjectExternalIDFluentHelper getAllProjectExternalID()
    {
        return new ProjectExternalIDFluentHelper(servicePath, "ProjectExternalID");
    }

    @Override
    @Nonnull
    public ProjectExternalIDByKeyFluentHelper getProjectExternalIDByKey( final String projectExternalID_ID )
    {
        return new ProjectExternalIDByKeyFluentHelper(servicePath, "ProjectExternalID", projectExternalID_ID);
    }

    @Override
    @Nonnull
    public OriginCostCenterFluentHelper getAllOriginCostCenter()
    {
        return new OriginCostCenterFluentHelper(servicePath, "OriginCostCenter");
    }

    @Override
    @Nonnull
    public
        OriginCostCenterByKeyFluentHelper
        getOriginCostCenterByKey( final String originCostCenter_ID, final String controllingArea )
    {
        return new OriginCostCenterByKeyFluentHelper(
            servicePath,
            "OriginCostCenter",
            originCostCenter_ID,
            controllingArea);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency5FluentHelper getAllFreeDefinedCurrency5()
    {
        return new FreeDefinedCurrency5FluentHelper(servicePath, "FreeDefinedCurrency5");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency5ByKeyFluentHelper getFreeDefinedCurrency5ByKey( final String freeDefinedCurrency5_ID )
    {
        return new FreeDefinedCurrency5ByKeyFluentHelper(servicePath, "FreeDefinedCurrency5", freeDefinedCurrency5_ID);
    }

    @Override
    @Nonnull
    public CompanyCodeCurrencyFluentHelper getAllCompanyCodeCurrency()
    {
        return new CompanyCodeCurrencyFluentHelper(servicePath, "CompanyCodeCurrency");
    }

    @Override
    @Nonnull
    public CompanyCodeCurrencyByKeyFluentHelper getCompanyCodeCurrencyByKey( final String companyCodeCurrency_ID )
    {
        return new CompanyCodeCurrencyByKeyFluentHelper(servicePath, "CompanyCodeCurrency", companyCodeCurrency_ID);
    }

    @Override
    @Nonnull
    public OriginObjectFluentHelper getAllOriginObject()
    {
        return new OriginObjectFluentHelper(servicePath, "OriginObjectType");
    }

    @Override
    @Nonnull
    public OriginObjectByKeyFluentHelper getOriginObjectByKey( final String originObjectType_ID )
    {
        return new OriginObjectByKeyFluentHelper(servicePath, "OriginObjectType", originObjectType_ID);
    }

    @Override
    @Nonnull
    public ControllingObjectDebitFluentHelper getAllControllingObjectDebit()
    {
        return new ControllingObjectDebitFluentHelper(servicePath, "ControllingObjectDebitType");
    }

    @Override
    @Nonnull
    public ControllingObjectDebitByKeyFluentHelper getControllingObjectDebitByKey(
        final String controllingObjectDebitType_ID )
    {
        return new ControllingObjectDebitByKeyFluentHelper(
            servicePath,
            "ControllingObjectDebitType",
            controllingObjectDebitType_ID);
    }

    @Override
    @Nonnull
    public PartnerWBSElementInternalIDFluentHelper getAllPartnerWBSElementInternalID()
    {
        return new PartnerWBSElementInternalIDFluentHelper(servicePath, "PartnerWBSElementInternalID");
    }

    @Override
    @Nonnull
    public PartnerWBSElementInternalIDByKeyFluentHelper getPartnerWBSElementInternalIDByKey(
        final String partnerWBSElementInternalID_ID )
    {
        return new PartnerWBSElementInternalIDByKeyFluentHelper(
            servicePath,
            "PartnerWBSElementInternalID",
            partnerWBSElementInternalID_ID);
    }

    @Override
    @Nonnull
    public GLAccountHierarchyFluentHelper getAllGLAccountHierarchy()
    {
        return new GLAccountHierarchyFluentHelper(servicePath, "GLAccountHierarchy");
    }

    @Override
    @Nonnull
    public
        GLAccountHierarchyByKeyFluentHelper
        getGLAccountHierarchyByKey( final String gLAccountHierarchy_ID, final String chartOfAccounts )
    {
        return new GLAccountHierarchyByKeyFluentHelper(
            servicePath,
            "GLAccountHierarchy",
            gLAccountHierarchy_ID,
            chartOfAccounts);
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency7FluentHelper getAllFreeDefinedCurrency7()
    {
        return new FreeDefinedCurrency7FluentHelper(servicePath, "FreeDefinedCurrency7");
    }

    @Override
    @Nonnull
    public FreeDefinedCurrency7ByKeyFluentHelper getFreeDefinedCurrency7ByKey( final String freeDefinedCurrency7_ID )
    {
        return new FreeDefinedCurrency7ByKeyFluentHelper(servicePath, "FreeDefinedCurrency7", freeDefinedCurrency7_ID);
    }

    @Override
    @Nonnull
    public PartnerCompanyCodeFluentHelper getAllPartnerCompanyCode()
    {
        return new PartnerCompanyCodeFluentHelper(servicePath, "PartnerCompanyCode");
    }

    @Override
    @Nonnull
    public PartnerCompanyCodeByKeyFluentHelper getPartnerCompanyCodeByKey( final String partnerCompanyCode_ID )
    {
        return new PartnerCompanyCodeByKeyFluentHelper(servicePath, "PartnerCompanyCode", partnerCompanyCode_ID);
    }

    @Override
    @Nonnull
    public SalesOrderItemFluentHelper getAllSalesOrderItem()
    {
        return new SalesOrderItemFluentHelper(servicePath, "SalesOrderItem");
    }

    @Override
    @Nonnull
    public
        SalesOrderItemByKeyFluentHelper
        getSalesOrderItemByKey( final String salesOrderItem_ID, final String salesOrder )
    {
        return new SalesOrderItemByKeyFluentHelper(servicePath, "SalesOrderItem", salesOrderItem_ID, salesOrder);
    }

    @Override
    @Nonnull
    public OffsettingAccount_2FluentHelper getAllOffsettingAccount_2()
    {
        return new OffsettingAccount_2FluentHelper(servicePath, "OffsettingAccountType");
    }

    @Override
    @Nonnull
    public OffsettingAccount_2ByKeyFluentHelper getOffsettingAccount_2ByKey( final String offsettingAccountType_ID )
    {
        return new OffsettingAccount_2ByKeyFluentHelper(servicePath, "OffsettingAccountType", offsettingAccountType_ID);
    }

    @Override
    @Nonnull
    public PartnerSalesDocumentItemFluentHelper getAllPartnerSalesDocumentItem()
    {
        return new PartnerSalesDocumentItemFluentHelper(servicePath, "PartnerSalesDocumentItem");
    }

    @Override
    @Nonnull
    public
        PartnerSalesDocumentItemByKeyFluentHelper
        getPartnerSalesDocumentItemByKey( final String partnerSalesDocumentItem_ID, final String partnerSalesDocument )
    {
        return new PartnerSalesDocumentItemByKeyFluentHelper(
            servicePath,
            "PartnerSalesDocumentItem",
            partnerSalesDocumentItem_ID,
            partnerSalesDocument);
    }

    @Override
    @Nonnull
    public InventoryValuationFluentHelper getAllInventoryValuation()
    {
        return new InventoryValuationFluentHelper(servicePath, "InventoryValuationType");
    }

    @Override
    @Nonnull
    public InventoryValuationByKeyFluentHelper getInventoryValuationByKey( final String inventoryValuationType_ID )
    {
        return new InventoryValuationByKeyFluentHelper(
            servicePath,
            "InventoryValuationType",
            inventoryValuationType_ID);
    }

    @Override
    @Nonnull
    public ODataQueryAdditionalMetadataFluentHelper getAllODataQueryAdditionalMetadata()
    {
        return new ODataQueryAdditionalMetadataFluentHelper(servicePath, "AdditionalMetadata");
    }

    @Override
    @Nonnull
    public ODataQueryAdditionalMetadataByKeyFluentHelper getODataQueryAdditionalMetadataByKey(
        final String oDataQueryMetadata )
    {
        return new ODataQueryAdditionalMetadataByKeyFluentHelper(servicePath, "AdditionalMetadata", oDataQueryMetadata);
    }

    @Override
    @Nonnull
    public SAP__CurrencyFluentHelper getAllSAP__Currency()
    {
        return new SAP__CurrencyFluentHelper(servicePath, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyByKeyFluentHelper getSAP__CurrencyByKey( final String currencyCode )
    {
        return new SAP__CurrencyByKeyFluentHelper(servicePath, "SAP__Currencies", currencyCode);
    }

    @Override
    @Nonnull
    public SAP__CurrencyCreateFluentHelper createSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyCreateFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyUpdateFluentHelper updateSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyUpdateFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyDeleteFluentHelper deleteSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyDeleteFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureFluentHelper getAllSAP__UnitOfMeasure()
    {
        return new SAP__UnitOfMeasureFluentHelper(servicePath, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureByKeyFluentHelper getSAP__UnitOfMeasureByKey( final String unitCode )
    {
        return new SAP__UnitOfMeasureByKeyFluentHelper(servicePath, "SAP__UnitsOfMeasure", unitCode);
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureCreateFluentHelper createSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureCreateFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureUpdateFluentHelper updateSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureUpdateFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureDeleteFluentHelper deleteSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureDeleteFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionFluentHelper getAllSAP__DocumentDescription()
    {
        return new SAP__DocumentDescriptionFluentHelper(servicePath, "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionByKeyFluentHelper getSAP__DocumentDescriptionByKey( final UUID id )
    {
        return new SAP__DocumentDescriptionByKeyFluentHelper(servicePath, "SAP__MyDocumentDescriptions", id);
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionCreateFluentHelper createSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionCreateFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionUpdateFluentHelper updateSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionUpdateFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionDeleteFluentHelper deleteSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionDeleteFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpFluentHelper getAllSAP__ValueHelp()
    {
        return new SAP__ValueHelpFluentHelper(servicePath, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpByKeyFluentHelper getSAP__ValueHelpByKey( final String vALUEHELP )
    {
        return new SAP__ValueHelpByKeyFluentHelper(servicePath, "SAP__ValueHelpSet", vALUEHELP);
    }

    @Override
    @Nonnull
    public SAP__ValueHelpCreateFluentHelper createSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpCreateFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpUpdateFluentHelper updateSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpUpdateFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpDeleteFluentHelper deleteSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpDeleteFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public TRIALBALANCEResultByKeyFluentHelper getTRIALBALANCEResultByKey( final String iD )
    {
        return new TRIALBALANCEResultByKeyFluentHelper(servicePath, "C_TRIALBALANCEResults", iD);
    }

    @Override
    @Nonnull
    public
        TRIALBALANCEParametersByKeyFluentHelper
        getTRIALBALANCEParametersByKey( final LocalDateTime p_FromPostingDate, final LocalDateTime p_ToPostingDate )
    {
        return new TRIALBALANCEParametersByKeyFluentHelper(
            servicePath,
            "C_TRIALBALANCE",
            p_FromPostingDate,
            p_ToPostingDate);
    }

}
