/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.AdjustDeliveryItemQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.batch.DefaultWarehouseInboundDeliveryServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve header information for warehouse
 * inbound deliveries. - You can retrieve item information for warehouse inbound deliveries, including serial numbers. -
 * You can change the carrier ID for a warehouse inbound delivery at header level. - You can change the product quantity
 * and the goods movement bin for a warehouse inbound delivery at item level. - You can adjust the delivery item
 * quantity down to 0 if the item was not received, or down to the packed quantity that was received. - You can post
 * goods receipt. - You can reverse goods receipt. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/a8/29826d35714642999d7b7dfbd58b8f/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WHSE_INBOUND_DELIVERY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WHSE_INBOUND_DELIVERY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Inbound Delivery Integration(SAP_COM_0385)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BR'>Warehouse Inbound Processing(3BR)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Inbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWarehouseInboundDeliveryService" )
@Deprecated
public class DefaultWarehouseInboundDeliveryService implements WarehouseInboundDeliveryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WarehouseInboundDeliveryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWarehouseInboundDeliveryService()
    {
        servicePath = WarehouseInboundDeliveryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWarehouseInboundDeliveryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehouseInboundDeliveryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWarehouseInboundDeliveryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWarehouseInboundDeliveryServiceBatch batch()
    {
        return new DefaultWarehouseInboundDeliveryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WhseInboundDeliveryHeadFluentHelper getAllWhseInboundDeliveryHead()
    {
        return new WhseInboundDeliveryHeadFluentHelper(servicePath, "WhseInboundDeliveryHead");
    }

    @Override
    @Nonnull
    public WhseInboundDeliveryHeadByKeyFluentHelper getWhseInboundDeliveryHeadByKey( final String inboundDelivery )
    {
        return new WhseInboundDeliveryHeadByKeyFluentHelper(servicePath, "WhseInboundDeliveryHead", inboundDelivery);
    }

    @Override
    @Nonnull
    public WhseInboundDeliveryHeadUpdateFluentHelper updateWhseInboundDeliveryHead(
        @Nonnull final WhseInboundDeliveryHead whseInboundDeliveryHead )
    {
        return new WhseInboundDeliveryHeadUpdateFluentHelper(
            servicePath,
            whseInboundDeliveryHead,
            "WhseInboundDeliveryHead");
    }

    @Override
    @Nonnull
    public WhseInboundDeliveryItemFluentHelper getAllWhseInboundDeliveryItem()
    {
        return new WhseInboundDeliveryItemFluentHelper(servicePath, "WhseInboundDeliveryItem");
    }

    @Override
    @Nonnull
    public
        WhseInboundDeliveryItemByKeyFluentHelper
        getWhseInboundDeliveryItemByKey( final String inboundDelivery, final String inboundDeliveryItem )
    {
        return new WhseInboundDeliveryItemByKeyFluentHelper(
            servicePath,
            "WhseInboundDeliveryItem",
            inboundDelivery,
            inboundDeliveryItem);
    }

    @Override
    @Nonnull
    public WhseInboundDeliveryItemUpdateFluentHelper updateWhseInboundDeliveryItem(
        @Nonnull final WhseInboundDeliveryItem whseInboundDeliveryItem )
    {
        return new WhseInboundDeliveryItemUpdateFluentHelper(
            servicePath,
            whseInboundDeliveryItem,
            "WhseInboundDeliveryItem");
    }

    @Override
    @Nonnull
    public WhseInbDelivItemSerialNumberFluentHelper getAllWhseInbDelivItemSerialNumber()
    {
        return new WhseInbDelivItemSerialNumberFluentHelper(servicePath, "WhseInbDelivItemSerialNumber");
    }

    @Override
    @Nonnull
    public WhseInbDelivItemSerialNumberByKeyFluentHelper getWhseInbDelivItemSerialNumberByKey(
        final String inboundDelivery,
        final String inboundDeliveryItem,
        final String eWMSerialNumber )
    {
        return new WhseInbDelivItemSerialNumberByKeyFluentHelper(
            servicePath,
            "WhseInbDelivItemSerialNumber",
            inboundDelivery,
            inboundDeliveryItem,
            eWMSerialNumber);
    }

    @Override
    @Nonnull
    public PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String inboundDelivery )
    {
        return new PostGoodsReceiptFluentHelper(servicePath, inboundDelivery);
    }

    @Override
    @Nonnull
    public ReverseGoodsReceiptFluentHelper reverseGoodsReceipt( @Nonnull final String inboundDelivery )
    {
        return new ReverseGoodsReceiptFluentHelper(servicePath, inboundDelivery);
    }

    @Override
    @Nonnull
    public
        AdjustDeliveryItemQuantityFluentHelper
        adjustDeliveryItemQuantity( @Nonnull final String inboundDelivery, @Nonnull final String inboundDeliveryItem )
    {
        return new AdjustDeliveryItemQuantityFluentHelper(servicePath, inboundDelivery, inboundDeliveryItem);
    }

}
