/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.AdjustDeliveryItemQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.PostGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.PrintLoadingListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.ReverseGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.batch.DefaultWarehouseOutboundDeliveryOrderServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve header information for warehouse
 * outbound delivery orders. - You can retrieve item information for warehouse outbound delivery orders, including
 * serial numbers. - You can change the carrier ID for a warehouse outbound delivery order at header level. - You can
 * change the staging bay for a warehouse outbound delivery order, as well as the product quantity, at item level. - You
 * can adjust the delivery quantity down to 0 if picking hasn&#39;t started, or down to the partial quantity that has
 * already been picked. - You can print a loading list for a delivery. - You can post goods issue. - You can reverse
 * goods issue..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/33/1cfb1d12c148569cd94072a421c69f/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WHSE_OUTB_DLV_ORDER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WHSE_OUTB_DLV_ORDER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Process Outbound Delivery Order Integration(SAP_COM_0356)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BS'>Warehouse Outbound Processing(3BS)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Outbound Delivery Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWarehouseOutboundDeliveryOrderService" )
@Deprecated
public class DefaultWarehouseOutboundDeliveryOrderService implements WarehouseOutboundDeliveryOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WarehouseOutboundDeliveryOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWarehouseOutboundDeliveryOrderService()
    {
        servicePath = WarehouseOutboundDeliveryOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWarehouseOutboundDeliveryOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehouseOutboundDeliveryOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWarehouseOutboundDeliveryOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWarehouseOutboundDeliveryOrderServiceBatch batch()
    {
        return new DefaultWarehouseOutboundDeliveryOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WhseDeliveryDocumentAddressFluentHelper getAllWhseDeliveryDocumentAddress()
    {
        return new WhseDeliveryDocumentAddressFluentHelper(servicePath, "WhseDeliveryDocumentAddress");
    }

    @Override
    @Nonnull
    public WhseDeliveryDocumentAddressByKeyFluentHelper getWhseDeliveryDocumentAddressByKey(
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem,
        final String businessPartnerRole )
    {
        return new WhseDeliveryDocumentAddressByKeyFluentHelper(
            servicePath,
            "WhseDeliveryDocumentAddress",
            outboundDeliveryOrder,
            outboundDeliveryOrderItem,
            businessPartnerRole);
    }

    @Override
    @Nonnull
    public WhseOutboundDeliveryOrderHeadFluentHelper getAllWhseOutboundDeliveryOrderHead()
    {
        return new WhseOutboundDeliveryOrderHeadFluentHelper(servicePath, "WhseOutboundDeliveryOrderHead");
    }

    @Override
    @Nonnull
    public WhseOutboundDeliveryOrderHeadByKeyFluentHelper getWhseOutboundDeliveryOrderHeadByKey(
        final String outboundDeliveryOrder )
    {
        return new WhseOutboundDeliveryOrderHeadByKeyFluentHelper(
            servicePath,
            "WhseOutboundDeliveryOrderHead",
            outboundDeliveryOrder);
    }

    @Override
    @Nonnull
    public WhseOutboundDeliveryOrderHeadUpdateFluentHelper updateWhseOutboundDeliveryOrderHead(
        @Nonnull final WhseOutboundDeliveryOrderHead whseOutboundDeliveryOrderHead )
    {
        return new WhseOutboundDeliveryOrderHeadUpdateFluentHelper(
            servicePath,
            whseOutboundDeliveryOrderHead,
            "WhseOutboundDeliveryOrderHead");
    }

    @Override
    @Nonnull
    public WhseOutboundDeliveryOrderItemFluentHelper getAllWhseOutboundDeliveryOrderItem()
    {
        return new WhseOutboundDeliveryOrderItemFluentHelper(servicePath, "WhseOutboundDeliveryOrderItem");
    }

    @Override
    @Nonnull
    public WhseOutboundDeliveryOrderItemByKeyFluentHelper getWhseOutboundDeliveryOrderItemByKey(
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem )
    {
        return new WhseOutboundDeliveryOrderItemByKeyFluentHelper(
            servicePath,
            "WhseOutboundDeliveryOrderItem",
            outboundDeliveryOrder,
            outboundDeliveryOrderItem);
    }

    @Override
    @Nonnull
    public WhseOutboundDeliveryOrderItemUpdateFluentHelper updateWhseOutboundDeliveryOrderItem(
        @Nonnull final WhseOutboundDeliveryOrderItem whseOutboundDeliveryOrderItem )
    {
        return new WhseOutboundDeliveryOrderItemUpdateFluentHelper(
            servicePath,
            whseOutboundDeliveryOrderItem,
            "WhseOutboundDeliveryOrderItem");
    }

    @Override
    @Nonnull
    public WhseOutbDelivOrderItemSerialNoFluentHelper getAllWhseOutbDelivOrderItemSerialNo()
    {
        return new WhseOutbDelivOrderItemSerialNoFluentHelper(servicePath, "WhseOutbDelivOrderItemSerialNo");
    }

    @Override
    @Nonnull
    public WhseOutbDelivOrderItemSerialNoByKeyFluentHelper getWhseOutbDelivOrderItemSerialNoByKey(
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem,
        final String eWMSerialNumber )
    {
        return new WhseOutbDelivOrderItemSerialNoByKeyFluentHelper(
            servicePath,
            "WhseOutbDelivOrderItemSerialNo",
            outboundDeliveryOrder,
            outboundDeliveryOrderItem,
            eWMSerialNumber);
    }

    @Override
    @Nonnull
    public PostGoodsIssueFluentHelper postGoodsIssue( @Nonnull final String outboundDeliveryOrder )
    {
        return new PostGoodsIssueFluentHelper(servicePath, outboundDeliveryOrder);
    }

    @Override
    @Nonnull
    public PrintLoadingListFluentHelper printLoadingList( @Nonnull final String outboundDeliveryOrder )
    {
        return new PrintLoadingListFluentHelper(servicePath, outboundDeliveryOrder);
    }

    @Override
    @Nonnull
    public ReverseGoodsIssueFluentHelper reverseGoodsIssue( @Nonnull final String outboundDeliveryOrder )
    {
        return new ReverseGoodsIssueFluentHelper(servicePath, outboundDeliveryOrder);
    }

    @Override
    @Nonnull
    public AdjustDeliveryItemQuantityFluentHelper adjustDeliveryItemQuantity(
        @Nonnull final String outboundDeliveryOrder,
        @Nonnull final String outboundDeliveryOrderItem )
    {
        return new AdjustDeliveryItemQuantityFluentHelper(
            servicePath,
            outboundDeliveryOrder,
            outboundDeliveryOrderItem);
    }

}
