/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.DeletePhysicalInventoryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.batch.DefaultWarehousePhysicalInventoryServiceBatch;

/**
 * <p>
 *
 * In every API call, you can make use of the following operations: - You can retrieve physical inventory (PI) items. -
 * You can count PI items. - You can change counted PI items. - You can mark PI items as ***Deleted***.
 *
 * You can integrate this API with external applications.
 *
 * For the count and change count operations, you can only perform these operations using batch requests. Additionally,
 * you must include the entities Warehouse Physical Inventory Item (WhsePhysicalInventoryItem) and Warehouse Physical
 * Inventory Count Item (WhsePhysicalInventoryCountItem) in the batch requests. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/aa/453eaa3c3142d49877ee969a5dacf7/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WHSE_PHYSINVENTORYITEM?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WHSE_PHYSINVENTORYITEM</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Physical Inventory Integration(SAP_COM_0378)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BX'>Warehouse Physical Inventory(3BX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Physical Inventory Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWarehousePhysicalInventoryService" )
@Deprecated
public class DefaultWarehousePhysicalInventoryService implements WarehousePhysicalInventoryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WarehousePhysicalInventoryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWarehousePhysicalInventoryService()
    {
        servicePath = WarehousePhysicalInventoryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWarehousePhysicalInventoryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehousePhysicalInventoryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWarehousePhysicalInventoryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWarehousePhysicalInventoryServiceBatch batch()
    {
        return new DefaultWarehousePhysicalInventoryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryCountItemFluentHelper getAllWhsePhysicalInventoryCountItem()
    {
        return new WhsePhysicalInventoryCountItemFluentHelper(servicePath, "WhsePhysicalInventoryCountItem");
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryCountItemByKeyFluentHelper getWhsePhysicalInventoryCountItemByKey(
        final UUID physicalInventoryDocumentUUID,
        final String physicalInventoryItemNumber,
        final Integer lineIndexOfPInvItem,
        final Integer pInvQuantitySequence )
    {
        return new WhsePhysicalInventoryCountItemByKeyFluentHelper(
            servicePath,
            "WhsePhysicalInventoryCountItem",
            physicalInventoryDocumentUUID,
            physicalInventoryItemNumber,
            lineIndexOfPInvItem,
            pInvQuantitySequence);
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryCountItemCreateFluentHelper createWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem )
    {
        return new WhsePhysicalInventoryCountItemCreateFluentHelper(
            servicePath,
            whsePhysicalInventoryCountItem,
            "WhsePhysicalInventoryCountItem");
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryCountItemUpdateFluentHelper updateWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem )
    {
        return new WhsePhysicalInventoryCountItemUpdateFluentHelper(
            servicePath,
            whsePhysicalInventoryCountItem,
            "WhsePhysicalInventoryCountItem");
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryItemFluentHelper getAllWhsePhysicalInventoryItem()
    {
        return new WhsePhysicalInventoryItemFluentHelper(servicePath, "WhsePhysicalInventoryItem");
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryItemByKeyFluentHelper getWhsePhysicalInventoryItemByKey(
        final UUID physicalInventoryDocumentUUID,
        final String physicalInventoryItemNumber )
    {
        return new WhsePhysicalInventoryItemByKeyFluentHelper(
            servicePath,
            "WhsePhysicalInventoryItem",
            physicalInventoryDocumentUUID,
            physicalInventoryItemNumber);
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryItemCreateFluentHelper createWhsePhysicalInventoryItem(
        @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem )
    {
        return new WhsePhysicalInventoryItemCreateFluentHelper(
            servicePath,
            whsePhysicalInventoryItem,
            "WhsePhysicalInventoryItem");
    }

    @Override
    @Nonnull
    public WhsePhysicalInventoryItemUpdateFluentHelper updateWhsePhysicalInventoryItem(
        @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem )
    {
        return new WhsePhysicalInventoryItemUpdateFluentHelper(
            servicePath,
            whsePhysicalInventoryItem,
            "WhsePhysicalInventoryItem");
    }

    @Override
    @Nonnull
    public DeletePhysicalInventoryItemFluentHelper deletePhysicalInventoryItem(
        @Nonnull final UUID physicalInventoryDocumentUUID,
        @Nonnull final String physicalInventoryItemNumber )
    {
        return new DeletePhysicalInventoryItemFluentHelper(
            servicePath,
            physicalInventoryDocumentUUID,
            physicalInventoryItemNumber);
    }

}
