/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.LogoffFromWarehouseResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.LogonToWarehouseResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.batch.DefaultWarehouseResourceServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve warehouse resources. Apply any of
 * the filters provided or retrieve all existing data. - You can create and delete warehouse resources. - You can update
 * existing warehouse resources (log on, log off)..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/bd/d0b88001154ebcb47de632c68ce0fb/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE_RESOURCE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE_RESOURCE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Process Warehouse Task Integration(SAP_COM_0353)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Resource</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWarehouseResourceService" )
@Deprecated
public class DefaultWarehouseResourceService implements WarehouseResourceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WarehouseResourceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWarehouseResourceService()
    {
        servicePath = WarehouseResourceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWarehouseResourceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehouseResourceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWarehouseResourceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWarehouseResourceServiceBatch batch()
    {
        return new DefaultWarehouseResourceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WarehouseResourceFluentHelper getAllWarehouseResource()
    {
        return new WarehouseResourceFluentHelper(servicePath, "WarehouseResource");
    }

    @Override
    @Nonnull
    public
        WarehouseResourceByKeyFluentHelper
        getWarehouseResourceByKey( final String warehouse, final String warehouseResource )
    {
        return new WarehouseResourceByKeyFluentHelper(servicePath, "WarehouseResource", warehouse, warehouseResource);
    }

    @Override
    @Nonnull
    public WarehouseResourceCreateFluentHelper createWarehouseResource(
        @Nonnull final WarehouseResource warehouseResource )
    {
        return new WarehouseResourceCreateFluentHelper(servicePath, warehouseResource, "WarehouseResource");
    }

    @Override
    @Nonnull
    public WarehouseResourceDeleteFluentHelper deleteWarehouseResource(
        @Nonnull final WarehouseResource warehouseResource )
    {
        return new WarehouseResourceDeleteFluentHelper(servicePath, warehouseResource, "WarehouseResource");
    }

    @Override
    @Nonnull
    public
        LogoffFromWarehouseResourceFluentHelper
        logoffFromWarehouseResource( @Nonnull final String warehouse, @Nonnull final String warehouseResource )
    {
        return new LogoffFromWarehouseResourceFluentHelper(servicePath, warehouse, warehouseResource);
    }

    @Override
    @Nonnull
    public
        LogonToWarehouseResourceFluentHelper
        logonToWarehouseResource( @Nonnull final String warehouse, @Nonnull final String warehouseResource )
    {
        return new LogonToWarehouseResourceFluentHelper(servicePath, warehouse, warehouseResource);
    }

}
