/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.batch.DefaultWarehouseServiceBatch;

/**
 * <p>
 * This allows you to integrate input help (F4 help) for warehouse numbers in your mobile apps.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/52/2c8cc5ee864e81a0d6fe41631a11d4/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Master Data Integration(SAP_COM_0374)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWarehouseService" )
@Deprecated
public class DefaultWarehouseService implements WarehouseService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WarehouseService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWarehouseService()
    {
        servicePath = WarehouseService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWarehouseService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehouseService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWarehouseService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWarehouseServiceBatch batch()
    {
        return new DefaultWarehouseServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WarehouseFluentHelper getAllWarehouse()
    {
        return new WarehouseFluentHelper(servicePath, "Warehouse");
    }

    @Override
    @Nonnull
    public WarehouseByKeyFluentHelper getWarehouseByKey( final String warehouse )
    {
        return new WarehouseByKeyFluentHelper(servicePath, "Warehouse", warehouse);
    }

    @Override
    @Nonnull
    public WarehouseStorageTypeFluentHelper getAllWarehouseStorageType()
    {
        return new WarehouseStorageTypeFluentHelper(servicePath, "WarehouseStorageType");
    }

    @Override
    @Nonnull
    public
        WarehouseStorageTypeByKeyFluentHelper
        getWarehouseStorageTypeByKey( final String warehouse, final String storageType )
    {
        return new WarehouseStorageTypeByKeyFluentHelper(servicePath, "WarehouseStorageType", warehouse, storageType);
    }

    @Override
    @Nonnull
    public WarehouseStorageTypeTextFluentHelper getAllWarehouseStorageTypeText()
    {
        return new WarehouseStorageTypeTextFluentHelper(servicePath, "WarehouseStorageTypeText");
    }

    @Override
    @Nonnull
    public
        WarehouseStorageTypeTextByKeyFluentHelper
        getWarehouseStorageTypeTextByKey( final String language, final String warehouse, final String storageType )
    {
        return new WarehouseStorageTypeTextByKeyFluentHelper(
            servicePath,
            "WarehouseStorageTypeText",
            language,
            warehouse,
            storageType);
    }

    @Override
    @Nonnull
    public WarehouseTextFluentHelper getAllWarehouseText()
    {
        return new WarehouseTextFluentHelper(servicePath, "WarehouseText");
    }

    @Override
    @Nonnull
    public WarehouseTextByKeyFluentHelper getWarehouseTextByKey( final String language, final String warehouse )
    {
        return new WarehouseTextByKeyFluentHelper(servicePath, "WarehouseText", language, warehouse);
    }

}
