/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBinByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBinFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.batch.DefaultWarehouseStorageBinServiceBatch;

/**
 * <p>
 * This allows you to integrate input help (F4 help) for warehouse storage bins in your mobile apps. It also assists in
 * the process of bin verification during warehouse order processing.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/5d/947af85ab4402c95bdfa57d00b909b/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE_STORAGE_BIN?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE_STORAGE_BIN</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Master Data Integration(SAP_COM_0374)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Storage Bin</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWarehouseStorageBinService" )
@Deprecated
public class DefaultWarehouseStorageBinService implements WarehouseStorageBinService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WarehouseStorageBinService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWarehouseStorageBinService()
    {
        servicePath = WarehouseStorageBinService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWarehouseStorageBinService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehouseStorageBinService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWarehouseStorageBinService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWarehouseStorageBinServiceBatch batch()
    {
        return new DefaultWarehouseStorageBinServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WarehouseStorageBinFluentHelper getAllWarehouseStorageBin()
    {
        return new WarehouseStorageBinFluentHelper(servicePath, "WarehouseStorageBin");
    }

    @Override
    @Nonnull
    public
        WarehouseStorageBinByKeyFluentHelper
        getWarehouseStorageBinByKey( final String warehouse, final String storageBin )
    {
        return new WarehouseStorageBinByKeyFluentHelper(servicePath, "WarehouseStorageBin", warehouse, storageBin);
    }

}
