/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.AssignWarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.CancelWarehouseTaskFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskExactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskHUFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.SetInProcessWarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.UnassignWarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.batch.DefaultWarehouseTaskServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve warehouse orders and warehouse
 * tasks. Apply any of the filters provided or retrieve all existing data. - For existing warehouse orders, you can
 * update the corresponding warehouse tasks. - You can update existing warehouse tasks (confirm, confirm with
 * exceptions, cancel). - You can update existing warehouse orders (assign or unassign warehouse order to warehouse
 * resource). - You can create warehouse tasks (product warehouse tasks, HU warehouse tasks, warehouse tasks for
 * warehouse requests)..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/90/419cedc18a471889c4388de49ad9dc/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE_ORDER_TASK?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE_ORDER_TASK</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Process Warehouse Task Integration(SAP_COM_0353)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWarehouseTaskService" )
@Deprecated
public class DefaultWarehouseTaskService implements WarehouseTaskService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WarehouseTaskService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWarehouseTaskService()
    {
        servicePath = WarehouseTaskService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWarehouseTaskService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehouseTaskService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWarehouseTaskService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWarehouseTaskServiceBatch batch()
    {
        return new DefaultWarehouseTaskServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WarehouseOrderFluentHelper getAllWarehouseOrder()
    {
        return new WarehouseOrderFluentHelper(servicePath, "WarehouseOrder");
    }

    @Override
    @Nonnull
    public WarehouseOrderByKeyFluentHelper getWarehouseOrderByKey( final String warehouse, final String warehouseOrder )
    {
        return new WarehouseOrderByKeyFluentHelper(servicePath, "WarehouseOrder", warehouse, warehouseOrder);
    }

    @Override
    @Nonnull
    public WarehouseOrderCreateFluentHelper createWarehouseOrder( @Nonnull final WarehouseOrder warehouseOrder )
    {
        return new WarehouseOrderCreateFluentHelper(servicePath, warehouseOrder, "WarehouseOrder");
    }

    @Override
    @Nonnull
    public WarehouseTaskFluentHelper getAllWarehouseTask()
    {
        return new WarehouseTaskFluentHelper(servicePath, "WarehouseTask");
    }

    @Override
    @Nonnull
    public
        WarehouseTaskByKeyFluentHelper
        getWarehouseTaskByKey( final String warehouse, final String warehouseTask, final String warehouseTaskItem )
    {
        return new WarehouseTaskByKeyFluentHelper(
            servicePath,
            "WarehouseTask",
            warehouse,
            warehouseTask,
            warehouseTaskItem);
    }

    @Override
    @Nonnull
    public WarehouseTaskCreateFluentHelper createWarehouseTask( @Nonnull final WarehouseTask warehouseTask )
    {
        return new WarehouseTaskCreateFluentHelper(servicePath, warehouseTask, "WarehouseTask");
    }

    @Override
    @Nonnull
    public WarehouseTaskExceptionCodeFluentHelper getAllWarehouseTaskExceptionCode()
    {
        return new WarehouseTaskExceptionCodeFluentHelper(servicePath, "WarehouseTaskExceptionCode");
    }

    @Override
    @Nonnull
    public WarehouseTaskExceptionCodeByKeyFluentHelper getWarehouseTaskExceptionCodeByKey(
        final String warehouse,
        final String warehouseTask,
        final String warehouseTaskItem,
        final String warehouseTaskExceptionCode,
        final String businessContext,
        final String businessContextExecutionStep )
    {
        return new WarehouseTaskExceptionCodeByKeyFluentHelper(
            servicePath,
            "WarehouseTaskExceptionCode",
            warehouse,
            warehouseTask,
            warehouseTaskItem,
            warehouseTaskExceptionCode,
            businessContext,
            businessContextExecutionStep);
    }

    @Override
    @Nonnull
    public AssignWarehouseOrderFluentHelper assignWarehouseOrder(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseOrder,
        @Nullable final String warehouseResource )
    {
        return new AssignWarehouseOrderFluentHelper(servicePath, warehouse, warehouseOrder, warehouseResource);
    }

    @Override
    @Nonnull
    public
        SetInProcessWarehouseOrderFluentHelper
        setInProcessWarehouseOrder( @Nonnull final String warehouse, @Nonnull final String warehouseOrder )
    {
        return new SetInProcessWarehouseOrderFluentHelper(servicePath, warehouse, warehouseOrder);
    }

    @Override
    @Nonnull
    public
        UnassignWarehouseOrderFluentHelper
        unassignWarehouseOrder( @Nonnull final String warehouse, @Nonnull final String warehouseOrder )
    {
        return new UnassignWarehouseOrderFluentHelper(servicePath, warehouse, warehouseOrder);
    }

    @Override
    @Nonnull
    public CancelWarehouseTaskFluentHelper cancelWarehouseTask(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem )
    {
        return new CancelWarehouseTaskFluentHelper(servicePath, warehouse, warehouseTask, warehouseTaskItem);
    }

    @Override
    @Nonnull
    public ConfirmWarehouseTaskExactFluentHelper confirmWarehouseTaskExact(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem )
    {
        return new ConfirmWarehouseTaskExactFluentHelper(servicePath, warehouse, warehouseTask, warehouseTaskItem);
    }

    @Override
    @Nonnull
    public ConfirmWarehouseTaskHUFluentHelper confirmWarehouseTaskHU(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem,
        @Nullable final String destinationStorageBin,
        @Nullable final String whseTaskExCodeDestStorageBin )
    {
        return new ConfirmWarehouseTaskHUFluentHelper(
            servicePath,
            warehouse,
            warehouseTask,
            warehouseTaskItem,
            destinationStorageBin,
            whseTaskExCodeDestStorageBin);
    }

    @Override
    @Nonnull
    public ConfirmWarehouseTaskProductFluentHelper confirmWarehouseTaskProduct(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem,
        @Nullable final String alternativeUnit,
        @Nullable final BigDecimal actualQuantityInAltvUnit,
        @Nullable final BigDecimal differenceQuantityInAltvUnit,
        @Nullable final String whseTaskExceptionCodeQtyDiff,
        @Nullable final String destinationStorageBin,
        @Nullable final String whseTaskExCodeDestStorageBin,
        @Nullable final String sourceHandlingUnit )
    {
        return new ConfirmWarehouseTaskProductFluentHelper(
            servicePath,
            warehouse,
            warehouseTask,
            warehouseTaskItem,
            alternativeUnit,
            actualQuantityInAltvUnit,
            differenceQuantityInAltvUnit,
            whseTaskExceptionCodeQtyDiff,
            destinationStorageBin,
            whseTaskExCodeDestStorageBin,
            sourceHandlingUnit);
    }

}
