/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.batch.DefaultWorkCenterDataServiceBatch;

/**
 * <p>
 *
 * This service is based on OData protocol and can be consumed in Fiori apps and on other user interfaces. It enables
 * you to create, read and update work centers. The service contains work center header, work center description, cost
 * center allocation, capacity assignment, capacity header, capacity description, capacity intervals, capacity shifts,
 * queuing operations, today’s operation, capacity per bucket and capacity order per bucket..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/62/ec4758c3f90a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WORK_CENTERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WORK_CENTERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Work Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWorkCenterDataService" )
@Deprecated
public class DefaultWorkCenterDataService implements WorkCenterDataService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WorkCenterDataService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWorkCenterDataService()
    {
        servicePath = WorkCenterDataService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWorkCenterDataService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWorkCenterDataService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWorkCenterDataService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWorkCenterDataServiceBatch batch()
    {
        return new DefaultWorkCenterDataServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public WorkCenterAllCapacityFluentHelper getAllWorkCenterAllCapacity()
    {
        return new WorkCenterAllCapacityFluentHelper(servicePath, "A_WorkCenterAllCapacity");
    }

    @Override
    @Nonnull
    public WorkCenterAllCapacityByKeyFluentHelper getWorkCenterAllCapacityByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityInternalID,
        final String capacityCategoryAllocation )
    {
        return new WorkCenterAllCapacityByKeyFluentHelper(
            servicePath,
            "A_WorkCenterAllCapacity",
            workCenterInternalID,
            workCenterTypeCode,
            capacityInternalID,
            capacityCategoryAllocation);
    }

    @Override
    @Nonnull
    public WorkCenterAllCapacityCreateFluentHelper createWorkCenterAllCapacity(
        @Nonnull final WorkCenterAllCapacity workCenterAllCapacity )
    {
        return new WorkCenterAllCapacityCreateFluentHelper(
            servicePath,
            workCenterAllCapacity,
            "A_WorkCenterAllCapacity");
    }

    @Override
    @Nonnull
    public WorkCenterAllCapacity_2FluentHelper getAllWorkCenterAllCapacity_2()
    {
        return new WorkCenterAllCapacity_2FluentHelper(servicePath, "A_WorkCenterAllCapacity_2");
    }

    @Override
    @Nonnull
    public WorkCenterAllCapacity_2ByKeyFluentHelper getWorkCenterAllCapacity_2ByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation )
    {
        return new WorkCenterAllCapacity_2ByKeyFluentHelper(
            servicePath,
            "A_WorkCenterAllCapacity_2",
            workCenterInternalID,
            workCenterTypeCode,
            capacityCategoryAllocation);
    }

    @Override
    @Nonnull
    public WorkCenterAllCapacity_2CreateFluentHelper createWorkCenterAllCapacity_2(
        @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 )
    {
        return new WorkCenterAllCapacity_2CreateFluentHelper(
            servicePath,
            workCenterAllCapacity_2,
            "A_WorkCenterAllCapacity_2");
    }

    @Override
    @Nonnull
    public WorkCenterAllCapacity_2UpdateFluentHelper updateWorkCenterAllCapacity_2(
        @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 )
    {
        return new WorkCenterAllCapacity_2UpdateFluentHelper(
            servicePath,
            workCenterAllCapacity_2,
            "A_WorkCenterAllCapacity_2");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityFluentHelper getAllWorkCenterCapacity()
    {
        return new WorkCenterCapacityFluentHelper(servicePath, "A_WorkCenterCapacity");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityByKeyFluentHelper getWorkCenterCapacityByKey( final String capacityInternalID )
    {
        return new WorkCenterCapacityByKeyFluentHelper(servicePath, "A_WorkCenterCapacity", capacityInternalID);
    }

    @Override
    @Nonnull
    public WorkCenterCapacityCreateFluentHelper createWorkCenterCapacity(
        @Nonnull final WorkCenterCapacity workCenterCapacity )
    {
        return new WorkCenterCapacityCreateFluentHelper(servicePath, workCenterCapacity, "A_WorkCenterCapacity");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityUpdateFluentHelper updateWorkCenterCapacity(
        @Nonnull final WorkCenterCapacity workCenterCapacity )
    {
        return new WorkCenterCapacityUpdateFluentHelper(servicePath, workCenterCapacity, "A_WorkCenterCapacity");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityIntervalFluentHelper getAllWorkCenterCapacityInterval()
    {
        return new WorkCenterCapacityIntervalFluentHelper(servicePath, "A_WorkCenterCapacityInterval");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityIntervalByKeyFluentHelper getWorkCenterCapacityIntervalByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation,
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate )
    {
        return new WorkCenterCapacityIntervalByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapacityInterval",
            workCenterInternalID,
            workCenterTypeCode,
            capacityCategoryAllocation,
            capacityInternalID,
            capacityActiveVersion,
            intervalEndDate);
    }

    @Override
    @Nonnull
    public WorkCenterCapacityIntervalCreateFluentHelper createWorkCenterCapacityInterval(
        @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval )
    {
        return new WorkCenterCapacityIntervalCreateFluentHelper(
            servicePath,
            workCenterCapacityInterval,
            "A_WorkCenterCapacityInterval");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityIntervalUpdateFluentHelper updateWorkCenterCapacityInterval(
        @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval )
    {
        return new WorkCenterCapacityIntervalUpdateFluentHelper(
            servicePath,
            workCenterCapacityInterval,
            "A_WorkCenterCapacityInterval");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityInterval_2FluentHelper getAllWorkCenterCapacityInterval_2()
    {
        return new WorkCenterCapacityInterval_2FluentHelper(servicePath, "A_WorkCenterCapacityInterval_2");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityInterval_2ByKeyFluentHelper getWorkCenterCapacityInterval_2ByKey(
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate )
    {
        return new WorkCenterCapacityInterval_2ByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapacityInterval_2",
            capacityInternalID,
            capacityActiveVersion,
            intervalEndDate);
    }

    @Override
    @Nonnull
    public WorkCenterCapacityInterval_2CreateFluentHelper createWorkCenterCapacityInterval_2(
        @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 )
    {
        return new WorkCenterCapacityInterval_2CreateFluentHelper(
            servicePath,
            workCenterCapacityInterval_2,
            "A_WorkCenterCapacityInterval_2");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityInterval_2UpdateFluentHelper updateWorkCenterCapacityInterval_2(
        @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 )
    {
        return new WorkCenterCapacityInterval_2UpdateFluentHelper(
            servicePath,
            workCenterCapacityInterval_2,
            "A_WorkCenterCapacityInterval_2");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShiftFluentHelper getAllWorkCenterCapacityShift()
    {
        return new WorkCenterCapacityShiftFluentHelper(servicePath, "A_WorkCenterCapacityShift");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShiftByKeyFluentHelper getWorkCenterCapacityShiftByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation,
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate,
        final String weekDay,
        final String availableCapacityShift )
    {
        return new WorkCenterCapacityShiftByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapacityShift",
            workCenterInternalID,
            workCenterTypeCode,
            capacityCategoryAllocation,
            capacityInternalID,
            capacityActiveVersion,
            intervalEndDate,
            weekDay,
            availableCapacityShift);
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShiftCreateFluentHelper createWorkCenterCapacityShift(
        @Nonnull final WorkCenterCapacityShift workCenterCapacityShift )
    {
        return new WorkCenterCapacityShiftCreateFluentHelper(
            servicePath,
            workCenterCapacityShift,
            "A_WorkCenterCapacityShift");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShiftUpdateFluentHelper updateWorkCenterCapacityShift(
        @Nonnull final WorkCenterCapacityShift workCenterCapacityShift )
    {
        return new WorkCenterCapacityShiftUpdateFluentHelper(
            servicePath,
            workCenterCapacityShift,
            "A_WorkCenterCapacityShift");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShift_2FluentHelper getAllWorkCenterCapacityShift_2()
    {
        return new WorkCenterCapacityShift_2FluentHelper(servicePath, "A_WorkCenterCapacityShift_2");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShift_2ByKeyFluentHelper getWorkCenterCapacityShift_2ByKey(
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate,
        final String weekDay,
        final String availableCapacityShift )
    {
        return new WorkCenterCapacityShift_2ByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapacityShift_2",
            capacityInternalID,
            capacityActiveVersion,
            intervalEndDate,
            weekDay,
            availableCapacityShift);
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShift_2CreateFluentHelper createWorkCenterCapacityShift_2(
        @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 )
    {
        return new WorkCenterCapacityShift_2CreateFluentHelper(
            servicePath,
            workCenterCapacityShift_2,
            "A_WorkCenterCapacityShift_2");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityShift_2UpdateFluentHelper updateWorkCenterCapacityShift_2(
        @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 )
    {
        return new WorkCenterCapacityShift_2UpdateFluentHelper(
            servicePath,
            workCenterCapacityShift_2,
            "A_WorkCenterCapacityShift_2");
    }

    @Override
    @Nonnull
    public WorkCenterCapacityTextFluentHelper getAllWorkCenterCapacityText()
    {
        return new WorkCenterCapacityTextFluentHelper(servicePath, "A_WorkCenterCapacityText");
    }

    @Override
    @Nonnull
    public
        WorkCenterCapacityTextByKeyFluentHelper
        getWorkCenterCapacityTextByKey( final String capacityInternalID, final String language )
    {
        return new WorkCenterCapacityTextByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapacityText",
            capacityInternalID,
            language);
    }

    @Override
    @Nonnull
    public WorkCenterCapacityTextUpdateFluentHelper updateWorkCenterCapacityText(
        @Nonnull final WorkCenterCapacityText workCenterCapacityText )
    {
        return new WorkCenterCapacityTextUpdateFluentHelper(
            servicePath,
            workCenterCapacityText,
            "A_WorkCenterCapacityText");
    }

    @Override
    @Nonnull
    public WorkCenterCapDayOpFluentHelper getAllWorkCenterCapDayOp()
    {
        return new WorkCenterCapDayOpFluentHelper(servicePath, "A_WorkCenterCapDayOp");
    }

    @Override
    @Nonnull
    public WorkCenterCapDayOpByKeyFluentHelper getWorkCenterCapDayOpByKey(
        final String plant,
        final String mRPController,
        final String workCenter,
        final String capacityInternalID,
        final String capacityRequirement,
        final String material,
        final String orderID,
        final String operation )
    {
        return new WorkCenterCapDayOpByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapDayOp",
            plant,
            mRPController,
            workCenter,
            capacityInternalID,
            capacityRequirement,
            material,
            orderID,
            operation);
    }

    @Override
    @Nonnull
    public WorkCenterCapOrderPerBucketParametersByKeyFluentHelper getWorkCenterCapOrderPerBucketParametersByKey(
        final LocalDateTime p_CapEvalStartDate,
        final LocalDateTime p_CapEvalEndDate,
        final String p_CapEvalBucketType )
    {
        return new WorkCenterCapOrderPerBucketParametersByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapOrderPerBucket",
            p_CapEvalStartDate,
            p_CapEvalEndDate,
            p_CapEvalBucketType);
    }

    @Override
    @Nonnull
    public WorkCenterCapPerBucketParametersByKeyFluentHelper getWorkCenterCapPerBucketParametersByKey(
        final LocalDateTime p_CapEvalStartDate,
        final LocalDateTime p_CapEvalEndDate,
        final String p_CapEvalBucketType )
    {
        return new WorkCenterCapPerBucketParametersByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapPerBucket",
            p_CapEvalStartDate,
            p_CapEvalEndDate,
            p_CapEvalBucketType);
    }

    @Override
    @Nonnull
    public WorkCenterCapPplineOpFluentHelper getAllWorkCenterCapPplineOp()
    {
        return new WorkCenterCapPplineOpFluentHelper(servicePath, "A_WorkCenterCapPplineOp");
    }

    @Override
    @Nonnull
    public WorkCenterCapPplineOpByKeyFluentHelper getWorkCenterCapPplineOpByKey(
        final String plant,
        final String mRPController,
        final String workCenter,
        final String capacityInternalID,
        final String capacityRequirement,
        final String material,
        final String orderID,
        final String operation )
    {
        return new WorkCenterCapPplineOpByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCapPplineOp",
            plant,
            mRPController,
            workCenter,
            capacityInternalID,
            capacityRequirement,
            material,
            orderID,
            operation);
    }

    @Override
    @Nonnull
    public WorkCenterCostCenterFluentHelper getAllWorkCenterCostCenter()
    {
        return new WorkCenterCostCenterFluentHelper(servicePath, "A_WorkCenterCostCenter");
    }

    @Override
    @Nonnull
    public WorkCenterCostCenterByKeyFluentHelper getWorkCenterCostCenterByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String costCenterAllocation,
        final LocalDateTime validityEndDate )
    {
        return new WorkCenterCostCenterByKeyFluentHelper(
            servicePath,
            "A_WorkCenterCostCenter",
            workCenterInternalID,
            workCenterTypeCode,
            costCenterAllocation,
            validityEndDate);
    }

    @Override
    @Nonnull
    public WorkCenterCostCenterCreateFluentHelper createWorkCenterCostCenter(
        @Nonnull final WorkCenterCostCenter workCenterCostCenter )
    {
        return new WorkCenterCostCenterCreateFluentHelper(servicePath, workCenterCostCenter, "A_WorkCenterCostCenter");
    }

    @Override
    @Nonnull
    public WorkCenterCostCenterUpdateFluentHelper updateWorkCenterCostCenter(
        @Nonnull final WorkCenterCostCenter workCenterCostCenter )
    {
        return new WorkCenterCostCenterUpdateFluentHelper(servicePath, workCenterCostCenter, "A_WorkCenterCostCenter");
    }

    @Override
    @Nonnull
    public WorkCenterDayOperationFluentHelper getAllWorkCenterDayOperation()
    {
        return new WorkCenterDayOperationFluentHelper(servicePath, "A_WorkCenterDayOperation");
    }

    @Override
    @Nonnull
    public WorkCenterDayOperationByKeyFluentHelper getWorkCenterDayOperationByKey(
        final String workCenterInternalID,
        final String manufacturingOrder,
        final String manufacturingOrderOperation,
        final String manufacturingOrderCategory )
    {
        return new WorkCenterDayOperationByKeyFluentHelper(
            servicePath,
            "A_WorkCenterDayOperation",
            workCenterInternalID,
            manufacturingOrder,
            manufacturingOrderOperation,
            manufacturingOrderCategory);
    }

    @Override
    @Nonnull
    public WorkCenterDescriptionFluentHelper getAllWorkCenterDescription()
    {
        return new WorkCenterDescriptionFluentHelper(servicePath, "A_WorkCenterDescription");
    }

    @Override
    @Nonnull
    public WorkCenterDescriptionByKeyFluentHelper getWorkCenterDescriptionByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String language )
    {
        return new WorkCenterDescriptionByKeyFluentHelper(
            servicePath,
            "A_WorkCenterDescription",
            workCenterInternalID,
            workCenterTypeCode,
            language);
    }

    @Override
    @Nonnull
    public WorkCenterDescriptionUpdateFluentHelper updateWorkCenterDescription(
        @Nonnull final WorkCenterDescription workCenterDescription )
    {
        return new WorkCenterDescriptionUpdateFluentHelper(
            servicePath,
            workCenterDescription,
            "A_WorkCenterDescription");
    }

    @Override
    @Nonnull
    public WorkCenterPipeLineOperationFluentHelper getAllWorkCenterPipeLineOperation()
    {
        return new WorkCenterPipeLineOperationFluentHelper(servicePath, "A_WorkCenterPipeLineOperation");
    }

    @Override
    @Nonnull
    public WorkCenterPipeLineOperationByKeyFluentHelper getWorkCenterPipeLineOperationByKey(
        final String workCenterInternalID,
        final String manufacturingOrder,
        final String manufacturingOrderOperation,
        final String manufacturingOrderCategory )
    {
        return new WorkCenterPipeLineOperationByKeyFluentHelper(
            servicePath,
            "A_WorkCenterPipeLineOperation",
            workCenterInternalID,
            manufacturingOrder,
            manufacturingOrderOperation,
            manufacturingOrderCategory);
    }

    @Override
    @Nonnull
    public WorkCentersFluentHelper getAllWorkCenters()
    {
        return new WorkCentersFluentHelper(servicePath, "A_WorkCenters");
    }

    @Override
    @Nonnull
    public
        WorkCentersByKeyFluentHelper
        getWorkCentersByKey( final String workCenterInternalID, final String workCenterTypeCode )
    {
        return new WorkCentersByKeyFluentHelper(servicePath, "A_WorkCenters", workCenterInternalID, workCenterTypeCode);
    }

    @Override
    @Nonnull
    public WorkCentersCreateFluentHelper createWorkCenters( @Nonnull final WorkCenters workCenters )
    {
        return new WorkCentersCreateFluentHelper(servicePath, workCenters, "A_WorkCenters");
    }

    @Override
    @Nonnull
    public WorkCentersUpdateFluentHelper updateWorkCenters( @Nonnull final WorkCenters workCenters )
    {
        return new WorkCentersUpdateFluentHelper(servicePath, workCenters, "A_WorkCenters");
    }

}
