/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.batch.DefaultWorkforceAvailabilityServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the (CRUD) daily availability information into the
 * S/4HANA system from your external HR system when you are not using the SAP SuccessFactors Employee Central system.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b1/d0a7e300b244dda5f77890ba66ba82/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MANAGE_WF_AVAILABILITY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MANAGE_WF_AVAILABILITY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Employee Integration(SAP_COM_0001), External HR Workforce Integration(SAP_COM_0301), Employee Central via SAP CPI
 * Integration(SAP_COM_0535), Employee Central Integration(SAP_COM_1001)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/JB1'>Core HR with SAP SuccessFactors Employee Central(JB1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FD'>Employee Integration - SAP S/4HANA Enablement(1FD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OFD'>Employee Integration - SAP S/4HANA Enablement(OFD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AJ'>Financial Master Data for SAP SuccessFactors Employee
 * Central(4AJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Workforce Person</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWorkforceAvailabilityService" )
@Deprecated
public class DefaultWorkforceAvailabilityService implements WorkforceAvailabilityService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WorkforceAvailabilityService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWorkforceAvailabilityService()
    {
        servicePath = WorkforceAvailabilityService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWorkforceAvailabilityService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWorkforceAvailabilityService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWorkforceAvailabilityService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWorkforceAvailabilityServiceBatch batch()
    {
        return new DefaultWorkforceAvailabilityServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public TimeOverviewFluentHelper getAllTimeOverview()
    {
        return new TimeOverviewFluentHelper(servicePath, "TimeOverviewSet");
    }

    @Override
    @Nonnull
    public TimeOverviewByKeyFluentHelper getTimeOverviewByKey(
        final String personworkagreementexternalid,
        final String companycode,
        final LocalDateTime calendardate )
    {
        return new TimeOverviewByKeyFluentHelper(
            servicePath,
            "TimeOverviewSet",
            personworkagreementexternalid,
            companycode,
            calendardate);
    }

    @Override
    @Nonnull
    public TimeOverviewCreateFluentHelper createTimeOverview( @Nonnull final TimeOverview timeOverview )
    {
        return new TimeOverviewCreateFluentHelper(servicePath, timeOverview, "TimeOverviewSet");
    }

    @Override
    @Nonnull
    public TimeOverviewUpdateFluentHelper updateTimeOverview( @Nonnull final TimeOverview timeOverview )
    {
        return new TimeOverviewUpdateFluentHelper(servicePath, timeOverview, "TimeOverviewSet");
    }

    @Override
    @Nonnull
    public TimeOverviewDeleteFluentHelper deleteTimeOverview( @Nonnull final TimeOverview timeOverview )
    {
        return new TimeOverviewDeleteFluentHelper(servicePath, timeOverview, "TimeOverviewSet");
    }

}
