/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__CurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__CurrencyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__CurrencyDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__CurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__CurrencyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelpDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTagByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTagCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTagDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTagFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.batch.DefaultWorkforcePersonSkilltagServiceBatch;

/**
 * <p>
 *
 * This service enables you to read,add or delete skilltag information of a person to the S/4HANA system. The skill tag
 * information would enable to staff the employees effectively based on the skill set required. The Manage Workforce
 * Person SkillTag service is based on the OData protocol, and can be consumed in Fiori apps and on other user
 * interfaces. The service contains the SkillTag node. When you use the service with proper authorization, the payload
 * information you send in the request is stored in the S/4HANA system. Once the SkillTag data has been successfully
 * created or deleted, the relevant data is sent in the response. In case of issues, the system displays error messages
 * in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/02/0fc037c7c24657912e88a055187f5a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MANAGE_SKILLTAGS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MANAGE_SKILLTAGS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>External HR Workforce Integration(SAP_COM_0301)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1FD'>Employee Integration - SAP S/4HANA Enablement(1FD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OFD'>Employee Integration - SAP S/4HANA Enablement(OFD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWorkforcePersonSkilltagService" )
@Deprecated
public class DefaultWorkforcePersonSkilltagService implements WorkforcePersonSkilltagService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WorkforcePersonSkilltagService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWorkforcePersonSkilltagService()
    {
        servicePath = WorkforcePersonSkilltagService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWorkforcePersonSkilltagService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWorkforcePersonSkilltagService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWorkforcePersonSkilltagService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWorkforcePersonSkilltagServiceBatch batch()
    {
        return new DefaultWorkforcePersonSkilltagServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SAP__ValueHelpFluentHelper getAllSAP__ValueHelp()
    {
        return new SAP__ValueHelpFluentHelper(servicePath, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpByKeyFluentHelper getSAP__ValueHelpByKey( final String vALUEHELP )
    {
        return new SAP__ValueHelpByKeyFluentHelper(servicePath, "SAP__ValueHelpSet", vALUEHELP);
    }

    @Override
    @Nonnull
    public SAP__ValueHelpCreateFluentHelper createSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpCreateFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpUpdateFluentHelper updateSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpUpdateFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SAP__ValueHelpDeleteFluentHelper deleteSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return new SAP__ValueHelpDeleteFluentHelper(servicePath, sAP__ValueHelp, "SAP__ValueHelpSet");
    }

    @Override
    @Nonnull
    public SkillTagFluentHelper getAllSkillTag()
    {
        return new SkillTagFluentHelper(servicePath, "SkillTagSet");
    }

    @Override
    @Nonnull
    public SkillTagByKeyFluentHelper getSkillTagByKey( final String personExternalId )
    {
        return new SkillTagByKeyFluentHelper(servicePath, "SkillTagSet", personExternalId);
    }

    @Override
    @Nonnull
    public SkillTagCreateFluentHelper createSkillTag( @Nonnull final SkillTag skillTag )
    {
        return new SkillTagCreateFluentHelper(servicePath, skillTag, "SkillTagSet");
    }

    @Override
    @Nonnull
    public SkillTagDeleteFluentHelper deleteSkillTag( @Nonnull final SkillTag skillTag )
    {
        return new SkillTagDeleteFluentHelper(servicePath, skillTag, "SkillTagSet");
    }

    @Override
    @Nonnull
    public SAP__CurrencyFluentHelper getAllSAP__Currency()
    {
        return new SAP__CurrencyFluentHelper(servicePath, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyByKeyFluentHelper getSAP__CurrencyByKey( final String currencyCode )
    {
        return new SAP__CurrencyByKeyFluentHelper(servicePath, "SAP__Currencies", currencyCode);
    }

    @Override
    @Nonnull
    public SAP__CurrencyCreateFluentHelper createSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyCreateFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyUpdateFluentHelper updateSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyUpdateFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__CurrencyDeleteFluentHelper deleteSAP__Currency( @Nonnull final SAP__Currency sAP__Currency )
    {
        return new SAP__CurrencyDeleteFluentHelper(servicePath, sAP__Currency, "SAP__Currencies");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureFluentHelper getAllSAP__UnitOfMeasure()
    {
        return new SAP__UnitOfMeasureFluentHelper(servicePath, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureByKeyFluentHelper getSAP__UnitOfMeasureByKey( final String unitCode )
    {
        return new SAP__UnitOfMeasureByKeyFluentHelper(servicePath, "SAP__UnitsOfMeasure", unitCode);
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureCreateFluentHelper createSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureCreateFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureUpdateFluentHelper updateSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureUpdateFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__UnitOfMeasureDeleteFluentHelper deleteSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return new SAP__UnitOfMeasureDeleteFluentHelper(servicePath, sAP__UnitOfMeasure, "SAP__UnitsOfMeasure");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionFluentHelper getAllSAP__DocumentDescription()
    {
        return new SAP__DocumentDescriptionFluentHelper(servicePath, "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionByKeyFluentHelper getSAP__DocumentDescriptionByKey( final UUID id )
    {
        return new SAP__DocumentDescriptionByKeyFluentHelper(servicePath, "SAP__MyDocumentDescriptions", id);
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionCreateFluentHelper createSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionCreateFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionUpdateFluentHelper updateSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionUpdateFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

    @Override
    @Nonnull
    public SAP__DocumentDescriptionDeleteFluentHelper deleteSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return new SAP__DocumentDescriptionDeleteFluentHelper(
            servicePath,
            sAP__DocumentDescription,
            "SAP__MyDocumentDescriptions");
    }

}
