/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.batch.DefaultWorkforceTimesheetServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete (CRUD) data related to timesheet of a workforce
 * (Employees or Contingent Workers) with the data provided in a payload, in an API call. This service also supports
 * automatic posting of timesheet data to the controlling module synchronously.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fa/198e62c6d24788bd1f82082feb3096/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MANAGE_WORKFORCE_TIMESHEET?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MANAGE_WORKFORCE_TIMESHEET</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Workforce Timesheet Integration(SAP_COM_0027)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Q4'>Time Recording(1Q4)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J12'>Time Recording - Project-Based Services(J12)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OQ4'>Time Recording(OQ4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>TimeSheet</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultWorkforceTimesheetService" )
@Deprecated
public class DefaultWorkforceTimesheetService implements WorkforceTimesheetService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link WorkforceTimesheetService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultWorkforceTimesheetService()
    {
        servicePath = WorkforceTimesheetService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultWorkforceTimesheetService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWorkforceTimesheetService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultWorkforceTimesheetService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultWorkforceTimesheetServiceBatch batch()
    {
        return new DefaultWorkforceTimesheetServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public TimeSheetEntryFluentHelper getAllTimeSheetEntry()
    {
        return new TimeSheetEntryFluentHelper(servicePath, "TimeSheetEntryCollection");
    }

    @Override
    @Nonnull
    public TimeSheetEntryByKeyFluentHelper getTimeSheetEntryByKey(
        final String personWorkAgreementExternalID,
        final String companyCode,
        final String timeSheetRecord )
    {
        return new TimeSheetEntryByKeyFluentHelper(
            servicePath,
            "TimeSheetEntryCollection",
            personWorkAgreementExternalID,
            companyCode,
            timeSheetRecord);
    }

    @Override
    @Nonnull
    public TimeSheetEntryCreateFluentHelper createTimeSheetEntry( @Nonnull final TimeSheetEntry timeSheetEntry )
    {
        return new TimeSheetEntryCreateFluentHelper(servicePath, timeSheetEntry, "TimeSheetEntryCollection");
    }

}
