/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.batch.DefectCodeAndCodeGroupServiceBatch;

/**
 * <p>
 *
 * This service is related to the business object Defect. The combination of defect code group and code uniquely
 * identifies the type of the defect in Quality Management in a coded format..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/74/a58fee8d5546c389ac5c52fc906da9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEFECTCODE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEFECTCODE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Notification and Defect Processing Integration(SAP_COM_0153)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Defect</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface DefectCodeAndCodeGroupService extends BatchService<DefectCodeAndCodeGroupServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_DEFECTCODE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    DefectCodeAndCodeGroupService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode
     * DefectCode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode DefectCode}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeFluentHelper getAllDefectCode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode
     * DefectCode} entity using key fields.
     *
     * @param defectCode
     *            Defect Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param defectCodeGroup
     *            Defect Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCode DefectCode}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeByKeyFluentHelper getDefectCodeByKey( final String defectCodeGroup, final String defectCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroup
     * DefectCodeGroup} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroup
     *         DefectCodeGroup} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeGroupFluentHelper getAllDefectCodeGroup();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroup
     * DefectCodeGroup} entity using key fields.
     *
     * @param defectCodeGroup
     *            Defect Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroup
     *         DefectCodeGroup} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeGroupByKeyFluentHelper getDefectCodeGroupByKey( final String defectCodeGroup );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText
     * DefectCodeGroupText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText
     *         DefectCodeGroupText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeGroupTextFluentHelper getAllDefectCodeGroupText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText
     * DefectCodeGroupText} entity using key fields.
     *
     * @param defectCodeGroup
     *            Defect Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupText
     *         DefectCodeGroupText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeGroupTextByKeyFluentHelper
        getDefectCodeGroupTextByKey( final String defectCodeGroup, final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText
     * DefectCodeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText
     *         DefectCodeText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeTextFluentHelper getAllDefectCodeText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText
     * DefectCodeText} entity using key fields.
     *
     * @param defectCode
     *            Defect Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param defectCodeGroup
     *            Defect Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeText
     *         DefectCodeText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCodeTextByKeyFluentHelper
        getDefectCodeTextByKey( final String defectCodeGroup, final String defectCode, final String language );

}
