/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.batch.DefectProcessingServiceBatch;

/**
 * <p>
 *
 * A defect is a deviation due to which a quality requirement cannot be fulfilled.
 *
 * This service enables you to record or process defects of different defect categories. Depending on the defect
 * category different properties are mandatory for creating the defect. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1f/88e2e4ccfd4f50a6646284a6f51bc6/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEFECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEFECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Notification and Defect Processing Integration(SAP_COM_0153)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Defect</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the
 *             <a href="https://api.sap.com/api/DEFECT_0001"> successor API</a> instead.
 */
@Deprecated
public interface DefectProcessingService extends BatchService<DefectProcessingServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_DEFECT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    DefectProcessingService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectFluentHelper getAllDefect();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     * using key fields.
     *
     * @param defectInternalID
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectByKeyFluentHelper getDefectByKey( final String defectInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     * and save it to the S/4HANA system.
     *
     * @param defect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectCreateFluentHelper createDefect( @Nonnull final Defect defect );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect}
     * entity and save it to the S/4HANA system.
     *
     * @param defect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectUpdateFluentHelper updateDefect( @Nonnull final Defect defect );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect}
     * entity in the S/4HANA system.
     *
     * @param defect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity
     *            object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect Defect} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DefectDeleteFluentHelper deleteDefect( @Nonnull final Defect defect );

}
