/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.batch.DocumentManagementServiceBatch;

/**
 * <p>
 *
 * The service contains header data of the document info record (DIR), description, object link information for BOM,
 * product, and change record, classification details for class and characteristics, and value help for document status
 * as nodes.
 *
 * All the information can be sent as part of the request payload, which is then used to maintain the DIR, including
 * appropriate checks for restricted values and authorizations. The data associated to the document info record is sent
 * in the response. If there are any issues in the request such as wrong values or insufficient information, the system
 * displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e5/e3aa41c5924883a543c7d751693ab0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DMS_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DMS_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Document Info Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface DocumentManagementService extends BatchService<DocumentManagementServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_DMS_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    DocumentManagementService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOM
     * DocInfoRecdObjLinkBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOM
     *         DocInfoRecdObjLinkBOM} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkBOMFluentHelper getAllDocInfoRecdObjLinkBOM();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOM
     * DocInfoRecdObjLinkBOM} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param linkedSAPObjectKey
     *            Document Management Object Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param docObjectLinkCounter
     *            Counter key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param linkedSAPObject
     *            Linked SAP Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOM
     *         DocInfoRecdObjLinkBOM} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkBOMByKeyFluentHelper getDocInfoRecdObjLinkBOMByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String linkedSAPObject,
        final String linkedSAPObjectKey,
        final String docObjectLinkCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd
     * DocInfoRecdObjLinkChgRecd} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd
     *         DocInfoRecdObjLinkChgRecd} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkChgRecdFluentHelper getAllDocInfoRecdObjLinkChgRecd();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd
     * DocInfoRecdObjLinkChgRecd} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param linkedSAPObjectKey
     *            Document Management Object Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param docObjectLinkCounter
     *            Counter key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param linkedSAPObject
     *            Linked SAP Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd
     *         DocInfoRecdObjLinkChgRecd} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecdByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkChgRecdByKeyFluentHelper getDocInfoRecdObjLinkChgRecdByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String linkedSAPObject,
        final String linkedSAPObjectKey,
        final String docObjectLinkCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     * DocInfoRecdObjLinkProduct} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *         DocInfoRecdObjLinkProduct} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkProductFluentHelper getAllDocInfoRecdObjLinkProduct();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     * DocInfoRecdObjLinkProduct} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param linkedSAPObjectKey
     *            Document Management Object Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param docObjectLinkCounter
     *            Counter key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param linkedSAPObject
     *            Linked SAP Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *         DocInfoRecdObjLinkProduct} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkProductByKeyFluentHelper getDocInfoRecdObjLinkProductByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String linkedSAPObject,
        final String linkedSAPObjectKey,
        final String docObjectLinkCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     * DocInfoRecdObjLinkProduct} entity and save it to the S/4HANA system.
     *
     * @param docInfoRecdObjLinkProduct
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *            DocInfoRecdObjLinkProduct} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *         DocInfoRecdObjLinkProduct} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkProductCreateFluentHelper
        createDocInfoRecdObjLinkProduct( @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     * DocInfoRecdObjLinkProduct} entity in the S/4HANA system.
     *
     * @param docInfoRecdObjLinkProduct
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *            DocInfoRecdObjLinkProduct} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *         DocInfoRecdObjLinkProduct} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocInfoRecdObjLinkProductDeleteFluentHelper
        deleteDocInfoRecdObjLinkProduct( @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     * DocumentInfoRecord} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *         DocumentInfoRecord} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordFluentHelper getAllDocumentInfoRecord();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     * DocumentInfoRecord} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *         DocumentInfoRecord} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordByKeyFluentHelper getDocumentInfoRecordByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocPart );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     * DocumentInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *            DocumentInfoRecord} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *         DocumentInfoRecord} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordCreateFluentHelper
        createDocumentInfoRecord( @Nonnull final DocumentInfoRecord documentInfoRecord );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     * DocumentInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *            DocumentInfoRecord} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *         DocumentInfoRecord} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordUpdateFluentHelper
        updateDocumentInfoRecord( @Nonnull final DocumentInfoRecord documentInfoRecord );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharc
     * DocumentInfoRecordCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharc
     *         DocumentInfoRecordCharc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordCharcFluentHelper getAllDocumentInfoRecordCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharc
     * DocumentInfoRecordCharc} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharc
     *         DocumentInfoRecordCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordCharcByKeyFluentHelper getDocumentInfoRecordCharcByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String charcInternalID,
        final String classType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue
     * DocumentInfoRecordCharcValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue
     *         DocumentInfoRecordCharcValue} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordCharcValueFluentHelper getAllDocumentInfoRecordCharcValue();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue
     * DocumentInfoRecordCharcValue} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue
     *         DocumentInfoRecordCharcValue} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordCharcValueByKeyFluentHelper getDocumentInfoRecordCharcValueByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass
     * DocumentInfoRecordClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass
     *         DocumentInfoRecordClass} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordClassFluentHelper getAllDocumentInfoRecordClass();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass
     * DocumentInfoRecordClass} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass
     *         DocumentInfoRecordClass} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordClassByKeyFluentHelper getDocumentInfoRecordClassByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String classInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharc
     * DocumentInfoRecordClassCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharc
     *         DocumentInfoRecordClassCharc} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordClassCharcFluentHelper getAllDocumentInfoRecordClassCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharc
     * DocumentInfoRecordClassCharc} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharc
     *         DocumentInfoRecordClassCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordClassCharcByKeyFluentHelper getDocumentInfoRecordClassCharcByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String classInternalID,
        final String charcInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *         DocumentInfoRecordDesc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordDescFluentHelper getAllDocumentInfoRecordDesc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param language
     *            Language
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *         DocumentInfoRecordDesc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordDescByKeyFluentHelper getDocumentInfoRecordDescByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecordDesc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *            DocumentInfoRecordDesc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *         DocumentInfoRecordDesc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordDescCreateFluentHelper
        createDocumentInfoRecordDesc( @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecordDesc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *            DocumentInfoRecordDesc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *         DocumentInfoRecordDesc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordDescUpdateFluentHelper
        updateDocumentInfoRecordDesc( @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entity in the S/4HANA system.
     *
     * @param documentInfoRecordDesc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *            DocumentInfoRecordDesc} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *         DocumentInfoRecordDesc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordDescDeleteFluentHelper
        deleteDocumentInfoRecordDesc( @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH
     * DocumentInfoRecordDocStsVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH
     *         DocumentInfoRecordDocStsVH} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordDocStsVHFluentHelper getAllDocumentInfoRecordDocStsVH();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH
     * DocumentInfoRecordDocStsVH} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param externalDocumentStatus
     *            Status of a document (language-dependent)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param language
     *            Language
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH
     *         DocumentInfoRecordDocStsVH} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordDocStsVHByKeyFluentHelper getDocumentInfoRecordDocStsVHByKey(
        final String documentInfoRecordDocType,
        final String language,
        final String externalDocumentStatus );

}
