/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.AttachmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.LocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.LocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.PersonCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.batch.EHSIncidentCreateServiceBatch;

/**
 * <p>
 *
 * This service contains the basic information about an incident as the main entity, and persons involved, location, and
 * attachments as dependent entities. For create operations, the information is sent in the request as a payload, except
 * for attachment-related data. You can add attachments to the newly created incident in separate calls. Once the
 * incident has been created, the incident data and global identification are sent in the response. For read operations,
 * filter information can be sent according to the OData protocol. While creating an incident or retrieving incident
 * data, the system performs checks for restricted values and authorization. If there are any issues, the system
 * displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/40/c541a704b747ae83b0ce8f0ed322a9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_EHS_REPORT_INCIDENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_EHS_REPORT_INCIDENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Environment, Health and Safety - Incident Reporting Integration(SAP_COM_0369)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3FP'>Lean Incident Management Reporting(3FP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PFP'>Lean Incident Management Reporting(PFP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>EHS Incident business object</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface EHSIncidentCreateService extends BatchService<EHSIncidentCreateServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_EHS_REPORT_INCIDENT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    EHSIncidentCreateService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier
     * CurEHSLocationInclRootHier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier
     *         CurEHSLocationInclRootHier} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CurEHSLocationInclRootHierFluentHelper getAllCurEHSLocationInclRootHier();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier
     * CurEHSLocationInclRootHier} entity using key fields.
     *
     * @param eHSLocationUUID
     *            Location
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier
     *         CurEHSLocationInclRootHier} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CurEHSLocationInclRootHierByKeyFluentHelper getCurEHSLocationInclRootHierByKey( final UUID eHSLocationUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp
     * EHSLocationValueHelp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp
     *         EHSLocationValueHelp} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocationValueHelpFluentHelper getAllEHSLocationValueHelp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp
     * EHSLocationValueHelp} entity using key fields.
     *
     * @param eHSLocationUUID
     *            Location
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp
     *         EHSLocationValueHelp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocationValueHelpByKeyFluentHelper getEHSLocationValueHelpByKey( final UUID eHSLocationUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH
     * EHSLocClassifierVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH
     *         EHSLocClassifierVH} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocClassifierVHFluentHelper getAllEHSLocClassifierVH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH
     * EHSLocClassifierVH} entity using key fields.
     *
     * @param eHSClassifierUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH
     *         EHSLocClassifierVH} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocClassifierVHByKeyFluentHelper getEHSLocClassifierVHByKey( final UUID eHSClassifierUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelp
     * EHSPersonValueHelp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelp
     *         EHSPersonValueHelp} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSPersonValueHelpFluentHelper getAllEHSPersonValueHelp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelp
     * EHSPersonValueHelp} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelp
     *         EHSPersonValueHelp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSPersonValueHelpByKeyFluentHelper getEHSPersonValueHelpByKey( final String businessPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationType
     * EHSLocationType} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationType
     *         EHSLocationType} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationTypeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocationTypeFluentHelper getAllEHSLocationType();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationType
     * EHSLocationType} entity using key fields.
     *
     * @param eHSLocationType
     *            Location Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationType
     *         EHSLocationType} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationTypeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocationTypeByKeyFluentHelper getEHSLocationTypeByKey( final String eHSLocationType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText
     * EHSLocClassifierText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText
     *         EHSLocClassifierText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocClassifierTextFluentHelper getAllEHSLocClassifierText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText
     * EHSLocClassifierText} entity using key fields.
     *
     * @param eHSLocClassifierRefUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param eHSLocClassifierUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param eHSLocationUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText
     *         EHSLocClassifierText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EHSLocClassifierTextByKeyFluentHelper getEHSLocClassifierTextByKey(
        final UUID eHSLocationUUID,
        final UUID eHSLocClassifierUUID,
        final UUID eHSLocClassifierRefUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment Attachment}
     * entity and save it to the S/4HANA system.
     *
     * @param attachment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment Attachment}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment Attachment}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.AttachmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AttachmentCreateFluentHelper createAttachment( @Nonnull final Attachment attachment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IncidentFluentHelper getAllIncident();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident}
     * entity using key fields.
     *
     * @param incidentUUID
     *            Incident Global Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IncidentByKeyFluentHelper getIncidentByKey( final UUID incidentUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident}
     * entity and save it to the S/4HANA system.
     *
     * @param incident
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IncidentCreateFluentHelper createIncident( @Nonnull final Incident incident );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location Location}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location Location} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.LocationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LocationFluentHelper getAllLocation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location Location}
     * entity using key fields.
     *
     * @param locationUUID
     *            Location Global Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location Location} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.LocationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LocationByKeyFluentHelper getLocationByKey( final UUID locationUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person Person} entity
     * and save it to the S/4HANA system.
     *
     * @param person
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person Person} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person Person} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.PersonCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PersonCreateFluentHelper createPerson( @Nonnull final Person person );

}
