/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.batch.EarmarkedFundsDocumentServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the earmarked fund master data from SAP S/4HANA Cloud
 * system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1e/1ab89beffa432ab0ff9f1f836f624c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_EARMARKEDFUNDSDOCUMENT_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_EARMARKEDFUNDSDOCUMENT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Manage Earmarked Fund Document Integration(SAP_COM_0934)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4GY'>Earmarked Funds(4GY)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Earmarked Funds</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface EarmarkedFundsDocumentService extends BatchService<EarmarkedFundsDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_EARMARKEDFUNDSDOCUMENT";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    EarmarkedFundsDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     * EarmarkedFundsDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *         EarmarkedFundsDocument} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentFluentHelper getAllEarmarkedFundsDocument();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     * EarmarkedFundsDocument} entity using key fields.
     *
     * @param earmarkedFundsDocument
     *            Document number for earmarked funds
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *         EarmarkedFundsDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentByKeyFluentHelper getEarmarkedFundsDocumentByKey( final String earmarkedFundsDocument );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     * EarmarkedFundsDocument} entity and save it to the S/4HANA system.
     *
     * @param earmarkedFundsDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *            EarmarkedFundsDocument} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *         EarmarkedFundsDocument} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentCreateFluentHelper
        createEarmarkedFundsDocument( @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     * EarmarkedFundsDocument} entity and save it to the S/4HANA system.
     *
     * @param earmarkedFundsDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *            EarmarkedFundsDocument} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *         EarmarkedFundsDocument} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentUpdateFluentHelper
        updateEarmarkedFundsDocument( @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     * EarmarkedFundsDocumentItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *         EarmarkedFundsDocumentItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentItemFluentHelper getAllEarmarkedFundsDocumentItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     * EarmarkedFundsDocumentItem} entity using key fields.
     *
     * @param earmarkedFundsDocument
     *            Document number for earmarked funds
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param earmarkedFundsDocumentItem
     *            Earmarked Funds: Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *         EarmarkedFundsDocumentItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentItemByKeyFluentHelper getEarmarkedFundsDocumentItemByKey(
        final String earmarkedFundsDocument,
        final String earmarkedFundsDocumentItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     * EarmarkedFundsDocumentItem} entity and save it to the S/4HANA system.
     *
     * @param earmarkedFundsDocumentItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *            EarmarkedFundsDocumentItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *         EarmarkedFundsDocumentItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentItemUpdateFluentHelper
        updateEarmarkedFundsDocumentItem( @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     * EarmarkedFundsDocumentItem} entity in the S/4HANA system.
     *
     * @param earmarkedFundsDocumentItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *            EarmarkedFundsDocumentItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *         EarmarkedFundsDocumentItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentItemDeleteFluentHelper
        deleteEarmarkedFundsDocumentItem( @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem );

}
