/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.SetProcessingStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.SetProjElemProcessingStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.batch.EnterpriseProjectServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update or delete the project definition or the project elements of
 * enterprise projects. The service is based on the OData protocol and can be consumed by apps and other user
 * interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/a2/02054eb04a432bbd89bb89da638256/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_ENTERPRISE_PROJECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_ENTERPRISE_PROJECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Project Integration (SAP_COM_0308)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NT'>Project Financial Control (1NT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1YF'>Project Review (1YF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONT'>Project Financial Control (ONT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>EnterpriseProject</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2102 (Feb 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface EnterpriseProjectService extends BatchService<EnterpriseProjectServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_ENTERPRISE_PROJECT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    EnterpriseProjectService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncFluentHelper getAllEnterpriseProjBlkFunc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity using key fields.
     *
     * @param projectUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncByKeyFluentHelper getEnterpriseProjBlkFuncByKey( final UUID projectUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncCreateFluentHelper
        createEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFuncUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncUpdateFluentHelper
        updateEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     * EnterpriseProject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *         EnterpriseProject} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectFluentHelper getAllEnterpriseProject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     * EnterpriseProject} entity using key fields.
     *
     * @param projectUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *         EnterpriseProject} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectByKeyFluentHelper getEnterpriseProjectByKey( final UUID projectUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *            EnterpriseProject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *         EnterpriseProject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectCreateFluentHelper createEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *            EnterpriseProject} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *         EnterpriseProject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectUpdateFluentHelper updateEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject EnterpriseProject}
     * entity in the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *            EnterpriseProject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *         EnterpriseProject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectDeleteFluentHelper deleteEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *         EnterpriseProjectElement} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementFluentHelper getAllEnterpriseProjectElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entity using key fields.
     *
     * @param projectElementUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementByKeyFluentHelper getEnterpriseProjectElementByKey( final UUID projectElementUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementCreateFluentHelper
        createEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementUpdateFluentHelper
        updateEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entity in the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementDeleteFluentHelper
        deleteEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     *         EntProjectElmntPublicSector} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElmntPublicSectorFluentHelper getAllEntProjectElmntPublicSector();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entity using key fields.
     *
     * @param projectElementUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     *         EntProjectElmntPublicSector} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElmntPublicSectorByKeyFluentHelper getEntProjectElmntPublicSectorByKey( final UUID projectElementUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectElmntPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     *            EntProjectElmntPublicSector} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     *         EntProjectElmntPublicSector} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSectorUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElmntPublicSectorUpdateFluentHelper
        updateEntProjectElmntPublicSector( @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     * EntProjectPublicSector} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     *         EntProjectPublicSector} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectPublicSectorFluentHelper getAllEntProjectPublicSector();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     * EntProjectPublicSector} entity using key fields.
     *
     * @param projectUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     *         EntProjectPublicSector} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectPublicSectorByKeyFluentHelper getEntProjectPublicSectorByKey( final UUID projectUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     * EntProjectPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     *            EntProjectPublicSector} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     *         EntProjectPublicSector} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSectorUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectPublicSectorUpdateFluentHelper
        updateEntProjectPublicSector( @Nonnull final EntProjectPublicSector entProjectPublicSector );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncFluentHelper getAllEntProjElmntBlockFunc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity using key fields.
     *
     * @param projectElementUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncByKeyFluentHelper getEntProjElmntBlockFuncByKey( final UUID projectElementUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncCreateFluentHelper
        createEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFuncUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncUpdateFluentHelper
        updateEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetProcessingStatus</b> OData function import.
     * </p>
     *
     * @param processingStatus
     *            Processing Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProcessingStatus</b>
     *            </p>
     * @param projectUUID
     *            Entity GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetProcessingStatus</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.SetProcessingStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetProcessingStatusFluentHelper
        setProcessingStatus( @Nonnull final UUID projectUUID, @Nullable final String processingStatus );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetProjElemProcessingStatus</b> OData function import.
     * </p>
     *
     * @param processingStatus
     *            Processing Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProcessingStatus</b>
     *            </p>
     * @param projectElementUUID
     *            Entity GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectElementUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetProjElemProcessingStatus</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.SetProjElemProcessingStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetProjElemProcessingStatusFluentHelper
        setProjElemProcessingStatus( @Nonnull final UUID projectElementUUID, @Nullable final String processingStatus );

}
