/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjElmntPositionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjElmntProcgStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjProcgStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.batch.EnterpriseProjectV2ServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, update or delete the project definition or the project elements of
 * enterprise projects or professional services projects. The service is based on the OData protocol and can be consumed
 * by apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b4/67d86283be4a56869f1e6784e47b64/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_ENTERPRISE_PROJECT_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_ENTERPRISE_PROJECT_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Project Integration(SAP_COM_0308)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NT'>Project Control - Finance(1NT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1YF'>Project Review(1YF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONT'>Project Control - Finance(ONT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OYF'>Project Review(OYF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Enterprise Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface EnterpriseProjectV2Service extends BatchService<EnterpriseProjectV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_ENTERPRISE_PROJECT_SRV;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    EnterpriseProjectV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncFluentHelper getAllEnterpriseProjBlkFunc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity using key fields.
     *
     * @param projectUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncByKeyFluentHelper getEnterpriseProjBlkFuncByKey( final UUID projectUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncCreateFluentHelper
        createEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *         EnterpriseProjBlkFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFuncUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjBlkFuncUpdateFluentHelper
        updateEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *         EnterpriseProjectElement} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementFluentHelper getAllEnterpriseProjectElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entity using key fields.
     *
     * @param projectElementUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementByKeyFluentHelper getEnterpriseProjectElementByKey( final UUID projectElementUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementCreateFluentHelper
        createEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementUpdateFluentHelper
        updateEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entity in the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *         EnterpriseProjectElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectElementDeleteFluentHelper
        deleteEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     * EnterpriseProjectJVA} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     *         EnterpriseProjectJVA} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectJVAFluentHelper getAllEnterpriseProjectJVA();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     * EnterpriseProjectJVA} entity using key fields.
     *
     * @param projectUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     *         EnterpriseProjectJVA} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectJVAByKeyFluentHelper getEnterpriseProjectJVAByKey( final UUID projectUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     * EnterpriseProjectJVA} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectJVA
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     *            EnterpriseProjectJVA} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     *         EnterpriseProjectJVA} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVAUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectJVAUpdateFluentHelper
        updateEnterpriseProjectJVA( @Nonnull final EnterpriseProjectJVA enterpriseProjectJVA );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     * EnterpriseProjectRole} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     *         EnterpriseProjectRole} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectRoleFluentHelper getAllEnterpriseProjectRole();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     * EnterpriseProjectRole} entity using key fields.
     *
     * @param projectRoleUUID
     *            Role GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     *         EnterpriseProjectRole} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectRoleByKeyFluentHelper getEnterpriseProjectRoleByKey( final UUID projectRoleUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     * EnterpriseProjectRole} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     *            EnterpriseProjectRole} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     *         EnterpriseProjectRole} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRoleCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectRoleCreateFluentHelper
        createEnterpriseProjectRole( @Nonnull final EnterpriseProjectRole enterpriseProjectRole );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     * EnterpriseProjectTeamMember} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     *         EnterpriseProjectTeamMember} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectTeamMemberFluentHelper getAllEnterpriseProjectTeamMember();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     * EnterpriseProjectTeamMember} entity using key fields.
     *
     * @param teamMemberUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     *         EnterpriseProjectTeamMember} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectTeamMemberByKeyFluentHelper getEnterpriseProjectTeamMemberByKey( final UUID teamMemberUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     * EnterpriseProjectTeamMember} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectTeamMember
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     *            EnterpriseProjectTeamMember} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     *         EnterpriseProjectTeamMember} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMemberCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectTeamMemberCreateFluentHelper
        createEnterpriseProjectTeamMember( @Nonnull final EnterpriseProjectTeamMember enterpriseProjectTeamMember );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *         EnterpriseProject} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectFluentHelper getAllEnterpriseProject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entity using key fields.
     *
     * @param projectUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *         EnterpriseProject} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectByKeyFluentHelper getEnterpriseProjectByKey( final UUID projectUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *            EnterpriseProject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *         EnterpriseProject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectCreateFluentHelper createEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *            EnterpriseProject} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *         EnterpriseProject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectUpdateFluentHelper updateEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entity in the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *            EnterpriseProject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *         EnterpriseProject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnterpriseProjectDeleteFluentHelper deleteEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     * EntProjectElementJVA} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     *         EntProjectElementJVA} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElementJVAFluentHelper getAllEntProjectElementJVA();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     * EntProjectElementJVA} entity using key fields.
     *
     * @param projectElementUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     *         EntProjectElementJVA} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElementJVAByKeyFluentHelper getEntProjectElementJVAByKey( final UUID projectElementUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     * EntProjectElementJVA} entity and save it to the S/4HANA system.
     *
     * @param entProjectElementJVA
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     *            EntProjectElementJVA} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     *         EntProjectElementJVA} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVAUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElementJVAUpdateFluentHelper
        updateEntProjectElementJVA( @Nonnull final EntProjectElementJVA entProjectElementJVA );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     * EntProjectPublicSector} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     *         EntProjectPublicSector} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectPublicSectorFluentHelper getAllEntProjectPublicSector();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     * EntProjectPublicSector} entity using key fields.
     *
     * @param projectUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     *         EntProjectPublicSector} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectPublicSectorByKeyFluentHelper getEntProjectPublicSectorByKey( final UUID projectUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     * EntProjectPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     *            EntProjectPublicSector} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     *         EntProjectPublicSector} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSectorUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectPublicSectorUpdateFluentHelper
        updateEntProjectPublicSector( @Nonnull final EntProjectPublicSector entProjectPublicSector );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncFluentHelper getAllEntProjElmntBlockFunc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity using key fields.
     *
     * @param projectElementUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncByKeyFluentHelper getEntProjElmntBlockFuncByKey( final UUID projectElementUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncCreateFluentHelper
        createEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *         EntProjElmntBlockFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFuncUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntBlockFuncUpdateFluentHelper
        updateEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     * EntProjElmntDlvbrl} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *         EntProjElmntDlvbrl} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntDlvbrlFluentHelper getAllEntProjElmntDlvbrl();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     * EntProjElmntDlvbrl} entity using key fields.
     *
     * @param entProjElmntDeliverableUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *         EntProjElmntDlvbrl} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntDlvbrlByKeyFluentHelper getEntProjElmntDlvbrlByKey( final UUID entProjElmntDeliverableUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     * EntProjElmntDlvbrl} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntDlvbrl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *            EntProjElmntDlvbrl} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *         EntProjElmntDlvbrl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntDlvbrlCreateFluentHelper
        createEntProjElmntDlvbrl( @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     * EntProjElmntDlvbrl} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntDlvbrl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *            EntProjElmntDlvbrl} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *         EntProjElmntDlvbrl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntDlvbrlUpdateFluentHelper
        updateEntProjElmntDlvbrl( @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     * EntProjElmntDlvbrlDistr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     *         EntProjElmntDlvbrlDistr} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntDlvbrlDistrFluentHelper getAllEntProjElmntDlvbrlDistr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     * EntProjElmntDlvbrlDistr} entity using key fields.
     *
     * @param entProjElmntDlvbrlDistrUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     *         EntProjElmntDlvbrlDistr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntDlvbrlDistrByKeyFluentHelper getEntProjElmntDlvbrlDistrByKey( final UUID entProjElmntDlvbrlDistrUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     * EntProjElmntDlvbrlDistr} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntDlvbrlDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     *            EntProjElmntDlvbrlDistr} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     *         EntProjElmntDlvbrlDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistrUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntDlvbrlDistrUpdateFluentHelper
        updateEntProjElmntDlvbrlDistr( @Nonnull final EntProjElmntDlvbrlDistr entProjElmntDlvbrlDistr );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     *         EntProjectElmntPublicSector} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElmntPublicSectorFluentHelper getAllEntProjectElmntPublicSector();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entity using key fields.
     *
     * @param projectElementUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     *         EntProjectElmntPublicSector} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElmntPublicSectorByKeyFluentHelper getEntProjectElmntPublicSectorByKey( final UUID projectElementUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectElmntPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     *            EntProjectElmntPublicSector} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     *         EntProjectElmntPublicSector} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSectorUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjectElmntPublicSectorUpdateFluentHelper
        updateEntProjectElmntPublicSector( @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     * EntProjElmntWorkItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *         EntProjElmntWorkItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntWorkItemFluentHelper getAllEntProjElmntWorkItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     * EntProjElmntWorkItem} entity using key fields.
     *
     * @param entProjElmntWorkItemUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *         EntProjElmntWorkItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntWorkItemByKeyFluentHelper getEntProjElmntWorkItemByKey( final UUID entProjElmntWorkItemUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     * EntProjElmntWorkItem} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntWorkItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *            EntProjElmntWorkItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *         EntProjElmntWorkItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntWorkItemUpdateFluentHelper
        updateEntProjElmntWorkItem( @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     * EntProjElmntWorkItem} entity in the S/4HANA system.
     *
     * @param entProjElmntWorkItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *            EntProjElmntWorkItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *         EntProjElmntWorkItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntProjElmntWorkItemDeleteFluentHelper
        deleteEntProjElmntWorkItem( @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *         EntTeamMemberEntitlement} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntTeamMemberEntitlementFluentHelper getAllEntTeamMemberEntitlement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entity using key fields.
     *
     * @param projectEntitlementUUID
     *            Entitlement Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *         EntTeamMemberEntitlement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntTeamMemberEntitlementByKeyFluentHelper getEntTeamMemberEntitlementByKey( final UUID projectEntitlementUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entity and save it to the S/4HANA system.
     *
     * @param entTeamMemberEntitlement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *            EntTeamMemberEntitlement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *         EntTeamMemberEntitlement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntTeamMemberEntitlementCreateFluentHelper
        createEntTeamMemberEntitlement( @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entity and save it to the S/4HANA system.
     *
     * @param entTeamMemberEntitlement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *            EntTeamMemberEntitlement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *         EntTeamMemberEntitlement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntTeamMemberEntitlementUpdateFluentHelper
        updateEntTeamMemberEntitlement( @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entity in the S/4HANA system.
     *
     * @param entTeamMemberEntitlement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *            EntTeamMemberEntitlement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *         EntTeamMemberEntitlement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EntTeamMemberEntitlementDeleteFluentHelper
        deleteEntTeamMemberEntitlement( @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement );

    /**
     * <p>
     * Creates a fluent helper for the <b>ChangeEntProjElmntPosition</b> OData function import.
     * </p>
     *
     * @param leftSiblingUUID
     *            PrjElmnt GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LeftSiblingUUID</b>
     *            </p>
     * @param parentObjectUUID
     *            PrjElmnt GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ParentObjectUUID</b>
     *            </p>
     * @param projectElementUUID
     *            Entity GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectElementUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ChangeEntProjElmntPosition</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjElmntPositionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeEntProjElmntPositionFluentHelper changeEntProjElmntPosition(
        @Nonnull final UUID projectElementUUID,
        @Nullable final UUID parentObjectUUID,
        @Nullable final UUID leftSiblingUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>ChangeEntProjElmntProcgStatus</b> OData function import.
     * </p>
     *
     * @param processingStatus
     *            Proc. Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProcessingStatus</b>
     *            </p>
     * @param projectElementUUID
     *            Entity GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectElementUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ChangeEntProjElmntProcgStatus</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjElmntProcgStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeEntProjElmntProcgStatusFluentHelper changeEntProjElmntProcgStatus(
        @Nonnull final UUID projectElementUUID,
        @Nullable final String processingStatus );

    /**
     * <p>
     * Creates a fluent helper for the <b>ChangeEntProjProcgStatus</b> OData function import.
     * </p>
     *
     * @param processingStatus
     *            Proc. Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProcessingStatus</b>
     *            </p>
     * @param projectUUID
     *            Entity GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ChangeEntProjProcgStatus</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.ChangeEntProjProcgStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeEntProjProcgStatusFluentHelper
        changeEntProjProcgStatus( @Nonnull final UUID projectUUID, @Nullable final String processingStatus );

}
