/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.DismantleEquipWithDataTransferFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.DismantleEquipmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.InstallEquipWithDataTransferFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.InstallEquipmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.ResetEquipmentFromInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.RsetEquipFromMarkedForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.SetEquipToMarkedForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.SetEquipmentToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.batch.EquipmentServiceBatch;

/**
 * <p>
 *
 * This service contains equipment, long text, partner function, warranty, class, characteristic, and characteristic
 * value nodes. The information is sent in the request as a payload.
 *
 * The request payload contains all information required to create or update an equipment. All the information in the
 * payload is used to create or update an equipment including appropriate checks for restricted values and
 * authorizations. Once the equipment has been created, the equipment number is sent in the response with the data
 * included in the equipment.
 *
 * If the input in the request is not as expected when you create or update an equipment, the system displays
 * appropriate error or warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/13/d40bd35fc74d289e81fc284a928448/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_EQUIPMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_EQUIPMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Asset Management Master Data Integration(SAP_COM_0395)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service
 * Management(49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation(4GA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Equipment</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface EquipmentService extends BatchService<EquipmentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_EQUIPMENT";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    EquipmentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentFluentHelper getAllEquipment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity
     * using key fields.
     *
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentByKeyFluentHelper getEquipmentByKey( final String equipment, final LocalDateTime validityEndDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity and
     * save it to the S/4HANA system.
     *
     * @param equipment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentCreateFluentHelper createEquipment( @Nonnull final Equipment equipment );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment}
     * entity and save it to the S/4HANA system.
     *
     * @param equipment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentUpdateFluentHelper updateEquipment( @Nonnull final Equipment equipment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     * EquipClassCharacteristicValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *         EquipClassCharacteristicValue} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipClassCharacteristicValueFluentHelper getAllEquipClassCharacteristicValue();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     * EquipClassCharacteristicValue} entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param characteristicInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *         EquipClassCharacteristicValue} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipClassCharacteristicValueByKeyFluentHelper getEquipClassCharacteristicValueByKey(
        final String equipment,
        final String classType,
        final String charcValuePositionNumber,
        final String characteristicInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     * EquipClassCharacteristicValue} entity and save it to the S/4HANA system.
     *
     * @param equipClassCharacteristicValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *            EquipClassCharacteristicValue} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *         EquipClassCharacteristicValue} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipClassCharacteristicValueCreateFluentHelper createEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     * EquipClassCharacteristicValue} entity and save it to the S/4HANA system.
     *
     * @param equipClassCharacteristicValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *            EquipClassCharacteristicValue} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *         EquipClassCharacteristicValue} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValueUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipClassCharacteristicValueUpdateFluentHelper updateEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass
     * EquipmentClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassFluentHelper getAllEquipmentClass();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass
     * EquipmentClass} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassByKeyFluentHelper
        getEquipmentClassByKey( final String equipment, final String classInternalID, final String classType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     * entity and save it to the S/4HANA system.
     *
     * @param equipmentClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassCreateFluentHelper createEquipmentClass( @Nonnull final EquipmentClass equipmentClass );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass
     * EquipmentClass} entity and save it to the S/4HANA system.
     *
     * @param equipmentClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassUpdateFluentHelper updateEquipmentClass( @Nonnull final EquipmentClass equipmentClass );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass
     * EquipmentClass} entity in the S/4HANA system.
     *
     * @param equipmentClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassDeleteFluentHelper deleteEquipmentClass( @Nonnull final EquipmentClass equipmentClass );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     * EquipmentClassCharacteristic} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     *         EquipmentClassCharacteristic} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassCharacteristicFluentHelper getAllEquipmentClassCharacteristic();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     * EquipmentClassCharacteristic} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param characteristicInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     *         EquipmentClassCharacteristic} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassCharacteristicByKeyFluentHelper getEquipmentClassCharacteristicByKey(
        final String equipment,
        final String classInternalID,
        final String characteristicInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     * EquipmentClassCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param equipmentClassCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     *            EquipmentClassCharacteristic} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     *         EquipmentClassCharacteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristicCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentClassCharacteristicCreateFluentHelper
        createEquipmentClassCharacteristic( @Nonnull final EquipmentClassCharacteristic equipmentClassCharacteristic );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     * EquipmentLongText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText EquipmentLongText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentLongTextFluentHelper getAllEquipmentLongText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     * EquipmentLongText} entity using key fields.
     *
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText EquipmentLongText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentLongTextByKeyFluentHelper getEquipmentLongTextByKey( final String equipment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     * EquipmentLongText} entity and save it to the S/4HANA system.
     *
     * @param equipmentLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     *            EquipmentLongText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText EquipmentLongText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentLongTextCreateFluentHelper createEquipmentLongText( @Nonnull final EquipmentLongText equipmentLongText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     * EquipmentLongText} entity and save it to the S/4HANA system.
     *
     * @param equipmentLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     *            EquipmentLongText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText EquipmentLongText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentLongTextUpdateFluentHelper updateEquipmentLongText( @Nonnull final EquipmentLongText equipmentLongText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     * EquipmentPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner EquipmentPartner}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentPartnerFluentHelper getAllEquipmentPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     * EquipmentPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param equipmentPartnerObjectNmbr
     *            Counter for differentiation 6-digit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner EquipmentPartner}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentPartnerByKeyFluentHelper getEquipmentPartnerByKey(
        final String equipment,
        final String partnerFunction,
        final String equipmentPartnerObjectNmbr );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     * EquipmentPartner} entity and save it to the S/4HANA system.
     *
     * @param equipmentPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     *            EquipmentPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner EquipmentPartner}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentPartnerCreateFluentHelper createEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     * EquipmentPartner} entity and save it to the S/4HANA system.
     *
     * @param equipmentPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     *            EquipmentPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner EquipmentPartner}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentPartnerUpdateFluentHelper updateEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     * EquipmentWarranty} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty EquipmentWarranty}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentWarrantyFluentHelper getAllEquipmentWarranty();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     * EquipmentWarranty} entity using key fields.
     *
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param warrantyType
     *            Warranty type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty EquipmentWarranty}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentWarrantyByKeyFluentHelper getEquipmentWarrantyByKey( final String equipment, final String warrantyType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     * EquipmentWarranty} entity and save it to the S/4HANA system.
     *
     * @param equipmentWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     *            EquipmentWarranty} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty EquipmentWarranty}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentWarrantyCreateFluentHelper createEquipmentWarranty( @Nonnull final EquipmentWarranty equipmentWarranty );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     * EquipmentWarranty} entity and save it to the S/4HANA system.
     *
     * @param equipmentWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     *            EquipmentWarranty} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty EquipmentWarranty}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarrantyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EquipmentWarrantyUpdateFluentHelper updateEquipmentWarranty( @Nonnull final EquipmentWarranty equipmentWarranty );

    /**
     * <p>
     * Creates a fluent helper for the <b>DismantleEquipment</b> OData function import.
     * </p>
     *
     * @param superordinateEquipment
     *            Superord. Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuperordinateEquipment</b>
     *            </p>
     * @param functionalLocation
     *            Functional Location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @param equipmentInstallationTime
     *            Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationTime</b>
     *            </p>
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param equipInstallationPositionNmbr
     *            Item (SD)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipInstallationPositionNmbr</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @param equipmentInstallationDate
     *            Changed On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DismantleEquipment</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.DismantleEquipmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DismantleEquipmentFluentHelper dismantleEquipment(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final String functionalLocation,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime );

    /**
     * <p>
     * Creates a fluent helper for the <b>DismantleEquipWithDataTransfer</b> OData function import.
     * </p>
     *
     * @param maintPlanningPlantCopyIsReqd
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanningPlantCopyIsReqd</b>
     *            </p>
     * @param workCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WorkCenterCopyIsRequested</b>
     *            </p>
     * @param costCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CostCenterCopyIsRequested</b>
     *            </p>
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param catalogProfileCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CatalogProfileCopyIsRequested</b>
     *            </p>
     * @param wBSElementCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WBSElementCopyIsRequested</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @param equipmentInstallationDate
     *            Changed On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationDate</b>
     *            </p>
     * @param salesOrganizationCopyIsReqd
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesOrganizationCopyIsReqd</b>
     *            </p>
     * @param plantSectionCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlantSectionCopyIsRequested</b>
     *            </p>
     * @param superordinateEquipment
     *            Superord. Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuperordinateEquipment</b>
     *            </p>
     * @param standingOrderCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StandingOrderCopyIsRequested</b>
     *            </p>
     * @param maintWorkCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintWorkCenterCopyIsRequested</b>
     *            </p>
     * @param functionalLocation
     *            Functional Location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @param equipmentInstallationTime
     *            Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationTime</b>
     *            </p>
     * @param businessAreaCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessAreaCopyIsRequested</b>
     *            </p>
     * @param settlementOrderCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SettlementOrderCopyIsRequested</b>
     *            </p>
     * @param sortFieldCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SortFieldCopyIsRequested</b>
     *            </p>
     * @param equipInstallationPositionNmbr
     *            Position
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipInstallationPositionNmbr</b>
     *            </p>
     * @param roomCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RoomCopyIsRequested</b>
     *            </p>
     * @param aBCIndicatorCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ABCIndicatorCopyIsRequested</b>
     *            </p>
     * @param locationCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LocationCopyIsRequested</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DismantleEquipWithDataTransfer</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.DismantleEquipWithDataTransferFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DismantleEquipWithDataTransferFluentHelper dismantleEquipWithDataTransfer(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String functionalLocation,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime,
        @Nullable final Boolean locationCopyIsRequested,
        @Nullable final Boolean roomCopyIsRequested,
        @Nullable final Boolean plantSectionCopyIsRequested,
        @Nullable final Boolean workCenterCopyIsRequested,
        @Nullable final Boolean aBCIndicatorCopyIsRequested,
        @Nullable final Boolean sortFieldCopyIsRequested,
        @Nullable final Boolean businessAreaCopyIsRequested,
        @Nullable final Boolean costCenterCopyIsRequested,
        @Nullable final Boolean wBSElementCopyIsRequested,
        @Nullable final Boolean standingOrderCopyIsRequested,
        @Nullable final Boolean settlementOrderCopyIsRequested,
        @Nullable final Boolean maintPlanningPlantCopyIsReqd,
        @Nullable final Boolean maintWorkCenterCopyIsRequested,
        @Nullable final Boolean catalogProfileCopyIsRequested,
        @Nullable final Boolean salesOrganizationCopyIsReqd );

    /**
     * <p>
     * Creates a fluent helper for the <b>InstallEquipment</b> OData function import.
     * </p>
     *
     * @param superordinateEquipment
     *            Superord. Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuperordinateEquipment</b>
     *            </p>
     * @param functionalLocation
     *            Functional Location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @param equipmentInstallationTime
     *            Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationTime</b>
     *            </p>
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param equipInstallationPositionNmbr
     *            Item (SD)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipInstallationPositionNmbr</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @param equipmentInstallationDate
     *            Changed On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>InstallEquipment</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.InstallEquipmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InstallEquipmentFluentHelper installEquipment(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final String functionalLocation,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime );

    /**
     * <p>
     * Creates a fluent helper for the <b>InstallEquipWithDataTransfer</b> OData function import.
     * </p>
     *
     * @param maintPlanningPlantCopyIsReqd
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanningPlantCopyIsReqd</b>
     *            </p>
     * @param workCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WorkCenterCopyIsRequested</b>
     *            </p>
     * @param costCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CostCenterCopyIsRequested</b>
     *            </p>
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param catalogProfileCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CatalogProfileCopyIsRequested</b>
     *            </p>
     * @param wBSElementCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WBSElementCopyIsRequested</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @param equipmentInstallationDate
     *            Changed On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationDate</b>
     *            </p>
     * @param salesOrganizationCopyIsReqd
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesOrganizationCopyIsReqd</b>
     *            </p>
     * @param plantSectionCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlantSectionCopyIsRequested</b>
     *            </p>
     * @param superordinateEquipment
     *            Superord. Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuperordinateEquipment</b>
     *            </p>
     * @param standingOrderCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StandingOrderCopyIsRequested</b>
     *            </p>
     * @param maintWorkCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintWorkCenterCopyIsRequested</b>
     *            </p>
     * @param functionalLocation
     *            Functional Location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @param equipmentInstallationTime
     *            Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationTime</b>
     *            </p>
     * @param businessAreaCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessAreaCopyIsRequested</b>
     *            </p>
     * @param settlementOrderCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SettlementOrderCopyIsRequested</b>
     *            </p>
     * @param sortFieldCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SortFieldCopyIsRequested</b>
     *            </p>
     * @param equipInstallationPositionNmbr
     *            Position
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipInstallationPositionNmbr</b>
     *            </p>
     * @param roomCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RoomCopyIsRequested</b>
     *            </p>
     * @param aBCIndicatorCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ABCIndicatorCopyIsRequested</b>
     *            </p>
     * @param locationCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LocationCopyIsRequested</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>InstallEquipWithDataTransfer</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.InstallEquipWithDataTransferFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InstallEquipWithDataTransferFluentHelper installEquipWithDataTransfer(
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String functionalLocation,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime,
        @Nullable final Boolean locationCopyIsRequested,
        @Nullable final Boolean roomCopyIsRequested,
        @Nullable final Boolean plantSectionCopyIsRequested,
        @Nullable final Boolean workCenterCopyIsRequested,
        @Nullable final Boolean aBCIndicatorCopyIsRequested,
        @Nullable final Boolean sortFieldCopyIsRequested,
        @Nullable final Boolean businessAreaCopyIsRequested,
        @Nullable final Boolean costCenterCopyIsRequested,
        @Nullable final Boolean wBSElementCopyIsRequested,
        @Nullable final Boolean standingOrderCopyIsRequested,
        @Nullable final Boolean settlementOrderCopyIsRequested,
        @Nullable final Boolean maintPlanningPlantCopyIsReqd,
        @Nullable final Boolean maintWorkCenterCopyIsRequested,
        @Nullable final Boolean catalogProfileCopyIsRequested,
        @Nullable final Boolean salesOrganizationCopyIsReqd );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetEquipmentFromInactive</b> OData function import.
     * </p>
     *
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetEquipmentFromInactive</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.ResetEquipmentFromInactiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetEquipmentFromInactiveFluentHelper
        resetEquipmentFromInactive( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>RsetEquipFromMarkedForDeletion</b> OData function import.
     * </p>
     *
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RsetEquipFromMarkedForDeletion</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.RsetEquipFromMarkedForDeletionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RsetEquipFromMarkedForDeletionFluentHelper
        rsetEquipFromMarkedForDeletion( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetEquipmentToInactive</b> OData function import.
     * </p>
     *
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetEquipmentToInactive</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.SetEquipmentToInactiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetEquipmentToInactiveFluentHelper
        setEquipmentToInactive( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetEquipToMarkedForDeletion</b> OData function import.
     * </p>
     *
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetEquipToMarkedForDeletion</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.SetEquipToMarkedForDeletionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetEquipToMarkedForDeletionFluentHelper
        setEquipToMarkedForDeletion( @Nonnull final String equipment, @Nonnull final LocalDateTime validityEndDate );

}
