/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.CallActionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.ChangeRecognitionKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.batch.EventBasedRevenueRecognitionIntegrationServiceBatch;

/**
 * <p>
 *
 * The service first allows for a clearing of the balance sheet GL accounts, a procedure by which the open items
 * belonging to one or more accounts are indicated as cleared. Second, it allows for using the revalue function, which
 * recalculates the posted revenue recognition values if you have changed, for example, the planned cost. This service
 * also allows changing the revenue recognition key that was originally assigned to a particular WBS element (project)
 * to a new one..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/14/07737644024c36a45388ffe4f593a4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_EVENT_BASED_REVREC_PROJECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_EVENT_BASED_REVREC_PROJECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Event-Based Revenue Recognition Integration(SAP_COM_0312)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1IL'>Event-Based Revenue Recognition - Project-Based
 * Services(1IL)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1P0'>Event-Based Revenue Recognition -
 * Project-Based Services - IFRS(1P0)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/33O'>Event-Based Revenue
 * Recognition - Project-Based Services - US GAAP(33O)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Enterprise Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface EventBasedRevenueRecognitionIntegrationService
    extends
    BatchService<EventBasedRevenueRecognitionIntegrationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_EVENT_BASED_REVREC_PROJECT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    EventBasedRevenueRecognitionIntegrationService withServicePath( @Nonnull final String servicePath );

    /**
     * <p>
     * Creates a fluent helper for the <b>CallAction</b> OData function import.
     * </p>
     *
     * @param period
     *            Signed INT2 / int16
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Period</b>
     *            </p>
     * @param year
     *            Signed INT2 / int16
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Year</b>
     *            </p>
     * @param wBSElementExternalID
     *            Constraints: Not nullable, Maximum length: 24
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WBSElementExternalID</b>
     *            </p>
     * @param actionName
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActionName</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CallAction</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.CallActionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CallActionFluentHelper callAction(
        @Nonnull final Short year,
        @Nonnull final Short period,
        @Nonnull final String actionName,
        @Nonnull final String wBSElementExternalID );

    /**
     * <p>
     * Creates a fluent helper for the <b>ChangeRecognitionKey</b> OData function import.
     * </p>
     *
     * @param wBSElementExternalID
     *            Constraints: Not nullable, Maximum length: 24
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WBSElementExternalID</b>
     *            </p>
     * @param recognitionKey
     *            Constraints: Not nullable, Maximum length: 6
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RecognitionKey</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ChangeRecognitionKey</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.ChangeRecognitionKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecognitionKeyFluentHelper
        changeRecognitionKey( @Nonnull final String wBSElementExternalID, @Nonnull final String recognitionKey );

}
